/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Internal
{
	/// <summary>TODO: Check if all time-consuming stuff is overridden!</summary>
	internal class TransactionObjectCarrier : Db4objects.Db4o.Internal.LocalTransaction
	{
		internal TransactionObjectCarrier(Db4objects.Db4o.Internal.ObjectContainerBase a_stream
			, Db4objects.Db4o.Internal.Transaction a_parent) : base(a_stream, a_parent)
		{
		}

		public override void Commit()
		{
		}

		public override void SlotFreeOnCommit(int a_id, int a_address, int a_length)
		{
		}

		public override void SlotFreeOnRollback(int a_id, int a_address, int a_length)
		{
		}

		internal override void SlotFreeOnRollbackSetPointer(int a_id, int a_address, int 
			a_length)
		{
			SetPointer(a_id, a_address, a_length);
		}

		internal override void SlotFreeOnRollbackCommitSetPointer(int a_id, int newAddress
			, int newLength)
		{
			SetPointer(a_id, newAddress, newLength);
		}

		internal override void SlotFreePointerOnCommit(int a_id, int a_address, int a_length
			)
		{
		}

		public override void SlotFreePointerOnCommit(int a_id)
		{
		}

		public override void SetPointer(int a_id, int a_address, int a_length)
		{
			WritePointer(a_id, a_address, a_length);
		}

		internal override bool SupportsVirtualFields()
		{
			return false;
		}
	}
}
