/* Copyright (C) 2004 - 2007 db4objects Inc. http://www.db4o.com */
/**
 * This example shows how to use the same db4o database between 
 * Java and .NET application. Pilot objects are originally saved in .NET,
 * then they are read and modified in Java application and read again 
 * in .NET
 *
 */

package com.db4odoc.aliases;

import java.util.List;

import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.config.Configuration;
import com.db4o.config.TypeAlias;
import com.db4o.config.WildcardAlias;
import com.db4o.query.Predicate;

public class InterLanguageExample2 {
	private static final String DB4O_FILE_NAME = "reference.db4o";
	
	public static void main(String[] args) {
		getObjects(configureAlias());
	}

	// end main

	private static Configuration configureAlias() {
		Configuration configuration = Db4o.newConfiguration();
		configuration.addAlias(new WildcardAlias(
				"Db4objects.Db4odoc.Aliases.*, Db4objects.Db4odoc",
				"com.db4odoc.aliases.*"));
		configuration.addAlias(new TypeAlias(
				"Db4objects.Db4o.Ext.Db4oDatabase, Db4objects.Db4o",
				"com.db4o.ext.Db4oDatabase"));
		return configuration;
	}

	// end configureAlias

	private static void getObjects(Configuration configuration) {
		ObjectContainer db = Db4o.openFile(configuration, DB4O_FILE_NAME);
		try {
			List<Pilot> result = db.query(new Predicate<Pilot>() {
				public boolean match(Pilot pilot) {
					return true;
				}
			});
			for (int i = 0; i < result.size(); i++) {
				Pilot pilot = result.get(i);
				pilot.setName("Modified " + pilot.getName());
				db.set(pilot);
			}
			listResult(result);
		} finally {
			db.close();
		}
	}

	// end getObjects

	private static void listResult(List<Pilot> result) {
		System.out.println(result.size());
		for (int i = 0; i < result.size(); i++) {
			System.out.println(result.get(i));
		}
	}
	// end listResult

	private static void listResult(ObjectSet result) {
		System.out.println(result.size());
		for (int i = 0; i < result.size(); i++) {
			System.out.println(result.get(i));
		}
	}
	// end listResult
}
