/* Copyright (C) 2004 - 2007 db4objects Inc. http://www.db4o.com */
using System;
using System.IO;
using System.Collections;
using Db4objects.Db4o;
using Db4objects.Db4o.Ext;
using Db4objects.Db4o.Query;

namespace Db4objects.Db4odoc.Soda
{
    class SodaExample
    {

        private const string Db4oFileName = "reference.db4o";

        private const int ObjectCount = 10;

        private static IObjectContainer _container = null;

        public static void Main(string[] args)
        {
            TestIdentity();
            TestContains();
            TestLike();
            TestStartsEnds();
        }
        // end Main

        private static IObjectContainer Database()
        {
            if (_container == null)
            {
                try
                {
                    _container = Db4oFactory.OpenFile(Db4oFileName);
                }
                catch (DatabaseFileLockedException ex)
                {
                    System.Console.WriteLine(ex.Message);
                }
            }
            return _container;
        }

        // end Database

        private static void CloseDatabase()
        {
            if (_container != null)
            {
                _container.Close();
                _container = null;
            }
        }

        // end CloseDatabase


        public static void TestLike()
        {
            File.Delete(Db4oFileName);
            IObjectContainer container = Database();
            if (container != null)
            {
                try
                {
                    Pilot pilot = new Pilot("Test Pilot1", 100);
                    container.Set(pilot);
                    pilot = new Pilot("Test Pilot2", 102);
                    container.Set(pilot);

                    // Simple.IQuery
                    IQuery query1 = container.Query();
                    query1.Constrain(typeof(Pilot));
                    query1.Descend("_name").Constrain("est");
                    IObjectSet result = query1.Execute();
                    ListResult(result);

                    // Like.IQuery
                    IQuery query2 = container.Query();
                    query2.Constrain(typeof(Pilot));
                    // All pilots with the name containing "est" will be retrieved
                    query2.Descend("_name").Constrain("est").Like();
                    result = query2.Execute();
                    ListResult(result);
                }
                catch (Db4oException ex)
                {
                    Console.WriteLine("Db4o Exception: " + ex.Message);
                }
                catch (Exception ex)
                {
                    Console.WriteLine("System Exception: " + ex.Message);
                }
                finally
                {
                    CloseDatabase();
                }
            }
        }
        // end TestLike

        public static void TestContains()
        {
            File.Delete(Db4oFileName);
            IObjectContainer container = Database();
            if (container != null)
            {
                try
                {
                    ArrayList list = new ArrayList();
                    Pilot pilot1 = new Pilot("Test 1", 1);
                    list.Add(pilot1);
                    Pilot pilot2 = new Pilot("Test 2", 2);
                    list.Add(pilot2);
                    Team team = new Team("Ferrari", list);
                    container.Set(team);

                    IQuery query = container.Query();
                    query.Constrain(typeof(Team));
                    query.Descend("_pilots").Constrain(pilot2).Contains();
                    IObjectSet result = query.Execute();
                    ListResult(result);
                }
                catch (Db4oException ex)
                {
                    Console.WriteLine("Db4o Exception: " + ex.Message);
                }
                catch (Exception ex)
                {
                    Console.WriteLine("System Exception: " + ex.Message);
                }
                finally
                {
                    CloseDatabase();
                }
            }
        }
        // end TestContains

        public static void TestStartsEnds()
        {
            File.Delete(Db4oFileName);
            IObjectContainer container = Database();
            if (container != null)
            {
                try
                {
                    Pilot pilot = new Pilot("Test Pilot0", 100);
                    container.Set(pilot);
                    pilot = new Pilot("Test Pilot1", 101);
                    container.Set(pilot);
                    pilot = new Pilot("Test Pilot2", 102);
                    container.Set(pilot);

                    IQuery query = container.Query();
                    query.Constrain(typeof(Pilot));
                    query.Descend("_name").Constrain("T0").EndsWith(false).Not();
                    //query.Descend("_name").Constrain("Pil").StartsWith(true);
                    IObjectSet result = query.Execute();
                    ListResult(result);
                }
                catch (Db4oException ex)
                {
                    Console.WriteLine("Db4o Exception: " + ex.Message);
                }
                catch (Exception ex)
                {
                    Console.WriteLine("System Exception: " + ex.Message);
                }
                finally
                {
                    CloseDatabase();
                }
            }
        }
        // end TestStartsEnds

        public static void TestIdentity()
        {
            File.Delete(Db4oFileName);
            IObjectContainer container = Database();
            if (container != null)
            {
                try
                {
                    Pilot pilot = new Pilot("Test Pilot1", 100);
                    Car car = new Car("BMW", pilot);
                    container.Set(car);
                    // Change the name, the pilot instance stays the same
                    pilot.Name = "Test Pilot2";
                    // create a new car
                    car = new Car("Ferrari", pilot);
                    container.Set(car);

                    // Simple query: 
                    IQuery query1 = container.Query();
                    query1.Constrain(typeof(Car));
                    query1.Descend("_pilot").Constrain(pilot);
                    IObjectSet result = query1.Execute();
                    ListResult(result);

                    // identity.IQuery:
                    IQuery query2 = container.Query();
                    query2.Constrain(typeof(Car));
                    // All cars having pilot with the same Database identity
                    // will be retrieved. As we only created Pilot object once
                    // it should mean all car objects
                    query2.Descend("_pilot").Constrain(pilot).Identity();
                    result = query2.Execute();
                    ListResult(result);
                }
                catch (Db4oException ex)
                {
                    Console.WriteLine("Db4o Exception: " + ex.Message);
                }
                catch (Exception ex)
                {
                    Console.WriteLine("System Exception: " + ex.Message);
                }
                finally
                {
                    CloseDatabase();
                }
            }
        }
        // end TestIdentity

        private static void ListResult(IObjectSet result)
        {
            System.Console.WriteLine(result.Count);
            for (int i = 0; i < result.Count; i++)
            {
                System.Console.WriteLine(result[i]);
            }
        }

        // end ListResult
    }
}
