/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * misc_gtk.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: misc_gtk.h,v 1.1 2003/12/26 14:31:52 uid68112 Exp $
*/

#ifndef __MISC_GTK_H__
#define __MISC_GTK_H__

/* gtk2 provides a direct association between a widget name and a widget pointer */
/* the 2 things to provide is the main window containing the widget and the widget name */
#if 0
#define get_widget_by_widget_name(obj,name)		g_object_get_data(G_OBJECT(obj),name)

/* unfortunatelly, there is no retrieve the name of an object, only an object from its name */
/* to avoid the problem, we redefine g_object_set_data_full to force it to set widget_name */
#define g_object_set_data_full(obj,nam,wid,destr)  \
	{g_object_set_data_full(obj,nam,wid,destr); gtk_widget_set_name(GTK_WIDGET(wid),nam); }
#define g_object_set_data(obj,nam,wid)  \
	{g_object_set_data(obj,nam,wid); gtk_widget_set_name(GTK_WIDGET(wid),nam); }
#else
#include "support.h"

#define get_widget_by_widget_name(obj,name)		lookup_widget(obj,name)

#define get_name_of_a_widget(obj)   gtk_widget_get_name(obj)

#define g_object_set_data_full(obj,nam,wid,destr)  \
	{g_object_set_data_full(obj,nam,wid,destr); gtk_widget_set_name(GTK_WIDGET(wid),nam); }
#define gtk_object_set_data_full(obj,nam,wid,destr)  \
	{gtk_object_set_data_full(obj,nam,wid,destr); gtk_widget_set_name(GTK_WIDGET(wid),nam); }

#if 0
#define g_object_set_data(obj,nam,wid)  \
	{g_object_set_data(obj,nam,wid); gtk_widget_set_name(GTK_WIDGET(wid),nam); }
#define gtk_object_set_data(obj,nam,wid)  \
	{gtk_object_set_data(obj,nam,wid); gtk_widget_set_name(GTK_WIDGET(wid),nam); }
#endif

#endif

/***************************************************************************/
/* take the string contained in the gtk_entry having the name "entry_name" */
/* and compare it to array.                                                */
/***************************************************************************/
/* output: index of the entry_name content string into array       */
/*         on error or when the string is not found, 0 is returned */
/*******************************************************************/
int gtk_entry_to_number(char *entry_name, const char *array[]);

/***************************************************************************/
/* take the string contained in the gtk_entry having the name "entry_name" */
/* and compare it to array.                                                */
/***************************************************************************/
/* output: index of the entry_name content string into array        */
/*         on error or when the string is not found, -1 is returned */
/********************************************************************/
int gtk_entry_to_number_wo_default(char *entry_name, const char *array[]);

#endif
