<?php
/*
 * $Id: class.boAttributesets.inc.php,v 1.2.2.1 2002/02/15 02:49:53 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('bo');

class boAttributesets
{
	function showall()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.htmlAttributesets');
		$obj->PrintAll();
	}

	function showmapping()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.htmlAttributesetmapping');
		$obj->Show($GLOBALS['setid'], $GLOBALS['typeid']);
	}

	function dbmap()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.dbAttributesetsmap');
		$obj->Connect();
		$obj->setid = $GLOBALS['setid'];
		$obj->typeid = $GLOBALS['typeid'];
		$obj->BeginTransaction();
		$obj->Execute('DELETE FROM attributesetsmap WHERE setid=' . $obj->setid . ' AND typeid=' . $obj->typeid);

		if (strlen($GLOBALS['keyidset']) > 0)
		{
			$keys = explode(',', $GLOBALS['keyidset']);
			$i = 1;
			while (list($junk, $id) = each($keys))
			{
				$obj->weight = $i;
				$obj->keyid = $id;
				$obj->Add();
				$i++;
			}
		}

		$obj->EndTransaction();

		$objA = CreateObject('dcl.dbAttributesets');
		$objA->Connect();
		$objA->Load($obj->setid);

		$objH = CreateObject('dcl.htmlAttributesetdetail');
		$objH->Show($objA);
	}

	function view()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']))
			return PrintPermissionDenied();

		$objA = CreateObject('dcl.dbAttributesets');
		$objA->Connect();
		$objA->Load($GLOBALS['id']);

		$obj = CreateObject('dcl.htmlAttributesetdetail');
		$obj->Show($objA);
	}

	function add()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.htmlAttributesets');
		$obj->ShowEntryForm();
		print('<p>');
		$obj->PrintAll();
	}

	function dbadd()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.dbAttributesets');
		$obj->Connect();
		$obj->InitFromGlobals();
		$obj->Add();

		$objHTML = CreateObject('dcl.htmlAttributesets');
		$objHTML->PrintAll();
	}

	function modify()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.dbAttributesets');
		$obj->Connect();
		$obj->Load($GLOBALS['id']);
		$objHTML = CreateObject('dcl.htmlAttributesets');
		$objHTML->ShowEntryForm($obj);
	}

	function dbmodify()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.dbAttributesets');
		$obj->Connect();
		$obj->InitFromGlobals();
		$obj->Edit();
		$objHTML = CreateObject('dcl.htmlAttributesets');
		$objHTML->PrintAll();
	}
	function delete()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.dbAttributesets');
		$obj->Connect();
		$obj->Load($GLOBALS['id']);
		ShowDeleteYesNo('Attribute Set', 'boAttributesets.dbdelete', $obj->id, $obj->name);
	}

	function dbdelete()
	{
		$classSubName = 'Attributesets';

		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.db' . $classSubName);
		$obj->connect();
		$obj->Load($GLOBALS['id']);

		$objKey = new dclDB; // Don't really need anything fancy, 'spose...
		$noref = true;
		$objKey->connect($obj->conn);
		while ((list($table, $field) = each($obj->foreignKeys)) && $noref)
		{
			if (is_array($field)) // More than one field in here references this key
			{
				while ((list($dummykey, $onefield) = each($field)) && $noref)
				{
					$obj->Query("SELECT $onefield FROM $table WHERE $onefield=" . $GLOBALS['id']);
					if ($obj->next_record())
						$noref = false;
				}
			}
			else
			{
				$obj->Query("SELECT $field FROM $table WHERE $field=" . $GLOBALS['id']);
				if ($obj->next_record())
					$noref = false;
			}
		}

		if ($noref)
		{
			$obj->Delete();
			print(STR_BO_DELETED);
		}
		else
		{
			$obj->SetActive(false);
			print(STR_BO_DEACTIVATED);
		}

		$objHTML = CreateObject('dcl.html' . $classSubName);
		$objHTML->PrintAll();
	}
}
?>
