<?php
/*
 * $Id: class.boView.inc.php,v 1.5.4.3 2003/01/26 18:29:15 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

class boView
{
	var $title;
	var $table;
	var $columns;
	var $columnhdrs;
	var $groups;
	var $order;
	var $filter;
	var $filternot;
	var $filterdate;
	var $filterlike;
	var $logicdate;
	var $logiclike;
	var $joins;
	var $urlpieces;
	var $style;
	var $startrow;
	var $numrows;

	function boView()
	{
		$this->Clear();
		$this->startrow = 0;
		$this->numrows = 0;
		$this->urlpieces = array(
				'vt',
				'vti',
				'vc',
				'vch',
				'vg',
				'vo',
				'vf',
				'vfn',
				'vfd',
				'vfl',
				'vs'
			);
	}

	function ClearDef($def)
	{
		$code = sprintf('$this->%s = array();', $def);
		eval($code);
	}

	function Clear()
	{
		// Set some defaults
		$this->title = '';
		$this->table = 'workorders';
		$this->columns = array();
		$this->columnhdrs = array();
		$this->groups = array();
		$this->order = array();
		$this->filter = array();
		$this->filternot = array();
		$this->filterdate = array();
		$this->filterlike = array();
		$this->joins = array();
		$this->logicdate = 'OR';
		$this->logiclike = 'OR';
		$this->style = 'spreadsheet';
	}

	function GetURLArray($field, &$arr, $encode = true)
	{
		reset($arr);
		$retVal = '';

		if (count($arr) > 0)
		{
			$retVal = $field . '=';
			$bFirst = true;
			while (list($key, $value) = each($arr))
			{
				if (is_array($value))
				{
					if ($bFirst == false)
						$retVal .= ',';

					if (count($value) > 0)
					{
						$retVal .= $key . ',' . count($value);
						while (list($key, $realVal) = each($value))
						{
							if ($encode)
								$retVal .= ',' . rawurlencode($realVal);
							else
								$retVal .= ',' . $realVal;
						}
					}
				}
				else
				{
					if ($bFirst == false)
						$retVal .= ',';

					if ($encode)
						$retVal .= rawurlencode($value);
					else
						$retVal .= $value;
				}

				$bFirst = false;
			}
		}

		return $retVal;
	}

	// Gets a URL to regenerate this view in another page
	function GetURL()
	{
		$retVal = 'vt=' . $this->table;
		$retVal .= '&vs=' . $this->style;
		if ($this->title != '')
			$retVal .= '&vti=' . rawurlencode($this->title);
		if (count($this->columns) > 0)
			$retVal .= '&';
		$retVal .= $this->GetURLArray('vc', $this->columns);
		if (count($this->columnhdrs) > 0)
			$retVal .= '&';
		$retVal .= $this->GetURLArray('vch', $this->columnhdrs);
		if (count($this->columns) > 0)
			$retVal .= '&';
		$retVal .= $this->GetURLArray('vg', $this->groups);
		if (count($this->order) > 0)
			$retVal .= '&';
		$retVal .= $this->GetURLArray('vo', $this->order);
		if (count($this->filter) > 0)
			$retVal .= '&';
		$retVal .= $this->GetURLArray('vf', $this->filter);
		if (count($this->filternot) > 0)
			$retVal .= '&';
		$retVal .= $this->GetURLArray('vfn', $this->filternot);
		if (count($this->filterdate) > 0)
			$retVal .= '&';
		$retVal .= $this->GetURLArray('vfd', $this->filterdate);
		if (count($this->filterlike) > 0)
			$retVal .= '&';
		$retVal .= $this->GetURLArray('vfl', $this->filterlike);

		return $retVal;
	}

	function GetFormElement($var, $val)
	{
		return sprintf('<input type="hidden" name="%s" value="%s">', $var, $val) . phpCrLf;
	}

	function GetForm()
	{
		$retVal = $this->GetFormElement('vt', $this->table);
		$retVal .= $this->GetFormElement('vs', $this->style);
		if ($this->title != '')
			$retVal .= $this->GetFormElement('vti', htmlspecialchars($this->title));

		$arrItems = array('vc' => 'columns', 'vch' => 'columnhdrs', 'vg' => 'groups', 'vo' => 'order', 
				'vf' => 'filter', 'vfn' => 'filternot', 'vfd' => 'filterdate', 'vfl' => 'filterlike');
		while (list($attr, $arr) = each($arrItems))
		{
			if (count($this->$arr) > 0)
			{
				list($var, $val) = explode('=', $this->GetURLArray($attr, $this->$arr, false));
				$retVal .= $this->GetFormElement($var, htmlspecialchars($val));
			}
		}

		return $retVal;
	}

	function SetFromURL()
	{
		$this->Clear();

		if (IsSet($GLOBALS['vt']))
			$this->table = $GLOBALS['vt'];

		if (IsSet($GLOBALS['vs']))
			$this->style = $GLOBALS['vs'];

		if (IsSet($GLOBALS['vti']))
		{
			$o = CreateObject('dcl.dbPersonnel');
			$this->title = $o->GPCStripSlashes($GLOBALS['vti']);
		}

		if (IsSet($GLOBALS['vc']))
			$this->columns = explode(',', $GLOBALS['vc']);

		if (IsSet($GLOBALS['vch']))
			$this->columnhdrs = explode(',', $GLOBALS['vch']);

		if (IsSet($GLOBALS['vg']))
			$this->groups = explode(',', $GLOBALS['vg']);

		if (IsSet($GLOBALS['vo']))
			$this->order = explode(',', $GLOBALS['vo']);

		$filterSet = array(
				'vf' => 'filter',
				'vfn' => 'filternot',
				'vfd' => 'filterdate',
				'vfl' => 'filterlike');

		while (list($urlName, $filterName) = each($filterSet))
		{
			if (IsSet($GLOBALS[$urlName]))
			{
				$allFilters = explode(',', $GLOBALS[$urlName]);

				// Get the field
				while (list($key, $field) = each($allFilters))
				{
					// Get how many are in there
					list($key, $numValues) = each($allFilters);
					for ($i = 0; $i < $numValues; $i++)
					{
						// Get that many values and store for that field
						list($key, $value) = each($allFilters);
						$this->AddDef($filterName, $field, $value);
					}
				}
			}
		}
	}

	function SetFromURLString($strURL)
	{
		$this->Clear();

		parse_str($strURL);

		if (IsSet($vt))
			$this->table = $vt;

		if (IsSet($vs))
			$this->style = $vs;

		if (IsSet($vti))
			$this->title = $vti;

		if (IsSet($vc) && trim($vc) != '')
			$this->columns = explode(',', $vc);

		if (IsSet($vch) && trim($vch) != '')
			$this->columnhdrs = explode(',', $vch);

		if (IsSet($vg) && trim($vg) != '')
			$this->groups = explode(',', $vg);

		if (IsSet($vo) && trim($vo) != '')
			$this->order = explode(',', $vo);

		$filterSet = array(
				'vf' => 'filter',
				'vfn' => 'filternot',
				'vfd' => 'filterdate',
				'vfl' => 'filterlike');

		while (list($urlName, $filterName) = each($filterSet))
		{
			if (IsSet($$urlName) && trim($$urlName) != '')
			{
				$allFilters = explode(',', $$urlName);

				// Get the field
				while (list($key, $field) = each($allFilters))
				{
					// Get how many are in there
					list($key, $numValues) = each($allFilters);
					for ($i = 0; $i < $numValues; $i++)
					{
						// Get that many values and store for that field
						list($key, $value) = each($allFilters);
						$this->AddDef($filterName, $field, $value);
					}
				}
			}
		}
	}

	function AddDef($which, $field, $value = "")
	{
		if (is_array($value))
		{
			while (list($key, $qvalue) = each($value))
			{
				if (substr($which, 0, 6) == 'filter')
					$code = sprintf('$this->%s["%s"][] = "%s";', $which, $field, $qvalue);
				else
					$code = sprintf('$this->%s[] = "%s";', $which, $qvalue);

				eval($code);
			}					
		}
		else
		{
			if (substr($which, 0, 6) == 'filter')
				$code = sprintf('$this->%s["%s"][] = "%s";', $which, $field, $value);
			else
				$code = sprintf('$this->%s[] = "%s";', $which, $field);

			eval($code);
		}
	}

	// That's Comma Separated List :)
	function GetCSLFromArray(&$arr, $appendTableForJoin = false)
	{
		reset($arr);
		$retVal = '';

		if (count($arr) > 0)
		{
			if ($appendTableForJoin == true && count($this->joins) > 0)
			{
				while (list($key, $field) = each($arr))
				{
					if ($retVal != '')
						$retVal .= ',';

					if (strpos($field, '.') > 0)
						$retVal .= $field; // He said they've already got one!
					else
						$retVal .= $this->table . '.' . $field;
				}
			}
			else
				$retVal = implode(',', $arr);
		}

		return $retVal;
	}

	function GetJoinForTable($table)
	{
		if ($table == '' || $table == $this->table)
			return '';

		$join = '';
		if ($this->table == 'workorders')
		{
			switch ($table)
			{
				case 'severities':
					$join = 'workorders.severity=severities.id';
					break;
				case 'priorities':
					$join = 'workorders.priority=priorities.id';
					break;
				case 'accounts':
					$join = 'workorders.account=accounts.id';
					break;
				case 'products':
					$join = 'workorders.product=products.id';
					break;
				case 'dcl_projects':
					$join = 'dcl_projects.projectid = projectmap.projectid';
					break;
				case 'dcl_product_module':
					$join = 'workorders.module_id=dcl_product_module.product_module_id';
					break;
				case 'projectmap':
					$join = 'workorders.jcn = projectmap.jcn AND (workorders.seq = projectmap.seq OR projectmap.seq = 0)';
					break;
				case 'statuses':
					$join = 'workorders.status=statuses.id';
					break;
				case 'personnel a':
					$join = 'workorders.responsible=a.id';
					break;
				case 'personnel b':
					$join = 'workorders.closedby=b.id';
					break;
				case 'personnel c':
					$join = 'workorders.createby=c.id';
					break;
			}
		}
		elseif ($this->table == 'tickets')
		{
			switch ($table)
			{
				case 'severities':
					$join = 'tickets.type=severities.id';
					break;
				case 'priorities':
					$join = 'tickets.priority=priorities.id';
					break;
				case 'accounts':
					$join = 'tickets.account=accounts.id';
					break;
				case 'products':
					$join = 'tickets.product=products.id';
					break;
				case 'dcl_product_module':
					$join = 'tickets.module_id=dcl_product_module.product_module_id';
					break;
				case 'statuses':
					$join = 'tickets.status=statuses.id';
					break;
				case 'personnel a':
					$join = 'tickets.responsible=a.id';
					break;
				case 'personnel b':
					$join = 'tickets.closedby=b.id';
					break;
				case 'personnel c':
					$join = 'tickets.createdby=c.id';
					break;
			}
		}
		elseif ($this->table == 'dcl_projects')
		{
			switch ($table)
			{
				case 'statuses':
					$join = 'dcl_projects.status=statuses.id';
					break;
				case 'personnel a':
					$join = 'dcl_projects.reportto=a.id';
					break;
			}
		}

		return $join;
	}

	function AppendJoins(&$arr)
	{
		if (count($arr) > 0)
		{
			reset($arr);
			$joinon = '';
			$i = 0;
			while (list($key, $field) = each($arr))
			{
				// If field is an array, then it contains values - $key is our real field
				if (is_array($field))
					$field = $key;

				if (strpos($field, '.') > 0)
				{
					list($table, $tablefield) = explode('.', $field);
					if ($table == $this->table)
						continue;
						
					$iJoinType = 1; // 1 = normal, 2 = left

					switch ($table)
					{
						case 'a':
							$table = 'personnel a';
							break;
						case 'b':
							$table = 'personnel b';
							break;
						case 'c':
							$table = 'personnel c';
							break;
						case 'responsible':
							$table = 'personnel a';
							$arr[$i] = str_replace('responsible', 'a', $arr[$i]);
							break;
						case 'closedby':
							$table = 'personnel b';
							$arr[$i] = str_replace('closedby', 'b', $arr[$i]);
							break;
						case 'createdby':
						case 'createby':
							$arr[$i] = str_replace($table, 'c', $arr[$i]);
							$table = 'personnel c';
							break;
						case 'reportto':
							$table = 'personnel a';
							$arr[$i] = str_replace('reportto', 'a', $arr[$i]);
							break;
						case 'accounts':
							$iJoinType = 2;
							break;
						case 'dcl_projects':
							$iJoinType = 2;
							break;
						case 'projectmap':
							$iJoinType = 2;
							break;
						case 'dcl_product_module':
							$iJoinType = 2;
							break;
					}

					if (!IsSet($this->joins[$table]))
					{
						// work orders are associated to projects in the projectmap table
						// so append it here - we don't want it in the selected columns
						if ($table == 'dcl_projects')
							$this->joins['projectmap'] = 2;
						
						$this->joins[$table] = $iJoinType;
					}
				}

				$i++;
			}
		}
	}

	function GetSQL($bCount = false)
	{
		global $dcl_domain, $dcl_domain_info;

		// Check for joins - currently we'll just look at the order by and groups since
		// we don't really get that complex anywhere except for searches
		$this->joins = array();
		$this->AppendJoins($this->order);
		$this->AppendJoins($this->groups);
		$this->AppendJoins($this->columns);
		$this->AppendJoins($this->filter);
		$this->AppendJoins($this->filternot);

		$sql = 'SELECT ';

		if ($bCount)
		{
			$sql .= 'COUNT(*)';
		}
		else
		{
			if (count($this->columns) > 0 || count($this->groups) > 0)
			{
				if (count($this->groups) > 0)
					$sql .= $this->GetCSLFromArray($this->groups, true);

				if (count($this->columns) > 0)
				{
					if (count($this->groups) > 0)
						$sql .= ",";

					$sql .= $this->GetCSLFromArray($this->columns, true);
				}
			}
			else
				$sql .= '*';
		}

		$sql .= ' FROM ' . $this->table;

		$bDoneDidWhere = false;

		// Add joins, if any
		if (count($this->joins) > 0)
		{
			reset($this->joins);
			$joinsql = '';
			while (list($table, $iJoinType) = each($this->joins))
			{
				if ($iJoinType == 2)
					$joinsql .= ' LEFT';
				else if ($dcl_domain_info[$dcl_domain]['dbType'] == 'mysql') // Hackage to make MySQL happy again
					$joinsql .= ' INNER';

				$joinsql .= ' JOIN ' . $table . ' ON ' . $this->GetJoinForTable($table);
			}

			$sql .= $joinsql . ' ';
		}

		if (count($this->filter) > 0)
		{
			if ($bDoneDidWhere == false)
			{
				$bDoneDidWhere = true;
				$sql .= ' WHERE ';
			}
			else
				$sql .= ' AND ';

			$bFirst = true;
			reset($this->filter);
			while (list($field, $values) = each($this->filter))
			{
				// prepend table name if not specified to avoid ambiguity
				if (strpos($field, '.') < 1)
					$field = $this->table . '.' . $field;

				if ($bFirst == false)
					$sql .= ' AND ';

				$bFirst = false;
				if (count($values) == 1)
					$sql .= "($field=" . $this->GetCSLFromArray($values) . ')';
				else
					$sql .= "($field in (" . $this->GetCSLFromArray($values) . '))';
			}
		}

		if (count($this->filternot) > 0)
		{
			if ($bDoneDidWhere == false)
			{
				$bDoneDidWhere = true;
				$sql .= ' WHERE ';
			}
			else
				$sql .= ' AND ';

			$bFirst = true;
			reset($this->filternot);
			while (list($field, $values) = each($this->filternot))
			{
				// prepend table name if not specified to avoid ambiguity
				if (strpos($field, '.') < 1)
					$field = $this->table . '.' . $field;

				if ($bFirst == false)
					$sql .= ' AND ';

				$bFirst = false;
				if (count($values) == 1)
					$sql .= "($field!=" . $this->GetCSLFromArray($values) . ')';
				else
					$sql .= "($field not in (" . $this->GetCSLFromArray($values) . '))';
			}
		}

		$objWO = CreateObject('dcl.dbWorkorders');

		if (count($this->filterdate) > 0)
		{
			if ($bDoneDidWhere == false)
			{
				$bDoneDidWhere = true;
				$sql .= ' WHERE (';
			}
			else
				$sql .= ' AND (';

			$bFirst = true;
			reset($this->filterdate);
			while (list($field, $values) = each($this->filterdate))
			{
				// prepend table name if not specified to avoid ambiguity
				if (strpos($field, '.') < 1)
					$field = $this->table . '.' . $field;

				if ($bFirst == false)
					$sql .= ' ' . $this->logicdate . ' ';

				$bFirst = false;
				if ($values[0] != '' && $values[1] != '')
				{
					$sql .= sprintf('(%s between %s and %s)',
							$field,
							$objWO->DisplayToSQL($values[0]),
							$objWO->DisplayToSQL($values[1]));
				}
				else if ($values[0] != '')
					{
						$sql .= sprintf('(%s >= %s)',
								$field,
								$objWO->DisplayToSQL($values[0]));
					}
					else if ($values[1] != '')
						{
							$sql .= sprintf('(%s <= %s)',
									$field,
									$objWO->DisplayToSQL($values[1]));
						}
			}

			$sql .= ')';
		}

		if (count($this->filterlike) > 0)
		{
			if ($bDoneDidWhere == false)
			{
				$bDoneDidWhere = true;
				$sql .= ' WHERE (';
			}
			else
				$sql .= ' AND (';

			$bFirst = true;
			reset($this->filterlike);
			while (list($field, $values) = each($this->filterlike))
			{
				// prepend table name if not specified to avoid ambiguity
				if (strpos($field, '.') < 1)
					$field = $this->table . '.' . $field;

				if ($bFirst == false)
					$sql .= ' ' . $this->logiclike . ' ';

				$bFirst = false;
				$sql .= sprintf('(%s like \'%%%s%%\')', $objWO->GetUpperSQL($field), strtoupper($values[0]));
			}

			$sql .= ')';
		}

		if (!$bCount && (count($this->order) > 0 || count($this->groups) > 0))
		{
			$sql .= ' ORDER BY ';
			if (count($this->groups) > 0)
				$sql .= $this->GetCSLFromArray($this->groups);

			if (count($this->order) > 0)
			{
				if (count($this->groups) > 0)
					$sql .= ',';

				$sql .= $this->GetCSLFromArray($this->order);
			}
		}

		return $sql;
	}
}
?>
