<?php
/*
 * $Id: class.htmlActions.inc.php,v 1.2.2.1 2002/02/15 07:06:27 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('actn');

class htmlActions
{
	function createCombo($default = 0, $cbName = 'action', $longShort = 'name', $size = 0, $activeOnly = true, $setid = 0)
	{
		print $this->GetCombo($default, $cbName, $longShort, $size, $activeOnly, $setid);
	}

	function GetCombo($default = 0, $cbName = 'action', $longShort = 'name', $size = 0, $activeOnly = true, $setid = 0)
	{
		$objDBActions = CreateObject('dcl.dbActions');
		$objDBActions->Connect();
		$objDBActions->cacheEnabled = false;

		$query = "SELECT a.id,a.$longShort FROM actions a ";

		if ($setid > 0)
		{
			$query .= ",attributesetsmap b WHERE a.id=b.keyid AND b.typeid=1 AND b.setid=$setid ";
			if ($activeOnly)
				$query .= ' AND a.active=\'Y\' ';
		}
		else
		{
			if ($activeOnly)
				$query .= 'WHERE a.active=\'Y\' ';
		}

		$query .= "ORDER BY $longShort";
		$objDBActions->Query($query);

		$str = "<select name=\"$cbName";
		if ($size > 0)
			$str .= '[]" multiple size="' . $size;

		$str .= '">';
		if ($size == 0)
			$str .= '<option value="0">' . STR_ACTN_SELECTONE . '</option>';

		while ($objDBActions->next_record())
		{
			$id = $objDBActions->f(0);
			$text = $objDBActions->f(1);
			$str .= "<option value=\"$id\"";
			if ($id == $default)
				$str .= ' selected';
			$str .= '>' . $text . '</option>';
		}

		$str .= '</select>';

		return $str;
	}

	function PrintAll($orderBy = 'name')
	{
		global $dcl_info;

		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']))
			return PrintPermissionDenied();

		$objDBActions = CreateObject('dcl.dbActions');
		$objDBActions->Connect();

		$objDBActions->Query("SELECT id,active,short,name FROM actions ORDER BY $orderBy");
		$allRecs = $objDBActions->FetchAllRows();

		if ($GLOBALS['SEC'] >= $dcl_info['DCL_ADD_USER'])
			$titleLink = '<a class="adark" href="' . menuLink('', 'menuAction=boActions.add') . '">[ ' . STR_CMMN_NEW . ' ]</a>';
		else
			$titleLink = '';

		if (count($allRecs) > 0)
		{
			$allName = array(
					0 => STR_ACTN_ID, 
					1 => STR_ACTN_ACTIVEABB, 
					2 => STR_ACTN_SHORT, 
					3 => STR_ACTN_NAME);

			if (count($allRecs) > 0 && $GLOBALS['SEC'] >= $dcl_info['DCL_ADD_USER'])
			{
				$allName[] = STR_ACTN_OPTIONS;
				for ($i = 0; $i < count($allRecs); $i++)
				{
					$options = '<a class="adark" href="' . menuLink('', 'menuAction=boActions.modify&id=' . $allRecs[$i][0]) . '">' . STR_CMMN_EDIT . '</a>';
					$options .= '&nbsp;';
					$options .= '<a class="adark" href="' . menuLink('', 'menuAction=boActions.delete&id=' . $allRecs[$i][0]) . '">' . STR_CMMN_DELETE . '</a>';
					$allRecs[$i][] = $options;
				}
			}
			PrintArrayAsChocoTable($allName, $allRecs, sprintf(STR_ACTN_TABLETITLE, $orderBy), '', $titleLink);
		}
		else
		{
			print('<CENTER>');
			PrintWithChocoFont(STR_ACTN_NOACTIONS . '&nbsp;&nbsp;' . $titleLink);
			print('</CENTER>');
		}
	}

	function ShowEntryForm($obj = '')
	{
		global $dcl_info;

		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']))
			return PrintPermissionDenied();

		$isEdit = is_object($obj);
		$Template = CreateTemplate(array('hForm' => 'htmlActionsForm.tpl'));
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('VAL_FORMACTION', menuLink());

		$hidden_vars = '';
		if ($isEdit)
		{
			$Template->set_var('TXT_FUNCTION', STR_ACTN_EDIT);
			$hidden_vars .= '<input type="hidden" name="menuAction" value="boActions.dbmodify">';
			$hidden_vars .= '<input type="hidden" name="id" value="' . $GLOBALS['id'] . '">';
		}
		else
		{
			$Template->set_var('TXT_FUNCTION', STR_ACTN_ADD);
			$hidden_vars .= '<input type="hidden" name="menuAction" value="boActions.dbadd">';
		}

		$Template->set_var('HIDDEN_VARS', $hidden_vars);

		// Labels
		$Template->set_var('TXT_ACTIVE', STR_ACTN_ACTIVE);
		$Template->set_var('TXT_SHORT', STR_ACTN_SHORT);
		$Template->set_var('TXT_NAME', STR_ACTN_NAME);
		$Template->set_var('BTN_OK', STR_CMMN_SAVE);
		$Template->set_var('BTN_RESET', STR_CMMN_RESET);
		$Template->set_var('TXT_HIGHLIGHTEDNOTE', STR_ACTN_HIGHLIGHTEDNOTE);
		$Template->set_var('TXT_ATTRIBUTESNOTE', STR_ACTN_ATTRIBUTENOTE);

		// Data
		if ($isEdit)
		{
			$Template->set_var('CMB_ACTIVE', GetYesNoCombo($obj->active, 'active', 0, false));
			$Template->set_var('VAL_SHORT', $obj->short);
			$Template->set_var('VAL_NAME', $obj->name);
		}
		else
		{
			$Template->set_var('CMB_ACTIVE', GetYesNoCombo('Y', 'active', 0, false));
			$Template->set_var('VAL_SHORT', '');
			$Template->set_var('VAL_NAME', '');
		}

		$Template->pparse('out', 'hForm');
	}
}
?>
