<?php
/*
 * $Id: class.htmlDepartments.inc.php,v 1.3.2.1 2002/02/15 07:06:27 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('dept');

class htmlDepartments
{
	function createCombo($default = 0, $cbName = 'department', $longShort = 'name', $size = 0, $activeOnly = true)
	{
		print $this->GetCombo($default, $cbName, $longShort, $size, $activeOnly);
	}

	function GetCombo($default = 0, $cbName = 'department', $longShort = 'name', $size = 0, $activeOnly = true)
	{
		$objDBDept = CreateObject('dcl.dbDepartments');
		$objDBDept->Connect();
		$objDBDept->cacheEnabled = false;

		$query = "SELECT id,$longShort FROM departments ";

		if ($activeOnly)
			$query .= 'WHERE active=\'Y\' ';

		$query .= "ORDER BY $longShort";
		$objDBDept->Query($query);

		$str = "<select name=\"$cbName";
		if ($size > 0)
			$str .= '[]" multiple size=' . $size;
		else
			$str .= '"';
		$str .= '>';
		if ($size == 0)
			$str .= sprintf('<option value="0">%s</option>', STR_DEPT_SELECTONE);

		while ($objDBDept->next_record())
		{
			$id = $objDBDept->f(0);
			$name = $objDBDept->f(1);
			$str .= '<option value="'. $id . '"';
			if ($id == $default)
				$str .= ' selected';
			$str .= '>' . $name . '</option>';
		}

		$str .= '</select>';

		return $str;
	}

	function PrintAll($orderBy = 'name')
	{
		global $dcl_info;

		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']))
			return PrintPermissionDenied();

		$objDBDepts = CreateObject('dcl.dbDepartments');
		$objDBDepts->Connect();

		$objDBDepts->Query("SELECT id,active,short,name FROM departments ORDER BY $orderBy");
		$allRecs = $objDBDepts->FetchAllRows();

		if ($GLOBALS['SEC'] >= $dcl_info['DCL_ADD_USER'])
			$titleLink = '<a class="adark" href="' . menuLink('', 'menuAction=boDepartments.add') . '">[ ' . STR_CMMN_NEW . ' ]</a>';
		else
			$titleLink = '';

		if (count($allRecs) > 0)
		{
			$allName = array(
					0 => STR_DEPT_ID, 
					1 => STR_DEPT_ACTIVEABB, 
					2 => STR_DEPT_SHORT, 
					3 => STR_DEPT_NAME);

			if (count($allRecs) > 0 && $GLOBALS['SEC'] >= $dcl_info['DCL_ADD_USER'])
			{
				$allName[] = STR_DEPT_OPTIONS;
				for ($i = 0; $i < count($allRecs); $i++)
				{
					$options = '<a class="adark" href="' . menuLink('', 'menuAction=boDepartments.modify&id=' . $allRecs[$i][0]) . '">' . STR_CMMN_EDIT . '</a>';
					$options .= "&nbsp;";
					$options .= '<a class="adark" href="' . menuLink('', 'menuAction=boDepartments.delete&id=' . $allRecs[$i][0]) . '">' . STR_CMMN_DELETE . '</a>';
					$allRecs[$i][] = $options;
				}
			}
			PrintArrayAsChocoTable($allName, $allRecs, sprintf(STR_DEPT_TABLETITLE, $orderBy), '', $titleLink);
		}
		else
		{
			print('<CENTER>');
			print(STR_DEPT_NODEPTS . '&nbsp;&nbsp;' . $titleLink);
			print('</CENTER>');
		}
	}

	function ShowEntryForm($obj = '')
	{
		global $dcl_info;

		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']))
			return PrintPermissionDenied();

		$isEdit = is_object($obj);
		$Template = CreateTemplate(array('hForm' => 'htmlDepartmentsForm.tpl'));
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('VAL_FORMACTION', menuLink());

		$hidden_vars = '';
		if ($isEdit)
		{
			$Template->set_var('TXT_FUNCTION', STR_DEPT_EDIT);
			$hidden_vars .= '<input type="hidden" name="menuAction" value="boDepartments.dbmodify">';
			$hidden_vars .= '<input type="hidden" name="id" value="' . $GLOBALS['id'] . '">';
		}
		else
		{
			$Template->set_var('TXT_FUNCTION', STR_DEPT_ADD);
			$hidden_vars .= '<input type="hidden" name="menuAction" value="boDepartments.dbadd">';
		}

		$Template->set_var('HIDDEN_VARS', $hidden_vars);

		// Labels
		$Template->set_var('TXT_ACTIVE', STR_DEPT_ACTIVE);
		$Template->set_var('TXT_SHORT', STR_DEPT_SHORT);
		$Template->set_var('TXT_NAME', STR_DEPT_NAME);
		$Template->set_var('BTN_OK', STR_CMMN_SAVE);
		$Template->set_var('BTN_RESET', STR_CMMN_RESET);
		$Template->set_var('TXT_HIGHLIGHTEDNOTE', STR_DEPT_HIGHLIGHTEDNOTE);

		// Data
		if ($isEdit)
		{
			$Template->set_var('CMB_ACTIVE', GetYesNoCombo($obj->active, 'active', 0, false));
			$Template->set_var('VAL_SHORT', $obj->short);
			$Template->set_var('VAL_NAME', $obj->name);
		}
		else
		{
			$Template->set_var('CMB_ACTIVE', GetYesNoCombo('Y', 'active', 0, false));
			$Template->set_var('VAL_SHORT', '');
			$Template->set_var('VAL_NAME', '');
		}

		$Template->pparse('out', 'hForm');
	}
}
?>
