<?php
/*
 * $Id: class.htmlProductModules.inc.php,v 1.1.2.4 2002/11/01 13:51:38 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('prod');

class htmlProductModules
{
	var $public;

	function htmlProductModules()
	{
		$this->public = array('add', 'modify', 'delete', 'submitAdd', 'submitModify', 'submitDelete', 'PrintAll');
	}

	function createCombo($default = 0, $cbName = 'module', $size = 0, $activeOnly = true, $product_id = 0)
	{
		print $this->GetCombo($default, $cbName, $size, $activeOnly);
	}

	function GetCombo($default = 0, $cbName = 'module', $size = 0, $activeOnly = true, $product_id = 0)
	{
		$filter = '';
		$table = 'dcl_product_module';

		if ($activeOnly)
			$filter = "active='Y'";
			
		if ($product_id > 0)
		{
			if ($filter != '')
				$filter .= ' And ';

			$filter .= 'product_id = ' . $product_id;
		}

		$order = 'module_name';

		$obj = CreateObject('dcl.htmlSelect');
		$obj->SetOptionsFromDb($table, 'product_module_id', 'module_name', $filter, $order);
		$obj->vDefault = $default;
		$obj->sName = $cbName;
		$obj->iSize = $size;
		$obj->sZeroOption = STR_CMMN_SELECTONE;

		return $obj->GetHTML();
	}

	function RenderOptions(&$aRecord)
	{
		echo '<td>';
		echo '<a class="adark" href="' . menuLink('', 'menuAction=htmlProductModules.modify&product_module_id=' . $aRecord['product_module_id']) . '">' . STR_CMMN_EDIT . '</a>';
		echo '&nbsp;';
		echo '<a class="adark" href="' . menuLink('', 'menuAction=htmlProductModules.delete&product_module_id=' . $aRecord['product_module_id']) . '">' . STR_CMMN_DELETE . '</a>';
		echo '</td>';
	}

	function RenderNav()
	{
		if ($GLOBALS['SEC'] >= $dcl_info['DCL_ADD_USER'])
		{
			RenderSepMenu(array(STR_CMMN_NEW => menuLink('', 'menuAction=htmlProductModules.add&product_id=' . $GLOBALS[GetSourceArray()]['product_id']),
								'Detail' => menuLink('', 'menuAction=boProducts.view&id=' . $GLOBALS[GetSourceArray()]['product_id'])));
		}
	}

	function PrintAll($orderBy = 'module_name')
	{
		global $dcl_info;

		commonHeader();

		$oProduct = CreateObject('dcl.dbProducts');
		$oProduct->Connect();
		if ($oProduct->Load($GLOBALS[GetSourceArray()]['product_id']) == -1)
		{
			printf('Could not load product by id %d', $GLOBALS[GetSourceArray()]['product_id']);
			return;
		}

		$o = CreateObject('dcl.boView');
		$o->table = 'dcl_product_module';
		$o->title = sprintf('Modules for Product ' . $oProduct->name, $orderBy);
		$o->AddDef('columns', '', array('product_module_id', 'active', 'module_name'));
		$o->AddDef('columnhdrs', '', array('ID', STR_CMMN_ACTIVE, 'Name'));
		$o->AddDef('order', $orderBy);
		$o->AddDef('filter', 'product_id', $GLOBALS[GetSourceArray()]['product_id']);

		$oView = CreateObject('dcl.htmlView');
		$oView->bColumnSort = false;
		$oView->bShowPager = false;
		if ($GLOBALS['SEC'] >= $dcl_info['DCL_ADD_USER'])
		{
			$oView->sColumnTitle = STR_CMMN_OPTIONS;
			$oView->SetCallback($this, 'RenderOptions', 'RenderNav');
		}

		$oView->Render($o);
	}

	function add()
	{
		commonHeader();
		$this->ShowEntryForm();
		print('<p>');
		$this->PrintAll();
	}

	function modify()
	{
		commonHeader();
		$obj = CreateObject('dcl.dbProductModules');
		$obj->Load($GLOBALS[GetSourceArray()]['product_module_id']);
		$this->ShowEntryForm($obj);
	}

	function delete()
	{
		commonHeader();
		$obj = CreateObject('dcl.dbProductModules');
		$obj->Load($GLOBALS[GetSourceArray()]['product_module_id']);
		ShowDeleteYesNo('Product Module', 'htmlProductModules.submitDelete', $obj->product_module_id, $obj->module_name);
	}

	function submitAdd()
	{
		commonHeader();

		$obj = CreateObject('dcl.boProductModules');
		CleanVars('HTTP_POST_VARS');
		$obj->add($GLOBALS['HTTP_POST_VARS']);
		$this->PrintAll();
	}

	function submitModify()
	{
		commonHeader();

		$obj = CreateObject('dcl.boProductModules');
		CleanVars('HTTP_POST_VARS');
		$obj->modify($GLOBALS['HTTP_POST_VARS']);

		$this->PrintAll();
	}

	function submitDelete()
	{
		commonHeader();

		$obj = CreateObject('dcl.boProductModules');
		CleanVars('HTTP_POST_VARS');
		$obj->oDB->Load($GLOBALS['HTTP_POST_VARS']['id']);
		$GLOBALS['HTTP_POST_VARS']['product_id'] = $obj->oDB->product_id;
		$obj->delete(array('product_module_id' => $GLOBALS['HTTP_POST_VARS']['id']));

		$this->PrintAll();
	}

	function ShowEntryForm($obj = '')
	{
		global $dcl_info;

		$isEdit = is_object($obj);
		$Template = CreateTemplate(array('hForm' => 'htmlProductModulesForm.tpl'));
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('VAL_FORMACTION', menuLink());

		$oProduct = CreateObject('dcl.dbProducts');
		$oProduct->Connect();
		
		$iProductID = $isEdit ? $obj->product_id : $GLOBALS[GetSourceArray()]['product_id'];
		if ($oProduct->Load($iProductID) == -1)
		{
			printf('Could not load product by id %d', $GLOBALS[GetSourceArray()]['product_id']);
			return;
		}

		$hidden_vars = '';
		if ($isEdit)
		{
			$Template->set_var('TXT_FUNCTION', 'Edit Module for Product ' . $oProduct->name);
			$hidden_vars .= GetHiddenVar('menuAction', 'htmlProductModules.submitModify');
			$hidden_vars .= GetHiddenVar('product_module_id', $GLOBALS[GetSourceArray()]['product_module_id']);
		}
		else
		{
			$Template->set_var('TXT_FUNCTION', 'Add Module for Product ' . $oProduct->name);
			$hidden_vars .= GetHiddenVar('menuAction', 'htmlProductModules.submitAdd');
		}

		$hidden_vars .= GetHiddenVar('product_id', $iProductID);
		$Template->set_var('HIDDEN_VARS', $hidden_vars);

		// Labels
		$Template->set_var('TXT_ACTIVE', STR_CMMN_ACTIVE);
		$Template->set_var('TXT_NAME', 'Name');
		$Template->set_var('BTN_OK', STR_CMMN_SAVE);
		$Template->set_var('BTN_CANCEL', STR_CMMN_CANCEL);
		$Template->set_var('URL_BACK', menuLink('', 'menuAction=htmlProductModules.PrintAll&product_id=' . $oProduct->id));
		$Template->set_var('TXT_HIGHLIGHTEDNOTE', STR_CMMN_HIGHLIGHTEDNOTE);
		$Template->set_var('TXT_ATTRIBUTESNOTE', STR_CMMN_ATTRIBUTENOTE);

		// Data
		if ($isEdit)
		{
			$Template->set_var('CMB_ACTIVE', GetYesNoCombo($obj->active, 'active', 0, false));
			$Template->set_var('VAL_NAME', $obj->module_name);
		}
		else
		{
			$Template->set_var('CMB_ACTIVE', GetYesNoCombo('Y', 'active', 0, false));
			$Template->set_var('VAL_NAME', '');
		}

		$Template->pparse('out', 'hForm');
	}
}
?>
