<?php
/*
 * $Id: class.htmlProjects.inc.php,v 1.5.2.1.2.1 2002/11/04 16:00:38 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('prj');
LoadStringResource('wo');

class htmlProjects
{
	function createCombo($default = 0, $cbName = 'project', $reportTo = 0, $size = 0, $dontshowid = -1)
	{
		print $this->GetCombo($default, $cbName, $reportTo, $size, $dontshowid);
	}

	function GetCombo($default = 0, $cbName = 'project', $reportTo = 0, $size = 0, $dontshowid = -1)
	{
		$objDBProjects = CreateObject('dcl.dbProjects');
		$objDBProjects->Connect();
		$whereClause = '';

		if ($reportTo > 0)
			$whereClause = " WHERE reportto=$reportTo";

		if ($dontshowid != -1)
		{
			if ($whereClause == '')
				$whereClause = ' WHERE ';
			else
				$whereClause .= ' AND ';

			$whereClause .= "projectid != $dontshowid";
		}

		$objDBProjects->Query('SELECT projectid,name FROM dcl_projects' . $whereClause . ' ORDER BY name');

		$str = '<select name="' . $cbName;
		if ($size > 0)
			$str .= '[]" multiple size="' . $size . '"';
		else
			$str .= '"';
		$str .= '>';
		if ($size == 0)
			$str .= '<option value="0">' . STR_PRJ_SELECTONE;

		while ($objDBProjects->next_record())
		{
			$id = $objDBProjects->f(0);
			$str .= '<option value="'. $id . '"';
			if ($id == $default)
				$str .= ' selected';
			$str .= '>';
			$str .= $objDBProjects->f(1);
		}

		$str .= '</select>';

		return $str;
	}

	function RenderOptions(&$aRecord)
	{
		$str = '<td>';
		$str .= '<a class="adark" href="' . menuLink('', 'menuAction=boProjects.viewproject&project=' . $aRecord['projectid']) . '">' . 'Detail' . '</a>';
		$str .= '&nbsp;|&nbsp;';
		$str .= '<a class="adark" href="' . menuLink('', 'menuAction=boProjects.showtree&project=' . $aRecord['projectid']) . '">' . 'Tree' . '</a>';
		$str .= '</td>';
		echo $str;
	}

	function RenderFilter(&$sPagerFormElements)
	{
		$oStatus = CreateObject('dcl.htmlStatuses');
		$oReport = CreateObject('dcl.htmlPersonnel');

		$filterStatus = IsSet($GLOBALS['filterStatus']) ? $GLOBALS['filterStatus'] : 1;
		$filterReportto = IsSet($GLOBALS['filterReportto']) ? $GLOBALS['filterReportto'] : 0;

		echo '<form method="post" action="' . menuLink('') . '">';
		echo $sPagerFormElements;
		echo '<br><b>', STR_PRJ_STATUS, ':</b>';
		$oStatus->createCombo($filterStatus, 'filterStatus');
		echo '&nbsp;<b>', STR_PRJ_LEAD, ':</b>';
		$oReport->createCombo($filterReportto, 'filterReportto', 'short', 0, false);
		echo '&nbsp;<input type="submit" value="Filter">';
		echo '</form>';
	}

	function show()
	{
		global $dcl_info;

		commonHeader();

		$oView = CreateObject('dcl.boView');
		if (IsSet($GLOBALS['btnNav']) && IsSet($GLOBALS['startrow']) && IsSet($GLOBALS['numrows']))
		{
			if ($GLOBALS['btnNav'] == '<<')
			{
				$oView->startrow = $GLOBALS['startrow'] - $GLOBALS['numrows'];
				if ($oView->startrow < 0)
					$objView->startrow = 0;
				$oView->numrows = $GLOBALS['numrows'];
			}
			else
			{
				$oView->startrow = $GLOBALS['startrow'] + $GLOBALS['numrows'];
				$oView->numrows = $GLOBALS['numrows'];
			}
		}
		else
		{
			$oView->numrows = 15;
			$oView->startrow = 0;
		}

		$filterStatus = '1';
		$filterReportto = '0';
		if (IsSet($GLOBALS['filterStatus']))
			$filterStatus = $GLOBALS['filterStatus'];
		if (IsSet($GLOBALS['filterReportto']))
			$filterReportto = $GLOBALS['filterReportto'];

		$oView->table = 'dcl_projects';
		$oView->style = 'report';
		$oView->title = 'Projects';
		$oView->AddDef('columnhdrs', '', array(STR_CMMN_ID, STR_PRJ_LEAD, STR_PRJ_STATUS, STR_PRJ_NAME));
		$oView->AddDef('columns', '', array('projectid', 'reportto.short', 'statuses.name', 'dcl_projects.name'));
		if ($dcl_info['DCL_PROJECT_BROWSE_PARENTS_ONLY'] == 'Y')
			$oView->AddDef('filter', 'parentprojectid', 0);

		$oView->AddDef('order', '', array('dcl_projects.name'));

		if ($filterStatus != '0')
			$oView->AddDef('filter', 'dcl_projects.status', $filterStatus);

		if ($filterReportto != '0')
			$oView->AddDef('filter', 'dcl_projects.reportto', $filterReportto);

		$oHtml = CreateObject('dcl.htmlView');
		$oHtml->oCallback = $this;
		$oHtml->sCallback = 'RenderOptions';
		$oHtml->sFilterCallback = 'RenderFilter';
		$oHtml->sColumnTitle = 'Options';
		$oHtml->sPagingMenuAction = 'htmlProjects.show';
		$oHtml->bColumnSort = false;
		$oHtml->bShowPager = false;
		$oHtml->Render($oView);
	}

	function DisplaySearchForm()
	{
		global $dcl_info;

		$Template = CreateTemplate(array('hForm' => 'htmlProjectsSearch.tpl'));
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('VAL_FORMACTION', menuLink());
		$Template->set_var('TXT_TITLE', STR_PRJ_SEARCH);
		$Template->set_var('TXT_CHOOSEPRJ', STR_PRJ_CHOOSEPRJ);
		$Template->set_var('CMB_PROJECT', $this->GetCombo(0, 'project'));
		$Template->set_var('BTN_VIEW', STR_CMMN_VIEW);
		$Template->set_var('BTN_RESET', STR_CMMN_RESET);
		$Template->pparse('out', 'hForm');
	}

	function ShowUploadFileForm($projectid)
	{
		global $dcl_info;

		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_HAVE_WO']))
			return PrintPermissionDenied();

		$Template = CreateTemplate(array('hForm' => 'htmlProjectsUpload.tpl'));
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('VAL_FORMACTION', menuLink());
		$Template->set_var('TXT_TITLE', STR_PRJ_UPLATTACH);
		$Template->set_var('TXT_ATTACH', STR_PRJ_ATTACH);
		$Template->set_var('VAL_MAXUPLOADFILESIZE', $dcl_info['DCL_MAX_UPLOAD_FILE_SIZE']);
		$Template->set_var('VAL_PROJECTID', $projectid);
		$Template->set_var('BTN_UPLOAD', STR_CMMN_UPLOAD);
		$Template->set_var('BTN_RESET', STR_CMMN_RESET);
		$Template->pparse('out', 'hForm');
	}

	function ShowDeleteAttachmentYesNo($projectid, $filename)
	{
		global $dcl_info;

		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_HAVE_WO']))
			return PrintPermissionDenied();

		$Template = CreateTemplate(array('hForm' => 'htmlProjectsDeleteAttachment.tpl'));
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('VAL_FORMACTION', menuLink());
		$Template->set_var('TXT_TITLE', STR_PRJ_DELATTACH);
		$Template->set_var('VAL_PROJECTID', $projectid);
		$Template->set_var('VAL_FILENAME', htmlspecialchars($filename));
		$Template->set_var('TXT_DELCONFIRM', sprintf(STR_PRJ_DELCONFIRM, $filename));
		$Template->set_var('BTN_YES', STR_CMMN_YES);
		$Template->set_var('BTN_NO', STR_CMMN_NO);
		$Template->pparse('out', 'hForm');
	}

	function my($rowlimit = 5)
	{
		global $dcl_info;

		$obj = CreateObject('dcl.dbProjects');
		$obj->Connect();

		$query = sprintf('SELECT projectid,name FROM dcl_projects WHERE reportto=%d AND status=%d ORDER BY name ',
				$GLOBALS['DCLID'], $dcl_info['DCL_DEFAULT_PROJECT_STATUS']);

		if ($rowlimit > 0)
			$obj->LimitQuery($query, 0, $rowlimit);
		else
			$obj->Query($query);

		if ($rowlimit == 0)
		{
			print('<center>');
			BeginChocoTable(false, '50%');
		}
		else
			BeginChocoTable(false);

		print('<tr><th><a class="alightu" href="' . menuLink('', 'menuAction=boProjects.showmy') . '">');
		print(STR_PRJ_MYPRJ);
		print('</a>');
		if ($rowlimit > 0)
			PrintWithChocoFont('&nbsp;&nbsp;(' . sprintf(STR_CMMN_TOPNUM, $rowlimit) . ')');
		print('</th></tr>');

		if ($obj->next_record())
		{
			$i = 0;
			do
			{
				if ($i++ % 2 == 0)
					print('<tr><td bgcolor="#ffffff">');
				else
					print('<tr><td bgcolor="' . $dcl_info['DCL_COLOR_LIGHT'] . '">');
				printf('<a class="adark" href="%s">%s</a>',
					menuLink('', 'menuAction=boProjects.viewproject&wostatus=0&project=' . $obj->f('projectid')),
					$obj->f('name'));
				print('</td></tr>');
			}
			while ($obj->next_record());
		}
		else
		{
			print('<tr><td bgcolor="#ffffff">');
			print(STR_PRJ_NOTLEAD);
			print('</td></tr>');
		}

		print('</td></tr></table>');
	}
}
?>
