<?php
/*
 * $Id: class.htmlProjectsdetail.inc.php,v 1.5.4.8 2003/01/26 18:29:15 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('prj');
LoadStringResource('wo');

class htmlProjectsdetail
{
	var $oPM;

	function GetActionCombo($include)
	{
		global $dcl_info;

		$cmbText = '<select name="menuAction">' . phpCrLf;
		$options = array();

		if ($GLOBALS['SEC'] >= $dcl_info['DCL_MOD_WO'] && ereg('e', $include))
			$options['boProjects.modify'] = STR_PRJ_MODIFY;

		if ($GLOBALS['SEC'] >= $dcl_info['DCL_DEL_WO'] && ereg('x', $include))
			$options['boProjects.delete'] = STR_PRJ_DELETE;

		if ($dcl_info['DCL_MAX_UPLOAD_FILE_SIZE'] > 0 && ereg('f', $include))
			$options['boProjects.upload'] = STR_PRJ_FILEUPLOAD;

		if ($GLOBALS['SEC'] >= $dcl_info['DCL_ASSIGN_WO'])
		{
			$options['boWorkorders.batchdetail'] = 'Batch Detail*';
			$options['boTimecards.batchadd'] = 'Batch Timecard*';
			$options['boWorkorders.batchassign'] = 'Batch Assign*';
			$options['htmlProjectmap.batchMove'] = 'Batch Move*';
		}

		if (ereg('w', $include))
			$options['boWatches.add'] = STR_PRJ_ADDWATCH;

		if (ereg('a', $include))
			$options['boWorkorders.newjcn'] = 'Add Work Order To This Project*';

		asort($options);
		reset($options);
		while (list($value, $text) = each($options))
			$cmbText .= sprintf('<option value="%s">%s</option>', $value, $text) . phpCrLf;

		$cmbText .= '</select>' . phpCrLf;
		return $cmbText;
	}
	
	function GetGroupByCombo()
	{
		$default = IsSet($GLOBALS['wogroupby']) ? $GLOBALS['wogroupby'] : 'none';
		$options = array('none' => 'None', '2' => 'Assigned', '6' => 'Status', '3' => 'Product', '4' => 'Module');
		
		$retVal = '<select name="wogroupby">';
		while (list($k, $v) = each($options))
		{
			$retVal .= sprintf('<option value="%s"%s>%s</option>', $k, $k == $default ? ' selected' : '', $v);
		}

		$retVal .= '</select>';

		return $retVal;
	}

	function Show($projectid, $wostatus, $woresponsible)
	{
		global $dcl_info, $dcl_domain_info, $dcl_domain;
		
		if (!IsSet($GLOBALS['wogroupby']))
			$GLOBALS['wogroupby'] = 'none';
			
		$bIsGrouping = ($GLOBALS['wogroupby'] != 'none');

		$objDBProjects = CreateObject('dcl.dbProjects');
		$objDBProjects->Connect();
		if ($objDBProjects->Load($projectid) == -1)
		{
			print('Could not find a project with an id of ' . $projectid);
			return;
		}

		$objDBProjectmap = CreateObject('dcl.dbProjectmap');
		$objDBProjectmap->Connect($objDBProjects->conn);
		$this->oPM = $objDBProjectmap;
		if ($wostatus == 0 && $woresponsible == 0)
			$objDBProjectmap->Load($projectid);
		else
			$objDBProjectmap->LoadFilter($projectid, $wostatus, $woresponsible);

		$Template = CreateTemplate(array('hForm' => 'htmlProjectsDetail.tpl',
					'hChild' => 'htmlProjectsSummaryDetail.tpl',
					'hWO' => 'htmlProjectDetailWorkorders.tpl'));

		$Template->set_block('hForm', 'attachments', 'hAttachments');
		$Template->set_block('hForm', 'parent', 'hParent');
		$Template->set_block('hChild', 'projects', 'hProjects');
		$Template->set_block('hWO', 'workorders', 'hWorkorders');
		$Template->set_block('hWO', 'nogrouping', 'hNoGrouping');
		$Template->set_block('hWO', 'grouping', 'hGrouping');

		$Template->set_var('hAttachments', '');
		$Template->set_var('hParent', '');
		$Template->set_var('hProjects', '');
		$Template->set_var('hWorkorders', '');
		$Template->set_var('hNoGrouping', '');
		$Template->set_var('hGrouping', '');

		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('VAL_FORMACTION', menuLink());
		$Template->set_var('TXT_NAME', STR_PRJ_NAME);
		$Template->set_var('TXT_LEAD', STR_PRJ_LEAD);
		$Template->set_var('TXT_DEADLINE', STR_PRJ_DEADLINE);
		$Template->set_var('TXT_ETC', STR_PRJ_ETC);
		$Template->set_var('TXT_TOTRESINCOMPWO', STR_PRJ_TOTRESINCOMPWO);
		$Template->set_var('TXT_OPENBY', STR_PRJ_OPENBY);
		$Template->set_var('TXT_ON', STR_PRJ_ON);
		$Template->set_var('TXT_STATUS', STR_PRJ_STATUS);
		$Template->set_var('TXT_LASTACT', STR_PRJ_LASTACT);
		$Template->set_var('TXT_CLOSEDON', STR_PRJ_CLOSEDON);
		$Template->set_var('TXT_TOTTASKS', STR_PRJ_TOTTASKS);
		$Template->set_var('TXT_TASKSCOMP', STR_PRJ_TASKSCOMP);
		$Template->set_var('TXT_HOURSPROJ', STR_PRJ_HOURSPROJ);
		$Template->set_var('TXT_HOURSPM', STR_PRJ_HOURSPM);
		$Template->set_var('TXT_HOURSAPP', STR_PRJ_HOURSAPP);
		$Template->set_var('TXT_HOURSREM', STR_PRJ_HOURSREM);
		$Template->set_var('TXT_PCTCOMP', STR_PRJ_PCTCOMP);
		$Template->set_var('TXT_FILTERWOBYSTATUS', STR_PRJ_FILTERWOBYSTATUS);
		$Template->set_var('TXT_FILTERWOBYRESPONSIBLE', STR_PRJ_FILTERWOBYRESPONSIBLE);
		$Template->set_var('TXT_DESCRIPTION', STR_PRJ_DESCRIPTION);
		$Template->set_var('TXT_ATTACH', STR_PRJ_ATTACH);
		$Template->set_var('TXT_BYTES', STR_CMMN_BYTES);
		$Template->set_var('TXT_GROUPBY', 'Group By');
		$Template->set_var('BTN_GO', STR_CMMN_GO);
		$Template->set_var('BTN_FILTER', STR_CMMN_FILTER);

		$Template->set_var('VAL_PROJECTID', $objDBProjects->projectid);
		$Template->set_var('VAL_WATCHTYPE', '2');
		$Template->set_var('VAL_NAME', htmlspecialchars($objDBProjects->name));
		$Template->set_var('VAL_PROJECTDEADLINE', $objDBProjects->projectdeadline);
		$Template->set_var('VAL_CREATEDON', $objDBProjects->createdon);
		$Template->set_var('VAL_LASTACTIVITY', $objDBProjects->lastactivity);
		$Template->set_var('VAL_FINALCLOSE', htmlspecialchars($objDBProjects->finalclose));
		$Template->set_var('VAL_DESCRIPTION', nl2br(htmlspecialchars($objDBProjects->description)));
		$Template->set_var('CMB_ACTION', $this->GetActionCombo('exfwa'));

		$objPersonnel = CreateObject('dcl.dbPersonnel');
		$objPersonnel->Connect($objDBProjects->conn);
		$objPersonnel->Load($objDBProjects->reportto);
		$Template->set_var('VAL_REPORTTO', $objPersonnel->short);

		$arrayStats = $objDBProjects->GetProjectStatistics($projectid, $dcl_info['DCL_PROJECT_INCLUDE_CHILD_STATS'], $dcl_info['DCL_PROJECT_INCLUDE_PARENT_STATS']);
		$Template->set_var('VAL_TOTALTASKS', $arrayStats['totaltasks']);
		$Template->set_var('VAL_TASKSCLOSED', $arrayStats['tasksclosed']);
		$Template->set_var('VAL_ESTHOURS', $arrayStats['esthours']);
		if ($arrayStats['etchours'] > 0)
		{
			$oneDay = 24 * 60 * 60; // Just in case time scale changes in the future
			$i = 0;
			$workDays = $arrayStats['etchours'] / 8.0;
			if ($arrayStats['resources'] > 1)
				$workDays /= $arrayStats['resources'];
			$endDay = mktime(0, 0, 0, date('m'), date('d'), date('Y'));
			while ($i < $workDays)
			{
				$endDay += $oneDay;
				if (date('w', $endDay) != 0 && date('w', $endDay) != 6)
					$i++;
			}
			$Template->set_var('VAL_ETCDATE', date($dcl_info['DCL_DATE_FORMAT'], $endDay));
		}
		else
			$Template->set_var('VAL_ETCDATE', '');

		$Template->set_var('VAL_RESOURCES', $arrayStats['resources']);
		$objPersonnel->Load($objDBProjects->createdby);
		$Template->set_var('VAL_CREATEDBY', $objPersonnel->short);

		$objStatus = CreateObject('dcl.dbStatuses');
		$objStatus->Connect($objDBProjects->conn);
		$objStatus->Load($objDBProjects->status);
		$Template->set_var('VAL_STATUS', $objStatus->name);

		$ouHours = -($arrayStats['esthours'] - $arrayStats['totalhours']);
		$diffHours = $ouHours;
		if ($diffHours < 0)
			$diffHours = -$diffHours;

		$ouPct = 0.0;
		$sign = '';
		if ($arrayStats['esthours'] > 0)
		{
			$ouPct = $diffHours / $arrayStats['esthours'] * 100;
			if ($arrayStats['esthours'] > $arrayStats['totalhours'] && $arrayStats['esthours'] > 0)
				$sign = '-';
			else if ($arrayStats['totalhours'] > $arrayStats['esthours'] && $arrayStats['totalhours'] > 0)
					$sign = '+';
		}

		$Template->set_var('VAL_HOURSPM', sprintf('%s%0.2f&nbsp;(%s%0.2f%%)', $sign, abs($ouHours), $sign, abs($ouPct)));
		$Template->set_var('VAL_TOTALHOURS', $arrayStats['totalhours']);
		$Template->set_var('VAL_ETCHOURS', $arrayStats['etchours']);

		if ($arrayStats['totalhours'] + $arrayStats['etchours'] > 0.0)
			$Template->set_var('VAL_PCTCOMP', sprintf('%0.2f%%', ($arrayStats['totalhours'] / ($arrayStats['totalhours'] + $arrayStats['etchours'])) * 100));
		else
			$Template->set_var('VAL_PCTCOMP', '0.00%');

		$objHStat = CreateObject('dcl.htmlStatuses');
		$Template->set_var('CMB_WOSTATUS', $objHStat->GetCombo($wostatus, 'wostatus'));

		$objHPersonnel = CreateObject('dcl.htmlPersonnel');
		$Template->set_var('CMB_WORESPONSIBLE', $objHPersonnel->GetCombo($woresponsible, 'woresponsible', 'short', 0, false, $dcl_info['DCL_HAVE_WO'], $projectid));
		
		$Template->set_var('CMB_WOGROUPBY', $this->GetGroupByCombo());

		$attachPath = $dcl_info['DCL_FILE_PATH'] . '/attachments/prj/' . substr($projectid, -1) . "/$projectid/";
		if ($hDir = @opendir($attachPath))
		{
			$startedNewCell = false;
			$hasAttachments = false;
			while ($fileName = @readdir($hDir))
			{
				if (is_file($attachPath . $fileName) && is_readable($attachPath . $fileName))
				{
					if ($GLOBALS['SEC'] >= $dcl_info['DCL_ASSIGN_WO'])
					{
						$link = '<a class="adark" href="';
						$link .= menuLink('', 'menuAction=boProjects.deleteattachment&filename=' . rawurlencode($fileName) . "&projectid=$projectid");
						$link .= '">[&nbsp;' . STR_CMMN_DELETE . '&nbsp;]</a>';

						$Template->set_var('LNK_DELATTACHMENT', $link);
					}
					else
						$Template->set_var('LNK_DELATTACHMENT', '');

					$Template->set_var('VAL_ENCODEDFILENAME', menuLink('', 'menuAction=htmlProjectsdetail.Download&filename=' . rawurlencode($fileName) . "&projectid=$projectid"));
					$Template->set_var('VAL_FILENAME', htmlspecialchars($fileName));
					$Template->set_var('VAL_FILESIZE', filesize($attachPath . $fileName));

					$Template->parse('hAttachments', 'attachments', true);
				}
			}
		}

		$objTemp = CreateObject('dcl.dbProjects');
		$objTemp->Connect($objDBProjects->conn);
		if ($objDBProjects->parentprojectid > 0)
		{
			$objTemp->Load($objDBProjects->parentprojectid);
			$Template->set_var('TXT_PARENTPRJ', STR_PRJ_PARENTPRJ);
			$Template->set_var('VAL_PARENTID', $objTemp->projectid);
			$Template->set_var('VAL_PARENTNAME', htmlspecialchars($objTemp->name));
			$Template->set_var('VAL_PARENTLINK', menuLink('', sprintf('menuAction=boProjects.viewproject&project=%d&wostatus=0', $objTemp->projectid)));
			$Template->parse('hParent', 'parent');
		}

		$Template->pparse('out', 'hForm');
		echo '<p>'; // a little space, please!

		$objTemp->Query('SELECT projectid FROM dcl_projects WHERE parentprojectid=' . $objDBProjects->projectid);
		if ($objTemp->next_record())
		{
			$Template->set_var('TXT_SUMMARYTITLE', STR_PRJ_CHILDPRJ);
			$Template->set_var('TXT_TOTTASKSABB', STR_PRJ_TOTTASKSABB);
			$Template->set_var('TXT_TASKSCOMPABB', STR_PRJ_TASKSCOMPABB);
			$Template->set_var('TXT_HOURSPROJABB', STR_PRJ_HOURSPROJABB);
			$Template->set_var('TXT_HOURSAPPABB', STR_PRJ_HOURSAPPABB);
			$Template->set_var('TXT_HOURSREMABB', STR_PRJ_HOURSREMABB);

			do
			{
				if ($objDBProjects->Load($objTemp->f(0)) != -1)
				{
					$Template->set_var('VAL_SUMMARYID', $objDBProjects->projectid);
					$Template->set_var('VAL_VIEWCHILDPROJECTLINK', menuLink('', 'menuAction=boProjects.viewproject&wostatus=0&project=' . $objDBProjects->projectid));
					$Template->set_var('VAL_SUMMARYNAME', htmlspecialchars($objDBProjects->name));
					$arrStat = $objDBProjects->GetProjectStatistics($objDBProjects->projectid);
					$Template->set_var('VAL_SUMMARYTOTALTASKS', $arrStat['totaltasks']);
					$Template->set_var('VAL_SUMMARYTASKSCLOSED', $arrStat['tasksclosed']);
					$Template->set_var('VAL_SUMMARYESTHOURS', $arrStat['esthours']);
					$Template->set_var('VAL_SUMMARYTOTALHOURS', $arrStat['totalhours']);
					$Template->set_var('VAL_SUMMARYETCHOURS', $arrStat['etchours']);

					$Template->parse('hProjects', 'projects', true);
				}
			}
			while ($objTemp->next_record());

			$Template->pparse('out', 'hChild');
		}

		$joinKeyword = '';
		if ($dcl_domain_info[$dcl_domain]['dbType'] == 'mysql') // Hackage to make MySQL happy again
			$joinKeyword = ' INNER';

		$cols = array('a.jcn', 'a.seq', 'b.short', 'c.name', 'g.module_name', 'd.name', 'e.name', 'a.deadlineon', 'a.totalhours', 'a.etchours', 'a.esthours', '(a.totalhours + a.etchours) - a.esthours', 'a.summary');
		$sql = 'Select a.jcn, a.seq, b.short, c.name, g.module_name, d.name, e.name, a.deadlineon, a.totalhours, a.etchours, a.esthours, (a.totalhours + a.etchours) - a.esthours, a.summary';
		$sql .= ' From workorders a';
		$sql .= $joinKeyword . ' JOIN personnel b ON a.responsible = b.id';
		$sql .= $joinKeyword . ' JOIN products c ON a.product = c.id';
		$sql .= ' LEFT JOIN accounts d ON a.account = d.id';
		$sql .= $joinKeyword . ' JOIN statuses e ON a.status = e.id';
		$sql .= $joinKeyword . ' JOIN projectmap f ON a.jcn = f.jcn and f.seq in (0, a.seq)';
		$sql .= ' LEFT JOIN dcl_product_module g ON a.module_id = g.product_module_id';
		$sql .= ' Where f.projectid=' . $projectid;

		if ($wostatus > 0)
			$sql .= ' And a.status=' . $wostatus;

		if ($woresponsible > 0)
			$sql .= ' And a.responsible=' . $woresponsible;

		if ($bIsGrouping)
			$sql .= ' Order By ' . $cols[$GLOBALS['wogroupby']] . ', a.jcn, a.seq';
		else
			$sql .= ' Order By a.jcn, a.seq';

		if ($objDBProjectmap->Query($sql) != -1)
		{
			$allRecs = $objDBProjectmap->FetchAllRows();

			if (count($allRecs) > 0)
			{
				$Template->set_var('TXT_TITLE', STR_PRJ_TASKLIST);
				$Template->set_var('TXT_WO', STR_WO_JCN);
				$Template->set_var('TXT_SEQ', STR_WO_SEQ);
				$Template->set_var('TXT_ASN', STR_WO_ASSIGNABB);
				$Template->set_var('TXT_PRODUCT', STR_WO_PRODUCT);
				$Template->set_var('TXT_MODULE', 'Module');
				$Template->set_var('TXT_ACCOUNT', STR_WO_ACCOUNT);
				$Template->set_var('TXT_STATUS', STR_WO_STATUS);
				$Template->set_var('TXT_DEADLINE', STR_WO_DEADLINE);
				$Template->set_var('TXT_HRS', STR_WO_HOURSABB);
				$Template->set_var('TXT_ETC', STR_WO_ETC);
				$Template->set_var('TXT_PRJ', STR_WO_PRJHRSABB);
				$Template->set_var('TXT_PLUSMINUS', '+/-');
				$Template->set_var('TXT_PCTCOMPLETE', '% Complete');
				$Template->set_var('TXT_SUMMARY', STR_WO_SUMMARY);
				$Template->set_var('TXT_OPTIONS', STR_CMMN_OPTIONS);

				// If not grouping, put button at top
				if (!$bIsGrouping)
					$Template->parse('hNoGrouping', 'nogrouping');

				$objHWO = CreateObject('dcl.htmlWorkorders');
				$oDate = new DCLDate;
				$lastGroupVal = '___UNDEFINED___';
				for ($i = 0; $i < count($allRecs); $i++)
				{
					$Template->set_var('HDR_GROUP', '');
					if ($bIsGrouping && $lastGroupVal != $allRecs[$i][$GLOBALS['wogroupby']])
					{
						$Template->set_var('VAL_GROUP', $allRecs[$i][$GLOBALS['wogroupby']]);
						$Template->set_var('HDR_GROUP', $Template->parse('hGrouping', 'grouping'));
						$lastGroupVal = $allRecs[$i][$GLOBALS['wogroupby']];
					}

					$Template->set_var('COLOR_ROW', $i % 2 == 0 ? '#FFFFFF' : $dcl_info['DCL_COLOR_LIGHT']);

					$Template->set_var('VAL_WOID', $allRecs[$i][0]);
					$Template->set_var('VAL_SEQ', $allRecs[$i][1]);
					$Template->set_var('VAL_RESPONSIBLE', $allRecs[$i][2]);
					$Template->set_var('VAL_PRODUCT', $allRecs[$i][3]);
					$Template->set_var('VAL_MODULE', $allRecs[$i][4]);
					$Template->set_var('VAL_ACCOUNT', $allRecs[$i][5]);

					$Template->set_var('VAL_STATUS', $allRecs[$i][6]);
					$Template->set_var('VAL_HRS', $allRecs[$i][8]);
					$Template->set_var('VAL_ETC', $allRecs[$i][9]);
					$Template->set_var('VAL_PRJ', $allRecs[$i][10]);
					$Template->set_var('VAL_SUMMARY', $allRecs[$i][12]);

					$oDate->SetFromDB($allRecs[$i][7]);
					$Template->set_var('VAL_DEADLINE', $oDate->ToDisplay());

					$ouHours = -($allRecs[$i][10] - $allRecs[$i][8]);
					$diffHours = $ouHours;
					if ($diffHours < 0)
						$diffHours = -$diffHours;

					$ouPct = 0.0;
					$sign = '';
					if ($allRecs[$i][10] > 0)
					{
						$ouPct = $diffHours / $allRecs[$i][10] * 100;
						if ($allRecs[$i][10] > $allRecs[$i][8] && $allRecs[$i][10] > 0)
							$sign = '-';
						else if ($allRecs[$i][8] > $allRecs[$i][10] && $allRecs[$i][8] > 0)
							$sign = '+';
					}

					$Template->set_var('VAL_PLUSMINUS', sprintf('%s%0.2f&nbsp;(%s%0.2f%%)', $sign, abs($ouHours), $sign, abs($ouPct)));

					if ($allRecs[$i][9] + $allRecs[$i][8] > 0)
						$allRecs[$i][12] = (($allRecs[$i][8] / ($allRecs[$i][9] + $allRecs[$i][8])) * 100);
					elseif ($allRecs[$i][9] == 0.0)
						$allRecs[$i][12] = 100.0;
					else
						$allRecs[$i][12] = 0.0;

					$Template->set_var('VAL_PCTCOMPLETE', sprintf("%0.2f%%", $allRecs[$i][12]));
					$Template->set_var('VAL_OPTIONS', $objHWO->GetActionLinks('dteasxuw', false, $allRecs[$i][0], $allRecs[$i][1], true));

					$Template->parse('hWorkorders', 'workorders', true);
				}

				$Template->set_var('hGrouping', '');
				$Template->pparse('out', 'hWO');
			}
		}

		print('</CENTER>');
	}

	function ShowTree($projectid, $wostatus, $woresponsible)
	{
		global $dcl_info;

		$obj = CreateObject('dcl.dbProjects');
		$obj->Connect();
		$obj->Load($projectid);
		echo '<center>';
		echo '<h3>Tree View of Project: ', $obj->name, '</h3>';
		if ($obj->parentprojectid > 0)
		{
			$oParent = $obj;
			$oParent->Load($obj->parentprojectid);
			echo 'Parent Project: ', $this->GetTreeLink($oParent->projectid, $oParent->name, $wostatus, $woresponsible);
		}

		echo '<form action="' . menuLink('') . '" method="post">';
		echo GetHiddenVar('project', $projectid);
		echo GetHiddenVar('menuAction', 'boProjects.showtree');

		$objStat = CreateObject('dcl.htmlStatuses');
		$objPersonnel = CreateObject('dcl.htmlPersonnel');

		echo '<b>', STR_PRJ_FILTERWOBYSTATUS, ':</b>';
		echo $objStat->GetCombo($wostatus, 'wostatus');

		echo '&nbsp;&nbsp;<b>', STR_PRJ_FILTERWOBYRESPONSIBLE, ':</b>';
		echo $objPersonnel->GetCombo($woresponsible, 'woresponsible', 'short', 0, false, $dcl_info['DCL_HAVE_WO']);

		echo '<input type="submit" value="', STR_CMMN_FILTER, '"></form><p>';

		echo '<table border="0">';
		$this->DisplayProjectTasks($projectid, $wostatus, $woresponsible);
		$this->DisplayChildProjects($projectid, $wostatus, $woresponsible, 1);
		echo '</table></center>';
	}

	function GetTreeLink($projectid, $name, $wostatus, $woresponsible)
	{
		$link = '<a class="agreyb" href="';
		$link .= menuLink('', sprintf('menuAction=boProjects.showtree&project=%d&wostatus=%d&woresponsible=%d',
					$projectid,
					$wostatus,
					$woresponsible));
		$link .= '">' . $name . '</a>';

		return $link;
	}

	function DisplayChildProjects($childOfID, $wostatus, $woresponsible, $level = 0)
	{
		$oPM = CreateObject('dcl.dbProjectmap');
		$oPM->Connect();
		$oPM->Query('SELECT projectid,name FROM dcl_projects WHERE parentprojectid=' . $childOfID);
		$a = $oPM->FetchAllRows();
		$oPM->FreeResult();
		if (is_array($a) && count($a) > 0)
		{
			for ($i = 0; $i < count($a); $i++)
			{
				echo '<tr><td colspan="6" style="background-color: #cecece;">';
				echo str_repeat('&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;', $level);
				echo $this->GetTreeLink($a[$i][0], $a[$i][1], $wostatus, $woresponsible);
				$this->DisplayProjectTasks($a[$i][0], $wostatus, $woresponsible, $level);
				$this->DisplayChildProjects($a[$i][0], $wostatus, $woresponsible, $level + 1);
			}
		}
	}

	function DisplayProjectTasks($projectid, $wostatus, $woresponsible, $level = 0)
	{
		global $dcl_info;

		$db = new dclDB;
		$db->Connect();
		$sql = 'SELECT a.jcn,a.seq,c.short,d.name,a.summary FROM workorders a, projectmap b,personnel c,statuses d WHERE ';
		$sql .= "a.jcn=b.jcn AND (b.seq=0 OR a.seq=b.seq) AND a.responsible=c.id AND a.status=d.id AND b.projectid=$projectid ";

		if ($wostatus > 0)
			$sql .= "AND a.status=$wostatus ";
		if ($woresponsible > 0)
			$sql .= "AND a.responsible=$woresponsible ";

		$sql .= 'ORDER BY a.jcn,a.seq';
		$db->Query($sql);

		if ($db->next_record())
		{
			echo '<tr><td>', str_repeat('&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;', $level), '</td>';
			echo '<td style="border-bottom: 2px solid black;"><b>WO#</b></td>';
			echo '<td style="border-bottom: 2px solid black;"><b>Seq</b></td>';
			echo '<td style="border-bottom: 2px solid black;"><b>Responsible</b></td>';
			echo '<td style="border-bottom: 2px solid black;"><b>Status</b></td>';
			echo '<td style="border-bottom: 2px solid black;"><b>Summary</b></td>';
			echo '</tr>';

			$hilite = false;

			do
			{
				echo '<tr><td>', str_repeat('&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;', $level), '</td>';
				for ($i = 0; $i < 5; $i++)
				{
					if ($hilite)
						echo '<td style="background-color: ', $dcl_info['DCL_COLOR_LIGHT'], '">';
					else
						echo '<td>';
					if ($i == 4)
						echo '<a class="agrey" href="' . menuLink('', 'menuAction=boWorkorders.viewjcn&jcn=' . $db->f(0) . '&seq=' . $db->f(1)), '">';
					echo $db->f($i);
					if ($i == 4)
						echo '</a>';
					echo '</td>';
				}
				$hilite = !$hilite;
				echo '</tr>';
			}
			while ($db->next_record());
		}
		else
			echo '<tr><td colspan="6">This project has no tasks that match your filter.</td></tr>';

		$db->FreeResult();
	}

	function Download()
	{
		global $dcl_info;

		// TODO: Security check
		$o = CreateObject('dcl.boFile');
		$o->iType = ATTACHMENT_PROJECT;
		$o->iKey1 = $GLOBALS['projectid'];
		$o->sFileName = $GLOBALS['filename'];
		$o->sRoot = $dcl_info['DCL_FILE_PATH'] . '/attachments';
		$o->Download();
	}
}
?>
