<?php
/*
 * $Id: class.htmlTicketSearches.inc.php,v 1.3.4.3 2002/10/31 05:12:57 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('wo');

class htmlTicketSearches
{		
	function DisplaySearchForm()
	{
		global $dcl_info;

		$objPersonnel = CreateObject('dcl.htmlPersonnel');
		$objProducts = CreateObject('dcl.htmlProducts');
		$objPriorities = CreateObject('dcl.htmlPriorities');
		$objSeverities = CreateObject('dcl.htmlSeverities');
		$objAccounts = CreateObject('dcl.htmlAccounts');
		$objStatuses = CreateObject('dcl.htmlStatuses');

		$Template = CreateTemplate(array('hForm' => 'htmlTicketSearch.tpl'));
		$Template->set_block('hForm', 'acols', 'hAcols');
		$Template->set_block('hForm', 'columnlist', 'hColumnlist');

		$Template->set_var('hAcols', '');
		$Template->set_var('hColumnlist', '');

		$Template->set_var('VAL_JSDATEFORMAT', GetJSDateFormat());
		$Template->set_var('VAL_FORMACTION', menuLink());
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);

		$Template->set_var('TXT_TITLE', STR_TCK_SEARCHTITLE);
		$Template->set_var('TXT_RESPONSIBLE', STR_TCK_RESPONSIBLE);
		$Template->set_var('TXT_OPENEDBY', STR_TCK_OPENEDBY);
		$Template->set_var('TXT_CLOSEDBY', STR_TCK_CLOSEDBY);
		$Template->set_var('TXT_PRODUCT', STR_TCK_PRODUCT);
		$Template->set_var('TXT_PRIORITY', STR_TCK_PRIORITY);
		$Template->set_var('TXT_TYPE', STR_TCK_TYPE);
		$Template->set_var('TXT_ACCOUNT', STR_TCK_ACCOUNT);
		$Template->set_var('TXT_STATUS', STR_TCK_STATUS);
		$Template->set_var('TXT_OPENEDON', STR_TCK_OPENEDON);
		$Template->set_var('TXT_CLOSEDON', STR_TCK_CLOSEDON);
		$Template->set_var('TXT_STATUSON', STR_TCK_STATUSON);
		$Template->set_var('TXT_LASTACTIONON', STR_TCK_LASTACTIONON);
		$Template->set_var('TXT_FROM', STR_CMMN_FROM);
		$Template->set_var('TXT_TO', STR_CMMN_TO);
		$Template->set_var('TXT_ISSUESUMMARY', STR_TCK_ISSUE . '/' . STR_TCK_SUMMARY . '/' . STR_TCK_CONTACT);
		$Template->set_var('TXT_REPORTOPTIONS', STR_TCK_REPORTOPTIONS);
		$Template->set_var('TXT_REPORTTITLE', STR_CMMN_TITLE);
		$Template->set_var('TXT_STYLE', STR_CMMN_STYLE);
		$Template->set_var('TXT_AVAILABLECOLUMNS', STR_CMMN_AVAILCOLS);
		$Template->set_var('TXT_SHOWCOLUMNS', STR_CMMN_SHOWCOLS);
		$Template->set_var('TXT_GROUPING', STR_CMMN_GROUPING);
		$Template->set_var('TXT_SORTING', STR_CMMN_SORTING);

		$Template->set_var('BTN_SEARCH', STR_CMMN_SEARCH);
		$Template->set_var('BTN_RESET', STR_CMMN_RESET);
		$Template->set_var('BTN_COL', STR_CMMN_COL);
		$Template->set_var('BTN_GRP', STR_CMMN_GRP);
		$Template->set_var('BTN_ORD', STR_CMMN_SRT);
		$Template->set_var('BTN_RM', STR_CMMN_RM);
		$Template->set_var('BTN_UP', STR_CMMN_UP);
		$Template->set_var('BTN_DN', STR_CMMN_DN);

		if ($GLOBALS['SEC'] >= $dcl_info['DCL_HAVE_WO'])
		{
			$Template->set_var('CHK_SECLVLWO', ' CHECKED');
			$Template->set_var('CHK_NOSECLVLWO', '');
		}
		else
		{
			$Template->set_var('CHK_SECLVLWO', '');
			$Template->set_var('CHK_NOSECLVLWO', ' CHECKED');
		}

		$Template->set_var('CMB_PERSONNEL', $objPersonnel->GetCombo($GLOBALS['DCLID'], 'personnel', 'lastfirst', 8, false));
		$Template->set_var('CMB_PRODUCT', $objProducts->GetCombo(0, 'product', 'name', 0, 8, false));
		$Template->set_var('CMB_PRIORITY', $objPriorities->GetCombo(0, 'priority', 'name', 8, false));
		$Template->set_var('CMB_TYPE', $objSeverities->GetCombo(0, 'type', 'name', 8, false));
		$Template->set_var('CMB_ACCOUNT', $objAccounts->GetCombo(0, 'account', 'name', 8, false));
		$Template->set_var('CMB_STATUS', $objStatuses->GetCombo(1, 'status', 'name', 8));

		$aFewDaysAgo = mktime(0, 0, 0, date('m'), date('d') - 3, date('Y'));
		$Template->set_var('VAL_DATEFROM', date($dcl_info['DCL_DATE_FORMAT'], $aFewDaysAgo));
		$Template->set_var('VAL_DATETO', date($dcl_info['DCL_DATE_FORMAT']));

		$aCols = array(
				'dcl_product_module.module_name' => 'Module*',
				'version' => STR_TCK_VERSION,
				'createdby.short' => STR_TCK_OPENEDBY,
				'createdon' => STR_TCK_OPENEDON,
				'closedby.short' => STR_TCK_CLOSEDBY,
				'closedon' => STR_TCK_CLOSEDON,
				'statuson' => STR_TCK_STATUSON,
				'lastactionon' => STR_TCK_LASTACTIONON,
				'priorities.name' => STR_TCK_PRIORITY,
				'severities.name' => STR_TCK_TYPE,
				'contact' => STR_TCK_CONTACT,
				'contactphone' => STR_TCK_CONTACTPHONE,
				'contactemail' => STR_TCK_CONTACTEMAIL,
				'issue' => STR_TCK_ISSUE,
				'seconds' => STR_TCK_APPROXTIME
			);

		while (list($val, $text) = each($aCols))
		{
			$Template->set_var('VAL_ACOLSVALUE', htmlspecialchars($val));
			$Template->set_var('VAL_ACOLSTEXT', htmlspecialchars($text));
			$Template->parse('hAcols', 'acols', true);
		}

		$aShow = array(
				'ticketid' => STR_TCK_TICKET . '#',
				'responsible.short' => STR_TCK_RESPONSIBLE,
				'products.name' => STR_TCK_PRODUCT,
				'accounts.name' => STR_TCK_ACCOUNT,
				'statuses.name' => STR_TCK_STATUS,
				'summary' => STR_TCK_SUMMARY
			);

		while (list($val, $text) = each($aShow))
		{
			$Template->set_var('VAL_COLSVALUE', htmlspecialchars($val));
			$Template->set_var('VAL_COLSTEXT', htmlspecialchars($text));
			$Template->parse('hColumnlist', 'columnlist', true);
		}

		$Template->pparse('out', 'hForm');
	}

	function my()
	{
		$t = CreateTemplate(array('hForm' => 'htmlMyTicketSearches.tpl'));

		$t->set_var('TXT_TITLE', STR_TCK_SEARCHTITLE);
		$t->set_var('FORM_ACTION', menuLink());
		$t->set_var('TXT_TICKET', STR_TCK_TICKET);
		$t->set_var('TXT_FIND', STR_CMMN_FIND);
		$t->set_var('TXT_VIEW', STR_CMMN_VIEW);
		$t->set_var('COLOR_DARK', $GLOBALS['dcl_info']['DCL_COLOR_DARK']);
		$t->set_var('COLOR_LIGHT',$GLOBALS['dcl_info']['DCL_COLOR_LIGHT']);

		$obj = CreateObject('dcl.htmlViews');
		$t->set_var('CMB_VIEWS', $obj->GetCombo(0, 'viewid', 0, true, 'tickets'));

		$t->pparse('out', 'hForm');
	}
}
?>
