<?php
/*
 * $Id: class.reportTicketActivity.inc.php,v 1.2.4.1 2002/08/18 04:17:47 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('wost');
LoadStringResource('tck');

class reportTicketActivity
{
	function getparameters($needHdr = true)
	{
		global $dcl_info;

		if ($needHdr == true)
			commonHeader();

		$objPersonnel = CreateObject('dcl.htmlPersonnel');

		$Template = CreateTemplate(array('hForm' => 'htmlTicketActivity.tpl'));

		$Template->set_var('VAL_JSDATEFORMAT', GetJSDateFormat());
		$Template->set_var('VAL_FORMACTION', menuLink());
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('TXT_TITLE', STR_WOST_TICKETACTIVITY);
		$Template->set_var('TXT_GENERATEREPORTFOR', STR_WOST_GENERATEREPORTFOR);
		$Template->set_var('TXT_DATERANGE', STR_WOST_DATERANGE);

		$Template->set_var('TXT_BEGINNING', STR_WOST_BEGIN);
		$Template->set_var('TXT_ENDING', STR_WOST_ENDING);
		$Template->set_var('BTN_EXECUTE', STR_CMMN_GO);
		$Template->set_var('BTN_RESET', STR_CMMN_RESET);
		$Template->set_var('CMB_RESPONSIBLE', $objPersonnel->GetCombo($GLOBALS['DCLID'], 'responsible', 'lastfirst', 0, false));

		if (IsSet($GLOBALS['begindate']))
			$Template->set_var('VAL_BEGINDATE', $GLOBALS['begindate']);
		else
			$Template->set_var('VAL_BEGINDATE', '');

		if (IsSet($GLOBALS['enddate']))
			$Template->set_var('VAL_ENDDATE', $GLOBALS['enddate']);
		else
			$Template->set_var('VAL_ENDDATE', '');

		$Template->pparse('out', 'hForm');
	}

	function execute()
	{
		commonHeader();

		if ($GLOBALS['begindate'] == '' || $GLOBALS['enddate'] == '')
		{
			print('<center>');
			PrintWithChocoFont(STR_WOST_DATEERR);
			print('</center><p>');
			$this->GetParameters(false);
			return;
		}

		$objPro = CreateObject('dcl.dbProducts');
		$objA = CreateObject('dcl.dbAccounts');
		$objP = CreateObject('dcl.dbPersonnel');
		$objS = CreateObject('dcl.dbStatuses');
		$objPr = CreateObject('dcl.dbPriorities');
		$objSe = CreateObject('dcl.dbSeverities');
		$obj = CreateObject('dcl.dbTickets');
		$objT = CreateObject('dcl.dbTicketresolutions');

		$objP->Connect();
		$objA->Connect($objP->conn);
		$objPro->Connect($objP->conn);
		$objS->Connect($objP->conn);
		$objPr->Connect($objP->conn);
		$objSe->Connect($objP->conn);
		$obj->Connect($objP->conn);
		$objT->Connect($objP->conn);

		$objP->Load($GLOBALS['responsible']);

		$query = 'select a.* from tickets a, ticketresolutions b where a.ticketid=b.ticketid and b.loggedby=' . $GLOBALS['responsible'];
		$query .= ' and b.loggedon between ' . $obj->DisplayToSQL($GLOBALS['begindate'] . ' 00:00:00') . ' and ' . $obj->DisplayToSQL($GLOBALS['enddate'] . ' 23:59:59');
		$query .= ' order by a.ticketid';

		if ($obj->Query($query) != -1)
		{
			if ($obj->next_record())
			{
				$arrayIndex = -1;
				$count = 0;
				$prevTicketID = -1;
				do
				{
					$obj->GetRow();

					if ($obj->ticketid != $prevTicketID)
					{
						$prevTicketID = $obj->ticketid;
						$arrayIndex++;
						$objA->Load($obj->account);
						$objPro->Load($obj->product);
						$objS->Load($obj->status);
						$objPr->Load($obj->priority);
						$objSe->Load($obj->type);

						$reportArray[$arrayIndex][0] = $objPro->name;
						$reportArray[$arrayIndex][1] = $objA->name;
						$reportArray[$arrayIndex][2] = $objS->name;
						$reportArray[$arrayIndex][3] = $objPr->name;
						$reportArray[$arrayIndex][4] = $objSe->name;
						$reportArray[$arrayIndex][5] = $obj->createdon;
						$reportArray[$arrayIndex][6] = $obj->closedon;
						$reportArray[$arrayIndex][7] = 1;
						$reportArray[$arrayIndex][8] = $obj->summary;
					}
					else
					{
						$reportArray[$arrayIndex][7]++;
					}

					$count++;
				}
				while ($obj->next_record());

				$nameArray = array(
						STR_TCK_PRODUCT,
						STR_TCK_ACCOUNT,
						STR_TCK_STATUS,
						STR_TCK_PRIORITY,
						STR_TCK_TYPE,
						STR_TCK_CREATED,
						STR_TCK_CLOSED,
						'Calls',
						STR_TCK_SUMMARY
					);
				PrintArrayAsChocoTable($nameArray, $reportArray, sprintf(STR_WOST_ACTIVITYTITLE, $objP->firstNameLast, $GLOBALS['begindate'], $GLOBALS['enddate']));
			}
			else
			{
				print('<center>');
				PrintWithChocoFont(STR_WOST_NOACTIVITY);
				print('</center>');
			}
		}
		else
			print(STR_WOST_QUERYERR);
	}
}
?>
