<?php
/*
 * $Id: functions.inc.php,v 1.7.2.3.2.6 2002/12/04 01:25:44 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

include('inc/config.php');
// Common definitions
define('phpCrLf', "\r\n");
define('phpTab', "\t");
define('DCL_MODE_NEW', 1);
define('DCL_MODE_EDIT', 2);
define('DCL_MODE_COPY', 3);

function menuLink($target = '/dcl/main.php', $params = '')
{
	global $phpgw;

	if ($target == '')
		$target = '/dcl/main.php';

	if (isset($phpgw) && is_object($phpgw))
	{
		return $phpgw->link($target, $params);
	}

	if (substr($target, 0, 5) == '/dcl/')
		$sRet = substr($target, 5);
	else
		$sRet = $target;

	if ($params != '')
		$sRet .= '?' . $params;

	return $sRet;
}

function GetSourceArray()
{
	if ($GLOBALS['HTTP_SERVER_VARS']['REQUEST_METHOD'] == 'GET')
		return 'HTTP_GET_VARS';

	return 'HTTP_POST_VARS';
}

function GPCStripSlashes($thisString)
{
	if (get_magic_quotes_gpc() == 0)
		return $thisString;

	return stripslashes($thisString);
}

function CleanVars($which)
{
	if (get_magic_quotes_gpc() == 0)
		return;

	reset($GLOBALS[$which]);
	while (list($k, $v) = each($GLOBALS[$which]))
		$GLOBALS[$which][$k] = GPCStripSlashes($GLOBALS[$which][$k]);
}

function RenderSepMenu($aMenu)
{
	reset($aMenu);
	$bNeedEnd = false;
	$bNeedStart = true;
	while (list($sText, $sLink) = each($aMenu))
	{
		if ($bNeedStart)
		{
			$bNeedStart = false;
			$bNeedEnd = true;
			echo '[';
		}
		else
			echo '&nbsp|';

		echo '&nbsp;<a class="adark" href="' . $sLink . '">' . $sText . '</a>';
	}

	if ($bNeedEnd)
		echo '&nbsp;]';
}

function LoadStringResource($name)
{
	global $dcl_info;

	// TODO: Allow browser override and check if locale available, if so configured
	if (!IsSet($GLOBALS['STR_' . $name . '_INCLUDED']))
	{
		$GLOBALS['STR_' . $name . '_INCLUDED'] = 1;
		include(sprintf('./str/%s/%s.str', $dcl_info['DCL_DEFAULT_LANGUAGE'], $name));
	}
}

function EvaluateReturnTo()
{
	// Always check the return value of this function to see if processing should continue
	// or the method should be invoked
	if (IsSet($GLOBALS['return_to']))
	{
			$GLOBALS['menuAction'] = $GLOBALS['return_to'];
			if ($GLOBALS['g_oSec']->ValidateMenuAction() == true)
			{
					list($class, $method) = explode(".", $GLOBALS['menuAction']);
					$obj = CreateObject('dcl.' . $class);
					eval("\$obj->$method();");

					return true;
			}
	}
	
	return false;
}

if (isset($phpgw) && is_object($phpgw))
{
	// In phpgw, so find DCL equivalent and load profile
	$oPersonnel = CreateObject('dcl.dbPersonnel');
	$oPersonnel->Connect();
	$oPersonnel->Query("select id, short, security from personnel where short='" . $phpgw_info['user']['account_lid'] . "'");
	if (!$oPersonnel->next_record())
	{
		$oPersonnel->FreeResult();
		if (isset($phpgw_info['user']['apps']['admin']) && is_array($phpgw_info['user']['apps']['admin']))
		{
			// Not in user table, but is phpgw admin, so load sa account
			$oPersonnel->Query("select id, short, security from personnel where short='sa'");
			$oPersonnel->next_record();
		}
	}

	if (is_array($oPersonnel->Record))
	{
		$DCLID = $oPersonnel->f('id');
		$DCLNAME = trim($oPersonnel->f('short'));
		$SEC = $oPersonnel->f('security');
		$DCLUI = 0;
		if (isset($phpgw_info['user']['preferences']['common']['lang']))
		{
			switch($phpgw_info['user']['preferences']['common']['lang'])
			{
				case 'de':
				case 'es':
				case 'fr':
				case 'it':
				case 'sl':
				case 'sv':
					$dcl_info['DCL_DEFAULT_LANGUAGE'] = $phpgw_info['user']['preferences']['common']['lang'];
					break;
				default:
					$dcl_info['DCL_DEFAULT_LANGUAGE'] = 'en';
			}
		}
	}
	$oPersonnel->FreeResult();
}

LoadStringResource('cmmn');
if (!function_exists('CreateObject'))
{
	function CreateObject($className)
	{
		$className = substr($className, 4);
		$includedChk = sprintf('%s_PHP_INCLUDED', strtoupper($className));
		if (!IsSet($GLOBALS[$includedChk]))
		{
			include('inc/class.' . $className . '.inc.php');
			$GLOBALS[$includedChk] = 1;
		}
		$obj = new $className;
		return $obj;
	}
}

function CreateTemplate($arrTemplate)
{
	global $dcl_info, $phpgw;

	// Create a template object and hook it up to the template in the
	// configured template set
	if (isset($phpgw) && is_object($phpgw))
		$Template = $phpgw->template;
	else
	{
		$Template = CreateObject('dcl.Template');

		// prepend directory structure
		reset($arrTemplate);
		while (list($handle, $filename) = each($arrTemplate))
			$arrTemplate[$handle] = 'templates/' . $dcl_info['DCL_DEF_TEMPLATE_SET'] . '/' . $filename;
	}

	$Template->set_file($arrTemplate);
	return $Template;
}

function GetHiddenVar($var, $val)
{
	return '<input type="hidden" name="' . $var . '" value="' . $val . '">';
}

if (!function_exists('str_repeat'))
{
	// PHP3 compatibility for PHP4 function
	function str_repeat($sString, $iRepeat)
	{
		if ($iRepeat < 1)
			return '';

		if ($iRepeat == 1)
			return $sString;

		// Try to be time effecient by doubling up string
		// then looping it for half the time
		$sRpt = $sString . $sString;
		$iRpt = floor($iRepeat / 2);
		$bExtra = ($iRepeat % 2 != 0);
		$sRet = '';

		for ($i = 0; $i < $iRpt; $i++)
			$sRet .= $sRpt;

		if ($bExtra)
			$sRet .= $sString;

		return $sRet;
	}
}

if (!function_exists('in_array'))
{
	// PHP3 compatibility for PHP4 function
	function in_array($sValue, &$aArray)
	{
		$bFound = false;
		if (is_array($aArray))
		{
			for ($i = 0; $i < count($aArray) && !$bFound; $i++)
				$bFound = ($aArray[$i] == $sValue);
		}

		return $bFound;
	}
}

function GetHelpLink($dark = false)
{
	global $dcl_info;

	$linkText = '?';

	$linkClass = $dark == true ? 'adark' : 'alight';

	return sprintf('[&nbsp;<a class="%s" href="#" onClick="javascript:window.open(\'./str/%s/help/%s.php\', \'dclhelp\', \'width=400,height=400,resizable=yes,scrollbars=yes\');">%s</a>&nbsp;]',
		$linkClass,
		$dcl_info['DCL_DEFAULT_LANGUAGE'],
		$GLOBALS['menuAction'],
		$linkText);
}

function GetJSDateFormat()
{
	global $dcl_info;

	$calDateFormat = str_replace('m', 'MM', $dcl_info['DCL_DATE_FORMAT']);
	$calDateFormat = str_replace('d', 'DD', $calDateFormat);
	return str_replace('Y', 'yyyy', $calDateFormat);
}

function commonHeader($formValidateSrc = '', $onLoad = '')
{
	if (IsSet($GLOBALS['HTML_HEADER_GENERATED']))
		return;

	global $phpgw, $dcl_info;
	$GLOBALS['HTML_HEADER_GENERATED'] = 1;

	if ($GLOBALS['DCLUI'] == 0 || $GLOBALS['DCLUI'] == 3)
		LoadStringResource('menu');

	if (!isset($phpgw) || !is_object($phpgw))
	{
		$title = '[' . $GLOBALS['dcl_domain_info'][$GLOBALS['dcl_domain']]['name'] . ' / ' . $GLOBALS['DCLNAME'] . ']';
		if ($dcl_info['DCL_HTML_TITLE'] != '')
			$title .= '&nbsp;-&nbsp;' . $dcl_info['DCL_HTML_TITLE'];
?>
<html><head><title><?php echo $title; ?></title>
<style type="text/css">
<!--
	form {margin-bottom: 0px}
	a {text-decoration: none; font-weight: bold;}
	a:hover {text-decoration: underline; color: #0000FF;}
	.alight {text-decoration: none; color: <?php echo $dcl_info['DCL_COLOR_LIGHT']; ?>;}
	.alightu {text-decoration: underline; color: <?php echo $dcl_info['DCL_COLOR_LIGHT']; ?>;}
	.adark {text-decoration: none; color: <?php echo $dcl_info['DCL_COLOR_DARK']; ?>;}
	.agrey {text-decoration: none; color: #111111; font-weight: normal;}
	.agreyb {text-decoration: none; color: #111111; font-weight: bold;}
	.agreyu {text-decoration: underline; color: #111111; font-weight: normal;}
	.highlight {color: <?php echo $dcl_info['DCL_COLOR_LIGHT']; ?>; background-color: <?php echo $dcl_info['DCL_COLOR_DARK']; ?>; }
	.light {color: <?php echo $dcl_info['DCL_COLOR_LIGHT']; ?>;}
	.header { border-bottom: solid black 2px; }
	body { font-family: Tahoma, Verdana, Arial, Helvetica; font-size: 11px; }
	th { font-family: Tahoma, Verdana, Arial, Helvetica; font-size: 11px; }
	td { font-family: Tahoma, Verdana, Arial, Helvetica; font-size: 11px; }
	input { font-family: Tahoma, Verdana, Arial, Helvetica; font-size: 11px; }
	select { font-family: Tahoma, Verdana, Arial, Helvetica; font-size: 11px; }
	textarea { font-family: Tahoma, Verdana, Arial, Helvetica; font-size: 11px; }
-->
</style>
<?php
	}
	else
	{
?>
<style type="text/css">
<!--
	form {margin-bottom: 0px}
	.alight {text-decoration: none; color: <?php echo $GLOBALS['dcl_info']['DCL_COLOR_LIGHT']; ?>;}
	.alightu {text-decoration: underline; color: <?php echo $GLOBALS['dcl_info']['DCL_COLOR_LIGHT']; ?>;}
	.adark {text-decoration: none; color: <?php echo $GLOBALS['dcl_info']['DCL_COLOR_DARK']; ?>;}
	.agrey {text-decoration: none; color: #111111; font-weight: normal;}
	.agreyb {text-decoration: none; color: #111111; font-weight: bold;}
	.agreyu {text-decoration: underline; color: #111111; font-weight: normal;}
	.highlight {color: <?php echo $GLOBALS['dcl_info']['DCL_COLOR_LIGHT']; ?>; background-color: <?php echo $GLOBALS['dcl_info']['DCL_COLOR_DARK']; ?>; }
	.light {color: <?php echo $GLOBALS['dcl_info']['DCL_COLOR_LIGHT']; ?>;}
	.header { border-bottom: solid black 2px; }
	input { font-family: Tahoma, Verdana, Arial, Helvetica; font-size: 11px; }
	select { font-family: Tahoma, Verdana, Arial, Helvetica; font-size: 11px; }
	textarea { font-family: Tahoma, Verdana, Arial, Helvetica; font-size: 11px; }
-->
</style>
<?php
	}

	if ($GLOBALS['DCLUI'] == 0) // Menus!
	{
		print('<script language="JavaScript1.2" src="js/resize.js"></script>' . phpCrLf);
		include('dropmenu.php');
		createmenu();
	}

	if (!isset($phpgw) || !is_object($phpgw))
	{
		print('</head>');
		print('<body bgcolor="#FFFFFF"');
		if ($onLoad != '')
			printf(' onload="%s"', $onLoad);
		print('>');
	}

	if ($GLOBALS['DCLUI'] == 0)
		showmenu();
	else if ($GLOBALS['DCLUI'] == 3)
	{
		print('<table border="0" width="100%">');
		print('<tr><td valign="top" width="125">');
		include('staticMenu.php');
		print('</td><td valign="top">');
	}
}

function commonFooter()
{
	if ($GLOBALS['DCLUI'] == 3)
		print('</td></tr></table>');
	if (!isset($phpgw) || !is_object($phpgw))
		print('</body></html>');
}

function BeginChocoTable($lightColor = true, $width = '100%', $cellSpacing = 0, $printable = false)
{
	global $dcl_info;

	if ($printable)
	{
		$lc = '#ffffff';
		$dc = '#000000';
	}
	else
	{
		$lc = $dcl_info['DCL_COLOR_LIGHT'];
		$dc = $dcl_info['DCL_COLOR_DARK'];
	}
	if ($lightColor == true)
		$bgColor = $lc;
	else
		$bgColor = $dc;

	print("<table border=\"0\" bgcolor=\"$bgColor\" ");
	if ($width != 0)
		print("width=\"$width\" ");
	print("cellspacing=\"$cellSpacing\" cellpadding=\"2\">");
}

function EndTable()
{
	print('</table>');
}

function PrintLink($linkName, $rollover, $linkURL, $dark = false, $printable = false)
{
	$class = $dark == false ? 'alight' : 'adark';
	print("<a class=\"$class\" href=\"$linkURL\" title=\"$rollover\">" ); 
	print($linkName) ;
	print('</a>&nbsp;');
}

function PrintLinkSet($linkArray, $rolloverArray, $enclose = true, $dark = false, $printable = false)
{
	print(GetLinkSet($linkArray, $rolloverArray, $enclose, $dark, $printable));
}

function GetLink($linkName, $rollover, $linkURL, $dark = false, $printable = false)
{
	$class = $dark == false ? 'alight' : 'adark';
	$link = "<a class=\"$class\" href=\"$linkURL\"";
	if ($rollover != '')
		$link .= " title=\"$rollover\"";
	$link .= '>' . $linkName . '</a>&nbsp;';

	return $link;
}

function GetLinkSet($linkArray, $rolloverArray, $enclose = true, $dark = false, $printable = false)
{
	global $dcl_info;

	if (!is_array($linkArray) || !is_array($rolloverArray) || count($linkArray) < 1)
	{
		// Output _something_ in case we need to allow a TD or TH to background
		// fill properly.
		return '&nbsp';
	}

	$linkset = '';
	if ($enclose)
		$linkset .= '<font color="' . $dcl_info['DCL_COLOR_LIGHT'] . '">[</font>&nbsp;';

	while (list($linkName, $linkURL) = each($linkArray))
		$linkset .= GetLink($linkName, $rolloverArray[$linkName], $linkURL, $dark, $printable);

	if ($enclose)
		$linkset .= '<font color="' . $dcl_info['DCL_COLOR_LIGHT'] . '">]</font>';

	return $linkset;
}

function BeginChocoFont($dark = false, $printable = false)
{
	global $dcl_info;

	if ($printable)
	{
		$lc = '#ffffff';
		$dc = '#000000';
	}
	else
	{
		$lc = $dcl_info['DCL_COLOR_LIGHT'];
		$dc = $dcl_info['DCL_COLOR_DARK'];
	}
	if ($dark == true)
		$fontColor = $dc;
	else
		$fontColor = $lc;

	print("<font color=\"$fontColor\">");
}

function EndFont()
{
	print('</font>');
}

function PrintUser()
{
	// THANKS: Michael Brader.  If the user is logged in, print their name
	if ($GLOBALS['DCLID'] >= 0)
	{
		$obj = CreateObject('dcl.dbPersonnel');
		$obj->Load($GLOBALS['DCLID']);
		PrintWithChocoFont(sprintf(STR_CMMN_LOGGEDINAS, $obj->short, $obj->security));
	}
	else
	{
		PrintWithChocoFont(STR_CMMN_NOTLOGGEDIN);
	}
}

function PrintWithChocoFont($thisString, $printable = false)
{
	print("<span class=\"highlight\">$thisString</span>");
}

function PrintArrayAsChocoTable($nameArray, $fieldArray, $title, $footer = '', $titleLinks = '', $printable=false, $groupBy = -1)
{
	global $dcl_info;

	print('<center><table border="0">');
	print('<tr><th colspan="');
	if ($titleLinks != '')
	{
		print(strval(count($fieldArray[0]) - 1));
		print('" align="left');
	}
	else
		print(strval(count($fieldArray[0])));

	print('">');
	print($title);
	if ($titleLinks != '')
		print('</th><th align="right">' . $titleLinks);
	print('</th></tr>');

	if (count($nameArray) < 1 || count($fieldArray) < 1 || !is_array($nameArray) || !is_array($fieldArray))
	{
		print('<tr><td>');
		PrintWithChocoFont(STR_CMMN_ARRAYTABLEERR);
		print('</td></tr><tr><td>');
		printf(STR_CMMN_ARRAYTABLEERRHELP, $title);
		print('</td></tr></table></center>');
		return;
	}

	$bGrouping = ($groupBy != -1);
	print('<tr>');
	for ($i = 0; $i < count($nameArray); $i++)
	{
		if ($bGrouping && $i == $groupBy)
			continue;

		echo '<th style="border-bottom: solid black 2px">', $nameArray[$i], '</th>';
	}
	print('</tr>');

	$lastGroup = '<< undefined >>';
	for ($i = 0; $i < count($fieldArray); $i++)
	{
		if ($bGrouping && $lastGroup != $fieldArray[$i][$groupBy])
		{
			// Get item count
			$iItems = 0;
			for ($x = $i; $x < count($fieldArray) && ($fieldArray[$i][$groupBy] == $fieldArray[$x][$groupBy]); $x++)
			{
				$iItems++;
			}

			print('<tr><th colspan="' . (count($fieldArray[$i]) - 1) . '" style="background-color: #cecece; text-align: left;">');
			print($fieldArray[$i][$groupBy]) . '&nbsp;(' . $iItems . ')';
			print('</th></tr>');
			$lastGroup = $fieldArray[$i][$groupBy];
		}

		print('<tr>');
		for ($j = 0; $j < count($fieldArray[$i]); $j++)
		{
			if ($bGrouping && $j == $groupBy)
				continue;

			$k = $fieldArray[$i][$j];
			if (trim($k) == '')
				$k = '&nbsp;';

			$align = '';
               // Right justify all numbers (looks really swell)
			if (is_double($k) || is_long($k))
				$align = 'right';

			if ($i % 2 == 0)
				echo '<td style="background-color: ', $dcl_info['DCL_COLOR_LIGHT'], ';"';
			else
				echo '<td style="background-color: #ffffff;"';

			if ($align != '')
				echo ' align="', $align, '"';

			echo '>';

			echo $k, '</td>';
		}
		print('</tr>');
	}
	if ($footer != '')
	{
		print('<tr><th>');
		print($footer);
		print('</th></tr>');
	}
	EndTable();
	print('</center>');
}

function PrintTH($thisString, $choco = false, $printable = false)
{
	global $dcl_info;

	if ($printable)
	{
		$lc = '#ffffff';
		$dc = '#000000';
	}
	else
	{
		$lc = $dcl_info['DCL_COLOR_LIGHT'];
		$dc = $dcl_info['DCL_COLOR_DARK'];
	}

	print('<th');
	if ($choco)
		print(" bgcolor=\"$lc\"");
	print('>');
	if ($choco)
		print("<font color=\"$dc\">");
	if (trim($thisString) == '')
		print('&nbsp;');
	else
		print($thisString);
	if ($choco)
		EndFont();
	print('</th>');
}

function PrintTD($thisString, $choco = false, $align = '', $printable = false)
{
	global $dcl_info;

	if ($printable)
	{
		$lc = '#ffffff';
		$dc = '#000000';
	}
	else
	{
		$lc = $dcl_info['DCL_COLOR_LIGHT'];
		$dc = $dcl_info['DCL_COLOR_DARK'];
	}

	print('<td');
	if ($choco)
		print(" bgcolor=\"$lc\"");
	if ($align != '')
		print(' align="' . $align . '"');
	print('>');
	if (trim($thisString) == '')
		print('&nbsp;');
	else
		print($thisString);
	print('</td>');
}

function FormatPhone($phone)
{
	$retVal = trim($phone);
	if (strlen($retVal) == 7)
	{
		$retVal = substr($phone, 0, 3) . '-' . substr($phone, 3);
	}
	if (strlen($retVal) == 10)
	{
		$retVal = '(' . substr($phone, 0, 3) . ') ' . substr($phone, 3, 3) . '-' . substr($phone, 6);
	}

	return $retVal;
}

function GetCalendarLink($linkTo)
{
	$link = '<a href="javascript:doNothing()" ';
	$link .= 'onclick="setDateField(' . $linkTo . '); ';
	$link .= 'top.newWin = window.open(\'calendar.html\',\'cal\',\'dependent=yes,width=210,height=230,screenX=200,screenY=300,titlebar=yes\')">';
	$link .= '<img src="img/calendar.gif" border="0"></a>';

	return $link;
}

function CreateCalendarLink($linkTo)
{
	print(GetCalendarLink($linkTo));
}

function CreateLinkedText($sText)
{
	// Regular stuff
	$sRetVal = eregi_replace('(http|ftp|telnet|irc)://[^<>[:space:]]+[[:alnum:]/]', '<a target="_blank" class="adark" href="\0">\0</a>', $sText);

	// Pseudo stuff
	$sRetVal = eregi_replace('dcl://workorders/([0-9]+)[-]([0-9]+)', '<a class="adark" href="main.php?menuAction=boWorkorders.viewjcn&jcn=\1&seq=\2">\0</a>', $sRetVal);
	$sRetVal = eregi_replace('dcl://tickets/([0-9]+)', '<a class="adark" href="main.php?menuAction=boTickets.view&ticketid=\1">\0</a>', $sRetVal);
	$sRetVal = eregi_replace('dcl://projects/([0-9]+)', '<a class="adark" href="main.php?menuAction=boProjects.viewproject&wostatus=0&project=\1">\0</a>', $sRetVal);

	return $sRetVal;
}

function ShowDeleteYesNo($title, $action, $id, $name, $canBeDeactivated = true, $idfield = 'id')
{
	global $dcl_info;

	print('<center>');
	BeginChocoTable(false, 0);
	print('<tr><th>');
	BeginChocoFont();
	printf(STR_CMMN_DELETEITEM, $title);
	EndFont();
	print('</th></tr><tr><td>');
	BeginChocoTable();
	print('<tr><td bgcolor="' . $dcl_info['DCL_COLOR_LIGHT'] . '">');
	print('<form method="post" action="' . menuLink() . '">');
	print("<input type=\"hidden\" name=\"menuAction\" value=\"$action\">");
	print("<input type=\"hidden\" name=\"$idfield\" value=\"$id\">");
	printf(STR_CMMN_DELETECONFIRM, $title, $name);
	if ($canBeDeactivated)
		print('<br>' . STR_CMMN_DEACTIVATENOTE);
	print('<br></td></tr><tr><td align="center" bgcolor="' . $dcl_info['DCL_COLOR_LIGHT'] . '">');
	printf('<input type="submit" value="%s">', STR_CMMN_YES);
	printf('<input type="button" value="%s" onclick="history.back();">', STR_CMMN_NO);
	print('</form>');
	print('</td></tr>');
	EndTable();
	print('</td></tr>');
	EndTable();
	print('</center>');
}

function GetYesNoCombo($default = 'Y', $cbName = 'active', $size = 0, $noneOption = true)
{
	$str = "<select name=\"$cbName";
	if ($size > 0)
		$str .= '[]" multiple size=' . $size;
	else
		$str .= '"';
	$str .= '>';
	if ($size == 0 && $noneOption == true)
		$str .= sprintf('<option value="?">%s', STR_CMMN_SELECTONE);

	$str .= '<option value="Y"';
	if ('Y' == $default)
		$str .= ' selected';
	$str .= sprintf('>%s</option>', STR_CMMN_YES);

	$str .= '<option value="N"';
	if ('N' == $default)
		$str .= ' selected';
	$str .= sprintf('>%s</option>', STR_CMMN_NO);

	$str .= '</select>';

	return $str;
}

function CreateYesNoCombo($default = 'Y', $cbName = 'active', $size = 0, $noneOption = true)
{
	print GetYesNoCombo($default, $cbName, $size, $noneOption);
}

function PrintPermissionDenied()
{
	echo '<center><h3><font color="red">' . STR_CMMN_PERMISSIONDENIED . '</font></h3></center>';
}
?>
