<?php
/*
 * $Id: mysql.php,v 1.3.2.1.2.2 2002/11/01 13:51:38 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

if (!IsSet($GLOBALS['MYSQL_PHP_INCLUDED']))
{
	$GLOBALS['MYSQL_PHP_INCLUDED'] = 1;

	include ('datetime.php');

	class dclDB
	{
		var $conn;
		var $res;
		var $oid;
		var $cur;
		var $fieldArray;
		var $foreignKeys;
		var $cache;
		var $cacheEnabled;
		var $schemaVersion = '3';
		var $objTimestamp;
		var $objDate;
		var $emptyTimestamp;
		var $Record;

		function dclDB()
		{
			$this->conn = 0;
			$this->res = 0;
			$this->oid = 0;
			$this->cur = -1;
			$this->Record = array();

			$this->objTimestamp = new DCLTimestamp;
			$this->objDate = new DCLDate;

			// MySQL will update a null timestamp to current date/time.  This will help avoid that
			// when it is not desired.
			$this->emptyTimestamp = "''";
		}

		function mysql_die($error = '')
		{
			global $strError,$strMySQLSaid, $strBack;
			echo "<b> $strError </b><p>";
			if (empty($error))
				echo $strMySQLSaid.mysql_error();
			else
				echo $strMySQLSaid.$error;
			echo "<br><a href=\"javascript:history.go(-1)\">$strBack</a>";
			exit;
		}

		function Connect($conn = '')
		{
			global $dcl_domain_info, $dcl_domain;

			if ($conn == '')
			{
				if (!IsSet($GLOBALS['__DB_CONN__']))
				{
					$connString = $dcl_domain_info[$dcl_domain]['dbHost'];
					if ($dcl_domain_info[$dcl_domain]['dbPort'] != '')
						$connString .= ':' . $dcl_domain_info[$dcl_domain]['dbPort'];
					$this->conn = mysql_pconnect($connString, $dcl_domain_info[$dcl_domain]['dbUser'], 
							$dcl_domain_info[$dcl_domain]['dbPassword']) or $this->mysql_die();

					$GLOBALS['__DB_CONN__'] = $this->conn;
				}
				else
					$this->conn = $GLOBALS['__DB_CONN__'];
			}
			else
				$this->conn = $conn;

			mysql_select_db($dcl_domain_info[$dcl_domain]['dbName'], $this->conn) or $this->mysql_die();

			return $this->conn;
		}

		function Query($query)
		{
			$this->res = 0;
			$this->oid = 0;
			$this->cur = -1;
			$this->Record = array();

			if ($this->conn)
			{
				$this->res = mysql_query($query, $this->conn) or $this->mysql_die();
				if ($this->res)
				{
					$this->cur = 0;
					return $this->res;
				}
				else
				{
					print("<br>Error executing query!<br>$query");
					return -1;
				}
			}
			else
				return -1;
		}

		function LimitQuery($query, $offset, $rows)
		{
			$this->res = 0;
			$this->oid = 0;
			$this->cur = -1;
			$this->Record = array();

			if ($this->conn)
			{
				@$this->res = mysql_query($query . ' LIMIT ' . $offset . ',' . $rows, $this->conn) or $this->mysql_die();
				if ($this->res)
				{
					$this->cur = 0;
					return $this->res;
				}
				else
				{
					print("<br>Error executing query!<br>$query<br>");
					print(pg_ErrorMessage());
					return -1;
				}
			}
			else
				return -1;
		}

		function Execute($query)
		{
			$this->res = 0;
			$this->oid = 0;
			$this->cur = -1;
			$this->Record = array();

			if ($this->conn)
			{
				mysql_query($query, $this->conn) or $this->mysql_die();
				return 1;
			}
			else
				return -1;
		}

		function Insert($query)
		{
			$this->res = 0;
			$this->oid = 0;
			$this->cur = -1;
			$this->Record = array();

			if ($this->conn)
			{
				$this->res = mysql_query($query, $this->conn);
				if ($this->res)
					return $this->oid = mysql_insert_id($this->conn);
				else
				{
					print("<br>Error executing insert!<br>$query");
					return -1;
				}
			}
			else
			{
				print('<br>No connection!');
				return -1;
			}
		}

		function FreeResult()
		{
			$this->Record = array();
			if ($this->res != 0)
				@mysql_free_result($this->res);

			$this->res = 0;
		}

		function BeginTransaction()
		{
            // Might as well be sending this to /dev/null
			//return $this->Execute("BEGIN");
			return 1;
		}

		function EndTransaction()
		{
            // Might as well be sending this to /dev/null
			//return $this->Execute("COMMIT");
			return 1;
		}

		function RollbackTransaction()
		{
            // Might as well be sending this to /dev/null
			//return $this->Execute("ROLLBACK");
			return 1;
		}

		function NumRows()
		{
			if ($this->res)
				return mysql_num_rows($this->res);
			else
				return -1;
		}

		function NumFields()
		{
			if ($this->res)
				return mysql_num_fields($this->res);
			else
				return -1;
		}

		// from phpGW/phpLib db classes - sort of
		function next_record()
		{
			// bump up if just ran query
			if ($this->cur == -1)
				$this->cur = 0;

			$this->Record = @mysql_fetch_array($this->res);
			$this->cur++;
			//$this->Errno  = mysql_errno();
			//$this->Error  = mysql_error();

			$stat = is_array($this->Record);
			if (!$stat)
				$this->FreeResult();

			return $stat;
		}

		// from phpGW/phpLib db classes - sort of
		function f($sName)
		{
			return $this->Record[$sName];
		}

		function GetFieldName($fieldIndex)
		{
			// Seems the official call is mysql_field_name, but mysql_fieldname is for backward compatability
			if ($this->res)
				return mysql_fieldname($this->res, $fieldIndex);

			return '';
		}

		function IsFieldNull($thisField)
		{
			if ($this->res)
			{
				if (count($this->Record) > 0)
					return $this->Record[$thisField] == NULL;

				return ($this->GetField($thisField) == '');
			}
			else
				return -1;
		}

		function FetchAllRows()
		{
			$retVal = array();
			$i = 0;
			// bump up if just ran query
			if ($this->cur == -1)
				$this->cur = 0;

			while ($a = @mysql_fetch_row($this->res))
			{
				$this->cur++;
				$retVal[$i++] = $a;
			}

			return $retVal;
		}

		function InitFromArray($aSource)
		{
			reset($this->fieldArray);
			while (list($key, $field) = each($this->fieldArray))
			{
				if (IsSet($aSource[$field]))
					$this->$field = $aSource[$field];
			}
		}

		function InitFromGlobals()
		{
			reset($this->fieldArray);
			while (list($key, $field) = each($this->fieldArray))
			{
				if (IsSet($GLOBALS[$field])) 
				{
					$this->$field = $this->GPCStripSlashes($GLOBALS[$field]);
				}
			}
		}

		function DBAddSlashes($thisString)
		{
			if (!IsSet($thisString) || $thisString == '')
				return '';

			return AddSlashes($thisString);
		}

		function GPCStripSlashes($thisString)
		{
			if (get_magic_quotes_gpc() == 0)
				return $thisString;

			return stripslashes($thisString);
		}

		function CacheRow($key)
		{
			if (!$this->cacheEnabled || IsSet($this->cache[$key]))
				return -1;

			reset($this->fieldArray);
			while (list($dummykey, $field) = each($this->fieldArray))
			{
				if (IsSet($this->$field)) 
					$this->cache[$key][$field] = $this->$field;
			}

			return 0;
		}

		function LoadCache($key)
		{
			if (!$this->cacheEnabled || !IsSet($this->cache[$key]))
				return -1;

			reset($this->fieldArray);
			while (list($dummykey, $field) = each($this->fieldArray))
			{
				if (IsSet($this->cache[$key][$field])) 
					$this->$field = $this->cache[$key][$field];
			}

			return 0;
		}

		function GetNewIDSQLForTable($tableName)
		{
			if ($tableName == 'workorders')
			{
				if (!$this->conn)
					$this->Connect();
				$res = mysql_query('INSERT INTO jcn VALUES(NULL)', $this->conn);
				$jcn = mysql_insert_id($this->conn);
				return $jcn;
			}

			return '';
		}

		function GetSeqSQL($jcn)
		{
			if (!$this->conn)
				$this->Connect();
			$res = mysql_query("SELECT MAX(seq)+1 FROM workorders WHERE jcn=$jcn", $this->conn);
			if ($res)
			{
				if (mysql_num_rows($res) > 0)
					return mysql_result($res, 0, 0);
			}
			else
				return '';
		}

		function GetDateSQL()
		{
            // From Urmet Janes for MSSQL support
			return 'now()';
		}

		function DisplayToSQL($thisDate)
		{
			global $dcl_info;

			$eregStr = str_replace('m', '([0-9]{2})', $dcl_info['DCL_DATE_FORMAT']);
			$eregStr = str_replace('d', '([0-9]{2})', $eregStr);
			$eregStr = str_replace('Y', '([0-9]{4})', $eregStr);
			if(ereg('^' . $eregStr . ' ([0-9]{2}).([0-9]{2}).([0-9]{2})$', $thisDate))
				return "'" . $this->ArrangeTimeStampForInsert($thisDate) . "'";
			else
				return "'" . $this->ArrangeDateForInsert($thisDate) . "'";
		}

		function ArrangeDateForInsert($thisDate)
		{
			$this->objDate->SetFromDisplay($thisDate);
			return $this->objDate->ToDB();
		}

		function ArrangeTimeStampForInsert($thisStamp)
		{
			$this->objTimestamp->SetFromDisplay($thisStamp);
			return $this->objTimestamp->ToDB();
		}

		function FormatDateForDisplay($thisDate)
		{
			if ($thisDate == '' || $thisDate == '0000-00-00')
				return '';

			$this->objDate->SetFromDB($thisDate);
			return $this->objDate->ToDisplay();
		}

		function FormatTimeStampForDisplay($thisStamp)
		{
			if ($thisStamp == '00000000000000' || $thisStamp == '')
				return '';

			$this->objTimestamp->SetFromDB($thisStamp);
			return $this->objTimestamp->ToDisplay();
		}

		function GetUpperSQL($text)
		{
			return $text;
		}

		function GetLastInsertID($sTable)
		{
			return mysql_insert_id($this->conn);
		}

		function HasFKRef($id)
		{
			$bHasRef = false;
			$oKey = new dclDB; // Don't really need anything fancy, 'spose...
			while ((list($sTable, $sField) = each($this->foreignKeys)) && !$bHasRef)
			{
				if (is_array($sField)) // More than one field in here references this key
				{
					while ((list($sDummyKey, $sOneField) = each($sField)) && !$bHasRef)
					{
						$oKey->Query("SELECT $sOneField FROM $sTable WHERE $sOneField=$id");
						if ($oKey->next_record())
							$bHasRef = true;
					}
				}
				else
				{
					$oKey->Query("SELECT $sField FROM $sTable WHERE $sField=$id");
					if ($oKey->next_record())
						$bHasRef = true;
				}
			}

			return $bHasRef;
		}
	}
}
?>
