# phpMyAdmin MySQL-Dump
# http://www.htmlwizard.net/phpMyAdmin/
#
# $Id: createdb.sql,v 1.6.2.8.2.5 2003/01/29 05:12:33 mdean Exp $
#
# Host: localhost Database : dcl

# --------------------------------------------------------
#
# Table structure for table 'accounts'
#

CREATE TABLE accounts (
		id int(11) DEFAULT '0' NOT NULL auto_increment,
		short varchar(25) NOT NULL,
		name varchar(50) NOT NULL,
		add1 varchar(30),
		add2 varchar(30),
		city varchar(50),
		state char(2),
		zip varchar(11),
		contact varchar(50),
		voice varchar(10),
		fax varchar(10),
		data1 varchar(10),
		data2 varchar(10),
		notes text,
		active varchar(1) default 'Y',
		PRIMARY KEY (id)
	);

#
# Dumping data for table 'accounts'
#


# --------------------------------------------------------
#
# Table structure for table 'actions'
#

CREATE TABLE actions (
		id int(11) DEFAULT '0' NOT NULL auto_increment,
		short varchar(10) NOT NULL,
		name varchar(20) NOT NULL,
		active varchar(1) default 'Y',
		PRIMARY KEY (id)
	);

#
# Dumping data for table 'actions'
#

INSERT INTO actions VALUES( '1', 'DBG', 'Debug', 'Y');
INSERT INTO actions VALUES( '2', 'RES', 'Research', 'Y');
INSERT INTO actions VALUES( '3', 'DOC', 'Document', 'Y');
INSERT INTO actions VALUES( '4', 'TST', 'Testing', 'Y');
INSERT INTO actions VALUES( '5', 'DES', 'Design', 'Y');
INSERT INTO actions VALUES( '6', 'IMP', 'Implementation', 'Y');
INSERT INTO actions VALUES( '7', 'CORR', 'Correction', 'Y');

# --------------------------------------------------------
#
# Table structure for table 'departments'
#

CREATE TABLE departments (
		id int(11) DEFAULT '0' NOT NULL auto_increment,
		short varchar(10) NOT NULL,
		name varchar(30) NOT NULL,
		active varchar(1) default 'Y',
		PRIMARY KEY (id)
	);

#
# Dumping data for table 'departments'
#


# --------------------------------------------------------
#
# Table structure for table 'jcn'
#

CREATE TABLE jcn (
		id int(11) DEFAULT '0' NOT NULL auto_increment,
		PRIMARY KEY (id)
	);

#
# Dumping data for table 'jcn'
#


# --------------------------------------------------------
#
# Table structure for table 'personnel'
#

CREATE TABLE personnel (
		id int(11) DEFAULT '0' NOT NULL auto_increment,
		short varchar(10) NOT NULL,
		lastname varchar(25),
		firstname varchar(20),
		reportto int(11),
		department int(11),
		pwd varchar(50),
		security int(11),
		email varchar(80),
		active varchar(1) default 'Y',
		PRIMARY KEY (id),
		KEY short (short),
		UNIQUE short_2 (short)
	);

#
# Dumping data for table 'personnel'
#

INSERT INTO personnel VALUES( '1', 'sa', 'Administrator', '', '0', '0', 'c12e01f2a13ff5587e1e9e4aedb8242d', '9', '', 'Y');

# --------------------------------------------------------
#
# Table structure for table 'priorities'
#

CREATE TABLE priorities (
		id int(11) DEFAULT '0' NOT NULL auto_increment,
		short varchar(10) NOT NULL,
		name varchar(20) NOT NULL,
		weight int(11) DEFAULT '0' NOT NULL,
		active varchar(1) default 'Y',
		PRIMARY KEY (id)
	);

#
# Dumping data for table 'priorities'
#


# --------------------------------------------------------
#
# Table structure for table 'products'
#

CREATE TABLE products (
		id int(11) DEFAULT '0' NOT NULL auto_increment,
		short varchar(10) NOT NULL,
		name varchar(50) NOT NULL,
		reportto int(11),
		active varchar(1) default 'Y',
		ticketsto int(11) not null,
		wosetid int(11) not null default '0',
		tcksetid int(11) not null default '0',
		PRIMARY KEY (id)
	);

#
# Dumping data for table 'products'
#


# --------------------------------------------------------
#
# Table structure for table 'severities'
#

CREATE TABLE severities (
		id int(11) DEFAULT '0' NOT NULL auto_increment,
		short varchar(10) NOT NULL,
		name varchar(20) NOT NULL,
		weight int(11) DEFAULT '0' NOT NULL,
		active varchar(1) default 'Y',
		PRIMARY KEY (id)
	);

#
# Dumping data for table 'severities'
#


# --------------------------------------------------------
#
# Table structure for table 'statuses'
#

CREATE TABLE statuses (
		id int(11) DEFAULT '0' NOT NULL auto_increment,
		short varchar(10) NOT NULL,
		name varchar(20) NOT NULL,
		active varchar(1) default 'Y',
		dcl_status_type int(11) default '1' not null,
		PRIMARY KEY (id)
	);

#
# Dumping data for table 'statuses'
#

INSERT INTO statuses VALUES( '1', 'OP', 'Open', 'Y', 1);
INSERT INTO statuses VALUES( '2', 'CL', 'Closed', 'Y', 2);
INSERT INTO statuses VALUES( '3', 'DF', 'Deferred', 'Y', 3);
INSERT INTO statuses VALUES( '4', 'UA', 'Unassigned', 'Y', 1);

# --------------------------------------------------------
#
# Table structure for table 'timecards'
#

CREATE TABLE timecards (
		id int(11) DEFAULT '0' NOT NULL auto_increment,
		jcn int(11) DEFAULT '0' NOT NULL,
		seq int(11) DEFAULT '0' NOT NULL,
		actionon date DEFAULT '0000-00-00' NOT NULL,
		inputon timestamp(14),
		actionby int(11) DEFAULT '0' NOT NULL,
		status int(11) DEFAULT '0' NOT NULL,
		action int(11) DEFAULT '0' NOT NULL,
		hours float(10,2) DEFAULT '0.00' NOT NULL,
		summary varchar(100) NOT NULL,
		description text NOT NULL,
		revision varchar(20) NOT NULL,
		reassign_from_id int(11) null,
		reassign_to_id int(11) null,
		PRIMARY KEY (id)
	);

#
# Dumping data for table 'timecards'
#


# --------------------------------------------------------
#
# Table structure for table 'workorders'
#

CREATE TABLE workorders (
		jcn int(11) DEFAULT '0' NOT NULL,
		seq int(11) DEFAULT '0' NOT NULL,
		product int(11) DEFAULT '0' NOT NULL,
		account int(11),
		createby int(11) DEFAULT '0' NOT NULL,
		createdon timestamp(14),
		closedby int(11),
		closedon date,
		status int(11) DEFAULT '0' NOT NULL,
		statuson timestamp(14),
		lastactionon timestamp(14),
		deadlineon date,
		eststarton date,
		estendon date,
		starton date,
		esthours float(10,2),
		totalhours float(10,2),
		priority int(11) DEFAULT '0' NOT NULL,
		severity int(11) DEFAULT '0' NOT NULL,
		contact varchar(50),
		contactphone varchar(10),
		summary varchar(100) NOT NULL,
		notes text,
		description text NOT NULL,
		responsible int(11) DEFAULT '0' NOT NULL,
		revision varchar(20),
		publicview tinyint(4),
		oid int(11) DEFAULT '0' NOT NULL auto_increment,
		etchours float(10,2),
		module_id int(11),
		PRIMARY KEY (oid)
	);

#
# Dumping data for table 'workorders'
#

# --------------------------------------------------------
#
# Table structure for table 'dcl_projects'
#

CREATE TABLE dcl_projects (
		projectid int(11) DEFAULT '0' NOT NULL auto_increment,
		name varchar(100) NOT NULL,
		reportto int(11) DEFAULT '0' NOT NULL,
		createdby int(11) DEFAULT '0' NOT NULL,
		createdon timestamp(14),
		projectdeadline date,
		description text NOT NULL,
		status int(11) DEFAULT '0' NOT NULL,
		lastactivity timestamp(14),
		finalclose date,
		parentprojectid int(11) default '0'  not null,
		PRIMARY KEY (projectid),
		UNIQUE name (name)
	);

#
# Dumping data for table 'dcl_projects'
#

# --------------------------------------------------------
#
# Table structure for table 'projectmap'
#

CREATE TABLE projectmap (
		projectid int(11) DEFAULT '0' NOT NULL,
		jcn int(11) DEFAULT '0' NOT NULL,
		seq int(11) DEFAULT '0' NOT NULL,
		PRIMARY KEY (projectid,jcn,seq)
	);

#
# Dumping data for table 'projectmap'
#

# --------------------------------------------------------
#
# Table structure for table 'watches'
#

CREATE TABLE watches (
		watchid int(11) DEFAULT '0' NOT NULL auto_increment,
		typeid int(11) DEFAULT '0' NOT NULL,
		whatid1 int(11) DEFAULT '0' NOT NULL,
		whatid2 int(11) DEFAULT '0' NOT NULL,
		whoid int(11) DEFAULT '0' NOT NULL,
		actions int(11) DEFAULT '0' NOT NULL,
		PRIMARY KEY (watchid)
	);

CREATE TABLE tickets (
		ticketid int(11) auto_increment NOT NULL,
		product int(11) NOT NULL,
		account int(11),
		createdby int(11) NOT NULL,
		createdon timestamp(14) DEFAULT 'now()' NOT NULL,
		responsible int(11) NOT NULL,
		closedby int(11),
		closedon timestamp(14),
		status int(11) NOT NULL,
		statuson timestamp(14) NOT NULL,
		lastactionon timestamp(14),
		priority int(11) NOT NULL,
		type int(11) NOT NULL,
		contact varchar(80),
		contactphone varchar(20),
		issue text NOT NULL,
		version varchar(20),
		summary varchar(100),
		seconds int(11) not null default '0',
		contactemail varchar(100),
		module_id int(11),
		PRIMARY KEY (ticketid)
	);

CREATE TABLE ticketresolutions (
		resid int(11) auto_increment NOT NULL,
		ticketid int(11) NOT NULL,
		loggedby int(11) NOT NULL,
		loggedon timestamp(14) DEFAULT 'now()' NOT NULL,
		status int(11) NOT NULL,
		resolution text NOT NULL,
		startedon timestamp(14) NOT NULL,
		PRIMARY KEY (resid)
	);

CREATE TABLE faq (
		faqid int(11) auto_increment NOT NULL,
		name varchar(80) NOT NULL,
		createby int(11),
		createon timestamp(14) DEFAULT 'now()' NOT NULL,
		modifyby int(11),
		modifyon timestamp(14),
		active char(1) DEFAULT 'Y' NOT NULL,
		description text,
		PRIMARY KEY (faqid)
	);

CREATE TABLE faqtopics (
		topicid int(11) auto_increment NOT NULL,
		seq int(11) NOT NULL,
		faqid int(11) NOT NULL,
		name varchar(80) NOT NULL,
		description text NOT NULL,
		createby int(11),
		createon timestamp(14) DEFAULT 'now()' NOT NULL,
		modifyby int(11),
		modifyon timestamp(14),
		active char(1) DEFAULT 'Y' NOT NULL,
		PRIMARY KEY (topicid)
	);

CREATE TABLE faqquestions (
		questionid int(11) auto_increment NOT NULL,
		seq int(11) NOT NULL,
		topicid int(11) NOT NULL,
		questiontext text NOT NULL,
		createby int(11),
		createon timestamp(14) DEFAULT 'now()' NOT NULL,
		modifyby int(11),
		modifyon timestamp(14),
		active char(1) DEFAULT 'Y' NOT NULL,
		PRIMARY KEY (questionid)
	);

CREATE TABLE faqanswers (
		answerid int(11) auto_increment NOT NULL,
		questionid int(11) NOT NULL,
		answertext text NOT NULL,
		createby int(11) NOT NULL,
		createon timestamp(14) DEFAULT 'now()' NOT NULL,
		modifyby int(11),
		modifyon timestamp(14),
		active char(1) DEFAULT 'Y' NOT NULL,
		PRIMARY KEY (answerid)
	);

CREATE TABLE views (
		viewid int(11) auto_increment NOT NULL,
		whoid int(11) NOT NULL,
		name varchar(100) NOT NULL,
		ispublic char(1) DEFAULT 'N' NOT NULL,
		viewurl text NOT NULL,
		tablename varchar(30) not null,
		PRIMARY KEY(viewid)
	);


CREATE TABLE attributesets (
		id int(11) auto_increment NOT NULL,
		short varchar(20) NOT NULL,
		name varchar(100) NOT NULL,
		active char(1) NOT NULL DEFAULT 'Y',
		PRIMARY KEY(id)
	);

INSERT INTO attributesets(short,name,active) VALUES ('WO', 'Work Orders', 'Y');
INSERT INTO attributesets(short,name,active) VALUES ('TCK', 'Tickets', 'Y');

CREATE TABLE attributesetsmap (
		setid int(11) NOT NULL,
		typeid int(11) NOT NULL,
		keyid int(11) NOT NULL,
		weight int(11) NOT NULL
	);

INSERT INTO attributesetsmap SELECT 1, 1, id, 1 FROM actions;
INSERT INTO attributesetsmap SELECT 1, 2, id, weight FROM priorities;
INSERT INTO attributesetsmap SELECT 1, 3, id, weight FROM severities;
INSERT INTO attributesetsmap SELECT 1, 4, id, 1 FROM statuses;

INSERT INTO attributesetsmap SELECT 2, 1, id, 1 FROM actions;
INSERT INTO attributesetsmap SELECT 2, 2, id, weight FROM priorities;
INSERT INTO attributesetsmap SELECT 2, 3, id, weight FROM severities;
INSERT INTO attributesetsmap SELECT 2, 4, id, 1 FROM statuses;

CREATE TABLE dcl_config (
		dcl_config_name varchar(50) NOT NULL,
		dcl_config_field varchar(30) NOT NULL,
		dcl_config_int int(11),
		dcl_config_double double,
		dcl_config_date date,
		dcl_config_datetime timestamp(14),
		dcl_config_varchar varchar(255),
		PRIMARY KEY (dcl_config_name)
	);

CREATE TABLE dcl_chklst (
		dcl_chklst_id int(11) auto_increment NOT NULL,
		dcl_chklst_tpl_id int(11) NOT NULL,
		dcl_chklst_summary varchar(255) NOT NULL,
		dcl_chklst_createby int(11) NOT NULL,
		dcl_chklst_createon timestamp DEFAULT 'now()' NOT NULL,
		dcl_chklst_modifyby int(11),
		dcl_chklst_modifyon timestamp,
		dcl_chklst_status varchar(255),
		PRIMARY KEY (dcl_chklst_id)
	);

CREATE TABLE dcl_chklst_tpl (
		dcl_chklst_tpl_id int(11) auto_increment NOT NULL,
		dcl_chklst_tpl_name varchar(255) NOT NULL,
		dcl_chklst_tpl_active char(1) DEFAULT 'Y' NOT NULL,
		PRIMARY KEY (dcl_chklst_tpl_id)
	);

CREATE TABLE dcl_product_module (
		product_module_id int(11) auto_increment Not Null,
		product_id int(11) Not Null,
		module_name varchar(50) Not Null,
		active char(1) Not Null,
		PRIMARY KEY (product_module_id)
	);

INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_VERSION','dcl_config_varchar',NULL,NULL,NULL,NULL,'0.9.2');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_DATE_FORMAT','dcl_config_varchar',NULL,NULL,NULL,NULL,'m/d/Y');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_DATE_FORMAT_DB','dcl_config_varchar',NULL,NULL,NULL,NULL,'Y-m-d');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_TIMESTAMP_FORMAT_DB','dcl_config_varchar',NULL,NULL,NULL,NULL,'YmdHis');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_TIMESTAMP_FORMAT','dcl_config_varchar',NULL,NULL,NULL,NULL,'m/d/Y H:i:s');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_MAX_UPLOAD_FILE_SIZE','dcl_config_int',1048576,NULL,NULL,NULL,NULL);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_DEFAULT_LANGUAGE','dcl_config_varchar',NULL,NULL,NULL,NULL,'en');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_PRIVATE_KEY','dcl_config_varchar',NULL,NULL,NULL,NULL,'IloveDCL');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_ROOT','dcl_config_varchar',NULL,NULL,NULL,NULL,'http://localhost/dcl/');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_ADD_USER','dcl_config_int',9,NULL,NULL,NULL,NULL);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_DEL_WO','dcl_config_int',8,NULL,NULL,NULL,NULL);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_MOD_WO','dcl_config_int',7,NULL,NULL,NULL,NULL);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_ASSIGN_WO','dcl_config_int',5,NULL,NULL,NULL,NULL);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_ADD_WO','dcl_config_int',3,NULL,NULL,NULL,NULL);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_HAVE_WO','dcl_config_int',4,NULL,NULL,NULL,NULL);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_CHG_PWD','dcl_config_int',2,NULL,NULL,NULL,NULL);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_DEF_STATUS_ASSIGN_WO','dcl_config_int',1,NULL,NULL,NULL,NULL);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_DEF_STATUS_UNASSIGN_WO','dcl_config_int',4,NULL,NULL,NULL,NULL);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_DEF_PRIORITY','dcl_config_int',1,NULL,NULL,NULL,NULL);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_DEF_SEVERITY','dcl_config_int',2,NULL,NULL,NULL,NULL);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_AUTO_DATE','dcl_config_varchar',NULL,NULL,NULL,NULL,'Y');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_TIME_CARD_ORDER','dcl_config_varchar',NULL,NULL,NULL,NULL,'ASC');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_PROJECT_XML_TEMPLATES','dcl_config_varchar',NULL,NULL,NULL,NULL,'N');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_GD_TYPE','dcl_config_varchar',NULL,NULL,NULL,NULL,'png');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_CQQ_PERCENT','dcl_config_int',0,NULL,NULL,NULL,NULL);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_CQQ_FROM','dcl_config_varchar',NULL,NULL,NULL,NULL,'Somebody <someone@somewhere.org>');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_CQQ_SUBJECT','dcl_config_varchar',NULL,NULL,NULL,NULL,'Thank You For Calling');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_CQQ_TEMPLATE','dcl_config_varchar',NULL,NULL,NULL,NULL,'cqqmail.tpl');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_DEF_TEMPLATE_SET','dcl_config_varchar',NULL,NULL,NULL,NULL,'default');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_COLOR_LIGHT','dcl_config_varchar',NULL,NULL,NULL,NULL,'#eeeef8');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_COLOR_DARK','dcl_config_varchar',NULL,NULL,NULL,NULL,'#737b9c');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_SMTP_SERVER','dcl_config_varchar',NULL,NULL,NULL,NULL,'localhost');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_SMTP_ENABLED','dcl_config_varchar',NULL,NULL,NULL,NULL,'Y');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_SMTP_PORT','dcl_config_int',25,NULL,NULL,NULL,NULL);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_SMTP_TIMEOUT','dcl_config_int',30,NULL,NULL,NULL,NULL);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_PROJECT_BROWSE_PARENTS_ONLY', 'dcl_config_varchar', 'N');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_PROJECT_INCLUDE_PARENT_STATS', 'dcl_config_varchar', 'N');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_PROJECT_INCLUDE_CHILD_STATS', 'dcl_config_varchar', 'Y');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_FILE_PATH', 'dcl_config_varchar', '.');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_HTML_TITLE', 'dcl_config_varchar', 'Double Choco Latte - Copyright (C) 1998-2001 Michael L. Dean and Tim R. Norman');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) VALUES ('DCL_DEFAULT_PROJECT_STATUS', 'dcl_config_int', 1);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) VALUES ('DCL_DEFAULT_TICKET_STATUS', 'dcl_config_int', 1);
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_TICKET_ENABLED', 'dcl_config_varchar', 'N');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_TICKET_AUTORESPOND', 'dcl_config_varchar', 'N');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_TICKET_REPLY', 'dcl_config_varchar', 'N');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_TICKET_AUTORESPONSE_EMAIL', 'dcl_config_varchar', 'nobody@localhost');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_TICKET_FILE_PATH', 'dcl_config_varchar', '/tmp');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_TICKET_STATUS', 'dcl_config_int', 0);
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_TICKET_PRIORITY', 'dcl_config_int', 0);
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_TICKET_SEVERITY', 'dcl_config_int', 0);
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_TICKET_ACCOUNT', 'dcl_config_int', 0);
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_TICKET_REPLY_LOGGED_BY', 'dcl_config_int', 0);
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_SMTP_DEFAULT_EMAIL', 'dcl_config_varchar', 'nobody@localhost');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_WO_NOTIFICATION_HTML', 'dcl_config_varchar', 'N');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_WO_EMAIL_TEMPLATE', 'dcl_config_varchar', 'notify_wo_en.tpl');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_TCK_NOTIFICATION_HTML', 'dcl_config_varchar', 'N');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_TCK_EMAIL_TEMPLATE', 'dcl_config_varchar', 'notify_tck_en.tpl');

create table dcl_status_type (
		dcl_status_type_id int(11) not null,
		dcl_status_type_name varchar(50) not null,
		primary key(dcl_status_type_id)
	);

insert into dcl_status_type values (1, 'Open');
insert into dcl_status_type values (2, 'Completed');
insert into dcl_status_type values (3, 'Deferred');
