/*!

\if MANPAGES
\page dcmp2pgm Read DICOM image and presentation state and render bitmap
\else
\page dcmp2pgm dcmp2pgm: Read DICOM image and presentation state and render bitmap
\endif

\section synopsis SYNOPSIS

\verbatim
dcmp2pgm [options] dcmimage_in [bitmap_out]
\endverbatim

\section description DESCRIPTION

The \b dcmp2pgm utility renders a monochrome DICOM image under the control of
a grayscale softcopy presentation state object into a monochrome bitmap
with 8 bits/pixel.  The bitmap is stored either as "Portable Gray Map" (PGM)
or as a DICOM secondary capture image object.  If no presentation state is
read from file, a default presentation state is created.  The utility allows
to read a configuration file of the Softcopy Presentation State Viewer upon
startup.  In this case, the settings from the configuration file affecting
the rendering of the presentation state are used, e.g. a correction of the
gray scale range according to Barten's model (DICOM part 14) can be
performed if the characteristic curve of the display system is available
and defined in the configuration file.

\section parameters PARAMETERS

\verbatim
dcmimage_in  input DICOM image

bitmap_out   output DICOM image or PGM bitmap
\endverbatim

\section options OPTIONS

\subsection general_options general options
\verbatim
  -h  --help
        print this help text and exit

      --version
        print version information and exit

  -v  --verbose
        verbose mode, dump presentation state contents

  -d  --debug
        debug mode, print debug information
\endverbatim

\subsection processing_options processing options
\verbatim
  -p  --pstate  [f]ilename: string
        process using presentation state file

  -c  --config  [f]ilename: string
        process using settings from configuration file

  -f  --frame  [f]rame: integer
        process using image frame f (default: 1)
\endverbatim

\subsection output_format output format
\verbatim
  -D  --pgm
        save image as PGM (default)

  +D  --dicom
        save image as DICOM secondary capture
\endverbatim

\subsection output_options output options
\verbatim
  +S  --save-pstate  [f]ilename: string
        save presentation state to file
\endverbatim

\section command_line COMMAND LINE

All command line tools use the following notation for parameters: square
brackets enclose optional values (0-1), three trailing dots indicate that
multiple values are allowed (1-n), a combination of both means 0 to n values.

Command line options are distinguished from parameters by a leading '+' or '-'
sign, respectively.  Usually, order and position of command line options are
arbitrary (i.e. they can appear anywhere).  However, if options are mutually
exclusive the rightmost appearance is used.  This behaviour conforms to the
standard evaluation rules of common Unix shells.

In addition, one or more command files can be specified using an '@' sign as a
prefix to the filename (e.g. <em>\@command.txt</em>).  Such a command argument
is replaced by the content of the corresponding text file (multiple
whitespaces are treated as a single separator) prior to any further
evaluation.  Please note that a command file cannot contain another command
file.  This simple but effective approach allows to summarize common
combinations of options/parameters and avoids longish and confusing command
lines (an example is provided in file <em>share/data/dumppat.txt</em>).

\section environment ENVIRONMENT

The \b dcmp2pgm utility will attempt to load DICOM data dictionaries specified
in the \e DCMDICTPATH environment variable.  By default, i.e. if the
\e DCMDICTPATH environment variable is not set, the file
<em>\<PREFIX\>/lib/dicom.dic</em> will be loaded unless the dictionary is built
into the application (default for Windows).

The default behaviour should be preferred and the \e DCMDICTPATH environment
variable only used when alternative data dictionaries are required.  The
\e DCMDICTPATH environment variable has the same format as the Unix shell
\e PATH variable in that a colon (":") separates entries.  The data dictionary
code will attempt to load each file specified in the \e DCMDICTPATH
environment variable.  It is an error if no data dictionary can be loaded.

\section files FILES

<em>etc/dcmpstat.cfg</em> - sample configuration file

\section copyright COPYRIGHT

Copyright (C) 1998-2004 by Kuratorium OFFIS e.V., Escherweg 2, 26121 Oldenburg,
Germany.

*/