/*!

\if MANPAGES
\page dcmprscp DICOM basic grayscale print management SCP
\else
\page dcmprscp dcmprscp: DICOM basic grayscale print management SCP
\endif

\section synopsis SYNOPSIS

\verbatim
dcmprscp [options]
\endverbatim

\section description DESCRIPTION

The \b dcmprscp utility implements the DICOM Basic Grayscale Print Management
Service Class as SCP. It also supports the optional Presentation LUT SOP
Class.  The utility is intended for use within the DICOMscope viewer.

The \b dcmprscp utility accepts print jobs from a remote Print SCU.  It does
not create real hardcopies but stores print jobs in the local DICOMscope
database as a set of Stored Print objects (one per page) and Hardcopy
Grayscale images (one per film box N-SET).  The DICOMscope application allows
to load a Stored Print object created by \b dcmprscp and to render a screen
preview of the hardcopy.  The \b dcmprscp utility reads the characteristics of
the printer to be emulated from the configuration file.

\section options OPTIONS

\subsection general_options general options
\verbatim
  -h  --help
        print this help text and exit

      --version
        print version information and exit

  -v  --verbose
        verbose mode, print actions

  -d  --debug
        debug mode, print debug information
\endverbatim

\subsection processing_options processing options
\verbatim
  -c  --config  [f]ilename: string
        process using settings from configuration file

  -p  --printer  [n]ame: string (default: 1st printer in cfg file)
        select printer with identifier [n] from cfg file

  +d  --dump
        print all DIMSE messages

  -l  --logfile
        print to log file instead of stdout
\endverbatim

\section command_line COMMAND LINE

All command line tools use the following notation for parameters: square
brackets enclose optional values (0-1), three trailing dots indicate that
multiple values are allowed (1-n), a combination of both means 0 to n values.

Command line options are distinguished from parameters by a leading '+' or '-'
sign, respectively.  Usually, order and position of command line options are
arbitrary (i.e. they can appear anywhere).  However, if options are mutually
exclusive the rightmost appearance is used.  This behaviour conforms to the
standard evaluation rules of common Unix shells.

In addition, one or more command files can be specified using an '@' sign as a
prefix to the filename (e.g. <em>\@command.txt</em>).  Such a command argument
is replaced by the content of the corresponding text file (multiple
whitespaces are treated as a single separator) prior to any further
evaluation.  Please note that a command file cannot contain another command
file.  This simple but effective approach allows to summarize common
combinations of options/parameters and avoids longish and confusing command
lines (an example is provided in file <em>share/data/dumppat.txt</em>).

\section environment ENVIRONMENT

The \b dcmprscp utility will attempt to load DICOM data dictionaries specified
in the \e DCMDICTPATH environment variable.  By default, i.e. if the
\e DCMDICTPATH environment variable is not set, the file
<em>\<PREFIX\>/lib/dicom.dic</em> will be loaded unless the dictionary is built
into the application (default for Windows).

The default behaviour should be preferred and the \e DCMDICTPATH environment
variable only used when alternative data dictionaries are required.  The
\e DCMDICTPATH environment variable has the same format as the Unix shell
\e PATH variable in that a colon (":") separates entries.  The data dictionary
code will attempt to load each file specified in the \e DCMDICTPATH
environment variable.  It is an error if no data dictionary can be loaded.

\section files FILES

<em>etc/dcmpstat.cfg</em>, <em>etc/printers.cfg</em> - sample configuration files

\section see_also SEE ALSO

<b>dcmprscu</b>(1)

\section copyright COPYRIGHT

Copyright (C) 1999-2004 by Kuratorium OFFIS e.V., Escherweg 2, 26121 Oldenburg,
Germany.

*/