// $Id$  -*- C++ -*-
// The Mark Box saves its region

// Copyright (C) 1995 Technische Universitaet Braunschweig, Germany.
// Written by Andreas Zeller <zeller@gnu.org>.
// 
// This file is part of DDD.
// 
// DDD is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// DDD is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public
// License along with DDD -- see the file COPYING.
// If not, write to the Free Software Foundation, Inc.,
// 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// 
// DDD is the data display debugger.
// For details, see the DDD World-Wide-Web page, 
// `http://www.gnu.org/software/ddd/',
// or send a mail to the DDD developers <ddd@gnu.org>.

char MarkBox_rcsid[] = 
    "$Id$";

#ifdef __GNUG__
#pragma implementation
#endif

#include "MarkBox.h"

#include "assert.h"
#include "MarkBox.h"

DEFINE_TYPE_INFO_1(MarkBox, TransparentHatBox)

// Draw
void MarkBox::_draw(Widget w, 
		    const BoxRegion& r, 
		    const BoxRegion& exposed,
		    GC gc, 
		    bool context_selected) const
{
    BoxRegion sonRegion = r;

    if (!extend(X))
	sonRegion.space(X) = size(X);
    if (!extend(Y))
	sonRegion.space(Y) = size(Y);

    // Save the region
    MUTABLE_THIS(MarkBox *)->_region = sonRegion;

    // Keep on drawing...
    TransparentHatBox::_draw(w, r, exposed, gc, context_selected);
}
