#! /bin/sh
#

PATH=/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin
DAEMON=/usr/sbin/ddtcd
NAME=ddtcd
DESC="Dynamic DNS daemon"

test -f $DAEMON || exit 0

set -e

case "$1" in
  start)
	echo -n "Starting $DESC: "
	start-stop-daemon --start --quiet --pidfile /var/run/ddt/$NAME.pid \
	        --exec $DAEMON
	echo "$NAME."

	# Uncomment the following if you wish your host to be marked online
	# on startup. You typically want this for permanant connections like
        # cable modem or DSL. You probably don't want this if using a modem.

        # sleep 0.1
        # echo -n "Updating Dynamic DNS: "
        # ddtc --online --batch >/dev/null
        # echo "done."

	;;
  stop)
	echo -n "Stopping $DESC: "
	start-stop-daemon --stop --quiet --oknodo --pidfile \
	        /var/run/ddt/$NAME.pid --exec $DAEMON
	echo "$NAME."
	;;
  #reload)
	# echo "Reloading $DESC configuration files."
	# start-stop-daemon --stop --signal 1 --quiet --pidfile \
	#	/var/run/$NAME.pid --exec $DAEMON
  #;;
  restart|force-reload)
	#
	#	If the "reload" option is implemented, move the "force-reload"
	#	option to the "reload" entry above. If not, "force-reload" is
	#	just the same as "restart".
	#
	echo -n "Restarting $DESC: "
	start-stop-daemon --stop --quiet --oknodo --pidfile \
		/var/run/ddt/$NAME.pid --exec $DAEMON
	sleep 1
	start-stop-daemon --start --quiet --oknodo --pidfile \
		/var/run/ddt/$NAME.pid --exec $DAEMON
	echo "$NAME."
	;;
  *)
	N=/etc/init.d/$NAME
	# echo "Usage: $N {start|stop|restart|reload|force-reload}" >&2
	echo "Usage: $N {start|stop|restart|force-reload}" >&2
	exit 1
	;;
esac

exit 0
