package com.tildemh.debbuggtk;

import com.tildemh.debbug.*;
import org.gnu.gtk.*;
import org.gnu.gnome.*;
import org.gnu.gnome.event.*;

/**
 * Bug reporter page for View Package bug listings
 * <p>See all outstanding bugs for this package (and source package??). Ability
 * to open with BugViewer (and hence also edit). Text will encourage editing. 
 *
 * <p>This is released under the terms of the GNU Lesser General Public License
 * (LGPL). See the COPYING file for details.
 *
 * @version $Id: BRViewBugs.java,v 1.5 2003/12/07 11:09:46 mh Exp $
 * @author &copy; Mark Howard &lt;mh@debian.org&gt; 2002
 */
public class BRViewBugs extends DruidPageStandard implements ListingReportListener, DruidPageSetupListener, DruidPageChangeListener {

	private boolean contentSet = false;
	private BugReporter br;
	private String pkg;
	private ListingReport listing;
	private org.gnu.gtk.Window parentWindow;
	private Label head;
	private ProgressBar progress;

	public BRViewBugs( BugReporter br, org.gnu.gtk.Window win ){
		super();
		this.br = br;
		this.parentWindow = win;
		addListener( (DruidPageSetupListener) this );
		addListener( (DruidPageChangeListener) this );
		setLogo( BugReporter.getLogo() );
	}


	public void druidPageSetupEvent( DruidPageSetupEvent event ){
		if ( event.isOfType( DruidPageSetupEvent.Type.PREPARE ) ){
			if (!contentSet){
				// make the page
				setTitle("View Existing Bug Reports");
				VBox content = getLayout();
				head = new Label("");
				head.setLineWrap(true);
				content.packStart(head, false, true, 0);

				progress = new ProgressBar();
				content.packStart(progress, false, true, 0);
				listing = new ListingReport( BTS.getInstance(), this, parentWindow );
				content.packStart( listing, true, true, 0 );
				// TODO: Show when listing last updated! and have refresh
				// button.

				// TODO: source package listing???

				Label foot = new Label("");
				foot.setMarkup("If the issue you wanted to report is listed above, please double click on that entry, click <tt>Edit Bug</tt> and add your comments (even if just to confirm that the bug exists - most maintainers will appreciate it). If your report is not listed above, please click <tt>Forward</tt>");
				foot.setLineWrap(true);
				content.packStart( foot, false, true, 0);				
				content.showAll();
				contentSet = true;
			}
			progress.setText("");
			progress.setFraction(0);
			pkg = br.getBug().getPackageName();
			head.setMarkup("Please look through the following list of existing bug reports against <tt>"+pkg+"</tt>. For more details of a report, double click on it.");
			listing.setPackage( new ListingStub( ListingType.BINARY, pkg ) );
		}
	}

	public boolean druidPageChangeEvent( DruidPageChangeEvent event ){
		if ( event.isOfType( DruidPageChangeEvent.Type.NEXT ) ){
			br.viewBugDone();
			return true;
		}else if ( event.isOfType( DruidPageChangeEvent.Type.BACK ) ){
		}else if ( event.isOfType( DruidPageChangeEvent.Type.CANCEL ) ){
		}
		return false;
	}

	public void listingSelectionChanged(com.tildemh.debbug.Bug bug){
		BugViewer bv = new BugViewer( bug );
	}

	public void listingChanged( ListingStub newListing ){ }

	public void listingReportStateChanged( ListingState state ){
		progress.setText( state.toString() );
		progress.setFraction( (double) state.getCurrent() / (double) state.getMax() );
	}

	
}
