package com.tildemh.debbuggtk;

import com.tildemh.debbug.*;
import org.gnu.gtk.*;
import org.gnu.gtk.event.*;
import java.io.*;

/**
 * Form to select a package to be displayed. This can be any of:
 * <ul>
 * <li>Binary package
 * <li>Source package
 * <li>Maintiner email
 * <li>Submitter email
 * </ul>
 *
 * <p>This is released under the terms of the GNU Lesser General Public License
 * (LGPL). See the COPYING file for details.
 *
 * @version $Id: PkgSelector.java,v 1.5 2002/12/21 20:01:10 mark Exp $
 * @author &copy; Mark Howard &lt;mh@debian.org&gt; 2002
 */
public class PkgSelector extends Window{
	

	private SizeGroup lblGrp;
	private PkgSelectorHandler handler;

	/**
	 * Constructs a pkgselector object
	 * @param handler object which will be called if the dialog sucessfully
	 * exits.
	 */
	public PkgSelector(PkgSelectorHandler handler){
		super(WindowType.TOPLEVEL);
		this.handler = handler;
		
		setTitle("Download package listings");
		setModal(true);
		
		VBox hbox = new VBox(false, 15);
		add(hbox);

		lblGrp = new SizeGroup( SizeGroupMode.HORIZONTAL );

		hbox.packStart( makeEntry("Binary Package: ", "") );
		hbox.packStart( makeEntry("Source Package: ", "src:") );
		hbox.packStart( makeEntry("Maintainer Email: ", "") );
		hbox.packStart( makeEntry("Submitter Email: ", "submitter:") );

	}

	/**
	 * Adds an entry space to the page.
	 */
	private HBox makeEntry(String title, String prefix){
		final String pref = prefix;
		HBox vbox = new HBox(false, 5);
		Label lbl = new Label(title);
		lblGrp.addWidget(lbl);
		vbox.packStart(lbl);
		final Entry entry = new Entry();
		vbox.packStart(entry);
		Button submit = new Button("Fetch");
		vbox.packStart(submit);
		submit.addListener(new ButtonListener(){
			public void buttonEvent(ButtonEvent event){
				if (event.isOfType( ButtonEvent.Type.CLICK )){
					hide();
					handler.pkgSelected( entry.getText(), pref);
				}
			}
		});
		return vbox;
	}


}
