package com.tildemh.debbug;


/**
 * Policy to determine when to check for bug reports online. 
 *
 * <p>This is released under the terms of the GNU Lesser General Public License
 * (LGPL). See the COPYING file for details.
 *
 * @version $Id: CachePolicy.java,v 1.3 2003/06/25 14:08:02 mark Exp $
 * @author &copy; Mark Howard &lt;mh@debian.org&gt; 2002
 */
public class CachePolicy{

	private int value;		// integer representation


	/** 
	 */
	private CachePolicy(int value){
		this.value = value;
	}

	/**
	 * Connections will never be made to the internet. If a report is not found
	 * in cache, a not found exception will be raised. This may be useful for
	 * implementing an offline mode.
	 */
	public static CachePolicy NEVER_CHECK = new CachePolicy(0);
	
	/**
	 * Always check online.
	 */
	public static CachePolicy ALWAYS_CHECK = new CachePolicy(0);

	/**
	 * @return true if two  are the same
	 */
	public boolean equals ( CachePolicy test ){
		return this.value == test.getValue();
	}
	
	/** 
	 * @return internal representation 
	 */
	public int getValue(){
		return value;
	}

}
