<?xml version="1.0" encoding="utf-8" ?>
<!-- vim: set sts=2 ai expandtab:

TEST Convert wiki page generated raw.xml to chapter
URL links cleaned as "&url-*;".
Table are not touched.

General:
 Drop <article>
 Drop <section> except second one
 Use second <section> and if requested change it to <chapter>

Add tags:
 * warning:	added for para with /!\
 * caution:	added for para with <!>
 * important:	added for para with {*}
 * tip:		added for para with {i}
 * note:	added for para with (!)
 * note:	added for para with (./)
 * note:	added for para with {OK}

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:variable name="uletters">ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789 !#$%()=-~^|\/+*,.?;:@`&quot;&apos;&amp;&gt;&lt;</xsl:variable>
<xsl:variable name="lletters">abcdefghijklmnopqrstuvwxyzabcdefghij</xsl:variable>

<xsl:output method="xml" indent="yes"/>

<!-- xsl:strip-space elements="*"/ -->

<xsl:template match="para">
  <xsl:copy>
    <!-- xsl:value-of select="concat(substring(translate(.,$uletters,$lletters),1,8),substring(translate(.,$uletters,$lletters), string-length(translate(.,$uletters,$lletters))-7,8))"/ -->
    <xsl:value-of select="(translate(.,$uletters,$lletters))"/>
  </xsl:copy>
</xsl:template>

<xsl:template match="@*|node()">
  <xsl:copy>
    <xsl:apply-templates select="@*|node()"/>
  </xsl:copy>
</xsl:template>


</xsl:stylesheet>






