#ifndef xcontrol_command_h_
#define xcontrol_command_h_ 1

#include "shared_fd.h"

#include <string>
#include <list>

class command
{
public:
	class arg_list;
	class env_list;

	command(std::string const &executable,
			arg_list const &args,
			env_list const &env,
			shared_fd child_stdin = shared_fd::devtty,
			shared_fd child_stdout = shared_fd::devtty,
			shared_fd child_stderr = shared_fd::devtty);

	void run(void);
	int wait(void);

	class arg_list :
		private std::list<std::string>
	{
	public:
		using std::list<std::string>::push_back;
		using std::list<std::string>::size;
		using std::list<std::string>::begin;
		using std::list<std::string>::end;
	};

	class env_list :
		private std::list<std::string>
	{
	public:
		void push_back(std::string const &key, std::string const &value)
		{
			std::string keyvalue = key + "=" + value;
			std::list<std::string>::push_back(keyvalue);
		}
		using std::list<std::string>::size;
		using std::list<std::string>::begin;
		using std::list<std::string>::end;
	};

private:
	std::string const executable;
	arg_list const args;
	env_list const env;
	shared_fd child_stdin;
	shared_fd child_stdout;
	shared_fd child_stderr;

	pid_t pid;
};

#endif
