#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "transformation.h"

#include "control_file.h"

#include "transformations.h"

namespace {

class build_depends_tools_transformation :
	public transformation
{
public:
	virtual ~build_depends_tools_transformation(void) throw();
	virtual void operator()(control_file &) const;
};

build_depends_tools_transformation::~build_depends_tools_transformation(void) throw()
{
	return;
}

void build_depends_tools_transformation::operator()(control_file &control) const
{
	source_section &source = control.source();
	source.build_depends += source.build_depends_tools;
	source.build_depends_tools.clear();
	return;
}

}

transformation const &transform_build_depends_tools = build_depends_tools_transformation();
