#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "control_file.h"
#include "control_file_stream.h"
#include "transformations.h"

#include "unknown_argument.h"

#include <stdexcept>
#include <iostream>

class no_action :
	public std::logic_error
{
public:
	no_action(void);
};

int main(int const argc, char const *const *const argv) throw()
try
{
	typedef char const *const *arg_iterator;
	arg_iterator const args_begin = &argv[1];
	arg_iterator const args_end = &argv[argc];

	enum
	{
		none,
		build,
		extract,
		check
	} action = none;

	for(arg_iterator i = args_begin; i != args_end; ++i)
	{
		std::string arg(*i);
		if(arg.empty())
			continue;

		if(arg == "build")
			action = build;
		else if(arg == "extract")
			action = extract;
		else if(arg == "check")
			action = check;
		else
			throw unknown_argument(arg);
	}

	if(action == none)
		throw no_action();

	control_file control("debian/xcontrol");

	transform_build_depends_tools(control);

	if(action == build)
	{
		control_file_ostream out(std::cout.rdbuf());
		out << control;
		return 0;
	}
	else if(action == check)
	{
		control_file compliant_control("debian/control");
		if(control == compliant_control)
			return 0;
		else
			return 1;
	}
}
catch(std::exception &e)
{
	std::cerr << "E: " << e.what() << std::endl;
	return 1;
}

no_action::no_action(void) :
	std::logic_error("no action specified")
{
	return;
}
