# This is a part of debnest.
# $Id: debnest-core.mk 10 2007-11-08 09:30:25Z makholm $

ifndef __debnest_core

__debnest_core := 1

DEBNEST_IMPORT_SCRIPTDIR ?= debian/scripts/debnest

DEBNEST_SOURCE_DIR	:= build-tree
DEBNEST_STAMP_DIR	:= stampdir
DEBNEST_DSCS		:= $(shell /bin/ls *.dsc)
ifeq (1,$(DEBNEST_VERSIONED_SOURCE))
DEBNEST_BUILD_DIR	:= $(shell for dsc in `echo $(DEBNEST_DSCS)`; do echo -n "`egrep "^Source: " $$dsc | cut -d' ' -f2`-`egrep "^Version: " $$dsc | grep -v GnuPG | cut -d' ' -f2 | sed 's/-[^-]*$$//'` "; done)
else
DEBNEST_BUILD_DIR	:= $(shell for dsc in `echo $(DEBNEST_DSCS)`; do echo -n "`egrep "^Source: " $$dsc | cut -d' ' -f2` "; done)
endif

DEBNESTUNPACK		:= debian/debnest-unpack-script

ifneq ($(shell if test -f $(DEBNESTUNPACK); then chmod +x $(DEBNESTUNPACK); $(DEBNESTUNPACK) builddir; fi),)
DEBNEST_BUILD_DIR	+= $(shell $(DEBNESTUNPACK) builddir)
endif

DEBNEST_PACKAGES	?= $(shell egrep "^Package: " debian/control | cut -d' ' -f2)

debnest-unpack: $(DEBNEST_STAMP_DIR)/debnest-unpack-stamp
$(DEBNEST_STAMP_DIR)/debnest-unpack-stamp:
	rm -rf $(DEBNEST_SOURCD_DIR)
	install -d $(DEBNEST_SOURCE_DIR) $(DEBNEST_STAMP_DIR)
	cp /dev/null $(DEBNEST_STAMP_DIR)/debnest-unpack-stampT
	if test -f $(DEBNESTUNPACK); then \
	  $(DEBNESTUNPACK) unpack $(DEBNEST_SOURCE_DIR) > $(DEBNEST_STAMP_DIR)/debnest-unpack-stampT; \
	fi
ifeq (1,$(DEBNEST_VERSIONED_SOURCE))
	if /bin/ls *.dsc > /dev/null 2> /dev/null; then \
	  for dsc in `pwd`/*.dsc; do \
	    (set -e; cd $(DEBNEST_SOURCE_DIR); dpkg-source -x $$dsc); \
	done; \
	fi
else
	if /bin/ls *.dsc > /dev/null 2> /dev/null; then \
	  for dsc in `pwd`/*.dsc; do  \
	    (set -e; cd $(DEBNEST_SOURCE_DIR); dpkg-source -x $$dsc `egrep "^Source: " $$dsc | cut -d' ' -f2`); \
	done; \
	fi
endif
ifneq (,$(DEBNEST_RECURSIVE_UNPACK))
	for dir in $(DEBNEST_BUILD_DIR); do \
		(set -e; cd $(DEBNEST_SOURCE_DIR)/$$dir; debian/rules $(DEBNEST_RECURSIVE_UNPACK)); \
	done;
endif
	touch $(DEBNEST_STAMP_DIR)/debnest-unpack-stampT; \
	mv $(DEBNEST_STAMP_DIR)/debnest-unpack-stampT $(DEBNEST_STAMP_DIR)/debnest-unpack-stamp

debnest-build: $(DEBNEST_STAMP_DIR)/debnest-unpack-stamp debnest-build-misc
	for dir in $(DEBNEST_BUILD_DIR); do \
	  (set -e; cd $(DEBNEST_SOURCE_DIR)/$$dir; debian/rules build); \
	done

debnest-clean-common:
	for dir in $(DEBNEST_BUILD_DIR); do \
	  ! test -f $(DEBNEST_SOURCE_DIR)/$$dir/debian/changelog.debnest || \
	  mv $(DEBNEST_SOURCE_DIR)/$$dir/debian/changelog.debnest \
	    $(DEBNEST_SOURCE_DIR)/$$dir/debian/changelog; \
	  ! test -f $(DEBNEST_SOURCE_DIR)/$$dir/debian/control.debnest || \
	  mv $(DEBNEST_SOURCE_DIR)/$$dir/debian/control.debnest \
	    $(DEBNEST_SOURCE_DIR)/$$dir/debian/control; \
	done
	/bin/rm -f $(DEBNEST_SOURCE_DIR)/*.deb

debnest-clean-nest: debnest-clean-common
	for dir in $(DEBNEST_BUILD_DIR); do \
	  (set -e; \
	  	if test -d $(DEBNEST_SOURCE_DIR)/$$dir; then \
	  		cd $(DEBNEST_SOURCE_DIR)/$$dir; debian/rules clean; \
	 	fi \
	  ); \
	done

debnest-clean: debnest-clean-nest debnest-clean-misc
	/bin/rm -rf $(DEBNEST_SOURCE_DIR) $(DEBNEST_STAMP_DIR) debian/files controlT

debnest-binary-common:
	cp /dev/null debian/files

	# changelog and control modification
	for dir in $(DEBNEST_BUILD_DIR); do \
	  cp $(DEBNEST_SOURCE_DIR)/$$dir/debian/changelog \
	    $(DEBNEST_SOURCE_DIR)/$$dir/debian/changelog.debnest; \
	  cp debian/changelog $(DEBNEST_SOURCE_DIR)/$$dir/debian/changelog; \
	  cp $(DEBNEST_SOURCE_DIR)/$$dir/debian/control \
	    $(DEBNEST_SOURCE_DIR)/$$dir/debian/control.debnest; \
	  sed -e "s/^Source: .*/Source: `grep '^Source: ' debian/control | cut -d' ' -f2-`/" -e "s/^Maintainer: .*/Maintainer: `grep '^Maintainer: ' debian/control | cut -d' ' -f2-`/" $(DEBNEST_SOURCE_DIR)/$$dir/debian/control > controlT; \
	  mv controlT $(DEBNEST_SOURCE_DIR)/$$dir/debian/control; \
	done

debnest-binary-indep-nest: build debnest-binary-common
	for dir in $(DEBNEST_BUILD_DIR); do \
	  (set -e; cd $(DEBNEST_SOURCE_DIR)/$$dir; debian/rules binary-indep); \
	done

debnest-binary-indep: debnest-binary-indep-nest
	for dir in $(DEBNEST_BUILD_DIR); do \
	  grep Package: debian/control | cut -d' ' -f2 | while read pkg; do \
	    if echo $(DEBNEST_PACKAGES) | egrep "(^| )$$pkg(\$$| )" > /dev/null; then \
	      grep "$${pkg}_" $(DEBNEST_SOURCE_DIR)/$$dir/debian/files | grep '_all\.deb' >> debian/files && \
	      cp $(DEBNEST_SOURCE_DIR)/`grep "$${pkg}_" $(DEBNEST_SOURCE_DIR)/$$dir/debian/files | cut -d' ' -f1` .. || true ; \
	    fi; \
	  done; \
	done

debnest-binary-arch-nest: build debnest-binary-common
	for dir in $(DEBNEST_BUILD_DIR); do \
	  (set -e; cd $(DEBNEST_SOURCE_DIR)/$$dir; debian/rules binary-arch ); \
	done

debnest-binary-arch: debnest-binary-arch-nest
	for dir in $(DEBNEST_BUILD_DIR); do \
	  grep Package: debian/control | cut -d' ' -f2 | while read pkg; do \
	    if echo $(DEBNEST_PACKAGES) | egrep "(^| )$$pkg(\$$| )" > /dev/null; then \
	      grep "$${pkg}_" $(DEBNEST_SOURCE_DIR)/$$dir/debian/files | grep -v '_all\.deb' >> debian/files && \
	      cp $(DEBNEST_SOURCE_DIR)/`grep "$${pkg}_" $(DEBNEST_SOURCE_DIR)/$$dir/debian/files | cut -d' ' -f1` .. || true ; \
	    fi; \
	  done; \
	done

debnest-binary: debnest-binary-arch debnest-binary-indep
debnest-binary-arch-misc::
debnest-binary-indep-misc::
debnest-build-misc::
debnest-clean-misc::

$(DEBNEST_IMPORT_SCRIPTDIR):
	install -d $(DEBNEST_IMPORT_SCRIPTDIR)

debnest-import: $(DEBNEST_IMPORT_SCRIPTDIR)
	install $(DEBNEST_SYSTEM_SCRIPTDIR)/debnest-core.mk \
		$(DEBNEST_SYSTEM_SCRIPTDIR)/debnest.mk \
			$(DEBNEST_IMPORT_SCRIPTDIR)
endif
