
#ifndef DATUM_H
#define DATUM_H

#include "def.h"

enum   datum_type {            NO_DATUM, DEB, TITLE, TOC, XREF   };
struct datum      {
  enum datum_type type      ; /*    0     x     x     x     x    */
  char  buf0[WIDTH_DATA+3]  ; /*    x     x     x     x     x    */
  char *buf                 ; /*    x     x     x     x     x    */
  char *maint   , *maintX   ; /*          x                      */
  char *pri     , *priX     ; /*          x                      */
  char *deb     , *debX     ; /*          x                      */
  char *desc    , *descX    ; /*          x                      */
  char *ram     , *ramX     ; /*                x     x     x    */
  char *title_uc, *title_ucX; /*                x                */
  char *count   , *countX   ; /*                x                */
  char *indent  , *indentX  ; /*                      x     x    */
  char *title   , *titleX   ; /*                      x     x    */
  char *arrow   , *arrowX   ; /*                            ?    */
  char *xrefs   , *xrefsX   ; /*                            ?    */
  char *xref[NMAX_XREF+1]   ; /*                            x    */
  char  ram_s[N_DIG+1]      ; /*          x                      */
};

/* The following enum labels the library-data-file parsing stages.  The
 * state machine defined later in the file you are now reading permits
 * only
 *
 *   * transitions between states labeled on the same line and
 *   * transitions exactly one line downward.
 *
 * For example, RUBRIC_SP2 can lead directly to RUBRIC_SP0 (same line)
 * or TITLE_RULE1 (one line downward), but never directly to XREF_TITLE
 * (two lines downward) or TOC_O (upward).
 */
enum doc_part {
  ILLEGAL,
  NONE1,
  PREFACE, TOC_SP0, TOC_RULE1, TOC_TITLE, TOC_RULE2,
  TOC_SP3, TOC_TITLE_X,
  TOC_O,
  TOC_X, RUBRIC_SP0, RUBRIC_RULE1, RUBRIC_SP1, RUBRIC_TITLE, RUBRIC_SP2,
  TITLE_RULE1, TITLE_O, TITLE_RULE2, DEB_O, DEB_X,
  XREF_TITLE, XREF_TITLE_RULE2,
  XREF_TITLE_SP2, XREF_TITLE_X,
  XREF_O, DOC_ENDMATTER,
  NONE2
};

extern struct datum  datum   ;
extern enum doc_part doc_part;
extern char          ram_s[] ;

struct datum *init_datum ( struct datum *d );
struct datum *get_datum  ( struct datum *d );
void          rewind_data( void            );

#endif

