# Debreaper
# copyright (c) 2007 Josselin Mouette
# Licensed under the GPL (v2 only)

import os,sys,tempfile
from gettext import gettext as _

def isdevnull (fd):
  a = os.fstat (fd)
  b = os.stat ("/dev/null")
  return a.st_dev == b.st_dev and a.st_ino == b.st_ino

class ReaperUI:
  def __init__ (self, name, pid, subtitle):
    sys.stderr.write(_("Application %(name)s (pid %(pid)d) crashed")%{"name":name,"pid":pid})
    sys.stderr.write("\n")
    self.name = name
    self.pid = pid
  def info_text (self, text):
    pass
  def summary_dialog (self, intro, fulltrace):
    (fd, fname) = tempfile.mkstemp ('.RIP', self.name+"."+`self.pid`+".", "/var/tmp")
    tmp = os.fdopen (fd, "w")
    tmp.write (fulltrace)
    tmp.close ()
    if isdevnull (2):
      # Nothing at all to write to? Don't worry, there's syslog
      import syslog
      if os.getuid() < 1000:
        facility = syslog.LOG_DAEMON
      else:
        facility = syslog.LOG_USER
      syslog.syslog (facility | syslog.LOG_NOTICE,
		     "%s (pid %d) crashed, information saved to %s"%(self.name,self.pid,fname))
    else:
      sys.stderr.write (intro+"\n")
      sys.stderr.write (_("Information saved to %s\n"%fname))
  def finalize (self):
    pass
