#!/usr/bin/env python
#
# Written by Bram Cohen
# multitracker extensions by John Hoffman
# Modified by Cameron Dale
# see LICENSE.txt for license information
#
# $Id: btmakemetafile.py 266 2007-08-18 02:06:35Z camrdale-guest $

"""Creates a metainfo file from a Packages file.

Converts a Packages file into a metainfo file containing all the information
needed to download all the packages in the Packages file.

"""

from DebTorrent import PSYCO
if PSYCO.psyco:
    try:
        import psyco
        assert psyco.__version__ >= 0x010100f0
        psyco.full()
    except:
        pass

from sys import argv, version, exit, version_info
from os.path import split
assert version_info >= (2,3), 'Requires Python 2.3 or better'
from DebTorrent.BT1.makemetafile import make_meta_file, defaults, print_announcelist_details
from DebTorrent.parseargs import parseargs, formatDefinitions

def prog(amount):
    """Display the current status of the file scan.
    
    @type amount: C{int}
    @param amount: the number of packages that have been found so far in the
        file
    
    """
    
    print '%d packages found\r' % amount,

if len(argv) < 3:
    a,b = split(argv[0])
    print 'Usage: ' + b + ' <trackerurl> <Packages file> [Packages file...] [params...]'
    print
    print formatDefinitions(defaults, 80)
    print_announcelist_details()
    print ('')
    exit(2)

try:
    config, args = parseargs(argv[1:], defaults, 2, None)
    for file in args[1:]:
        make_meta_file(file, args[0], config, progress = prog)
        print ''
except ValueError, e:
    print 'error: ' + str(e)
    print 'run with no args for parameter explanations'
