#ifndef __dictionary_h__
#define __dictionary_h__


/** Key-ID pair. */
typedef struct Entry {
	/** Key. */
	const char* key;

	/** Value. */
	int id;
} Entry;


/** Dictionary. */
typedef struct {
	/** Number of entries allocated. */
	int max;

	/** Number of entries. */
	int count;

	/** Dictionary sorted by keys. */
	struct Entry* entries;

	/** Dictionary sorted by values. */
	const char** keys;
} Dictionary;


void print_dictionary( const Dictionary* dictionary);
void clear_dictionary( Dictionary* dictionary);
void destroy_dictionary( Dictionary* dictionary);
int find( const Dictionary* dictionary, const char* key);
int insert( Dictionary* dictionary, const char* key);
const char* get_key( const Dictionary* dictionary, int id);


#endif
