#ifndef __stack_h__
#define __stack_h__


/** First-in first-out stack of integers. */
typedef struct {
	/** Maximum number of elements on the stack. */
	int max;
	/** Number of elements on the stack. */
	int count;
	/** Elements on the stack. */
	int* table;
} Stack;


/** Returns the top element of the stack. */
#define top(s) ((s)->table[(s)->count-1])

/** Removes the specified number of elements from the stack. */
#define pop(s,n) ((s)->count-=(n))

/** Pushes the specified element onto the top of the stack. */
#define push(s,e) (*allot_element(s) = (e))


void clear_stack( Stack* stack);
void destroy_stack( Stack* stack);
int* allot_element( Stack* stack);


#endif
