/*
 * the Decibel Realtime Communication Framework
 * Copyright (C) 2006 by basyskom GmbH
 *  @author Tobias Hunger <info@basyskom.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "channelhandler.h"
#include "channelhandleradaptor.h"

#include <QtTapioca/Connection>
#include <QtTapioca/Channel>
#include <QtTapioca/Handle>

#include <QtDBus/QDBusObjectPath>
#include <QtCore/QPointer>

namespace Decibel
{

/**
 * @brief Private data class for the ChannelHandler.
 * @author Tobias Hunger <info@basyskom.de>
 */
class ChannelHandlerPrivate
{
private:
    ChannelHandlerPrivate()
    { }

    ~ChannelHandlerPrivate()
    { }

    QPointer<ChannelHandlerAdaptor> adaptor;

    friend class ChannelHandler;
};

} // namespace

// ****************************************************************************

Decibel::ChannelHandler::ChannelHandler(QObject * parent) :
    QObject(parent),
    d(new Decibel::ChannelHandlerPrivate())
{
    Q_ASSERT(0 != d);
    d->adaptor = new ChannelHandlerAdaptor(this);
    Q_ASSERT(0 != d->adaptor);
}

Decibel::ChannelHandler::~ChannelHandler()
{
    delete d;
}

bool Decibel::ChannelHandler::handleChannel(const Decibel::ChannelInfo & channel_info)
{
    QtTapioca::Connection * connection(new QtTapioca::Connection(channel_info.connection_service,
                                                                 channel_info.connection_path.path(),
                                                                 this));
    if (connection == 0) { return false; }

    QList<QtTapioca::Channel *> channels = connection->openChannels();
    QtTapioca::Channel * channel;
    foreach(channel, channels)
    {
        if (channel->serviceName() == channel_info.channel_service &&
            channel->objectPath() == channel_info.channel_path.path() &&
            channel->target()->handle()->type() == channel_info.target_handle_type &&
            channel->target()->handle()->id() == channel_info.target_handle)
        { return handleChannel(connection, channel); }
    }
    return false;
}
