/*
 * the Decibel Realtime Communication Framework
 * Copyright (C) 2006 by basyskom GmbH
 *  @author Tobias Hunger <info@basyskom.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef _DECIBEL_DAEMON_POLICYENGINE_H_
#define _DECIBEL_DAEMON_POLICYENGINE_H_

#include <QtCore/QObject>

namespace QtTapioca
{
    class Connection;
    class Channel;
} // namespace QtTapioca

class ComponentManager;
class PolicyEnginePrivate;

/**
 * @brief This class implements the policy logic used to decide
 * which ChannelHandler to start in response to an incoming channel.
 *
 * This class implements the policy logic used to decide
 * which ChannelHandler to start in response to an incoming channel.
 * This decision is based on data provided by the ComponentManager.
 *
 * This class is not accessible via D-Bus.
 *
 * @author Tobias Hunger <info@basyskom.de>
 */
class PolicyEngine : public QObject
{
    Q_OBJECT
    Q_DECLARE_PRIVATE(PolicyEngine)

public:
    /**
     * @brief Constructor
     * @param component_mgr Pointer to the ComponentManager.
     * @param parent The parent object.
     */
    explicit PolicyEngine(const ComponentManager * component_mgr,
                          QObject * parent = 0);
    /** Destructor */
    ~PolicyEngine();

public slots:
    /**
     * @brief React to incoming channels.
     * @param connection A pointer to the Connection the incoming channel
     * is part of.
     * @param channel A pointer to the incoming Channel.
     * @param incoming True is this channel is a incoming channel and false
     *                 otherwise.
     *
     * This method triggers decides what to do with a incoming
     * information channel and triggers external ChannelHandlers
     * via D-Bus activation if required.
     */
    void onChannelOpened(QtTapioca::Connection * connection,
                         QtTapioca::Channel * channel,
                         bool incoming) const;
private:
    PolicyEnginePrivate * const d;
};

#endif
