/* DuplicityInfo.c generated by valac, the Vala compiler
 * generated from DuplicityInfo.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    Déjà Dup
    © 2008,2009 Michael Terry <mike@mterry.name>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>


#define DEJA_DUP_TYPE_DUPLICITY_INFO (deja_dup_duplicity_info_get_type ())
#define DEJA_DUP_DUPLICITY_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_DUPLICITY_INFO, DejaDupDuplicityInfo))
#define DEJA_DUP_DUPLICITY_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_DUPLICITY_INFO, DejaDupDuplicityInfoClass))
#define DEJA_DUP_IS_DUPLICITY_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_DUPLICITY_INFO))
#define DEJA_DUP_IS_DUPLICITY_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_DUPLICITY_INFO))
#define DEJA_DUP_DUPLICITY_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_DUPLICITY_INFO, DejaDupDuplicityInfoClass))

typedef struct _DejaDupDuplicityInfo DejaDupDuplicityInfo;
typedef struct _DejaDupDuplicityInfoClass DejaDupDuplicityInfoClass;
typedef struct _DejaDupDuplicityInfoPrivate DejaDupDuplicityInfoPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _DejaDupDuplicityInfo {
	GObject parent_instance;
	DejaDupDuplicityInfoPrivate * priv;
};

struct _DejaDupDuplicityInfoClass {
	GObjectClass parent_class;
};

struct _DejaDupDuplicityInfoPrivate {
	gboolean _has_broken_cleanup;
	gboolean _has_backup_progress;
	gboolean _has_restore_progress;
	gboolean _has_collection_status;
	gboolean _new_time_format;
	gboolean _can_read_short_filenames;
	char* version_string;
	gint major;
	gint minor;
	gint micro;
};


static DejaDupDuplicityInfo* deja_dup_duplicity_info_info;
static DejaDupDuplicityInfo* deja_dup_duplicity_info_info = NULL;
static gpointer deja_dup_duplicity_info_parent_class = NULL;

GType deja_dup_duplicity_info_get_type (void);
#define DEJA_DUP_DUPLICITY_INFO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DEJA_DUP_TYPE_DUPLICITY_INFO, DejaDupDuplicityInfoPrivate))
enum  {
	DEJA_DUP_DUPLICITY_INFO_DUMMY_PROPERTY,
	DEJA_DUP_DUPLICITY_INFO_HAS_BROKEN_CLEANUP,
	DEJA_DUP_DUPLICITY_INFO_HAS_BACKUP_PROGRESS,
	DEJA_DUP_DUPLICITY_INFO_HAS_RESTORE_PROGRESS,
	DEJA_DUP_DUPLICITY_INFO_HAS_COLLECTION_STATUS,
	DEJA_DUP_DUPLICITY_INFO_NEW_TIME_FORMAT,
	DEJA_DUP_DUPLICITY_INFO_CAN_READ_SHORT_FILENAMES
};
#define DEJA_DUP_DUPLICITY_INFO_REQUIRED_MAJOR 0
#define DEJA_DUP_DUPLICITY_INFO_REQUIRED_MINOR 5
#define DEJA_DUP_DUPLICITY_INFO_REQUIRED_MICRO 3
DejaDupDuplicityInfo* deja_dup_duplicity_info_new (void);
DejaDupDuplicityInfo* deja_dup_duplicity_info_construct (GType object_type);
DejaDupDuplicityInfo* deja_dup_duplicity_info_get_default (void);
static void deja_dup_duplicity_info_show_missing_duplicity_error (DejaDupDuplicityInfo* self, GtkWindow* parent, const char* msg_in);
static gboolean deja_dup_duplicity_info_meets_requirements (DejaDupDuplicityInfo* self);
static void deja_dup_duplicity_info_show_bad_version_error (DejaDupDuplicityInfo* self, GtkWindow* parent);
static gboolean deja_dup_duplicity_info_meets_version (DejaDupDuplicityInfo* self, gint vmaj, gint vmin, gint vmic);
static void deja_dup_duplicity_info_set_has_backup_progress (DejaDupDuplicityInfo* self, gboolean value);
static void deja_dup_duplicity_info_set_has_collection_status (DejaDupDuplicityInfo* self, gboolean value);
static gboolean deja_dup_duplicity_info_equals_version (DejaDupDuplicityInfo* self, gint vmaj, gint vmin, gint vmic);
static void deja_dup_duplicity_info_set_has_broken_cleanup (DejaDupDuplicityInfo* self, gboolean value);
static void deja_dup_duplicity_info_set_has_restore_progress (DejaDupDuplicityInfo* self, gboolean value);
static void deja_dup_duplicity_info_set_new_time_format (DejaDupDuplicityInfo* self, gboolean value);
static void deja_dup_duplicity_info_set_can_read_short_filenames (DejaDupDuplicityInfo* self, gboolean value);
gboolean deja_dup_duplicity_info_check_duplicity_version (DejaDupDuplicityInfo* self, GtkWindow* parent);
gboolean deja_dup_duplicity_info_get_has_broken_cleanup (DejaDupDuplicityInfo* self);
gboolean deja_dup_duplicity_info_get_has_backup_progress (DejaDupDuplicityInfo* self);
gboolean deja_dup_duplicity_info_get_has_restore_progress (DejaDupDuplicityInfo* self);
gboolean deja_dup_duplicity_info_get_has_collection_status (DejaDupDuplicityInfo* self);
gboolean deja_dup_duplicity_info_get_new_time_format (DejaDupDuplicityInfo* self);
gboolean deja_dup_duplicity_info_get_can_read_short_filenames (DejaDupDuplicityInfo* self);
static void deja_dup_duplicity_info_finalize (GObject* obj);
static void deja_dup_duplicity_info_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void deja_dup_duplicity_info_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


DejaDupDuplicityInfo* deja_dup_duplicity_info_get_default (void) {
	DejaDupDuplicityInfo* result;
	if (deja_dup_duplicity_info_info == NULL) {
		DejaDupDuplicityInfo* _tmp0_;
		deja_dup_duplicity_info_info = (_tmp0_ = deja_dup_duplicity_info_new (), _g_object_unref0 (deja_dup_duplicity_info_info), _tmp0_);
	}
	result = _g_object_ref0 (deja_dup_duplicity_info_info);
	return result;
}


static char* string_strip (const char* self) {
	char* result;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = g_strdup (self);
	g_strstrip (_result_);
	result = _result_;
	return result;
}


gboolean deja_dup_duplicity_info_check_duplicity_version (DejaDupDuplicityInfo* self, GtkWindow* parent) {
	gboolean result;
	GError * _inner_error_;
	char* output;
	char** _tmp4_;
	gint tokens_size;
	gint tokens_length1;
	char** _tmp3_;
	char** tokens;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	char* _tmp7_;
	char** _tmp9_;
	gint ver_tokens_size;
	gint ver_tokens_length1;
	char** _tmp8_;
	char** ver_tokens;
	gboolean _tmp10_ = FALSE;
	gboolean good_enough;
	gboolean _tmp11_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_inner_error_ = NULL;
	output = NULL;
	{
		char* _tmp2_;
		gboolean _tmp1_;
		char* _tmp0_ = NULL;
		_tmp1_ = g_spawn_command_line_sync ("duplicity --version", &_tmp0_, NULL, NULL, &_inner_error_);
		output = (_tmp2_ = _tmp0_, _g_free0 (output), _tmp2_);
		_tmp1_;
		if (_inner_error_ != NULL) {
			goto __catch38_g_error;
			goto __finally38;
		}
	}
	goto __finally38;
	__catch38_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			deja_dup_duplicity_info_show_missing_duplicity_error (self, parent, e->message);
			result = FALSE;
			_g_error_free0 (e);
			_g_free0 (output);
			return result;
		}
	}
	__finally38:
	if (_inner_error_ != NULL) {
		_g_free0 (output);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	tokens = (_tmp4_ = _tmp3_ = g_strsplit (output, " ", 2), tokens_length1 = _vala_array_length (_tmp3_), tokens_size = tokens_length1, _tmp4_);
	if (tokens == NULL) {
		_tmp6_ = TRUE;
	} else {
		_tmp6_ = tokens[0] == NULL;
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = tokens[1] == NULL;
	}
	if (_tmp5_) {
		deja_dup_duplicity_info_show_missing_duplicity_error (self, parent, NULL);
		result = FALSE;
		_g_free0 (output);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	self->priv->version_string = (_tmp7_ = string_strip (tokens[1]), _g_free0 (self->priv->version_string), _tmp7_);
	ver_tokens = (_tmp9_ = _tmp8_ = g_strsplit (self->priv->version_string, ".", 0), ver_tokens_length1 = _vala_array_length (_tmp8_), ver_tokens_size = ver_tokens_length1, _tmp9_);
	if (ver_tokens == NULL) {
		_tmp10_ = TRUE;
	} else {
		_tmp10_ = ver_tokens[0] == NULL;
	}
	if (_tmp10_) {
		deja_dup_duplicity_info_show_missing_duplicity_error (self, parent, NULL);
		result = FALSE;
		_g_free0 (output);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		ver_tokens = (_vala_array_free (ver_tokens, ver_tokens_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	self->priv->major = atoi (ver_tokens[0]);
	if (ver_tokens[1] != NULL) {
		self->priv->minor = atoi (ver_tokens[1]);
		if (ver_tokens[2] != NULL) {
			self->priv->micro = atoi (ver_tokens[2]);
		}
	}
	good_enough = deja_dup_duplicity_info_meets_requirements (self);
	if (!good_enough) {
		deja_dup_duplicity_info_show_bad_version_error (self, parent);
		result = FALSE;
		_g_free0 (output);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		ver_tokens = (_vala_array_free (ver_tokens, ver_tokens_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	if (deja_dup_duplicity_info_meets_version (self, 0, 5, 4)) {
		deja_dup_duplicity_info_set_has_backup_progress (self, TRUE);
		deja_dup_duplicity_info_set_has_collection_status (self, TRUE);
	}
	if (deja_dup_duplicity_info_equals_version (self, 0, 5, 4)) {
		_tmp11_ = TRUE;
	} else {
		_tmp11_ = deja_dup_duplicity_info_equals_version (self, 0, 5, 5);
	}
	if (_tmp11_) {
		deja_dup_duplicity_info_set_has_broken_cleanup (self, TRUE);
	}
	if (deja_dup_duplicity_info_meets_version (self, 0, 5, 6)) {
		deja_dup_duplicity_info_set_has_restore_progress (self, TRUE);
	}
	if (deja_dup_duplicity_info_meets_version (self, 0, 5, 10)) {
		deja_dup_duplicity_info_set_new_time_format (self, TRUE);
	}
	if (deja_dup_duplicity_info_meets_version (self, 0, 5, 16)) {
		deja_dup_duplicity_info_set_can_read_short_filenames (self, TRUE);
	}
	result = TRUE;
	_g_free0 (output);
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	ver_tokens = (_vala_array_free (ver_tokens, ver_tokens_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gboolean deja_dup_duplicity_info_meets_version (DejaDupDuplicityInfo* self, gint vmaj, gint vmin, gint vmic) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->major > vmaj) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		if (self->priv->major == vmaj) {
			_tmp2_ = self->priv->minor > vmin;
		} else {
			_tmp2_ = FALSE;
		}
		_tmp1_ = _tmp2_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (self->priv->major == vmaj) {
			_tmp4_ = self->priv->minor == vmin;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			_tmp3_ = self->priv->micro >= vmic;
		} else {
			_tmp3_ = FALSE;
		}
		_tmp0_ = _tmp3_;
	}
	result = _tmp0_;
	return result;
}


static gboolean deja_dup_duplicity_info_equals_version (DejaDupDuplicityInfo* self, gint vmaj, gint vmin, gint vmic) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->major == vmaj) {
		_tmp1_ = self->priv->minor == vmin;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = self->priv->micro == vmic;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean deja_dup_duplicity_info_meets_requirements (DejaDupDuplicityInfo* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = deja_dup_duplicity_info_meets_version (self, DEJA_DUP_DUPLICITY_INFO_REQUIRED_MAJOR, DEJA_DUP_DUPLICITY_INFO_REQUIRED_MINOR, DEJA_DUP_DUPLICITY_INFO_REQUIRED_MICRO);
	return result;
}


static char* string_chomp (const char* self) {
	char* result;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = g_strdup (self);
	g_strchomp (_result_);
	result = _result_;
	return result;
}


static void deja_dup_duplicity_info_show_missing_duplicity_error (DejaDupDuplicityInfo* self, GtkWindow* parent, const char* msg_in) {
	GtkMessageDialog* dlg;
	char* msg;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	dlg = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (parent, GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _ ("Could not run duplicity")));
	msg = g_strdup (msg_in);
	if (msg != NULL) {
		char* _tmp1_;
		char* _tmp0_;
		msg = (_tmp1_ = g_strconcat (_tmp0_ = string_chomp (msg), "\n\n", NULL), _g_free0 (msg), _tmp1_);
		_g_free0 (_tmp0_);
	} else {
		if (self->priv->version_string == NULL) {
			char* _tmp2_;
			msg = (_tmp2_ = g_strdup (_ ("Could not understand duplicity version.\n\n")), _g_free0 (msg), _tmp2_);
		} else {
			char* _tmp3_;
			msg = (_tmp3_ = g_strdup_printf (_ ("Could not understand duplicity version '%s'.\n\n"), self->priv->version_string), _g_free0 (msg), _tmp3_);
		}
	}
	gtk_message_dialog_format_secondary_text (dlg, "%s%s", msg, _ ("Without duplicity, Déjà Dup cannot function.  It will close now."), NULL);
	gtk_dialog_run ((GtkDialog*) dlg);
	gtk_object_destroy ((GtkObject*) dlg);
	gtk_main_quit ();
	_g_object_unref0 (dlg);
	_g_free0 (msg);
}


static void deja_dup_duplicity_info_show_bad_version_error (DejaDupDuplicityInfo* self, GtkWindow* parent) {
	GtkMessageDialog* dlg;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	dlg = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (parent, GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _ ("Duplicity's version is too old")));
	gtk_message_dialog_format_secondary_text (dlg, _ ("Déjà Dup requires at least version %d.%d.%.2d of duplicity, but only found version %d.%d.%.2d"), DEJA_DUP_DUPLICITY_INFO_REQUIRED_MAJOR, DEJA_DUP_DUPLICITY_INFO_REQUIRED_MINOR, DEJA_DUP_DUPLICITY_INFO_REQUIRED_MICRO, self->priv->major, self->priv->minor, self->priv->micro, NULL);
	gtk_dialog_run ((GtkDialog*) dlg);
	gtk_object_destroy ((GtkObject*) dlg);
	gtk_main_quit ();
	_g_object_unref0 (dlg);
}


DejaDupDuplicityInfo* deja_dup_duplicity_info_construct (GType object_type) {
	DejaDupDuplicityInfo * self;
	self = (DejaDupDuplicityInfo*) g_object_new (object_type, NULL);
	return self;
}


DejaDupDuplicityInfo* deja_dup_duplicity_info_new (void) {
	return deja_dup_duplicity_info_construct (DEJA_DUP_TYPE_DUPLICITY_INFO);
}


gboolean deja_dup_duplicity_info_get_has_broken_cleanup (DejaDupDuplicityInfo* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_broken_cleanup;
	return result;
}


static void deja_dup_duplicity_info_set_has_broken_cleanup (DejaDupDuplicityInfo* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_has_broken_cleanup = value;
	g_object_notify ((GObject *) self, "has-broken-cleanup");
}


gboolean deja_dup_duplicity_info_get_has_backup_progress (DejaDupDuplicityInfo* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_backup_progress;
	return result;
}


static void deja_dup_duplicity_info_set_has_backup_progress (DejaDupDuplicityInfo* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_has_backup_progress = value;
	g_object_notify ((GObject *) self, "has-backup-progress");
}


gboolean deja_dup_duplicity_info_get_has_restore_progress (DejaDupDuplicityInfo* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_restore_progress;
	return result;
}


static void deja_dup_duplicity_info_set_has_restore_progress (DejaDupDuplicityInfo* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_has_restore_progress = value;
	g_object_notify ((GObject *) self, "has-restore-progress");
}


gboolean deja_dup_duplicity_info_get_has_collection_status (DejaDupDuplicityInfo* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_collection_status;
	return result;
}


static void deja_dup_duplicity_info_set_has_collection_status (DejaDupDuplicityInfo* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_has_collection_status = value;
	g_object_notify ((GObject *) self, "has-collection-status");
}


gboolean deja_dup_duplicity_info_get_new_time_format (DejaDupDuplicityInfo* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_new_time_format;
	return result;
}


static void deja_dup_duplicity_info_set_new_time_format (DejaDupDuplicityInfo* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_new_time_format = value;
	g_object_notify ((GObject *) self, "new-time-format");
}


gboolean deja_dup_duplicity_info_get_can_read_short_filenames (DejaDupDuplicityInfo* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_can_read_short_filenames;
	return result;
}


static void deja_dup_duplicity_info_set_can_read_short_filenames (DejaDupDuplicityInfo* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_can_read_short_filenames = value;
	g_object_notify ((GObject *) self, "can-read-short-filenames");
}


static void deja_dup_duplicity_info_class_init (DejaDupDuplicityInfoClass * klass) {
	deja_dup_duplicity_info_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DejaDupDuplicityInfoPrivate));
	G_OBJECT_CLASS (klass)->get_property = deja_dup_duplicity_info_get_property;
	G_OBJECT_CLASS (klass)->set_property = deja_dup_duplicity_info_set_property;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_duplicity_info_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_DUPLICITY_INFO_HAS_BROKEN_CLEANUP, g_param_spec_boolean ("has-broken-cleanup", "has-broken-cleanup", "has-broken-cleanup", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_DUPLICITY_INFO_HAS_BACKUP_PROGRESS, g_param_spec_boolean ("has-backup-progress", "has-backup-progress", "has-backup-progress", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_DUPLICITY_INFO_HAS_RESTORE_PROGRESS, g_param_spec_boolean ("has-restore-progress", "has-restore-progress", "has-restore-progress", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_DUPLICITY_INFO_HAS_COLLECTION_STATUS, g_param_spec_boolean ("has-collection-status", "has-collection-status", "has-collection-status", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_DUPLICITY_INFO_NEW_TIME_FORMAT, g_param_spec_boolean ("new-time-format", "new-time-format", "new-time-format", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_DUPLICITY_INFO_CAN_READ_SHORT_FILENAMES, g_param_spec_boolean ("can-read-short-filenames", "can-read-short-filenames", "can-read-short-filenames", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void deja_dup_duplicity_info_instance_init (DejaDupDuplicityInfo * self) {
	self->priv = DEJA_DUP_DUPLICITY_INFO_GET_PRIVATE (self);
	self->priv->_has_broken_cleanup = FALSE;
	self->priv->_has_backup_progress = FALSE;
	self->priv->_has_restore_progress = FALSE;
	self->priv->_has_collection_status = FALSE;
	self->priv->_new_time_format = FALSE;
	self->priv->_can_read_short_filenames = FALSE;
	self->priv->version_string = NULL;
	self->priv->major = 0;
	self->priv->minor = 0;
	self->priv->micro = 0;
}


static void deja_dup_duplicity_info_finalize (GObject* obj) {
	DejaDupDuplicityInfo * self;
	self = DEJA_DUP_DUPLICITY_INFO (obj);
	_g_free0 (self->priv->version_string);
	G_OBJECT_CLASS (deja_dup_duplicity_info_parent_class)->finalize (obj);
}


GType deja_dup_duplicity_info_get_type (void) {
	static GType deja_dup_duplicity_info_type_id = 0;
	if (deja_dup_duplicity_info_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupDuplicityInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_duplicity_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupDuplicityInfo), 0, (GInstanceInitFunc) deja_dup_duplicity_info_instance_init, NULL };
		deja_dup_duplicity_info_type_id = g_type_register_static (G_TYPE_OBJECT, "DejaDupDuplicityInfo", &g_define_type_info, 0);
	}
	return deja_dup_duplicity_info_type_id;
}


static void deja_dup_duplicity_info_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DejaDupDuplicityInfo * self;
	self = DEJA_DUP_DUPLICITY_INFO (object);
	switch (property_id) {
		case DEJA_DUP_DUPLICITY_INFO_HAS_BROKEN_CLEANUP:
		g_value_set_boolean (value, deja_dup_duplicity_info_get_has_broken_cleanup (self));
		break;
		case DEJA_DUP_DUPLICITY_INFO_HAS_BACKUP_PROGRESS:
		g_value_set_boolean (value, deja_dup_duplicity_info_get_has_backup_progress (self));
		break;
		case DEJA_DUP_DUPLICITY_INFO_HAS_RESTORE_PROGRESS:
		g_value_set_boolean (value, deja_dup_duplicity_info_get_has_restore_progress (self));
		break;
		case DEJA_DUP_DUPLICITY_INFO_HAS_COLLECTION_STATUS:
		g_value_set_boolean (value, deja_dup_duplicity_info_get_has_collection_status (self));
		break;
		case DEJA_DUP_DUPLICITY_INFO_NEW_TIME_FORMAT:
		g_value_set_boolean (value, deja_dup_duplicity_info_get_new_time_format (self));
		break;
		case DEJA_DUP_DUPLICITY_INFO_CAN_READ_SHORT_FILENAMES:
		g_value_set_boolean (value, deja_dup_duplicity_info_get_can_read_short_filenames (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void deja_dup_duplicity_info_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DejaDupDuplicityInfo * self;
	self = DEJA_DUP_DUPLICITY_INFO (object);
	switch (property_id) {
		case DEJA_DUP_DUPLICITY_INFO_HAS_BROKEN_CLEANUP:
		deja_dup_duplicity_info_set_has_broken_cleanup (self, g_value_get_boolean (value));
		break;
		case DEJA_DUP_DUPLICITY_INFO_HAS_BACKUP_PROGRESS:
		deja_dup_duplicity_info_set_has_backup_progress (self, g_value_get_boolean (value));
		break;
		case DEJA_DUP_DUPLICITY_INFO_HAS_RESTORE_PROGRESS:
		deja_dup_duplicity_info_set_has_restore_progress (self, g_value_get_boolean (value));
		break;
		case DEJA_DUP_DUPLICITY_INFO_HAS_COLLECTION_STATUS:
		deja_dup_duplicity_info_set_has_collection_status (self, g_value_get_boolean (value));
		break;
		case DEJA_DUP_DUPLICITY_INFO_NEW_TIME_FORMAT:
		deja_dup_duplicity_info_set_new_time_format (self, g_value_get_boolean (value));
		break;
		case DEJA_DUP_DUPLICITY_INFO_CAN_READ_SHORT_FILENAMES:
		deja_dup_duplicity_info_set_can_read_short_filenames (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}




