/* OperationBackup.c generated by valac 0.10.0, the Vala compiler
 * generated from OperationBackup.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    © 2008–2010 Michael Terry <mike@mterry.name>
    © 2010 Michael Vogt <michael.vogt@ubuntu.com>

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gconf/gconf-client.h>
#include <gconf/gconf.h>


#define DEJA_DUP_TYPE_OPERATION (deja_dup_operation_get_type ())
#define DEJA_DUP_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_OPERATION, DejaDupOperation))
#define DEJA_DUP_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_OPERATION, DejaDupOperationClass))
#define DEJA_DUP_IS_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_OPERATION))
#define DEJA_DUP_IS_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_OPERATION))
#define DEJA_DUP_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_OPERATION, DejaDupOperationClass))

typedef struct _DejaDupOperation DejaDupOperation;
typedef struct _DejaDupOperationClass DejaDupOperationClass;
typedef struct _DejaDupOperationPrivate DejaDupOperationPrivate;

#define DEJA_DUP_TYPE_DUPLICITY (deja_dup_duplicity_get_type ())
#define DEJA_DUP_DUPLICITY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_DUPLICITY, DejaDupDuplicity))
#define DEJA_DUP_DUPLICITY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_DUPLICITY, DejaDupDuplicityClass))
#define DEJA_DUP_IS_DUPLICITY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_DUPLICITY))
#define DEJA_DUP_IS_DUPLICITY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_DUPLICITY))
#define DEJA_DUP_DUPLICITY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_DUPLICITY, DejaDupDuplicityClass))

typedef struct _DejaDupDuplicity DejaDupDuplicity;
typedef struct _DejaDupDuplicityClass DejaDupDuplicityClass;

#define DEJA_DUP_TYPE_OPERATION_BACKUP (deja_dup_operation_backup_get_type ())
#define DEJA_DUP_OPERATION_BACKUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_OPERATION_BACKUP, DejaDupOperationBackup))
#define DEJA_DUP_OPERATION_BACKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_OPERATION_BACKUP, DejaDupOperationBackupClass))
#define DEJA_DUP_IS_OPERATION_BACKUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_OPERATION_BACKUP))
#define DEJA_DUP_IS_OPERATION_BACKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_OPERATION_BACKUP))
#define DEJA_DUP_OPERATION_BACKUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_OPERATION_BACKUP, DejaDupOperationBackupClass))

typedef struct _DejaDupOperationBackup DejaDupOperationBackup;
typedef struct _DejaDupOperationBackupClass DejaDupOperationBackupClass;
typedef struct _DejaDupOperationBackupPrivate DejaDupOperationBackupPrivate;

#define DEJA_DUP_OPERATION_TYPE_MODE (deja_dup_operation_mode_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _DejaDupOperationBackupOperationFinishedData DejaDupOperationBackupOperationFinishedData;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_slist_free0(var) ((var == NULL) ? NULL : (var = (g_slist_free (var), NULL)))
typedef struct _DejaDupDuplicityPrivate DejaDupDuplicityPrivate;

#define DEJA_DUP_TYPE_BACKEND (deja_dup_backend_get_type ())
#define DEJA_DUP_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackend))
#define DEJA_DUP_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))
#define DEJA_DUP_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))

typedef struct _DejaDupBackend DejaDupBackend;
typedef struct _DejaDupBackendClass DejaDupBackendClass;
#define __g_list_free_g_free0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_free (var), NULL)))

struct _DejaDupOperation {
	GObject parent_instance;
	DejaDupOperationPrivate * priv;
	DejaDupDuplicity* dup;
	char* passphrase;
};

struct _DejaDupOperationClass {
	GObjectClass parent_class;
	void (*start) (DejaDupOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*start_finish) (DejaDupOperation* self, GAsyncResult* _res_, GError** error);
	void (*connect_to_dup) (DejaDupOperation* self);
	void (*operation_finished) (DejaDupOperation* self, DejaDupDuplicity* dup, gboolean success, gboolean cancelled, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*operation_finished_finish) (DejaDupOperation* self, GAsyncResult* _res_);
	GList* (*make_argv) (DejaDupOperation* self, GError** error);
};

struct _DejaDupOperationBackup {
	DejaDupOperation parent_instance;
	DejaDupOperationBackupPrivate * priv;
};

struct _DejaDupOperationBackupClass {
	DejaDupOperationClass parent_class;
};

typedef enum  {
	DEJA_DUP_OPERATION_MODE_INVALID,
	DEJA_DUP_OPERATION_MODE_BACKUP,
	DEJA_DUP_OPERATION_MODE_RESTORE,
	DEJA_DUP_OPERATION_MODE_STATUS,
	DEJA_DUP_OPERATION_MODE_LIST
} DejaDupOperationMode;

struct _DejaDupOperationBackupOperationFinishedData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupOperationBackup* self;
	DejaDupDuplicity* dup;
	gboolean success;
	gboolean cancelled;
	GError * e;
	GError * _inner_error_;
};

struct _DejaDupDuplicity {
	GObject parent_instance;
	DejaDupDuplicityPrivate * priv;
	GList* includes;
	GList* excludes;
};

struct _DejaDupDuplicityClass {
	GObjectClass parent_class;
	void (*start) (DejaDupDuplicity* self, DejaDupBackend* backend, gboolean encrypted, GList* argv, GList* envp);
	void (*process_error) (DejaDupDuplicity* self, char** firstline, int firstline_length1, GList* data, const char* text_in);
	void (*process_info) (DejaDupDuplicity* self, char** firstline, int firstline_length1, GList* data, const char* text);
	void (*process_warning) (DejaDupDuplicity* self, char** firstline, int firstline_length1, GList* data, const char* text);
};


static gpointer deja_dup_operation_backup_parent_class = NULL;

GType deja_dup_operation_get_type (void) G_GNUC_CONST;
GType deja_dup_duplicity_get_type (void) G_GNUC_CONST;
GType deja_dup_operation_backup_get_type (void) G_GNUC_CONST;
enum  {
	DEJA_DUP_OPERATION_BACKUP_DUMMY_PROPERTY
};
DejaDupOperationBackup* deja_dup_operation_backup_new (guint xid);
DejaDupOperationBackup* deja_dup_operation_backup_construct (GType object_type, guint xid);
GType deja_dup_operation_mode_get_type (void) G_GNUC_CONST;
static void deja_dup_operation_backup_real_operation_finished_data_free (gpointer _data);
static void deja_dup_operation_backup_real_operation_finished (DejaDupOperation* base, DejaDupDuplicity* dup, gboolean success, gboolean cancelled, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void deja_dup_operation_backup_operation_finished_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean deja_dup_operation_backup_real_operation_finished_co (DejaDupOperationBackupOperationFinishedData* data);
void deja_dup_update_last_run_timestamp (GError** error);
void deja_dup_operation_operation_finished (DejaDupOperation* self, DejaDupDuplicity* dup, gboolean success, gboolean cancelled, GAsyncReadyCallback _callback_, gpointer _user_data_);
void deja_dup_operation_operation_finished_finish (DejaDupOperation* self, GAsyncResult* _res_);
static void deja_dup_operation_backup_add_to_file_list (DejaDupOperationBackup* self, GList** list, GFile* file);
static GList* deja_dup_operation_backup_real_make_argv (DejaDupOperation* base, GError** error);
GConfClient* deja_dup_get_gconf_client (void);
#define DEJA_DUP_INCLUDE_LIST_KEY "/apps/deja-dup/include-list"
GFile** deja_dup_parse_dir_list (GSList* dirs, int* result_length1);
#define DEJA_DUP_EXCLUDE_LIST_KEY "/apps/deja-dup/exclude-list"
static GList* deja_dup_operation_backup_get_always_excluded_dirs (DejaDupOperationBackup* self);
GType deja_dup_backend_get_type (void) G_GNUC_CONST;
void deja_dup_duplicity_set_local (DejaDupDuplicity* self, GFile* value);
static void _g_list_free_g_free (GList* self);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);



DejaDupOperationBackup* deja_dup_operation_backup_construct (GType object_type, guint xid) {
	DejaDupOperationBackup * self;
	self = (DejaDupOperationBackup*) g_object_new (object_type, "xid", xid, "mode", DEJA_DUP_OPERATION_MODE_BACKUP, NULL);
	return self;
}


DejaDupOperationBackup* deja_dup_operation_backup_new (guint xid) {
	return deja_dup_operation_backup_construct (DEJA_DUP_TYPE_OPERATION_BACKUP, xid);
}


static void deja_dup_operation_backup_real_operation_finished_data_free (gpointer _data) {
	DejaDupOperationBackupOperationFinishedData* data;
	data = _data;
	_g_object_unref0 (data->dup);
	g_object_unref (data->self);
	g_slice_free (DejaDupOperationBackupOperationFinishedData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void deja_dup_operation_backup_real_operation_finished (DejaDupOperation* base, DejaDupDuplicity* dup, gboolean success, gboolean cancelled, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupOperationBackup * self;
	DejaDupOperationBackupOperationFinishedData* _data_;
	self = (DejaDupOperationBackup*) base;
	_data_ = g_slice_new0 (DejaDupOperationBackupOperationFinishedData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_operation_backup_real_operation_finished);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_operation_backup_real_operation_finished_data_free);
	_data_->self = g_object_ref (self);
	_data_->dup = _g_object_ref0 (dup);
	_data_->success = success;
	_data_->cancelled = cancelled;
	deja_dup_operation_backup_real_operation_finished_co (_data_);
}


static void deja_dup_operation_backup_real_operation_finished_finish (DejaDupOperation* base, GAsyncResult* _res_) {
	DejaDupOperationBackupOperationFinishedData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void deja_dup_operation_backup_operation_finished_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupOperationBackupOperationFinishedData* data;
	data = _user_data_;
	data->_res_ = _res_;
	deja_dup_operation_backup_real_operation_finished_co (data);
}


static gboolean deja_dup_operation_backup_real_operation_finished_co (DejaDupOperationBackupOperationFinishedData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (data->success) {
		{
			deja_dup_update_last_run_timestamp (&data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				goto __catch37_g_error;
			}
		}
		goto __finally37;
		__catch37_g_error:
		{
			data->e = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
				g_warning ("OperationBackup.vala:35: %s\n", data->e->message);
				_g_error_free0 (data->e);
			}
		}
		__finally37:
		if (data->_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	DEJA_DUP_OPERATION_CLASS (deja_dup_operation_backup_parent_class)->operation_finished (DEJA_DUP_OPERATION (data->self), data->dup, data->success, data->cancelled, NULL, NULL);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void deja_dup_operation_backup_add_to_file_list (DejaDupOperationBackup* self, GList** list, GFile* file) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	{
		GFileInfo* info;
		info = g_file_query_info (file, G_FILE_ATTRIBUTE_STANDARD_IS_SYMLINK "," G_FILE_ATTRIBUTE_STANDARD_SYMLINK_TARGET, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (g_error_matches (_inner_error_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
				goto __catch38_g_io_error_not_found;
			}
			goto __catch38_g_error;
		}
		if (g_file_info_get_is_symlink (info)) {
			char* symlink_target;
			GFile* parent_dir;
			symlink_target = g_strdup (g_file_info_get_symlink_target (info));
			parent_dir = g_file_get_parent (file);
			*list = g_list_prepend (*list, g_file_resolve_relative_path (parent_dir, symlink_target));
			_g_object_unref0 (parent_dir);
			_g_free0 (symlink_target);
		}
		_g_object_unref0 (info);
	}
	goto __finally38;
	__catch38_g_io_error_not_found:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (e);
			return;
		}
	}
	goto __finally38;
	__catch38_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("OperationBackup.vala:64: %s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally38:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	*list = g_list_prepend (*list, _g_object_ref0 (file));
}


static void _g_list_free_g_free (GList* self) {
	g_list_foreach (self, (GFunc) g_free, NULL);
	g_list_free (self);
}


static GList* deja_dup_operation_backup_real_make_argv (DejaDupOperation* base, GError** error) {
	DejaDupOperationBackup * self;
	GList* result = NULL;
	GConfClient* client;
	GSList* _tmp0_;
	gint include_list_length1;
	gint _include_list_size_;
	GFile** _tmp4_;
	GSList* _tmp1_;
	gint _tmp2_;
	GFile** _tmp3_;
	GFile** include_list;
	GSList* _tmp5_;
	gint exclude_list_length1;
	gint _exclude_list_size_;
	GFile** _tmp9_;
	GSList* _tmp6_;
	gint _tmp7_;
	GFile** _tmp8_;
	GFile** exclude_list;
	GList* rv;
	GList* always_excluded;
	GFile* _tmp11_;
	GError * _inner_error_ = NULL;
	self = (DejaDupOperationBackup*) base;
	client = deja_dup_get_gconf_client ();
	_tmp0_ = gconf_client_get_list (client, DEJA_DUP_INCLUDE_LIST_KEY, GCONF_VALUE_STRING, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (client);
		return NULL;
	}
	include_list = (_tmp4_ = (_tmp3_ = deja_dup_parse_dir_list (_tmp1_ = _tmp0_, &_tmp2_), _g_slist_free0 (_tmp1_), _tmp3_), include_list_length1 = _tmp2_, _include_list_size_ = include_list_length1, _tmp4_);
	_tmp5_ = gconf_client_get_list (client, DEJA_DUP_EXCLUDE_LIST_KEY, GCONF_VALUE_STRING, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		include_list = (_vala_array_free (include_list, include_list_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (client);
		return NULL;
	}
	exclude_list = (_tmp9_ = (_tmp8_ = deja_dup_parse_dir_list (_tmp6_ = _tmp5_, &_tmp7_), _g_slist_free0 (_tmp6_), _tmp8_), exclude_list_length1 = _tmp7_, _exclude_list_size_ = exclude_list_length1, _tmp9_);
	rv = NULL;
	always_excluded = deja_dup_operation_backup_get_always_excluded_dirs (self);
	{
		GList* dir_collection;
		GList* dir_it;
		dir_collection = always_excluded;
		for (dir_it = dir_collection; dir_it != NULL; dir_it = dir_it->next) {
			char* dir;
			dir = g_strdup ((const char*) dir_it->data);
			{
				GFile* _tmp10_;
				deja_dup_operation_backup_add_to_file_list (self, &((DejaDupOperation*) self)->dup->excludes, _tmp10_ = g_file_new_for_path (dir));
				_g_object_unref0 (_tmp10_);
				_g_free0 (dir);
			}
		}
	}
	{
		GFile** s_collection;
		int s_collection_length1;
		int s_it;
		s_collection = exclude_list;
		s_collection_length1 = exclude_list_length1;
		for (s_it = 0; s_it < exclude_list_length1; s_it = s_it + 1) {
			GFile* s;
			s = _g_object_ref0 (s_collection[s_it]);
			{
				deja_dup_operation_backup_add_to_file_list (self, &((DejaDupOperation*) self)->dup->excludes, s);
				_g_object_unref0 (s);
			}
		}
	}
	{
		GFile** s_collection;
		int s_collection_length1;
		int s_it;
		s_collection = include_list;
		s_collection_length1 = include_list_length1;
		for (s_it = 0; s_it < include_list_length1; s_it = s_it + 1) {
			GFile* s;
			s = _g_object_ref0 (s_collection[s_it]);
			{
				deja_dup_operation_backup_add_to_file_list (self, &((DejaDupOperation*) self)->dup->includes, s);
				_g_object_unref0 (s);
			}
		}
	}
	deja_dup_duplicity_set_local (((DejaDupOperation*) self)->dup, _tmp11_ = g_file_new_for_path ("/"));
	_g_object_unref0 (_tmp11_);
	result = rv;
	__g_list_free_g_free0 (always_excluded);
	exclude_list = (_vala_array_free (exclude_list, exclude_list_length1, (GDestroyNotify) g_object_unref), NULL);
	include_list = (_vala_array_free (include_list, include_list_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (client);
	return result;
}


static GList* deja_dup_operation_backup_get_always_excluded_dirs (DejaDupOperationBackup* self) {
	GList* result = NULL;
	GList* rv;
	char* dir;
	char* _tmp0_;
	char* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	rv = NULL;
	dir = g_strdup (g_get_user_cache_dir ());
	if (dir != NULL) {
		rv = g_list_append (rv, g_strdup (dir));
	}
	dir = (_tmp0_ = g_strdup (g_get_home_dir ()), _g_free0 (dir), _tmp0_);
	if (dir != NULL) {
		rv = g_list_append (rv, g_build_filename (dir, ".thumbnails", NULL));
		rv = g_list_append (rv, g_build_filename (dir, ".gvfs", NULL));
		rv = g_list_append (rv, g_build_filename (dir, ".xsession-errors", NULL));
		rv = g_list_append (rv, g_build_filename (dir, ".recently-used.xbel", NULL));
		rv = g_list_append (rv, g_build_filename (dir, ".recent-applications.xbel", NULL));
		rv = g_list_append (rv, g_build_filename (dir, ".Private", NULL));
	}
	dir = (_tmp1_ = g_strdup (g_get_tmp_dir ()), _g_free0 (dir), _tmp1_);
	if (dir != NULL) {
		rv = g_list_append (rv, g_strdup (dir));
	}
	rv = g_list_append (rv, g_strdup ("/proc"));
	rv = g_list_append (rv, g_strdup ("/sys"));
	result = rv;
	_g_free0 (dir);
	return result;
}


static void deja_dup_operation_backup_class_init (DejaDupOperationBackupClass * klass) {
	deja_dup_operation_backup_parent_class = g_type_class_peek_parent (klass);
	DEJA_DUP_OPERATION_CLASS (klass)->operation_finished = deja_dup_operation_backup_real_operation_finished;
	DEJA_DUP_OPERATION_CLASS (klass)->operation_finished_finish = deja_dup_operation_backup_real_operation_finished_finish;
	DEJA_DUP_OPERATION_CLASS (klass)->make_argv = deja_dup_operation_backup_real_make_argv;
}


static void deja_dup_operation_backup_instance_init (DejaDupOperationBackup * self) {
}


GType deja_dup_operation_backup_get_type (void) {
	static volatile gsize deja_dup_operation_backup_type_id__volatile = 0;
	if (g_once_init_enter (&deja_dup_operation_backup_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupOperationBackupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_operation_backup_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupOperationBackup), 0, (GInstanceInitFunc) deja_dup_operation_backup_instance_init, NULL };
		GType deja_dup_operation_backup_type_id;
		deja_dup_operation_backup_type_id = g_type_register_static (DEJA_DUP_TYPE_OPERATION, "DejaDupOperationBackup", &g_define_type_info, 0);
		g_once_init_leave (&deja_dup_operation_backup_type_id__volatile, deja_dup_operation_backup_type_id);
	}
	return deja_dup_operation_backup_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




