/* AssistantBackup.c generated by valac 0.10.0, the Vala compiler
 * generated from AssistantBackup.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    © 2008–2010 Michael Terry <mike@mterry.name>

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <common.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <widgets.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdkx.h>
#include <gdk/gdk.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <gconf/gconf-client.h>


#define TYPE_ASSISTANT (assistant_get_type ())
#define ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT, Assistant))
#define ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT, AssistantClass))
#define IS_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT))
#define IS_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT))
#define ASSISTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT, AssistantClass))

typedef struct _Assistant Assistant;
typedef struct _AssistantClass AssistantClass;
typedef struct _AssistantPrivate AssistantPrivate;

#define TYPE_ASSISTANT_OPERATION (assistant_operation_get_type ())
#define ASSISTANT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT_OPERATION, AssistantOperation))
#define ASSISTANT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT_OPERATION, AssistantOperationClass))
#define IS_ASSISTANT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT_OPERATION))
#define IS_ASSISTANT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT_OPERATION))
#define ASSISTANT_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT_OPERATION, AssistantOperationClass))

typedef struct _AssistantOperation AssistantOperation;
typedef struct _AssistantOperationClass AssistantOperationClass;
typedef struct _AssistantOperationPrivate AssistantOperationPrivate;

#define TYPE_ASSISTANT_BACKUP (assistant_backup_get_type ())
#define ASSISTANT_BACKUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT_BACKUP, AssistantBackup))
#define ASSISTANT_BACKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT_BACKUP, AssistantBackupClass))
#define IS_ASSISTANT_BACKUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT_BACKUP))
#define IS_ASSISTANT_BACKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT_BACKUP))
#define ASSISTANT_BACKUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT_BACKUP, AssistantBackupClass))

typedef struct _AssistantBackup AssistantBackup;
typedef struct _AssistantBackupClass AssistantBackupClass;
typedef struct _AssistantBackupPrivate AssistantBackupPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define ASSISTANT_TYPE_TYPE (assistant_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _Assistant {
	GtkDialog parent_instance;
	AssistantPrivate * priv;
	GtkImage* header_icon;
	GtkEventBox* page_box;
};

struct _AssistantClass {
	GtkDialogClass parent_class;
};

struct _AssistantOperation {
	Assistant parent_instance;
	AssistantOperationPrivate * priv;
	gboolean succeeded;
	GtkLabel* summary_label;
	DejaDupOperation* op;
	GMountOperation* mount_op;
};

struct _AssistantOperationClass {
	AssistantClass parent_class;
	GtkWidget* (*make_confirm_page) (AssistantOperation* self);
	void (*add_setup_pages) (AssistantOperation* self);
	void (*add_custom_config_pages) (AssistantOperation* self);
	DejaDupOperation* (*create_op) (AssistantOperation* self);
	char* (*get_progress_file_prefix) (AssistantOperation* self);
	void (*set_op_icon_name) (AssistantOperation* self);
	GtkWidget* (*make_progress_page) (AssistantOperation* self);
	void (*show_error) (AssistantOperation* self, const char* _error_, const char* detail);
	GtkWidget* (*make_summary_page) (AssistantOperation* self);
	void (*do_prepare) (AssistantOperation* self, Assistant* assist, GtkWidget* page);
	void (*do_close) (AssistantOperation* self);
};

struct _AssistantBackup {
	AssistantOperation parent_instance;
	AssistantBackupPrivate * priv;
};

struct _AssistantBackupClass {
	AssistantOperationClass parent_class;
};

struct _AssistantBackupPrivate {
	DejaDupToggleGroup* periodic_toggle;
};

typedef enum  {
	ASSISTANT_TYPE_NORMAL,
	ASSISTANT_TYPE_INTERRUPT,
	ASSISTANT_TYPE_SUMMARY,
	ASSISTANT_TYPE_PROGRESS,
	ASSISTANT_TYPE_FINISH
} AssistantType;


static gpointer assistant_backup_parent_class = NULL;

GType assistant_get_type (void) G_GNUC_CONST;
GType assistant_operation_get_type (void) G_GNUC_CONST;
GType assistant_backup_get_type (void) G_GNUC_CONST;
#define ASSISTANT_BACKUP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ASSISTANT_BACKUP, AssistantBackupPrivate))
enum  {
	ASSISTANT_BACKUP_DUMMY_PROPERTY
};
AssistantBackup* assistant_backup_new (gboolean automatic);
AssistantBackup* assistant_backup_construct (GType object_type, gboolean automatic);
static GtkWidget* assistant_backup_make_backup_location_page (AssistantBackup* self);
static GtkWidget* assistant_backup_make_include_exclude_page (AssistantBackup* self);
static void assistant_backup_real_add_custom_config_pages (AssistantOperation* base);
gboolean assistant_operation_get_automatic (AssistantOperation* self);
GType assistant_type_get_type (void) G_GNUC_CONST;
void assistant_append_page (Assistant* self, GtkWidget* page, AssistantType type);
void assistant_set_page_title (Assistant* self, GtkWidget* page, const char* title);
static GtkWidget* assistant_backup_real_make_confirm_page (AssistantOperation* base);
static DejaDupOperation* assistant_backup_real_create_op (AssistantOperation* base);
static void assistant_backup_do_resume (AssistantBackup* self);
void assistant_operation_hide_everything (AssistantOperation* self);
void assistant_operation_do_close (AssistantOperation* self);
static char* assistant_backup_real_get_progress_file_prefix (AssistantOperation* base);
static void assistant_backup_real_set_op_icon_name (AssistantOperation* base);
static void assistant_backup_add_periodic_widgets (AssistantBackup* self, GtkVBox* page);
static void assistant_backup_real_do_prepare (AssistantOperation* base, Assistant* assist, GtkWidget* page);
void assistant_operation_do_prepare (AssistantOperation* self, Assistant* assist, GtkWidget* page);
GtkWidget* assistant_operation_get_summary_page (AssistantOperation* self);
gboolean assistant_operation_get_error_occurred (AssistantOperation* self);
static gboolean _lambda16_ (AssistantBackup* self);
static gboolean __lambda16__gsource_func (gpointer self);
static gboolean _lambda17_ (AssistantBackup* self);
void assistant_operation_force_visible (AssistantOperation* self, gboolean user_click);
static gboolean __lambda17__gsource_func (gpointer self);
GtkWidget* assistant_operation_get_progress_page (AssistantOperation* self);
void assistant_set_apply_text (Assistant* self, const char* value);
void assistant_set_resume_supported (Assistant* self, gboolean value);
static void _assistant_backup_do_resume_assistant_resumed (Assistant* _sender, gpointer self);
static GObject * assistant_backup_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void assistant_backup_finalize (GObject* obj);



AssistantBackup* assistant_backup_construct (GType object_type, gboolean automatic) {
	AssistantBackup * self;
	self = (AssistantBackup*) g_object_new (object_type, "automatic", automatic, NULL);
	return self;
}


AssistantBackup* assistant_backup_new (gboolean automatic) {
	return assistant_backup_construct (TYPE_ASSISTANT_BACKUP, automatic);
}


static GtkWidget* assistant_backup_make_backup_location_page (AssistantBackup* self) {
	GtkWidget* result = NULL;
	gint rows;
	GtkWidget* w;
	GtkWidget* label;
	GtkVBox* vbox;
	GtkTable* page;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	rows = 0;
	w = NULL;
	label = NULL;
	vbox = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 0));
	gtk_container_set_border_width ((GtkContainer*) vbox, (guint) 12);
	page = g_object_ref_sink ((GtkTable*) gtk_table_new ((guint) rows, (guint) 2, FALSE));
	g_object_set ((GObject*) page, "row-spacing", 6, "column-spacing", 6, NULL);
	w = (_tmp0_ = (GtkWidget*) g_object_ref_sink (deja_dup_config_location_new ()), _g_object_unref0 (w), _tmp0_);
	label = (_tmp1_ = (GtkWidget*) g_object_ref_sink ((GtkLabel*) gtk_label_new_with_mnemonic (_ ("_Backup location:"))), _g_object_unref0 (label), _tmp1_);
	g_object_set ((GObject*) label, "xalign", 0.0f, "mnemonic-widget", w, NULL);
	gtk_table_attach (page, label, (guint) 0, (guint) 1, (guint) rows, (guint) (rows + 1), GTK_FILL, 0, (guint) 0, (guint) 0);
	gtk_table_attach (page, w, (guint) 1, (guint) 2, (guint) rows, (guint) (rows + 1), GTK_FILL | GTK_EXPAND, 0, (guint) 0, (guint) 0);
	rows = rows + 1;
	w = (_tmp2_ = (GtkWidget*) g_object_ref_sink (deja_dup_config_bool_new (DEJA_DUP_ENCRYPT_KEY, _ ("_Encrypt backup files"))), _g_object_unref0 (w), _tmp2_);
	gtk_table_attach (page, w, (guint) 0, (guint) 2, (guint) rows, (guint) (rows + 1), GTK_FILL | GTK_EXPAND, GTK_FILL, (guint) 0, (guint) 0);
	rows = rows + 1;
	w = (_tmp3_ = (GtkWidget*) g_object_ref_sink (deja_dup_config_label_policy_new ()), _g_object_unref0 (w), _tmp3_);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) page, TRUE, TRUE, (guint) 0);
	gtk_box_pack_end ((GtkBox*) vbox, w, FALSE, FALSE, (guint) 0);
	result = (GtkWidget*) vbox;
	_g_object_unref0 (page);
	_g_object_unref0 (label);
	_g_object_unref0 (w);
	return result;
}


static GtkWidget* assistant_backup_make_include_exclude_page (AssistantBackup* self) {
	GtkWidget* result = NULL;
	gint rows;
	GtkWidget* w;
	GtkWidget* label;
	GtkTable* page;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	rows = 0;
	w = NULL;
	label = NULL;
	page = g_object_ref_sink ((GtkTable*) gtk_table_new ((guint) rows, (guint) 2, FALSE));
	g_object_set ((GObject*) page, "row-spacing", 6, "column-spacing", 6, "border-width", 12, NULL);
	w = (_tmp0_ = (GtkWidget*) g_object_ref_sink (deja_dup_config_list_new (DEJA_DUP_INCLUDE_LIST_KEY, NULL)), _g_object_unref0 (w), _tmp0_);
	gtk_widget_set_size_request (w, 250, 100);
	label = (_tmp1_ = (GtkWidget*) g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("I_nclude files in folders:"))), _g_object_unref0 (label), _tmp1_);
	g_object_set ((GObject*) label, "mnemonic-widget", w, "use-underline", TRUE, "wrap", TRUE, "width-request", 100, "xalign", 0.0f, "yalign", 0.0f, NULL);
	gtk_table_attach (page, label, (guint) 0, (guint) 1, (guint) rows, (guint) (rows + 1), GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
	gtk_table_attach (page, w, (guint) 1, (guint) 2, (guint) rows, (guint) (rows + 1), GTK_FILL | GTK_EXPAND, GTK_FILL, (guint) 0, (guint) 0);
	rows = rows + 1;
	w = (_tmp2_ = (GtkWidget*) g_object_ref_sink (deja_dup_config_list_new (DEJA_DUP_EXCLUDE_LIST_KEY, NULL)), _g_object_unref0 (w), _tmp2_);
	gtk_widget_set_size_request (w, 250, 70);
	label = (_tmp3_ = (GtkWidget*) g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("E_xcept files in folders:"))), _g_object_unref0 (label), _tmp3_);
	g_object_set ((GObject*) label, "mnemonic-widget", w, "use-underline", TRUE, "wrap", TRUE, "width-request", 100, "xalign", 0.0f, "yalign", 0.0f, NULL);
	gtk_table_attach (page, label, (guint) 0, (guint) 1, (guint) rows, (guint) (rows + 1), GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
	gtk_table_attach (page, w, (guint) 1, (guint) 2, (guint) rows, (guint) (rows + 1), GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, (guint) 0, (guint) 0);
	rows = rows + 1;
	result = (GtkWidget*) page;
	_g_object_unref0 (label);
	_g_object_unref0 (w);
	return result;
}


static void assistant_backup_real_add_custom_config_pages (AssistantOperation* base) {
	AssistantBackup * self;
	GtkWidget* page;
	GtkWidget* _tmp0_;
	self = (AssistantBackup*) base;
	if (assistant_operation_get_automatic ((AssistantOperation*) self)) {
		return;
	}
	page = assistant_backup_make_backup_location_page (self);
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_NORMAL);
	assistant_set_page_title ((Assistant*) self, page, _ ("Preferences"));
	page = (_tmp0_ = assistant_backup_make_include_exclude_page (self), _g_object_unref0 (page), _tmp0_);
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_NORMAL);
	assistant_set_page_title ((Assistant*) self, page, _ ("Preferences"));
	_g_object_unref0 (page);
}


static GtkWidget* assistant_backup_real_make_confirm_page (AssistantOperation* base) {
	AssistantBackup * self;
	GtkWidget* result = NULL;
	gint rows;
	GtkWidget* label;
	GtkWidget* w;
	GtkTable* page;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	GtkWidget* _tmp4_;
	GtkWidget* _tmp5_;
	GtkWidget* _tmp6_;
	GtkWidget* _tmp7_;
	self = (AssistantBackup*) base;
	if (assistant_operation_get_automatic ((AssistantOperation*) self)) {
		result = NULL;
		return result;
	}
	rows = 0;
	label = NULL;
	w = NULL;
	page = g_object_ref_sink ((GtkTable*) gtk_table_new ((guint) rows, (guint) 2, FALSE));
	g_object_set ((GObject*) page, "row-spacing", 6, "column-spacing", 6, "border-width", 12, NULL);
	label = (_tmp0_ = (GtkWidget*) g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Backup location:"))), _g_object_unref0 (label), _tmp0_);
	g_object_set ((GObject*) label, "xalign", 0.0f, NULL);
	w = (_tmp1_ = (GtkWidget*) g_object_ref_sink (deja_dup_config_label_location_new ()), _g_object_unref0 (w), _tmp1_);
	gtk_table_attach (page, label, (guint) 0, (guint) 1, (guint) rows, (guint) (rows + 1), GTK_FILL, 0, (guint) 0, (guint) 0);
	gtk_table_attach (page, w, (guint) 1, (guint) 2, (guint) rows, (guint) (rows + 1), GTK_FILL, 0, (guint) 0, (guint) 0);
	rows = rows + 1;
	label = (_tmp2_ = (GtkWidget*) g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Encrypted:"))), _g_object_unref0 (label), _tmp2_);
	g_object_set ((GObject*) label, "xalign", 0.0f, NULL);
	w = (_tmp3_ = (GtkWidget*) g_object_ref_sink (deja_dup_config_label_bool_new (DEJA_DUP_ENCRYPT_KEY)), _g_object_unref0 (w), _tmp3_);
	gtk_table_attach (page, label, (guint) 0, (guint) 1, (guint) rows, (guint) (rows + 1), GTK_FILL, 0, (guint) 0, (guint) 0);
	gtk_table_attach (page, w, (guint) 1, (guint) 2, (guint) rows, (guint) (rows + 1), GTK_FILL, 0, (guint) 0, (guint) 0);
	rows = rows + 1;
	label = (_tmp4_ = (GtkWidget*) g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Include from:"))), _g_object_unref0 (label), _tmp4_);
	g_object_set ((GObject*) label, "xalign", 0.0f, "yalign", 0.0f, NULL);
	w = (_tmp5_ = (GtkWidget*) g_object_ref_sink (deja_dup_config_label_list_new (DEJA_DUP_INCLUDE_LIST_KEY)), _g_object_unref0 (w), _tmp5_);
	g_object_set ((GObject*) w, "width-request", 250, NULL);
	gtk_table_attach (page, label, (guint) 0, (guint) 1, (guint) rows, (guint) (rows + 1), GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
	gtk_table_attach (page, w, (guint) 1, (guint) 2, (guint) rows, (guint) (rows + 1), 0, GTK_FILL, (guint) 0, (guint) 0);
	rows = rows + 1;
	label = (_tmp6_ = (GtkWidget*) g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Except for:"))), _g_object_unref0 (label), _tmp6_);
	g_object_set ((GObject*) label, "xalign", 0.0f, "yalign", 0.0f, NULL);
	w = (_tmp7_ = (GtkWidget*) g_object_ref_sink (deja_dup_config_label_list_new (DEJA_DUP_EXCLUDE_LIST_KEY)), _g_object_unref0 (w), _tmp7_);
	g_object_set ((GObject*) w, "width-request", 250, NULL);
	gtk_table_attach (page, label, (guint) 0, (guint) 1, (guint) rows, (guint) (rows + 1), GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
	gtk_table_attach (page, w, (guint) 1, (guint) 2, (guint) rows, (guint) (rows + 1), 0, GTK_FILL, (guint) 0, (guint) 0);
	rows = rows + 1;
	result = (GtkWidget*) page;
	_g_object_unref0 (w);
	_g_object_unref0 (label);
	return result;
}


static DejaDupOperation* assistant_backup_real_create_op (AssistantOperation* base) {
	AssistantBackup * self;
	DejaDupOperation* result = NULL;
	XID xid;
	self = (AssistantBackup*) base;
	gtk_widget_realize ((GtkWidget*) self);
	xid = gdk_x11_drawable_get_xid ((GdkDrawable*) gtk_widget_get_window ((GtkWidget*) self));
	result = (DejaDupOperation*) deja_dup_operation_backup_new ((guint) xid);
	return result;
}


static void assistant_backup_do_resume (AssistantBackup* self) {
	g_return_if_fail (self != NULL);
	assistant_operation_hide_everything ((AssistantOperation*) self);
	if (((AssistantOperation*) self)->op != NULL) {
		deja_dup_operation_stop (((AssistantOperation*) self)->op);
	} else {
		((AssistantOperation*) self)->succeeded = TRUE;
		assistant_operation_do_close ((AssistantOperation*) self);
	}
}


static char* assistant_backup_real_get_progress_file_prefix (AssistantOperation* base) {
	AssistantBackup * self;
	char* result = NULL;
	self = (AssistantBackup*) base;
	result = g_strdup (_ ("Backing up:"));
	return result;
}


static void assistant_backup_real_set_op_icon_name (AssistantOperation* base) {
	AssistantBackup * self;
	self = (AssistantBackup*) base;
	gtk_window_set_icon_name ((GtkWindow*) self, "deja-dup-backup");
}


static void assistant_backup_add_periodic_widgets (AssistantBackup* self, GtkVBox* page) {
	DejaDupConfigBool* check;
	DejaDupConfigPeriod* combo;
	char* _tmp0_;
	GtkLabel* _tmp1_;
	GtkLabel* label;
	GtkHBox* hbox;
	DejaDupToggleGroup* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	check = g_object_ref_sink (deja_dup_config_bool_new (DEJA_DUP_PERIODIC_KEY, _ ("_Automatically back up on a regular schedule")));
	combo = g_object_ref_sink (deja_dup_config_period_new (DEJA_DUP_PERIODIC_PERIOD_KEY));
	label = (_tmp1_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_tmp0_ = g_strdup_printf ("    %s", _ ("How _often to back up:")))), _g_free0 (_tmp0_), _tmp1_);
	g_object_set ((GObject*) label, "mnemonic-widget", combo, "use-underline", TRUE, "xalign", 0.0f, NULL);
	hbox = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6));
	g_object_set ((GObject*) hbox, "child", label, "child", combo, NULL);
	gtk_box_pack_end ((GtkBox*) page, (GtkWidget*) hbox, FALSE, FALSE, (guint) 0);
	gtk_box_pack_end ((GtkBox*) page, (GtkWidget*) check, FALSE, FALSE, (guint) 0);
	self->priv->periodic_toggle = (_tmp2_ = deja_dup_toggle_group_new ((DejaDupTogglable*) check), _g_object_unref0 (self->priv->periodic_toggle), _tmp2_);
	deja_dup_toggle_group_add_dependent (self->priv->periodic_toggle, (GtkWidget*) label);
	deja_dup_toggle_group_add_dependent (self->priv->periodic_toggle, (GtkWidget*) combo);
	deja_dup_toggle_group_check (self->priv->periodic_toggle);
	gtk_widget_show_all ((GtkWidget*) check);
	gtk_widget_show_all ((GtkWidget*) hbox);
	_g_object_unref0 (hbox);
	_g_object_unref0 (label);
	_g_object_unref0 (combo);
	_g_object_unref0 (check);
}


static gboolean _lambda16_ (AssistantBackup* self) {
	gboolean result = FALSE;
	assistant_operation_do_close ((AssistantOperation*) self);
	result = FALSE;
	return result;
}


static gboolean __lambda16__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda16_ (self);
	return result;
}


static gboolean _lambda17_ (AssistantBackup* self) {
	gboolean result = FALSE;
	assistant_operation_force_visible ((AssistantOperation*) self, FALSE);
	result = FALSE;
	return result;
}


static gboolean __lambda17__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda17_ (self);
	return result;
}


static void assistant_backup_real_do_prepare (AssistantOperation* base, Assistant* assist, GtkWidget* page) {
	AssistantBackup * self;
	GError * _inner_error_ = NULL;
	self = (AssistantBackup*) base;
	g_return_if_fail (assist != NULL);
	g_return_if_fail (page != NULL);
	ASSISTANT_OPERATION_CLASS (assistant_backup_parent_class)->do_prepare (ASSISTANT_OPERATION (self), assist, page);
	if (page == assistant_operation_get_summary_page ((AssistantOperation*) self)) {
		if (assistant_operation_get_error_occurred ((AssistantOperation*) self)) {
			assistant_set_page_title ((Assistant*) self, page, _ ("Backup Failed"));
		} else {
			GConfClient* client;
			gboolean val;
			assistant_set_page_title ((Assistant*) self, page, _ ("Backup Finished"));
			gtk_label_set_label (((AssistantOperation*) self)->summary_label, _ ("Your files were successfully backed up."));
			client = deja_dup_get_gconf_client ();
			val = FALSE;
			{
				gboolean _tmp0_;
				_tmp0_ = gconf_client_get_bool (client, DEJA_DUP_PERIODIC_KEY, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch1_g_error;
				}
				val = _tmp0_;
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError * e;
				e = _inner_error_;
				_inner_error_ = NULL;
				{
					g_warning ("AssistantBackup.vala:248: %s\n", e->message);
					_g_error_free0 (e);
				}
			}
			__finally1:
			if (_inner_error_ != NULL) {
				_g_object_unref0 (client);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			if (!val) {
				assistant_backup_add_periodic_widgets (self, GTK_VBOX (page));
			}
			if (assistant_operation_get_automatic ((AssistantOperation*) self)) {
				g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda16__gsource_func, g_object_ref (self), g_object_unref);
			} else {
				g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda17__gsource_func, g_object_ref (self), g_object_unref);
			}
			_g_object_unref0 (client);
		}
	} else {
		if (page == assistant_operation_get_progress_page ((AssistantOperation*) self)) {
			assistant_set_page_title ((Assistant*) self, page, _ ("Backing up…"));
		}
	}
}


static void _assistant_backup_do_resume_assistant_resumed (Assistant* _sender, gpointer self) {
	assistant_backup_do_resume (self);
}


static GObject * assistant_backup_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	AssistantBackup * self;
	parent_class = G_OBJECT_CLASS (assistant_backup_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = ASSISTANT_BACKUP (obj);
	{
		DejaDupDuplicityInfo* _tmp0_;
		gtk_window_set_title ((GtkWindow*) self, C_ ("back up is verb", "Back Up"));
		assistant_set_apply_text ((Assistant*) self, C_ ("back up is verb", "_Back Up"));
		assistant_set_resume_supported ((Assistant*) self, deja_dup_duplicity_info_get_can_resume (_tmp0_ = deja_dup_duplicity_info_get_default ()));
		_g_object_unref0 (_tmp0_);
		g_signal_connect_object ((Assistant*) self, "resumed", (GCallback) _assistant_backup_do_resume_assistant_resumed, self, 0);
	}
	return obj;
}


static void assistant_backup_class_init (AssistantBackupClass * klass) {
	assistant_backup_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AssistantBackupPrivate));
	ASSISTANT_OPERATION_CLASS (klass)->add_custom_config_pages = assistant_backup_real_add_custom_config_pages;
	ASSISTANT_OPERATION_CLASS (klass)->make_confirm_page = assistant_backup_real_make_confirm_page;
	ASSISTANT_OPERATION_CLASS (klass)->create_op = assistant_backup_real_create_op;
	ASSISTANT_OPERATION_CLASS (klass)->get_progress_file_prefix = assistant_backup_real_get_progress_file_prefix;
	ASSISTANT_OPERATION_CLASS (klass)->set_op_icon_name = assistant_backup_real_set_op_icon_name;
	ASSISTANT_OPERATION_CLASS (klass)->do_prepare = assistant_backup_real_do_prepare;
	G_OBJECT_CLASS (klass)->constructor = assistant_backup_constructor;
	G_OBJECT_CLASS (klass)->finalize = assistant_backup_finalize;
}


static void assistant_backup_instance_init (AssistantBackup * self) {
	self->priv = ASSISTANT_BACKUP_GET_PRIVATE (self);
}


static void assistant_backup_finalize (GObject* obj) {
	AssistantBackup * self;
	self = ASSISTANT_BACKUP (obj);
	_g_object_unref0 (self->priv->periodic_toggle);
	G_OBJECT_CLASS (assistant_backup_parent_class)->finalize (obj);
}


GType assistant_backup_get_type (void) {
	static volatile gsize assistant_backup_type_id__volatile = 0;
	if (g_once_init_enter (&assistant_backup_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AssistantBackupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) assistant_backup_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AssistantBackup), 0, (GInstanceInitFunc) assistant_backup_instance_init, NULL };
		GType assistant_backup_type_id;
		assistant_backup_type_id = g_type_register_static (TYPE_ASSISTANT_OPERATION, "AssistantBackup", &g_define_type_info, 0);
		g_once_init_leave (&assistant_backup_type_id__volatile, assistant_backup_type_id);
	}
	return assistant_backup_type_id__volatile;
}




