/* StatusIcon.c generated by valac 0.10.0, the Vala compiler
 * generated from StatusIcon.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    © 2009 Michael Terry <mike@mterry.name>

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <common.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <whacks.h>


#define TYPE_STATUS_ICON (status_icon_get_type ())
#define STATUS_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STATUS_ICON, StatusIcon))
#define STATUS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STATUS_ICON, StatusIconClass))
#define IS_STATUS_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STATUS_ICON))
#define IS_STATUS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STATUS_ICON))
#define STATUS_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STATUS_ICON, StatusIconClass))

typedef struct _StatusIcon StatusIcon;
typedef struct _StatusIconClass StatusIconClass;
typedef struct _StatusIconPrivate StatusIconPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _StatusIcon {
	GObject parent_instance;
	StatusIconPrivate * priv;
};

struct _StatusIconClass {
	GObjectClass parent_class;
};

struct _StatusIconPrivate {
	GtkWindow* _window;
	DejaDupOperation* _op;
	gboolean _automatic;
	char* action;
	double progress;
	GtkMenu* menu;
	GtkCheckMenuItem* toggle_item;
	GObject* iconobj;
	GtkStatusIcon* gtkicon;
};


static gpointer status_icon_parent_class = NULL;

GType status_icon_get_type (void) G_GNUC_CONST;
#define STATUS_ICON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_STATUS_ICON, StatusIconPrivate))
enum  {
	STATUS_ICON_DUMMY_PROPERTY,
	STATUS_ICON_WINDOW,
	STATUS_ICON_OP,
	STATUS_ICON_AUTOMATIC
};
StatusIcon* status_icon_new (GtkWindow* window, DejaDupOperation* op, gboolean automatic);
StatusIcon* status_icon_construct (GType object_type, GtkWindow* window, DejaDupOperation* op, gboolean automatic);
static void status_icon_set_action_desc (StatusIcon* self, DejaDupOperation* op, const char* action);
static void status_icon_update_progress (StatusIcon* self);
static void status_icon_note_progress (StatusIcon* self, DejaDupOperation* op, double progress);
static void status_icon_later (StatusIcon* self);
DejaDupOperation* status_icon_get_op (StatusIcon* self);
static void status_icon_skip (StatusIcon* self);
static void status_icon_toggle (StatusIcon* self);
static GtkMenu* status_icon_ensure_menu (StatusIcon* self);
GtkWindow* status_icon_get_window (StatusIcon* self);
static void _status_icon_toggle_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
static void _lambda0_ (GtkMenuItem* i, StatusIcon* self);
static void __lambda0__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
gboolean status_icon_get_automatic (StatusIcon* self);
static void _lambda1_ (GtkMenuItem* i, StatusIcon* self);
static void __lambda1__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void status_icon_show_menu (StatusIcon* self, GtkStatusIcon* status_icon, guint button, guint activate_time);
static void _gtk_status_icon_position_menu_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self);
static void status_icon_set_window (StatusIcon* self, GtkWindow* value);
static void status_icon_set_op (StatusIcon* self, DejaDupOperation* value);
static void status_icon_set_automatic (StatusIcon* self, gboolean value);
static void _lambda2_ (GtkWidget* w, StatusIcon* self);
static void __lambda2__gtk_widget_show (GtkWidget* _sender, gpointer self);
static void _lambda3_ (GtkWidget* w, StatusIcon* self);
static void __lambda3__gtk_widget_hide (GtkWidget* _sender, gpointer self);
static void _status_icon_show_menu_gtk_status_icon_popup_menu (GtkStatusIcon* _sender, guint button, guint activate_time, gpointer self);
static void _lambda4_ (GtkStatusIcon* s, StatusIcon* self);
static void __lambda4__gtk_status_icon_activate (GtkStatusIcon* _sender, gpointer self);
static void _status_icon_set_action_desc_deja_dup_operation_action_desc_changed (DejaDupOperation* _sender, const char* action, gpointer self);
static void _status_icon_note_progress_deja_dup_operation_progress (DejaDupOperation* _sender, double percent, gpointer self);
static GObject * status_icon_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void status_icon_finalize (GObject* obj);
static void status_icon_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void status_icon_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



StatusIcon* status_icon_construct (GType object_type, GtkWindow* window, DejaDupOperation* op, gboolean automatic) {
	StatusIcon * self;
	g_return_val_if_fail (op != NULL, NULL);
	self = (StatusIcon*) g_object_new (object_type, "window", window, "op", op, "automatic", automatic, NULL);
	return self;
}


StatusIcon* status_icon_new (GtkWindow* window, DejaDupOperation* op, gboolean automatic) {
	return status_icon_construct (TYPE_STATUS_ICON, window, op, automatic);
}


static void status_icon_set_action_desc (StatusIcon* self, DejaDupOperation* op, const char* action) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	g_return_if_fail (action != NULL);
	self->priv->action = (_tmp0_ = g_strdup (action), _g_free0 (self->priv->action), _tmp0_);
	status_icon_update_progress (self);
}


static void status_icon_note_progress (StatusIcon* self, DejaDupOperation* op, double progress) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	self->priv->progress = progress;
	status_icon_update_progress (self);
}


static void status_icon_update_progress (StatusIcon* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->gtkicon != NULL) {
		char* tooltip;
		tooltip = g_strdup ("");
		if (self->priv->action != NULL) {
			char* _tmp0_;
			tooltip = (_tmp0_ = g_strdup (self->priv->action), _g_free0 (tooltip), _tmp0_);
		}
		if (self->priv->progress > 0) {
			char* _tmp1_;
			char* _tmp2_;
			char* _tmp3_;
			tooltip = (_tmp3_ = g_strconcat (_tmp1_ = g_strconcat (tooltip, "\n", NULL), _tmp2_ = g_strdup_printf (_ ("%.1f%% complete"), self->priv->progress * 100), NULL), _g_free0 (tooltip), _tmp3_);
			_g_free0 (_tmp2_);
			_g_free0 (_tmp1_);
		}
		gtk_status_icon_set_tooltip_text (self->priv->gtkicon, tooltip);
		_g_free0 (tooltip);
	}
	if (self->priv->progress > 0) {
		char* _tmp4_;
		gtk_menu_item_set_label ((GtkMenuItem*) self->priv->toggle_item, _tmp4_ = g_strdup_printf (_ ("Show _Progress (%.1f%%)"), self->priv->progress * 100));
		_g_free0 (_tmp4_);
	} else {
		gtk_menu_item_set_label ((GtkMenuItem*) self->priv->toggle_item, _ ("Show _Progress"));
	}
}


static void status_icon_later (StatusIcon* self) {
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "hide-all");
	deja_dup_operation_stop (self->priv->_op);
}


static void status_icon_skip (StatusIcon* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "hide-all");
	{
		deja_dup_update_last_run_timestamp (&_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch10_g_error;
		}
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("StatusIcon.vala:125: %s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally10:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	deja_dup_operation_cancel (self->priv->_op);
}


static void status_icon_toggle (StatusIcon* self) {
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "toggle-window");
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _status_icon_toggle_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
	status_icon_toggle (self);
}


static void _lambda0_ (GtkMenuItem* i, StatusIcon* self) {
	g_return_if_fail (i != NULL);
	status_icon_later (self);
}


static void __lambda0__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda0_ (_sender, self);
}


static void _lambda1_ (GtkMenuItem* i, StatusIcon* self) {
	g_return_if_fail (i != NULL);
	status_icon_skip (self);
}


static void __lambda1__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda1_ (_sender, self);
}


static GtkMenu* status_icon_ensure_menu (StatusIcon* self) {
	GtkMenu* result = NULL;
	GtkMenu* _tmp0_;
	GtkCheckMenuItem* check;
	GtkCheckMenuItem* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->menu != NULL) {
		result = _g_object_ref0 (self->priv->menu);
		return result;
	}
	self->priv->menu = (_tmp0_ = g_object_ref_sink ((GtkMenu*) gtk_menu_new ()), _g_object_unref0 (self->priv->menu), _tmp0_);
	check = g_object_ref_sink ((GtkCheckMenuItem*) gtk_check_menu_item_new ());
	gtk_check_menu_item_set_active (check, gtk_widget_get_visible ((GtkWidget*) self->priv->_window));
	gtk_menu_item_set_use_underline ((GtkMenuItem*) check, TRUE);
	g_signal_connect_object (check, "toggled", (GCallback) _status_icon_toggle_gtk_check_menu_item_toggled, self, 0);
	gtk_menu_shell_append ((GtkMenuShell*) self->priv->menu, (GtkWidget*) ((GtkMenuItem*) check));
	self->priv->toggle_item = (_tmp1_ = _g_object_ref0 (check), _g_object_unref0 (self->priv->toggle_item), _tmp1_);
	status_icon_update_progress (self);
	if (deja_dup_operation_get_mode (self->priv->_op) == DEJA_DUP_OPERATION_MODE_BACKUP) {
		GtkMenuItem* item;
		DejaDupDuplicityInfo* _tmp2_;
		gboolean _tmp3_;
		item = NULL;
		if ((_tmp3_ = deja_dup_duplicity_info_get_can_resume (_tmp2_ = deja_dup_duplicity_info_get_default ()), _g_object_unref0 (_tmp2_), _tmp3_)) {
			GtkMenuItem* _tmp4_;
			item = (_tmp4_ = g_object_ref_sink ((GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_ ("_Resume Later"))), _g_object_unref0 (item), _tmp4_);
		} else {
			GtkMenuItem* _tmp5_;
			item = (_tmp5_ = g_object_ref_sink ((GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_ ("_Delay Backup"))), _g_object_unref0 (item), _tmp5_);
		}
		g_signal_connect_object (item, "activate", (GCallback) __lambda0__gtk_menu_item_activate, self, 0);
		gtk_menu_shell_append ((GtkMenuShell*) self->priv->menu, (GtkWidget*) item);
		if (self->priv->_automatic) {
			GtkMenuItem* _tmp6_;
			item = (_tmp6_ = g_object_ref_sink ((GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_ ("_Skip Backup"))), _g_object_unref0 (item), _tmp6_);
			g_signal_connect_object (item, "activate", (GCallback) __lambda1__gtk_menu_item_activate, self, 0);
			gtk_menu_shell_append ((GtkMenuShell*) self->priv->menu, (GtkWidget*) item);
		}
		_g_object_unref0 (item);
	}
	gtk_widget_show_all ((GtkWidget*) self->priv->menu);
	result = _g_object_ref0 (self->priv->menu);
	_g_object_unref0 (check);
	return result;
}


static void _gtk_status_icon_position_menu_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self) {
	gtk_status_icon_position_menu (menu, x, y, push_in, self);
}


static void status_icon_show_menu (StatusIcon* self, GtkStatusIcon* status_icon, guint button, guint activate_time) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (status_icon != NULL);
	gtk_menu_popup (self->priv->menu, NULL, NULL, _gtk_status_icon_position_menu_gtk_menu_position_func, status_icon, button, (guint32) activate_time);
}


GtkWindow* status_icon_get_window (StatusIcon* self) {
	GtkWindow* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_window;
	return result;
}


static void status_icon_set_window (StatusIcon* self, GtkWindow* value) {
	GtkWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_window = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_window), _tmp0_);
	g_object_notify ((GObject *) self, "window");
}


DejaDupOperation* status_icon_get_op (StatusIcon* self) {
	DejaDupOperation* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_op;
	return result;
}


static void status_icon_set_op (StatusIcon* self, DejaDupOperation* value) {
	DejaDupOperation* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_op = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_op), _tmp0_);
	g_object_notify ((GObject *) self, "op");
}


gboolean status_icon_get_automatic (StatusIcon* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_automatic;
	return result;
}


static void status_icon_set_automatic (StatusIcon* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_automatic = value;
	g_object_notify ((GObject *) self, "automatic");
}


static void _lambda2_ (GtkWidget* w, StatusIcon* self) {
	guint _tmp0_;
	g_return_if_fail (w != NULL);
	g_signal_parse_name ("toggled", GTK_TYPE_CHECK_MENU_ITEM, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (self->priv->toggle_item, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _status_icon_toggle_gtk_check_menu_item_toggled, self);
	gtk_check_menu_item_set_active (self->priv->toggle_item, TRUE);
	g_signal_connect_object (self->priv->toggle_item, "toggled", (GCallback) _status_icon_toggle_gtk_check_menu_item_toggled, self, 0);
}


static void __lambda2__gtk_widget_show (GtkWidget* _sender, gpointer self) {
	_lambda2_ (_sender, self);
}


static void _lambda3_ (GtkWidget* w, StatusIcon* self) {
	guint _tmp0_;
	g_return_if_fail (w != NULL);
	g_signal_parse_name ("toggled", GTK_TYPE_CHECK_MENU_ITEM, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (self->priv->toggle_item, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _status_icon_toggle_gtk_check_menu_item_toggled, self);
	gtk_check_menu_item_set_active (self->priv->toggle_item, FALSE);
	g_signal_connect_object (self->priv->toggle_item, "toggled", (GCallback) _status_icon_toggle_gtk_check_menu_item_toggled, self, 0);
}


static void __lambda3__gtk_widget_hide (GtkWidget* _sender, gpointer self) {
	_lambda3_ (_sender, self);
}


static void _status_icon_show_menu_gtk_status_icon_popup_menu (GtkStatusIcon* _sender, guint button, guint activate_time, gpointer self) {
	status_icon_show_menu (self, _sender, button, activate_time);
}


static void _lambda4_ (GtkStatusIcon* s, StatusIcon* self) {
	g_return_if_fail (s != NULL);
	status_icon_show_menu (self, s, (guint) 0, (guint) gtk_get_current_event_time ());
}


static void __lambda4__gtk_status_icon_activate (GtkStatusIcon* _sender, gpointer self) {
	_lambda4_ (_sender, self);
}


static void _status_icon_set_action_desc_deja_dup_operation_action_desc_changed (DejaDupOperation* _sender, const char* action, gpointer self) {
	status_icon_set_action_desc (self, _sender, action);
}


static void _status_icon_note_progress_deja_dup_operation_progress (DejaDupOperation* _sender, double percent, gpointer self) {
	status_icon_note_progress (self, _sender, percent);
}


static GObject * status_icon_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	StatusIcon * self;
	parent_class = G_OBJECT_CLASS (status_icon_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = STATUS_ICON (obj);
	{
		GtkMenu* _tmp0_;
		GObject* _tmp1_;
		_tmp0_ = status_icon_ensure_menu (self);
		_g_object_unref0 (_tmp0_);
		self->priv->iconobj = (_tmp1_ = hacks_status_icon_make_app_indicator (self->priv->menu), _g_object_unref0 (self->priv->iconobj), _tmp1_);
		if (self->priv->_window != NULL) {
			g_signal_connect_object ((GtkWidget*) self->priv->_window, "show", (GCallback) __lambda2__gtk_widget_show, self, 0);
			g_signal_connect_object ((GtkWidget*) self->priv->_window, "hide", (GCallback) __lambda3__gtk_widget_hide, self, 0);
		}
		if (self->priv->iconobj == NULL) {
			GtkStatusIcon* _tmp2_;
			GObject* _tmp3_;
			self->priv->gtkicon = (_tmp2_ = gtk_status_icon_new (), _g_object_unref0 (self->priv->gtkicon), _tmp2_);
			g_object_set ((GObject*) self->priv->gtkicon, "icon-name", "deja-dup-symbolic", "title", _ ("Déjà Dup"), NULL);
			g_signal_connect_object (self->priv->gtkicon, "popup-menu", (GCallback) _status_icon_show_menu_gtk_status_icon_popup_menu, self, 0);
			g_signal_connect_object (self->priv->gtkicon, "activate", (GCallback) __lambda4__gtk_status_icon_activate, self, 0);
			self->priv->iconobj = (_tmp3_ = _g_object_ref0 ((GObject*) self->priv->gtkicon), _g_object_unref0 (self->priv->iconobj), _tmp3_);
		}
		g_signal_connect_object (self->priv->_op, "action-desc-changed", (GCallback) _status_icon_set_action_desc_deja_dup_operation_action_desc_changed, self, 0);
		g_signal_connect_object (self->priv->_op, "progress", (GCallback) _status_icon_note_progress_deja_dup_operation_progress, self, 0);
	}
	return obj;
}


static void status_icon_class_init (StatusIconClass * klass) {
	status_icon_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (StatusIconPrivate));
	G_OBJECT_CLASS (klass)->get_property = status_icon_get_property;
	G_OBJECT_CLASS (klass)->set_property = status_icon_set_property;
	G_OBJECT_CLASS (klass)->constructor = status_icon_constructor;
	G_OBJECT_CLASS (klass)->finalize = status_icon_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), STATUS_ICON_WINDOW, g_param_spec_object ("window", "window", "window", GTK_TYPE_WINDOW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), STATUS_ICON_OP, g_param_spec_object ("op", "op", "op", DEJA_DUP_TYPE_OPERATION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), STATUS_ICON_AUTOMATIC, g_param_spec_boolean ("automatic", "automatic", "automatic", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_signal_new ("toggle_window", TYPE_STATUS_ICON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("hide_all", TYPE_STATUS_ICON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void status_icon_instance_init (StatusIcon * self) {
	self->priv = STATUS_ICON_GET_PRIVATE (self);
	self->priv->_automatic = FALSE;
}


static void status_icon_finalize (GObject* obj) {
	StatusIcon * self;
	self = STATUS_ICON (obj);
	{
		hacks_status_icon_close_app_indicator (self->priv->iconobj);
	}
	_g_object_unref0 (self->priv->_window);
	_g_object_unref0 (self->priv->_op);
	_g_free0 (self->priv->action);
	_g_object_unref0 (self->priv->menu);
	_g_object_unref0 (self->priv->toggle_item);
	_g_object_unref0 (self->priv->iconobj);
	_g_object_unref0 (self->priv->gtkicon);
	G_OBJECT_CLASS (status_icon_parent_class)->finalize (obj);
}


GType status_icon_get_type (void) {
	static volatile gsize status_icon_type_id__volatile = 0;
	if (g_once_init_enter (&status_icon_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (StatusIconClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) status_icon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (StatusIcon), 0, (GInstanceInitFunc) status_icon_instance_init, NULL };
		GType status_icon_type_id;
		status_icon_type_id = g_type_register_static (G_TYPE_OBJECT, "StatusIcon", &g_define_type_info, 0);
		g_once_init_leave (&status_icon_type_id__volatile, status_icon_type_id);
	}
	return status_icon_type_id__volatile;
}


static void status_icon_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	StatusIcon * self;
	self = STATUS_ICON (object);
	switch (property_id) {
		case STATUS_ICON_WINDOW:
		g_value_set_object (value, status_icon_get_window (self));
		break;
		case STATUS_ICON_OP:
		g_value_set_object (value, status_icon_get_op (self));
		break;
		case STATUS_ICON_AUTOMATIC:
		g_value_set_boolean (value, status_icon_get_automatic (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void status_icon_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	StatusIcon * self;
	self = STATUS_ICON (object);
	switch (property_id) {
		case STATUS_ICON_WINDOW:
		status_icon_set_window (self, g_value_get_object (value));
		break;
		case STATUS_ICON_OP:
		status_icon_set_op (self, g_value_get_object (value));
		break;
		case STATUS_ICON_AUTOMATIC:
		status_icon_set_automatic (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




