/* WidgetUtils.c generated by valac 0.10.0, the Vala compiler
 * generated from WidgetUtils.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    © 2008,2009 Michael Terry <mike@mterry.name>

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <common.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))



void deja_dup_show_uri (GtkWindow* parent, const char* link);
void deja_dup_handle_about_uri (GtkAboutDialog* about, const char* link);
void deja_dup_handle_about_mail (GtkAboutDialog* about, const char* link);
void deja_dup_show_about (GObject* owner, GtkWindow* parent);
static void _deja_dup_handle_about_mail_gtk_about_dialog_activate_link_func (GtkAboutDialog* about, const char* link_, gpointer self);
static void _deja_dup_handle_about_uri_gtk_about_dialog_activate_link_func (GtkAboutDialog* about, const char* link_, gpointer self);
static void _lambda6_ (GtkDialog* dlg, gint resp);
static void __lambda6__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
GtkWindow* deja_dup_get_topwindow (GtkWidget* w);
gboolean deja_dup_init_duplicity (GtkWindow* parent);

const char* DEJA_DUP_authors[4] = {"Andrew Fister <temposs@gmail.com>", "Michael Terry <mike@mterry.name>", "Michael Vogt <michael.vogt@ubuntu.com>", NULL};
const char* DEJA_DUP_artists[4] = {"Andreas Nilsson <nisses.mail@home.se>", "Jakub Steiner <jimmac@novell.com>", "Michael Terry <mike@mterry.name>", NULL};
const char* DEJA_DUP_documenters[2] = {"Michael Terry <mike@mterry.name>", NULL};


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void deja_dup_show_uri (GtkWindow* parent, const char* link) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (parent != NULL);
	g_return_if_fail (link != NULL);
	{
		GdkScreen* screen;
		screen = _g_object_ref0 (gtk_window_get_screen (parent));
		gtk_show_uri (screen, link, (guint32) GDK_CURRENT_TIME, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (screen);
			goto __catch34_g_error;
		}
		_g_object_unref0 (screen);
	}
	goto __finally34;
	__catch34_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			GtkMessageDialog* dlg;
			dlg = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (parent, GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _ ("Could not display %s"), link));
			gtk_message_dialog_format_secondary_text (dlg, "%s", e->message, NULL);
			gtk_dialog_run ((GtkDialog*) dlg);
			gtk_object_destroy ((GtkObject*) dlg);
			_g_object_unref0 (dlg);
			_g_error_free0 (e);
		}
	}
	__finally34:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void deja_dup_handle_about_uri (GtkAboutDialog* about, const char* link) {
	g_return_if_fail (about != NULL);
	g_return_if_fail (link != NULL);
	deja_dup_show_uri ((GtkWindow*) about, link);
}


void deja_dup_handle_about_mail (GtkAboutDialog* about, const char* link) {
	char* _tmp0_;
	g_return_if_fail (about != NULL);
	g_return_if_fail (link != NULL);
	deja_dup_show_uri ((GtkWindow*) about, _tmp0_ = g_strdup_printf ("mailto:%s", link));
	_g_free0 (_tmp0_);
}


static void _deja_dup_handle_about_mail_gtk_about_dialog_activate_link_func (GtkAboutDialog* about, const char* link_, gpointer self) {
	deja_dup_handle_about_mail (about, link_);
}


static void _deja_dup_handle_about_uri_gtk_about_dialog_activate_link_func (GtkAboutDialog* about, const char* link_, gpointer self) {
	deja_dup_handle_about_uri (about, link_);
}


static void _lambda6_ (GtkDialog* dlg, gint resp) {
	GObject* about_owner;
	g_return_if_fail (dlg != NULL);
	about_owner = _g_object_ref0 (G_OBJECT ((GObject*) g_object_get_data ((GObject*) dlg, "owner")));
	g_object_set_data_full (about_owner, "about-dlg", NULL, NULL);
	gtk_object_destroy ((GtkObject*) dlg);
	_g_object_unref0 (about_owner);
}


static void __lambda6__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	_lambda6_ (_sender, response_id);
}


void deja_dup_show_about (GObject* owner, GtkWindow* parent) {
	GtkAboutDialog* about;
	GtkAboutDialog* _tmp0_;
	char* _tmp1_;
	g_return_if_fail (owner != NULL);
	about = _g_object_ref0 (GTK_ABOUT_DIALOG ((GtkAboutDialog*) g_object_get_data (owner, "about-dlg")));
	if (about != NULL) {
		gtk_window_present ((GtkWindow*) about);
		_g_object_unref0 (about);
		return;
	}
	about = (_tmp0_ = g_object_ref_sink ((GtkAboutDialog*) gtk_about_dialog_new ()), _g_object_unref0 (about), _tmp0_);
	gtk_about_dialog_set_email_hook (_deja_dup_handle_about_mail_gtk_about_dialog_activate_link_func, NULL, NULL);
	gtk_about_dialog_set_url_hook (_deja_dup_handle_about_uri_gtk_about_dialog_activate_link_func, NULL, NULL);
	gtk_window_set_title ((GtkWindow*) about, _ ("About Déjà Dup"));
	gtk_about_dialog_set_authors (about, DEJA_DUP_authors);
	gtk_about_dialog_set_artists (about, DEJA_DUP_artists);
	gtk_about_dialog_set_documenters (about, DEJA_DUP_documenters);
	gtk_about_dialog_set_translator_credits (about, _ ("translator-credits"));
	gtk_about_dialog_set_logo_icon_name (about, PACKAGE);
	gtk_about_dialog_set_version (about, VERSION);
	gtk_about_dialog_set_website (about, "https://launchpad.net/deja-dup");
	gtk_about_dialog_set_license (about, _tmp1_ = g_strdup_printf ("%s\n\n%s\n\n%s", _ ("This program is free software; you can redistribute it and/or modify i" \
"t under the terms of the GNU General Public License as published by th" \
"e Free Software Foundation; either version 3 of the License, or (at yo" \
"ur option) any later version."), _ ("This program is distributed in the hope that it will be useful, but WI" \
"THOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILI" \
"TY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public Li" \
"cense for more details."), _ ("You should have received a copy of the GNU General Public License alon" \
"g with this program.  If not, see http://www.gnu.org/licenses/.")));
	_g_free0 (_tmp1_);
	gtk_about_dialog_set_wrap_license (about, TRUE);
	g_object_set_data_full (owner, "about-dlg", _g_object_ref0 (about), g_object_unref);
	g_object_set_data_full ((GObject*) about, "owner", _g_object_ref0 (owner), g_object_unref);
	gtk_window_set_transient_for ((GtkWindow*) about, parent);
	g_signal_connect ((GtkDialog*) about, "response", (GCallback) __lambda6__gtk_dialog_response, NULL);
	gtk_widget_show ((GtkWidget*) about);
	_g_object_unref0 (about);
}


GtkWindow* deja_dup_get_topwindow (GtkWidget* w) {
	GtkWindow* result = NULL;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (w != NULL, NULL);
	w = gtk_widget_get_toplevel (w);
	if (w != NULL) {
		_tmp0_ = GTK_WIDGET_TOPLEVEL (w);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = _g_object_ref0 (GTK_WINDOW (w));
		return result;
	} else {
		result = NULL;
		return result;
	}
}


gboolean deja_dup_init_duplicity (GtkWindow* parent) {
	gboolean result = FALSE;
	char* header;
	char* msg;
	DejaDupDuplicityInfo* _tmp0_;
	char* _tmp1_ = NULL;
	gboolean _tmp2_;
	char* _tmp3_;
	char* _tmp4_ = NULL;
	gboolean _tmp5_;
	char* _tmp6_;
	gboolean _tmp7_;
	gboolean rv;
	header = NULL;
	msg = NULL;
	rv = (_tmp7_ = (_tmp5_ = (_tmp2_ = deja_dup_duplicity_info_check_duplicity_version (_tmp0_ = deja_dup_duplicity_info_get_default (), &_tmp1_, &_tmp4_), header = (_tmp3_ = _tmp1_, _g_free0 (header), _tmp3_), _tmp2_), msg = (_tmp6_ = _tmp4_, _g_free0 (msg), _tmp6_), _tmp5_), _g_object_unref0 (_tmp0_), _tmp7_);
	if (!rv) {
		GtkMessageDialog* dlg;
		dlg = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (parent, GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "%s", header));
		gtk_message_dialog_format_secondary_text (dlg, "%s", msg, NULL);
		gtk_dialog_run ((GtkDialog*) dlg);
		gtk_object_destroy ((GtkObject*) dlg);
		_g_object_unref0 (dlg);
	}
	result = rv;
	_g_free0 (msg);
	_g_free0 (header);
	return result;
}




