/* AssistantRestoreMissing.c generated by valac 0.12.0, the Vala compiler
 * generated from AssistantRestoreMissing.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    © 2010 Urban Skudnik <urban.skudnik@gmail.com>
    © 2010 Michael Terry <mike@mterry.name>

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <gtk/gtk.h>
#include <common.h>
#include <gio/gio.h>
#include <config.h>
#include <glib/gi18n-lib.h>
#include <whacks.h>
#include <gobject/gvaluecollector.h>


#define TYPE_DELETED_FILE (deleted_file_get_type ())
#define DELETED_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELETED_FILE, DeletedFile))
#define DELETED_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELETED_FILE, DeletedFileClass))
#define IS_DELETED_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELETED_FILE))
#define IS_DELETED_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELETED_FILE))
#define DELETED_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELETED_FILE, DeletedFileClass))

typedef struct _DeletedFile DeletedFile;
typedef struct _DeletedFileClass DeletedFileClass;
typedef struct _DeletedFilePrivate DeletedFilePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecDeletedFile ParamSpecDeletedFile;

#define TYPE_ASSISTANT (assistant_get_type ())
#define ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT, Assistant))
#define ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT, AssistantClass))
#define IS_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT))
#define IS_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT))
#define ASSISTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT, AssistantClass))

typedef struct _Assistant Assistant;
typedef struct _AssistantClass AssistantClass;
typedef struct _AssistantPrivate AssistantPrivate;

#define ASSISTANT_TYPE_PAGE_INFO (assistant_page_info_get_type ())
#define ASSISTANT_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfo))
#define ASSISTANT_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfoClass))
#define ASSISTANT_IS_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ASSISTANT_TYPE_PAGE_INFO))
#define ASSISTANT_IS_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ASSISTANT_TYPE_PAGE_INFO))
#define ASSISTANT_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfoClass))

typedef struct _AssistantPageInfo AssistantPageInfo;
typedef struct _AssistantPageInfoClass AssistantPageInfoClass;

#define TYPE_ASSISTANT_OPERATION (assistant_operation_get_type ())
#define ASSISTANT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT_OPERATION, AssistantOperation))
#define ASSISTANT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT_OPERATION, AssistantOperationClass))
#define IS_ASSISTANT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT_OPERATION))
#define IS_ASSISTANT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT_OPERATION))
#define ASSISTANT_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT_OPERATION, AssistantOperationClass))

typedef struct _AssistantOperation AssistantOperation;
typedef struct _AssistantOperationClass AssistantOperationClass;
typedef struct _AssistantOperationPrivate AssistantOperationPrivate;

#define TYPE_STATUS_ICON (status_icon_get_type ())
#define STATUS_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STATUS_ICON, StatusIcon))
#define STATUS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STATUS_ICON, StatusIconClass))
#define IS_STATUS_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STATUS_ICON))
#define IS_STATUS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STATUS_ICON))
#define STATUS_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STATUS_ICON, StatusIconClass))

typedef struct _StatusIcon StatusIcon;
typedef struct _StatusIconClass StatusIconClass;

#define TYPE_ASSISTANT_RESTORE (assistant_restore_get_type ())
#define ASSISTANT_RESTORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT_RESTORE, AssistantRestore))
#define ASSISTANT_RESTORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT_RESTORE, AssistantRestoreClass))
#define IS_ASSISTANT_RESTORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT_RESTORE))
#define IS_ASSISTANT_RESTORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT_RESTORE))
#define ASSISTANT_RESTORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT_RESTORE, AssistantRestoreClass))

typedef struct _AssistantRestore AssistantRestore;
typedef struct _AssistantRestoreClass AssistantRestoreClass;
typedef struct _AssistantRestorePrivate AssistantRestorePrivate;

#define TYPE_ASSISTANT_RESTORE_MISSING (assistant_restore_missing_get_type ())
#define ASSISTANT_RESTORE_MISSING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT_RESTORE_MISSING, AssistantRestoreMissing))
#define ASSISTANT_RESTORE_MISSING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT_RESTORE_MISSING, AssistantRestoreMissingClass))
#define IS_ASSISTANT_RESTORE_MISSING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT_RESTORE_MISSING))
#define IS_ASSISTANT_RESTORE_MISSING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT_RESTORE_MISSING))
#define ASSISTANT_RESTORE_MISSING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT_RESTORE_MISSING, AssistantRestoreMissingClass))

typedef struct _AssistantRestoreMissing AssistantRestoreMissing;
typedef struct _AssistantRestoreMissingClass AssistantRestoreMissingClass;
typedef struct _AssistantRestoreMissingPrivate AssistantRestoreMissingPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_sequence_free0(var) ((var == NULL) ? NULL : (var = (g_sequence_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define ASSISTANT_TYPE_TYPE (assistant_type_get_type ())
#define _deleted_file_unref0(var) ((var == NULL) ? NULL : (var = (deleted_file_unref (var), NULL)))
#define _deja_dup_operation_state_unref0(var) ((var == NULL) ? NULL : (var = (deja_dup_operation_state_unref (var), NULL)))

struct _DeletedFile {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DeletedFilePrivate * priv;
};

struct _DeletedFileClass {
	GTypeClass parent_class;
	void (*finalize) (DeletedFile *self);
};

struct _DeletedFilePrivate {
	gchar* _name;
	struct tm _deleted;
	gboolean _restore;
};

struct _ParamSpecDeletedFile {
	GParamSpec parent_instance;
};

struct _Assistant {
	GtkDialog parent_instance;
	AssistantPrivate * priv;
	GtkImage* header_icon;
	GtkEventBox* page_box;
	GList* current;
};

struct _AssistantClass {
	GtkDialogClass parent_class;
	void (*hide_for_now) (Assistant* self);
};

struct _AssistantOperation {
	Assistant parent_instance;
	AssistantOperationPrivate * priv;
	StatusIcon* status_icon;
	gboolean succeeded;
	GtkLabel* summary_label;
	DejaDupOperation* op;
};

struct _AssistantOperationClass {
	AssistantClass parent_class;
	GtkWidget* (*make_confirm_page) (AssistantOperation* self);
	void (*add_setup_pages) (AssistantOperation* self);
	void (*add_custom_config_pages) (AssistantOperation* self);
	DejaDupOperation* (*create_op) (AssistantOperation* self);
	gchar* (*get_progress_file_prefix) (AssistantOperation* self);
	void (*set_op_icon_name) (AssistantOperation* self);
	GtkWidget* (*make_progress_page) (AssistantOperation* self);
	void (*show_error) (AssistantOperation* self, const gchar* _error_, const gchar* detail);
	GtkWidget* (*make_summary_page) (AssistantOperation* self);
	void (*apply_finished) (AssistantOperation* self, DejaDupOperation* op, gboolean success, gboolean cancelled);
	void (*do_prepare) (AssistantOperation* self, Assistant* assist, GtkWidget* page);
	void (*do_cancel) (AssistantOperation* self);
	void (*do_close) (AssistantOperation* self);
};

struct _AssistantRestore {
	AssistantOperation parent_instance;
	AssistantRestorePrivate * priv;
	GList* _restore_files;
	DejaDupOperationStatus* query_op;
	DejaDupOperationState* op_state;
};

struct _AssistantRestoreClass {
	AssistantOperationClass parent_class;
	void (*handle_collection_dates) (AssistantRestore* self, DejaDupOperationStatus* op, GList* dates);
	void (*query_finished) (AssistantRestore* self, DejaDupOperation* op, gboolean success, gboolean cancelled);
};

struct _AssistantRestoreMissing {
	AssistantRestore parent_instance;
	AssistantRestoreMissingPrivate * priv;
};

struct _AssistantRestoreMissingClass {
	AssistantRestoreClass parent_class;
};

struct _AssistantRestoreMissingPrivate {
	GFile* list_directory;
	gboolean backups_queue_filled;
	gboolean scan_queue;
	gboolean cancel_assistant;
	GSequence* backups_queue;
	GHashTable* allfiles_prev;
	GList* restore_files_remaining;
	DejaDupOperationFiles* query_op_files;
	GtkWidget* listfiles_page;
	GtkTreeIter deleted_iter;
	GtkListStore* listmodel;
	GtkLabel* list_dir_label;
	GtkLabel* current_scan_date;
	GtkSpinner* spinner;
};

struct _Block1Data {
	int _ref_count_;
	AssistantRestoreMissing * self;
	GFile* file;
};

typedef enum  {
	ASSISTANT_TYPE_NORMAL,
	ASSISTANT_TYPE_INTERRUPT,
	ASSISTANT_TYPE_SUMMARY,
	ASSISTANT_TYPE_PROGRESS,
	ASSISTANT_TYPE_FINISH
} AssistantType;


static gpointer deleted_file_parent_class = NULL;
static gpointer assistant_restore_missing_parent_class = NULL;

gpointer deleted_file_ref (gpointer instance);
void deleted_file_unref (gpointer instance);
GParamSpec* param_spec_deleted_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_deleted_file (GValue* value, gpointer v_object);
void value_take_deleted_file (GValue* value, gpointer v_object);
gpointer value_get_deleted_file (const GValue* value);
GType deleted_file_get_type (void) G_GNUC_CONST;
#define DELETED_FILE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DELETED_FILE, DeletedFilePrivate))
enum  {
	DELETED_FILE_DUMMY_PROPERTY
};
DeletedFile* deleted_file_new (const gchar* name, struct tm* deleted);
DeletedFile* deleted_file_construct (GType object_type, const gchar* name, struct tm* deleted);
void deleted_file_set_name (DeletedFile* self, const gchar* value);
void deleted_file_set_deleted (DeletedFile* self, struct tm* value);
gchar* deleted_file_filename (DeletedFile* self);
const gchar* deleted_file_get_name (DeletedFile* self);
gchar* deleted_file_queue_format (DeletedFile* self);
void deleted_file_get_deleted (DeletedFile* self, struct tm* result);
gboolean deleted_file_get_restore (DeletedFile* self);
void deleted_file_set_restore (DeletedFile* self, gboolean value);
static void deleted_file_finalize (DeletedFile* obj);
GType assistant_get_type (void) G_GNUC_CONST;
static gpointer assistant_page_info_ref (gpointer instance);
static void assistant_page_info_unref (gpointer instance);
static GParamSpec* assistant_param_spec_page_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void assistant_value_set_page_info (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void assistant_value_take_page_info (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer assistant_value_get_page_info (const GValue* value) G_GNUC_UNUSED;
static GType assistant_page_info_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GType assistant_operation_get_type (void) G_GNUC_CONST;
GType status_icon_get_type (void) G_GNUC_CONST;
GType assistant_restore_get_type (void) G_GNUC_CONST;
GType assistant_restore_missing_get_type (void) G_GNUC_CONST;
#define ASSISTANT_RESTORE_MISSING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ASSISTANT_RESTORE_MISSING, AssistantRestoreMissingPrivate))
enum  {
	ASSISTANT_RESTORE_MISSING_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static gint assistant_restore_missing_compare_time (struct tm* a, struct tm* b);
AssistantRestoreMissing* assistant_restore_missing_new (GFile* list_dir);
AssistantRestoreMissing* assistant_restore_missing_construct (GType object_type, GFile* list_dir);
AssistantRestore* assistant_restore_new (void);
AssistantRestore* assistant_restore_construct (GType object_type);
static gchar* assistant_restore_missing_get_ui_file (AssistantRestoreMissing* self, const gchar* ui_file);
static gchar** _vala_array_dup1 (gchar** self, int length);
static GtkWidget* assistant_restore_missing_make_listfiles_page (AssistantRestoreMissing* self);
static void _lambda28_ (GtkCellRendererToggle* toggle, const gchar* path, AssistantRestoreMissing* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static gint _lambda29_ (GFile* f, Block1Data* _data1_);
static gint __lambda29__gcompare_func (gconstpointer a, gconstpointer b);
void assistant_allow_forward (Assistant* self, gboolean allow);
GList* assistant_restore_get_restore_files (AssistantRestore* self);
static void __lambda28__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender, const gchar* path, gpointer self);
static void assistant_restore_missing_add_listfiles_page (AssistantRestoreMissing* self);
GType assistant_type_get_type (void) G_GNUC_CONST;
void assistant_append_page (Assistant* self, GtkWidget* page, AssistantType type);
void assistant_set_page_title (Assistant* self, GtkWidget* page, const gchar* title);
static void assistant_restore_missing_real_add_setup_pages (AssistantOperation* base);
static void assistant_restore_missing_real_do_prepare (AssistantOperation* base, Assistant* assist, GtkWidget* page);
GtkWidget* assistant_operation_get_confirm_page (AssistantOperation* self);
void assistant_restore_missing_do_query_files_at_date (AssistantRestoreMissing* self);
void assistant_operation_provide_password (AssistantOperation* self);
void assistant_restore_do_query (AssistantRestore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void assistant_restore_do_query_finish (AssistantRestore* self, GAsyncResult* _res_);
static gboolean _lambda31_ (AssistantRestoreMissing* self);
static gboolean __lambda31__gsource_func (gpointer self);
void assistant_operation_do_prepare (AssistantOperation* self, Assistant* assist, GtkWidget* page);
void assistant_restore_missing_handle_listed_files (AssistantRestoreMissing* self, DejaDupOperationFiles* op, const gchar* date, const gchar* file);
static void assistant_restore_missing_real_handle_collection_dates (AssistantRestore* base, DejaDupOperationStatus* op, GList* dates);
static struct tm* _g_time_dup (struct tm* self);
static void _g_free0_ (gpointer var);
static void _deleted_file_unref0_ (gpointer var);
void assistant_operation_do_close (AssistantOperation* self);
void assistant_restore_missing_query_files_finished (AssistantRestoreMissing* self, DejaDupOperation* op, gboolean success, gboolean cancelled);
static void _assistant_restore_missing_handle_listed_files_deja_dup_operation_files_listed_current_files (DejaDupOperationFiles* _sender, const gchar* date, const gchar* file, gpointer self);
static void _assistant_restore_missing_query_files_finished_deja_dup_operation_done (DejaDupOperation* _sender, gboolean success, gboolean cancelled, gpointer self);
void assistant_operation_get_passphrase (AssistantOperation* self);
static void _assistant_operation_get_passphrase_deja_dup_operation_passphrase_required (DejaDupOperation* _sender, gpointer self);
static void _lambda30_ (DejaDupOperation* o, const gchar* e, const gchar* d, AssistantRestoreMissing* self);
void assistant_operation_show_error (AssistantOperation* self, const gchar* _error_, const gchar* detail);
static void __lambda30__deja_dup_operation_raise_error (DejaDupOperation* _sender, const gchar* errstr, const gchar* detail, gpointer self);
static void assistant_restore_missing_real_query_finished (AssistantRestore* base, DejaDupOperation* op, gboolean success, gboolean cancelled);
static void assistant_restore_missing_real_do_cancel (AssistantOperation* base);
void assistant_operation_do_cancel (AssistantOperation* self);
static void assistant_restore_missing_real_apply_finished (AssistantOperation* base, DejaDupOperation* op, gboolean success, gboolean cancelled);
void assistant_operation_do_apply (AssistantOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void assistant_operation_do_apply_finish (AssistantOperation* self, GAsyncResult* _res_);
void assistant_go_to_page (Assistant* self, GtkWidget* page);
GtkWidget* assistant_operation_get_summary_page (AssistantOperation* self);
void assistant_operation_force_visible (AssistantOperation* self, gboolean user_click);
static DejaDupOperation* assistant_restore_missing_real_create_op (AssistantOperation* base);
static void assistant_restore_missing_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


DeletedFile* deleted_file_construct (GType object_type, const gchar* name, struct tm* deleted) {
	DeletedFile* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (DeletedFile*) g_type_create_instance (object_type);
	deleted_file_set_name (self, name);
	deleted_file_set_deleted (self, deleted);
	return self;
}


DeletedFile* deleted_file_new (const gchar* name, struct tm* deleted) {
	return deleted_file_construct (TYPE_DELETED_FILE, name, deleted);
}


gchar* deleted_file_filename (DeletedFile* self) {
	gchar* result = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar** splited_fn;
	gint splited_fn_length1;
	gint _splited_fn_size_;
	gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = _tmp0_ = g_strsplit (self->priv->_name, "/", 0);
	splited_fn = _tmp1_;
	splited_fn_length1 = _vala_array_length (_tmp0_);
	_splited_fn_size_ = _vala_array_length (_tmp0_);
	_tmp2_ = g_strdup (splited_fn[splited_fn_length1 - 1]);
	result = _tmp2_;
	splited_fn = (_vala_array_free (splited_fn, splited_fn_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gchar* g_time_format (struct tm *self, const gchar* format) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* buffer;
	gint buffer_length1;
	gint _buffer_size_;
	gchar* _tmp1_;
	g_return_val_if_fail (format != NULL, NULL);
	_tmp0_ = g_new0 (gchar, 64);
	buffer = _tmp0_;
	buffer_length1 = 64;
	_buffer_size_ = 64;
	strftime (buffer, buffer_length1, format, &(*self));
	_tmp1_ = g_strdup ((const gchar*) buffer);
	result = _tmp1_;
	buffer = (g_free (buffer), NULL);
	return result;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


gchar* deleted_file_queue_format (DeletedFile* self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* file;
	gchar* _tmp1_ = NULL;
	gchar* time;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self->priv->_name);
	file = _tmp0_;
	_tmp1_ = g_time_format (&self->priv->_deleted, "%s");
	time = _tmp1_;
	_tmp2_ = string_to_string (file);
	_tmp3_ = string_to_string (time);
	_tmp4_ = g_strconcat (_tmp2_, " ", _tmp3_, NULL);
	result = _tmp4_;
	_g_free0 (time);
	_g_free0 (file);
	return result;
}


const gchar* deleted_file_get_name (DeletedFile* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_name;
	return result;
}


void deleted_file_set_name (DeletedFile* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp0_;
}


void deleted_file_get_deleted (DeletedFile* self, struct tm* result) {
	g_return_if_fail (self != NULL);
	*result = self->priv->_deleted;
	return;
}


void deleted_file_set_deleted (DeletedFile* self, struct tm* value) {
	g_return_if_fail (self != NULL);
	self->priv->_deleted = *value;
}


gboolean deleted_file_get_restore (DeletedFile* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_restore;
	return result;
}


void deleted_file_set_restore (DeletedFile* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_restore = value;
}


static void value_deleted_file_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_deleted_file_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		deleted_file_unref (value->data[0].v_pointer);
	}
}


static void value_deleted_file_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = deleted_file_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_deleted_file_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_deleted_file_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		DeletedFile* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = deleted_file_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_deleted_file_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	DeletedFile** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = deleted_file_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_deleted_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecDeletedFile* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_DELETED_FILE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_deleted_file (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DELETED_FILE), NULL);
	return value->data[0].v_pointer;
}


void value_set_deleted_file (GValue* value, gpointer v_object) {
	DeletedFile* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DELETED_FILE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DELETED_FILE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		deleted_file_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		deleted_file_unref (old);
	}
}


void value_take_deleted_file (GValue* value, gpointer v_object) {
	DeletedFile* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DELETED_FILE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DELETED_FILE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		deleted_file_unref (old);
	}
}


static void deleted_file_class_init (DeletedFileClass * klass) {
	deleted_file_parent_class = g_type_class_peek_parent (klass);
	DELETED_FILE_CLASS (klass)->finalize = deleted_file_finalize;
	g_type_class_add_private (klass, sizeof (DeletedFilePrivate));
}


static void deleted_file_instance_init (DeletedFile * self) {
	self->priv = DELETED_FILE_GET_PRIVATE (self);
	self->priv->_restore = FALSE;
	self->ref_count = 1;
}


static void deleted_file_finalize (DeletedFile* obj) {
	DeletedFile * self;
	self = DELETED_FILE (obj);
	_g_free0 (self->priv->_name);
}


GType deleted_file_get_type (void) {
	static volatile gsize deleted_file_type_id__volatile = 0;
	if (g_once_init_enter (&deleted_file_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_deleted_file_init, value_deleted_file_free_value, value_deleted_file_copy_value, value_deleted_file_peek_pointer, "p", value_deleted_file_collect_value, "p", value_deleted_file_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (DeletedFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deleted_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DeletedFile), 0, (GInstanceInitFunc) deleted_file_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType deleted_file_type_id;
		deleted_file_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DeletedFile", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&deleted_file_type_id__volatile, deleted_file_type_id);
	}
	return deleted_file_type_id__volatile;
}


gpointer deleted_file_ref (gpointer instance) {
	DeletedFile* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void deleted_file_unref (gpointer instance) {
	DeletedFile* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		DELETED_FILE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gint assistant_restore_missing_compare_time (struct tm* a, struct tm* b) {
	gint result = 0;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint a_epoch;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint b_epoch;
	_tmp0_ = g_time_format (a, "%s");
	_tmp1_ = _tmp0_;
	_tmp2_ = atoi (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	a_epoch = _tmp3_;
	_tmp4_ = g_time_format (b, "%s");
	_tmp5_ = _tmp4_;
	_tmp6_ = atoi (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	b_epoch = _tmp7_;
	if (a_epoch < b_epoch) {
		result = 1;
		return result;
	} else {
		if (a_epoch == b_epoch) {
			result = 0;
			return result;
		} else {
			result = -1;
			return result;
		}
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


AssistantRestoreMissing* assistant_restore_missing_construct (GType object_type, GFile* list_dir) {
	AssistantRestoreMissing * self = NULL;
	GFile* _tmp0_;
	g_return_val_if_fail (list_dir != NULL, NULL);
	self = (AssistantRestoreMissing*) assistant_restore_construct (object_type);
	_tmp0_ = _g_object_ref0 (list_dir);
	_g_object_unref0 (self->priv->list_directory);
	self->priv->list_directory = _tmp0_;
	return self;
}


AssistantRestoreMissing* assistant_restore_missing_new (GFile* list_dir) {
	return assistant_restore_missing_construct (TYPE_ASSISTANT_RESTORE_MISSING, list_dir);
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static gchar* assistant_restore_missing_get_ui_file (AssistantRestoreMissing* self, const gchar* ui_file) {
	gchar* result = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gchar** sysdatadirs;
	gint sysdatadirs_length1;
	gint _sysdatadirs_size_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (ui_file != NULL, NULL);
	_tmp1_ = _tmp0_ = g_get_system_data_dirs ();
	_tmp2_ = (_tmp3_ = _tmp1_, (_tmp3_ == NULL) ? ((gpointer) _tmp3_) : _vala_array_dup1 (_tmp3_, _vala_array_length (_tmp0_)));
	sysdatadirs = _tmp2_;
	sysdatadirs_length1 = _vala_array_length (_tmp0_);
	_sysdatadirs_size_ = _vala_array_length (_tmp0_);
	{
		gchar** sysdir_collection;
		int sysdir_collection_length1;
		int sysdir_it;
		sysdir_collection = sysdatadirs;
		sysdir_collection_length1 = sysdatadirs_length1;
		for (sysdir_it = 0; sysdir_it < sysdatadirs_length1; sysdir_it = sysdir_it + 1) {
			gchar* _tmp4_;
			gchar* sysdir;
			_tmp4_ = g_strdup (sysdir_collection[sysdir_it]);
			sysdir = _tmp4_;
			{
				gchar* _tmp5_ = NULL;
				gchar* p;
				GFile* _tmp6_ = NULL;
				GFile* file;
				gboolean _tmp7_;
				_tmp5_ = g_build_filename (sysdir, PACKAGE, "ui", ui_file, NULL);
				p = _tmp5_;
				_tmp6_ = g_file_new_for_path (p);
				file = _tmp6_;
				_tmp7_ = g_file_query_exists (file, NULL);
				if (_tmp7_) {
					result = p;
					_g_object_unref0 (file);
					_g_free0 (sysdir);
					sysdatadirs = (_vala_array_free (sysdatadirs, sysdatadirs_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				_g_object_unref0 (file);
				_g_free0 (p);
				_g_free0 (sysdir);
			}
		}
	}
	result = NULL;
	sysdatadirs = (_vala_array_free (sysdatadirs, sysdatadirs_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_g_object_unref0 (_data1_->file);
		g_slice_free (Block1Data, _data1_);
	}
}


static gint _lambda29_ (GFile* f, Block1Data* _data1_) {
	gint result = 0;
	GFile* _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (f != NULL, 0);
	_tmp0_ = f;
	_tmp1_ = g_file_equal (_data1_->file, G_IS_FILE (_tmp0_) ? ((GFile*) _tmp0_) : NULL);
	if (_tmp1_) {
		result = 0;
		return result;
	} else {
		result = 1;
		return result;
	}
}


static gint __lambda29__gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = _lambda29_ (b, a);
	return result;
}


static void _lambda28_ (GtkCellRendererToggle* toggle, const gchar* path, AssistantRestoreMissing* self) {
	Block1Data* _data1_;
	GtkTreePath* _tmp0_ = NULL;
	GtkTreePath* tree_path;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	gchar* name = NULL;
	GFile* _tmp3_ = NULL;
	gboolean _tmp4_;
	GList* _tmp7_ = NULL;
	g_return_if_fail (toggle != NULL);
	g_return_if_fail (path != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = gtk_tree_path_new_from_string (path);
	tree_path = _tmp0_;
	gtk_tree_model_get_iter ((GtkTreeModel*) self->priv->listmodel, &_tmp1_, tree_path);
	self->priv->deleted_iter = _tmp1_;
	_tmp2_ = gtk_cell_renderer_toggle_get_active (toggle);
	gtk_list_store_set (self->priv->listmodel, &self->priv->deleted_iter, 0, !_tmp2_, -1);
	gtk_tree_model_get ((GtkTreeModel*) self->priv->listmodel, &self->priv->deleted_iter, 1, &name, -1);
	_tmp3_ = g_file_get_child (self->priv->list_directory, name);
	_data1_->file = _tmp3_;
	_tmp4_ = gtk_cell_renderer_toggle_get_active (toggle);
	if (_tmp4_) {
		GFile* _tmp5_;
		_tmp5_ = _g_object_ref0 (_data1_->file);
		((AssistantRestore*) self)->_restore_files = g_list_prepend (((AssistantRestore*) self)->_restore_files, _tmp5_);
	} else {
		GList* _tmp6_ = NULL;
		_tmp6_ = g_list_find_custom (((AssistantRestore*) self)->_restore_files, _data1_->file, __lambda29__gcompare_func);
		((AssistantRestore*) self)->_restore_files = g_list_remove_link (((AssistantRestore*) self)->_restore_files, _tmp6_);
	}
	_tmp7_ = assistant_restore_get_restore_files ((AssistantRestore*) self);
	assistant_allow_forward ((Assistant*) self, _tmp7_ != NULL);
	_g_free0 (name);
	_gtk_tree_path_free0 (tree_path);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static void __lambda28__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender, const gchar* path, gpointer self) {
	_lambda28_ (_sender, path, self);
}


static GtkWidget* assistant_restore_missing_make_listfiles_page (AssistantRestoreMissing* self) {
	GtkWidget* result = NULL;
	GtkBuilder* _tmp0_ = NULL;
	GtkBuilder* builder;
	gchar* _tmp1_ = NULL;
	gchar* gf;
	GObject* _tmp2_ = NULL;
	GObject* _tmp3_;
	GtkWidget* _tmp4_;
	GtkWidget* page;
	GObject* _tmp5_ = NULL;
	GObject* _tmp6_;
	GtkScrolledWindow* _tmp7_;
	GtkScrolledWindow* filelistwindow;
	GObject* _tmp8_ = NULL;
	GObject* _tmp9_;
	GtkBox* _tmp10_;
	GtkBox* status_table;
	GObject* _tmp11_ = NULL;
	GObject* _tmp12_;
	GtkBox* _tmp13_;
	GtkBox* progress_table;
	GObject* _tmp14_ = NULL;
	GObject* _tmp15_;
	GtkLabel* _tmp16_;
	GtkLabel* _tmp17_ = NULL;
	GtkListStore* _tmp18_ = NULL;
	GtkTreeView* _tmp19_ = NULL;
	GtkTreeView* treeview;
	GtkCellRendererToggle* _tmp20_ = NULL;
	GtkCellRendererToggle* toggle;
	const gchar* _tmp21_ = NULL;
	GtkCellRendererText* _tmp22_ = NULL;
	GtkCellRendererText* _tmp23_;
	const gchar* _tmp24_ = NULL;
	GtkCellRendererText* _tmp25_ = NULL;
	GtkCellRendererText* _tmp26_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_builder_new ();
	builder = _tmp0_;
	_tmp1_ = assistant_restore_missing_get_ui_file (self, "restore-missing.ui");
	gf = _tmp1_;
	if (gf == NULL) {
		g_warning ("AssistantRestoreMissing.vala:145: Error: Could not find interface file" \
".");
		result = NULL;
		_g_free0 (gf);
		_g_object_unref0 (builder);
		return result;
	}
	gtk_builder_add_from_file (builder, gf, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_free0 (gf);
		goto __catch2_g_error;
	}
	gtk_builder_connect_signals (builder, self);
	_tmp2_ = gtk_builder_get_object (builder, "restore-missing-files");
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (GTK_IS_WIDGET (_tmp3_) ? ((GtkWidget*) _tmp3_) : NULL);
	page = _tmp4_;
	_tmp5_ = gtk_builder_get_object (builder, "file-list-window");
	_tmp6_ = _tmp5_;
	_tmp7_ = _g_object_ref0 (GTK_IS_SCROLLED_WINDOW (_tmp6_) ? ((GtkScrolledWindow*) _tmp6_) : NULL);
	filelistwindow = _tmp7_;
	_tmp8_ = gtk_builder_get_object (builder, "folder-box");
	_tmp9_ = _tmp8_;
	_tmp10_ = _g_object_ref0 (GTK_IS_BOX (_tmp9_) ? ((GtkBox*) _tmp9_) : NULL);
	status_table = _tmp10_;
	_tmp11_ = gtk_builder_get_object (builder, "status-box");
	_tmp12_ = _tmp11_;
	_tmp13_ = _g_object_ref0 (GTK_IS_BOX (_tmp12_) ? ((GtkBox*) _tmp12_) : NULL);
	progress_table = _tmp13_;
	_tmp14_ = gtk_builder_get_object (builder, "status-label");
	_tmp15_ = _tmp14_;
	_tmp16_ = _g_object_ref0 (GTK_IS_LABEL (_tmp15_) ? ((GtkLabel*) _tmp15_) : NULL);
	_g_object_unref0 (self->priv->current_scan_date);
	self->priv->current_scan_date = _tmp16_;
	_tmp17_ = (GtkLabel*) gtk_label_new ("");
	_g_object_unref0 (self->priv->list_dir_label);
	self->priv->list_dir_label = g_object_ref_sink (_tmp17_);
	g_object_set ((GObject*) self->priv->list_dir_label, "xalign", 0.0f, NULL);
	gtk_box_pack_start (status_table, (GtkWidget*) self->priv->list_dir_label, TRUE, TRUE, (guint) 0);
	gtk_box_pack_end (progress_table, (GtkWidget*) self->priv->spinner, FALSE, FALSE, (guint) 0);
	gtk_widget_set_size_request ((GtkWidget*) self->priv->spinner, 20, 20);
	_tmp18_ = gtk_list_store_new (3, G_TYPE_BOOLEAN, G_TYPE_STRING, G_TYPE_STRING);
	_g_object_unref0 (self->priv->listmodel);
	self->priv->listmodel = _tmp18_;
	_tmp19_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) self->priv->listmodel);
	treeview = g_object_ref_sink (_tmp19_);
	_tmp20_ = (GtkCellRendererToggle*) gtk_cell_renderer_toggle_new ();
	toggle = g_object_ref_sink (_tmp20_);
	g_signal_connect_object (toggle, "toggled", (GCallback) __lambda28__gtk_cell_renderer_toggle_toggled, self, 0);
	gtk_tree_view_insert_column_with_attributes (treeview, -1, "    ", (GtkCellRenderer*) toggle, "active", 0, NULL);
	_tmp21_ = _ ("File");
	_tmp22_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp23_ = g_object_ref_sink (_tmp22_);
	gtk_tree_view_insert_column_with_attributes (treeview, -1, _tmp21_, (GtkCellRenderer*) _tmp23_, "text", 1, NULL);
	_g_object_unref0 (_tmp23_);
	_tmp24_ = _ ("Last seen");
	_tmp25_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp26_ = g_object_ref_sink (_tmp25_);
	gtk_tree_view_insert_column_with_attributes (treeview, -1, _tmp24_, (GtkCellRenderer*) _tmp26_, "text", 2, NULL);
	_g_object_unref0 (_tmp26_);
	gtk_tree_view_set_headers_visible (treeview, TRUE);
	gtk_scrolled_window_add_with_viewport (filelistwindow, (GtkWidget*) treeview);
	result = page;
	_g_object_unref0 (toggle);
	_g_object_unref0 (treeview);
	_g_object_unref0 (progress_table);
	_g_object_unref0 (status_table);
	_g_object_unref0 (filelistwindow);
	_g_free0 (gf);
	_g_object_unref0 (builder);
	return result;
	_g_object_unref0 (toggle);
	_g_object_unref0 (treeview);
	_g_object_unref0 (progress_table);
	_g_object_unref0 (status_table);
	_g_object_unref0 (filelistwindow);
	_g_object_unref0 (page);
	_g_free0 (gf);
	goto __finally2;
	__catch2_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("AssistantRestoreMissing.vala:197: %s", err->message);
		result = NULL;
		_g_error_free0 (err);
		_g_object_unref0 (builder);
		return result;
	}
	__finally2:
	_g_object_unref0 (builder);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


static void assistant_restore_missing_add_listfiles_page (AssistantRestoreMissing* self) {
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* page;
	const gchar* _tmp1_ = NULL;
	GtkWidget* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = assistant_restore_missing_make_listfiles_page (self);
	page = _tmp0_;
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_NORMAL);
	_tmp1_ = _ ("Restore which Files?");
	assistant_set_page_title ((Assistant*) self, page, _tmp1_);
	_tmp2_ = _g_object_ref0 (page);
	_g_object_unref0 (self->priv->listfiles_page);
	self->priv->listfiles_page = _tmp2_;
	_g_object_unref0 (page);
}


static void assistant_restore_missing_real_add_setup_pages (AssistantOperation* base) {
	AssistantRestoreMissing * self;
	self = (AssistantRestoreMissing*) base;
	assistant_restore_missing_add_listfiles_page (self);
}


static gboolean _lambda31_ (AssistantRestoreMissing* self) {
	gboolean result = FALSE;
	GList* _tmp0_ = NULL;
	_tmp0_ = assistant_restore_get_restore_files ((AssistantRestore*) self);
	assistant_allow_forward ((Assistant*) self, _tmp0_ != NULL);
	result = FALSE;
	return result;
}


static gboolean __lambda31__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda31_ (self);
	return result;
}


static void assistant_restore_missing_real_do_prepare (AssistantOperation* base, Assistant* assist, GtkWidget* page) {
	AssistantRestoreMissing * self;
	GtkWidget* _tmp0_ = NULL;
	self = (AssistantRestoreMissing*) base;
	g_return_if_fail (assist != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = assistant_operation_get_confirm_page ((AssistantOperation*) self);
	if (page == _tmp0_) {
		GList* _tmp1_ = NULL;
		GList* _tmp2_ = NULL;
		self->priv->scan_queue = FALSE;
		_tmp1_ = assistant_restore_get_restore_files ((AssistantRestore*) self);
		_tmp2_ = g_list_copy (_tmp1_);
		__g_list_free__g_object_unref0_0 (self->priv->restore_files_remaining);
		self->priv->restore_files_remaining = _tmp2_;
	} else {
		if (page == self->priv->listfiles_page) {
			gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			_tmp3_ = g_file_get_parse_name (self->priv->list_directory);
			_tmp4_ = _tmp3_;
			gtk_label_set_label (self->priv->list_dir_label, _tmp4_);
			_g_free0 (_tmp4_);
			if (!self->priv->scan_queue) {
				assistant_restore_missing_do_query_files_at_date (self);
				self->priv->scan_queue = TRUE;
			} else {
				gboolean _tmp5_ = FALSE;
				if (((AssistantRestore*) self)->query_op != NULL) {
					gboolean _tmp6_;
					_tmp6_ = deja_dup_operation_get_needs_password ((DejaDupOperation*) ((AssistantRestore*) self)->query_op);
					_tmp5_ = _tmp6_;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					assistant_operation_provide_password ((AssistantOperation*) self);
				} else {
					gboolean _tmp7_ = FALSE;
					if (self->priv->query_op_files != NULL) {
						gboolean _tmp8_;
						_tmp8_ = deja_dup_operation_get_needs_password ((DejaDupOperation*) self->priv->query_op_files);
						_tmp7_ = _tmp8_;
					} else {
						_tmp7_ = FALSE;
					}
					if (_tmp7_) {
						assistant_operation_provide_password ((AssistantOperation*) self);
					} else {
						if (!self->priv->backups_queue_filled) {
							assistant_restore_do_query ((AssistantRestore*) self, NULL, NULL);
						}
					}
				}
			}
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda31__gsource_func, g_object_ref (self), g_object_unref);
		}
	}
	ASSISTANT_OPERATION_CLASS (assistant_restore_missing_parent_class)->do_prepare ((AssistantOperation*) ASSISTANT_RESTORE (self), assist, page);
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}


static gpointer _deleted_file_ref0 (gpointer self) {
	return self ? deleted_file_ref (self) : NULL;
}


void assistant_restore_missing_handle_listed_files (AssistantRestoreMissing* self, DejaDupOperationFiles* op, const gchar* date, const gchar* file) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* filestr;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	g_return_if_fail (date != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = string_to_string (file);
	_tmp1_ = g_strconcat ("/", _tmp0_, NULL);
	filestr = _tmp1_;
	_tmp3_ = g_file_get_path (self->priv->list_directory);
	_tmp4_ = _tmp3_;
	_tmp5_ = string_contains (filestr, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	if (_tmp6_) {
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp7_ = g_file_get_path (self->priv->list_directory);
		_tmp8_ = _tmp7_;
		_tmp2_ = g_strcmp0 (_tmp8_, filestr) != 0;
		_g_free0 (_tmp8_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GFile* _tmp9_ = NULL;
		GFile* fileobj;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_;
		_tmp9_ = g_file_new_for_path (filestr);
		fileobj = _tmp9_;
		_tmp11_ = g_file_query_exists (fileobj, NULL);
		if (!_tmp11_) {
			gboolean _tmp12_;
			_tmp12_ = g_hash_table_lookup_extended (self->priv->allfiles_prev, filestr, NULL, NULL);
			_tmp10_ = !_tmp12_;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			gboolean _tmp13_;
			_tmp13_ = g_file_has_parent (fileobj, self->priv->list_directory);
			if (_tmp13_) {
				struct tm _tmp14_ = {0};
				DeletedFile* _tmp15_ = NULL;
				DeletedFile* fs;
				GtkTreeIter _tmp16_ = {0};
				gchar* _tmp17_ = NULL;
				gchar* _tmp18_;
				struct tm _tmp19_ = {0};
				gchar* _tmp20_ = NULL;
				gchar* _tmp21_;
				gchar* _tmp22_ = NULL;
				DeletedFile* _tmp23_;
				deja_dup_operation_files_get_time (op, &_tmp14_);
				_tmp15_ = deleted_file_new (filestr, &_tmp14_);
				fs = _tmp15_;
				gtk_list_store_append (self->priv->listmodel, &_tmp16_);
				self->priv->deleted_iter = _tmp16_;
				_tmp17_ = deleted_file_filename (fs);
				_tmp18_ = _tmp17_;
				deja_dup_operation_files_get_time (op, &_tmp19_);
				_tmp20_ = g_time_format (&_tmp19_, "%c");
				_tmp21_ = _tmp20_;
				gtk_list_store_set (self->priv->listmodel, &self->priv->deleted_iter, 0, FALSE, 1, _tmp18_, 2, _tmp21_, -1);
				_g_free0 (_tmp21_);
				_g_free0 (_tmp18_);
				_tmp22_ = g_file_get_path (fileobj);
				_tmp23_ = _deleted_file_ref0 (fs);
				g_hash_table_insert (self->priv->allfiles_prev, _tmp22_, _tmp23_);
				_deleted_file_unref0 (fs);
			}
		}
		_g_object_unref0 (fileobj);
	}
	_g_free0 (filestr);
}


static void g_time_local (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
	localtime_r (&time, &_tmp0_);
	_result_ = _tmp0_;
	*result = _result_;
	return;
}


static struct tm* _g_time_dup (struct tm* self) {
	struct tm* dup;
	dup = g_new0 (struct tm, 1);
	memcpy (dup, self, sizeof (struct tm));
	return dup;
}


static gpointer __g_time_dup0 (gpointer self) {
	return self ? _g_time_dup (self) : NULL;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _deleted_file_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (deleted_file_unref (var), NULL));
}


static void assistant_restore_missing_real_handle_collection_dates (AssistantRestore* base, DejaDupOperationStatus* op, GList* dates) {
	AssistantRestoreMissing * self;
	GTimeVal tv = {0};
	self = (AssistantRestoreMissing*) base;
	g_return_if_fail (op != NULL);
	g_get_current_time (&tv);
	if (!self->priv->backups_queue_filled) {
		GHashTable* _tmp6_ = NULL;
		{
			GList* date_collection;
			GList* date_it;
			date_collection = dates;
			for (date_it = date_collection; date_it != NULL; date_it = date_it->next) {
				gchar* _tmp0_;
				gchar* date;
				_tmp0_ = g_strdup ((const gchar*) date_it->data);
				date = _tmp0_;
				{
					gboolean _tmp1_;
					_tmp1_ = g_time_val_from_iso8601 (date, &tv);
					if (_tmp1_) {
						struct tm _tmp2_ = {0};
						struct tm _tmp3_ = {0};
						struct tm t;
						struct tm* _tmp4_;
						GSequenceIter* _tmp5_ = NULL;
						g_time_local ((time_t) tv.tv_sec, &_tmp2_);
						_tmp3_ = _tmp2_;
						t = _tmp3_;
						_tmp4_ = __g_time_dup0 (&t);
						_tmp5_ = g_sequence_insert_sorted (self->priv->backups_queue, _tmp4_, (GCompareDataFunc) assistant_restore_missing_compare_time, NULL);
					}
					_g_free0 (date);
				}
			}
		}
		_tmp6_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, _deleted_file_unref0_);
		_g_hash_table_unref0 (self->priv->allfiles_prev);
		self->priv->allfiles_prev = _tmp6_;
		self->priv->backups_queue_filled = TRUE;
		gtk_spinner_start (self->priv->spinner);
	}
}


static void _assistant_restore_missing_handle_listed_files_deja_dup_operation_files_listed_current_files (DejaDupOperationFiles* _sender, const gchar* date, const gchar* file, gpointer self) {
	assistant_restore_missing_handle_listed_files (self, _sender, date, file);
}


static void _assistant_restore_missing_query_files_finished_deja_dup_operation_done (DejaDupOperation* _sender, gboolean success, gboolean cancelled, gpointer self) {
	assistant_restore_missing_query_files_finished (self, _sender, success, cancelled);
}


static void _assistant_operation_get_passphrase_deja_dup_operation_passphrase_required (DejaDupOperation* _sender, gpointer self) {
	assistant_operation_get_passphrase (self);
}


static void _lambda30_ (DejaDupOperation* o, const gchar* e, const gchar* d, AssistantRestoreMissing* self) {
	g_return_if_fail (o != NULL);
	g_return_if_fail (e != NULL);
	assistant_operation_show_error ((AssistantOperation*) self, e, d);
}


static void __lambda30__deja_dup_operation_raise_error (DejaDupOperation* _sender, const gchar* errstr, const gchar* detail, gpointer self) {
	_lambda30_ (_sender, errstr, detail, self);
}


void assistant_restore_missing_do_query_files_at_date (AssistantRestoreMissing* self) {
	gint _tmp0_;
	GSequenceIter* _tmp1_ = NULL;
	GSequenceIter* begin;
	gconstpointer _tmp2_ = NULL;
	struct tm* _tmp3_;
	struct tm* etime;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint tepoch;
	GTimeVal ttoday = {0};
	gint ttodayi;
	gchar* worddiff = NULL;
	gint tdiff;
	GdkWindow* _tmp23_ = NULL;
	glong _tmp24_;
	glong xid;
	DejaDupOperationFiles* _tmp25_ = NULL;
	DejaDupOperation* _tmp26_;
	g_return_if_fail (self != NULL);
	if (self->priv->cancel_assistant) {
		assistant_operation_do_close ((AssistantOperation*) self);
		return;
	}
	_tmp0_ = g_sequence_get_length (self->priv->backups_queue);
	if (_tmp0_ == 0) {
		assistant_restore_missing_query_files_finished (self, (DejaDupOperation*) self->priv->query_op_files, TRUE, FALSE);
		return;
	}
	_tmp1_ = g_sequence_get_begin_iter (self->priv->backups_queue);
	begin = _tmp1_;
	_tmp2_ = g_sequence_get (begin);
	_tmp3_ = __g_time_dup0 ((struct tm*) _tmp2_);
	etime = _tmp3_;
	g_sequence_remove (begin);
	_tmp4_ = g_time_format (etime, "%s");
	_tmp5_ = _tmp4_;
	_tmp6_ = atoi (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	tepoch = _tmp7_;
	g_get_current_time (&ttoday);
	g_get_current_time (&ttoday);
	ttodayi = (gint) ttoday.tv_sec;
	tdiff = ((ttodayi - tepoch) / 60) / 60;
	if ((tdiff / 24) == 0) {
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		_tmp8_ = _ ("Scanning for files from yesterday…");
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (worddiff);
		worddiff = _tmp9_;
	} else {
		if (((tdiff / 24) / 7) == 0) {
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			_tmp10_ = _ ("Scanning for files from last week…");
			_tmp11_ = g_strdup (_tmp10_);
			_g_free0 (worddiff);
			worddiff = _tmp11_;
		} else {
			if (((tdiff / 24) / 30) == 0) {
				const gchar* _tmp12_ = NULL;
				gchar* _tmp13_;
				_tmp12_ = _ ("Scanning for files from last month…");
				_tmp13_ = g_strdup (_tmp12_);
				_g_free0 (worddiff);
				worddiff = _tmp13_;
			} else {
				gboolean _tmp14_ = FALSE;
				if (((tdiff / 24) / 30) >= 1) {
					_tmp14_ = ((tdiff / 24) / 30) <= 12;
				} else {
					_tmp14_ = FALSE;
				}
				if (_tmp14_) {
					gint n;
					gchar* _tmp15_ = NULL;
					gchar* _tmp16_;
					const gchar* _tmp17_ = NULL;
					gchar* _tmp18_;
					n = (tdiff / 24) / 30;
					_tmp15_ = g_strdup_printf ("Scanning for files from about %d months ago…", n);
					_tmp16_ = _tmp15_;
					_tmp17_ = ngettext ("Scanning for files from about a month ago…", _tmp16_, (gulong) n);
					_tmp18_ = g_strdup (_tmp17_);
					_g_free0 (worddiff);
					worddiff = _tmp18_;
					_g_free0 (_tmp16_);
				} else {
					gint n;
					gchar* _tmp19_ = NULL;
					gchar* _tmp20_;
					const gchar* _tmp21_ = NULL;
					gchar* _tmp22_;
					n = ((tdiff / 24) / 30) / 12;
					_tmp19_ = g_strdup_printf ("Scanning for files from about %d years ago…", n);
					_tmp20_ = _tmp19_;
					_tmp21_ = ngettext ("Scanning for files from about a year ago…", _tmp20_, (gulong) n);
					_tmp22_ = g_strdup (_tmp21_);
					_g_free0 (worddiff);
					worddiff = _tmp22_;
					_g_free0 (_tmp20_);
				}
			}
		}
	}
	gtk_label_set_text (self->priv->current_scan_date, worddiff);
	gtk_widget_realize ((GtkWidget*) self);
	_tmp23_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp24_ = hacks_window_get_xid (_tmp23_);
	xid = _tmp24_;
	_tmp25_ = deja_dup_operation_files_new ((guint) xid, etime, self->priv->list_directory);
	_g_object_unref0 (self->priv->query_op_files);
	self->priv->query_op_files = _tmp25_;
	g_signal_connect_object (self->priv->query_op_files, "listed-current-files", (GCallback) _assistant_restore_missing_handle_listed_files_deja_dup_operation_files_listed_current_files, self, 0);
	g_signal_connect_object ((DejaDupOperation*) self->priv->query_op_files, "done", (GCallback) _assistant_restore_missing_query_files_finished_deja_dup_operation_done, self, 0);
	_tmp26_ = _g_object_ref0 ((DejaDupOperation*) self->priv->query_op_files);
	_g_object_unref0 (((AssistantOperation*) self)->op);
	((AssistantOperation*) self)->op = _tmp26_;
	g_signal_connect_object (((AssistantOperation*) self)->op, "passphrase-required", (GCallback) _assistant_operation_get_passphrase_deja_dup_operation_passphrase_required, (AssistantOperation*) self, 0);
	g_signal_connect_object (((AssistantOperation*) self)->op, "raise-error", (GCallback) __lambda30__deja_dup_operation_raise_error, self, 0);
	deja_dup_operation_set_state (((AssistantOperation*) self)->op, ((AssistantRestore*) self)->op_state);
	deja_dup_operation_start ((DejaDupOperation*) self->priv->query_op_files, NULL, NULL);
	_g_free0 (worddiff);
	_g_free0 (etime);
}


static void assistant_restore_missing_real_query_finished (AssistantRestore* base, DejaDupOperation* op, gboolean success, gboolean cancelled) {
	AssistantRestoreMissing * self;
	DejaDupOperationState* _tmp0_ = NULL;
	self = (AssistantRestoreMissing*) base;
	g_return_if_fail (op != NULL);
	_g_object_unref0 (((AssistantRestore*) self)->query_op);
	((AssistantRestore*) self)->query_op = NULL;
	_tmp0_ = deja_dup_operation_get_state (((AssistantOperation*) self)->op);
	_deja_dup_operation_state_unref0 (((AssistantRestore*) self)->op_state);
	((AssistantRestore*) self)->op_state = _tmp0_;
	_g_object_unref0 (((AssistantOperation*) self)->op);
	((AssistantOperation*) self)->op = NULL;
	if (cancelled) {
		assistant_operation_do_close ((AssistantOperation*) self);
	} else {
		if (success) {
			assistant_restore_missing_do_query_files_at_date (self);
		}
	}
}


static void assistant_restore_missing_real_do_cancel (AssistantOperation* base) {
	AssistantRestoreMissing * self;
	self = (AssistantRestoreMissing*) base;
	self->priv->cancel_assistant = TRUE;
	ASSISTANT_OPERATION_CLASS (assistant_restore_missing_parent_class)->do_cancel ((AssistantOperation*) ASSISTANT_RESTORE (self));
}


static void assistant_restore_missing_real_apply_finished (AssistantOperation* base, DejaDupOperation* op, gboolean success, gboolean cancelled) {
	AssistantRestoreMissing * self;
	self = (AssistantRestoreMissing*) base;
	g_return_if_fail (op != NULL);
	_g_object_unref0 (((AssistantOperation*) self)->op);
	((AssistantOperation*) self)->op = NULL;
	if (cancelled) {
		if (success) {
			gtk_main_quit ();
		} else {
			assistant_operation_do_close ((AssistantOperation*) self);
		}
	} else {
		if (success) {
			((AssistantOperation*) self)->succeeded = TRUE;
			if (self->priv->restore_files_remaining != NULL) {
				assistant_operation_do_apply ((AssistantOperation*) ASSISTANT_RESTORE (self), NULL, NULL);
			} else {
				GtkWidget* _tmp0_ = NULL;
				_tmp0_ = assistant_operation_get_summary_page ((AssistantOperation*) self);
				assistant_go_to_page ((Assistant*) self, _tmp0_);
			}
		} else {
			assistant_operation_force_visible ((AssistantOperation*) self, FALSE);
		}
	}
}


void assistant_restore_missing_query_files_finished (AssistantRestoreMissing* self, DejaDupOperation* op, gboolean success, gboolean cancelled) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->priv->query_op_files);
	self->priv->query_op_files = NULL;
	_g_object_unref0 (((AssistantOperation*) self)->op);
	((AssistantOperation*) self)->op = NULL;
	_tmp0_ = g_sequence_get_length (self->priv->backups_queue);
	if (_tmp0_ == 0) {
		const gchar* _tmp1_ = NULL;
		gtk_spinner_stop (self->priv->spinner);
		hacks_widget_destroy ((GtkWidget*) self->priv->spinner);
		_tmp1_ = _ ("Scanning finished");
		gtk_label_set_text (self->priv->current_scan_date, _tmp1_);
		self->priv->scan_queue = FALSE;
	} else {
		if (self->priv->scan_queue) {
			assistant_restore_missing_do_query_files_at_date (self);
		}
	}
}


static DejaDupOperation* assistant_restore_missing_real_create_op (AssistantOperation* base) {
	AssistantRestoreMissing * self;
	DejaDupOperation* result = NULL;
	GdkWindow* _tmp0_ = NULL;
	glong _tmp1_;
	glong xid;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gconstpointer _tmp4_ = NULL;
	DeletedFile* _tmp5_;
	DeletedFile* _tmp6_;
	DeletedFile* restore_file;
	GList* file_list;
	const gchar* _tmp7_ = NULL;
	GFile* _tmp8_ = NULL;
	struct tm _tmp9_ = {0};
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	DejaDupOperationRestore* _tmp12_ = NULL;
	DejaDupOperationRestore* _tmp13_;
	DejaDupOperationRestore* rest_op;
	self = (AssistantRestoreMissing*) base;
	gtk_widget_realize ((GtkWidget*) self);
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp1_ = hacks_window_get_xid (_tmp0_);
	xid = _tmp1_;
	_tmp2_ = g_file_get_path ((GFile*) self->priv->restore_files_remaining->data);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_hash_table_lookup (self->priv->allfiles_prev, _tmp3_);
	_tmp5_ = _deleted_file_ref0 ((DeletedFile*) _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp3_);
	restore_file = _tmp6_;
	self->priv->restore_files_remaining = g_list_remove_link (self->priv->restore_files_remaining, self->priv->restore_files_remaining);
	file_list = NULL;
	_tmp7_ = deleted_file_get_name (restore_file);
	_tmp8_ = g_file_new_for_path (_tmp7_);
	file_list = g_list_append (file_list, _tmp8_);
	deleted_file_get_deleted (restore_file, &_tmp9_);
	_tmp10_ = g_time_format (&_tmp9_, "%s");
	_tmp11_ = _tmp10_;
	_tmp12_ = deja_dup_operation_restore_new ("/", _tmp11_, file_list, (guint) xid);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	rest_op = _tmp13_;
	deja_dup_operation_set_state ((DejaDupOperation*) rest_op, ((AssistantRestore*) self)->op_state);
	result = (DejaDupOperation*) rest_op;
	__g_list_free__g_object_unref0_0 (file_list);
	_deleted_file_unref0 (restore_file);
	return result;
}


static void assistant_restore_missing_class_init (AssistantRestoreMissingClass * klass) {
	assistant_restore_missing_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AssistantRestoreMissingPrivate));
	ASSISTANT_OPERATION_CLASS (klass)->add_setup_pages = assistant_restore_missing_real_add_setup_pages;
	ASSISTANT_OPERATION_CLASS (klass)->do_prepare = assistant_restore_missing_real_do_prepare;
	ASSISTANT_RESTORE_CLASS (klass)->handle_collection_dates = assistant_restore_missing_real_handle_collection_dates;
	ASSISTANT_RESTORE_CLASS (klass)->query_finished = assistant_restore_missing_real_query_finished;
	ASSISTANT_OPERATION_CLASS (klass)->do_cancel = assistant_restore_missing_real_do_cancel;
	ASSISTANT_OPERATION_CLASS (klass)->apply_finished = assistant_restore_missing_real_apply_finished;
	ASSISTANT_OPERATION_CLASS (klass)->create_op = assistant_restore_missing_real_create_op;
	G_OBJECT_CLASS (klass)->finalize = assistant_restore_missing_finalize;
}


static void assistant_restore_missing_instance_init (AssistantRestoreMissing * self) {
	GSequence* _tmp0_ = NULL;
	GtkSpinner* _tmp1_ = NULL;
	self->priv = ASSISTANT_RESTORE_MISSING_GET_PRIVATE (self);
	self->priv->backups_queue_filled = FALSE;
	self->priv->scan_queue = TRUE;
	self->priv->cancel_assistant = FALSE;
	_tmp0_ = g_sequence_new (g_free);
	self->priv->backups_queue = _tmp0_;
	_tmp1_ = (GtkSpinner*) gtk_spinner_new ();
	self->priv->spinner = g_object_ref_sink (_tmp1_);
}


static void assistant_restore_missing_finalize (GObject* obj) {
	AssistantRestoreMissing * self;
	self = ASSISTANT_RESTORE_MISSING (obj);
	_g_object_unref0 (self->priv->list_directory);
	_g_sequence_free0 (self->priv->backups_queue);
	_g_hash_table_unref0 (self->priv->allfiles_prev);
	__g_list_free__g_object_unref0_0 (self->priv->restore_files_remaining);
	_g_object_unref0 (self->priv->query_op_files);
	_g_object_unref0 (self->priv->listfiles_page);
	_g_object_unref0 (self->priv->listmodel);
	_g_object_unref0 (self->priv->list_dir_label);
	_g_object_unref0 (self->priv->current_scan_date);
	_g_object_unref0 (self->priv->spinner);
	G_OBJECT_CLASS (assistant_restore_missing_parent_class)->finalize (obj);
}


GType assistant_restore_missing_get_type (void) {
	static volatile gsize assistant_restore_missing_type_id__volatile = 0;
	if (g_once_init_enter (&assistant_restore_missing_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AssistantRestoreMissingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) assistant_restore_missing_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AssistantRestoreMissing), 0, (GInstanceInitFunc) assistant_restore_missing_instance_init, NULL };
		GType assistant_restore_missing_type_id;
		assistant_restore_missing_type_id = g_type_register_static (TYPE_ASSISTANT_RESTORE, "AssistantRestoreMissing", &g_define_type_info, 0);
		g_once_init_leave (&assistant_restore_missing_type_id__volatile, assistant_restore_missing_type_id);
	}
	return assistant_restore_missing_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



