/* StatusIcon.c generated by valac 0.12.0, the Vala compiler
 * generated from StatusIcon.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    © 2009–2010 Michael Terry <mike@mterry.name>

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <common.h>
#include <glib/gi18n-lib.h>
#include <chacks.h>
#include <whacks.h>
#include <libnotify/notify.h>


#define TYPE_STATUS_ICON (status_icon_get_type ())
#define STATUS_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STATUS_ICON, StatusIcon))
#define STATUS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STATUS_ICON, StatusIconClass))
#define IS_STATUS_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STATUS_ICON))
#define IS_STATUS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STATUS_ICON))
#define STATUS_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STATUS_ICON, StatusIconClass))

typedef struct _StatusIcon StatusIcon;
typedef struct _StatusIconClass StatusIconClass;
typedef struct _StatusIconPrivate StatusIconPrivate;

#define STATUS_ICON_TYPE_CLOSE_ACTION (status_icon_close_action_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_UNITY_STATUS_ICON (unity_status_icon_get_type ())
#define UNITY_STATUS_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNITY_STATUS_ICON, UnityStatusIcon))
#define UNITY_STATUS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNITY_STATUS_ICON, UnityStatusIconClass))
#define IS_UNITY_STATUS_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNITY_STATUS_ICON))
#define IS_UNITY_STATUS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNITY_STATUS_ICON))
#define UNITY_STATUS_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNITY_STATUS_ICON, UnityStatusIconClass))

typedef struct _UnityStatusIcon UnityStatusIcon;
typedef struct _UnityStatusIconClass UnityStatusIconClass;

#define TYPE_SHELL_STATUS_ICON (shell_status_icon_get_type ())
#define SHELL_STATUS_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SHELL_STATUS_ICON, ShellStatusIcon))
#define SHELL_STATUS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SHELL_STATUS_ICON, ShellStatusIconClass))
#define IS_SHELL_STATUS_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SHELL_STATUS_ICON))
#define IS_SHELL_STATUS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SHELL_STATUS_ICON))
#define SHELL_STATUS_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SHELL_STATUS_ICON, ShellStatusIconClass))

typedef struct _ShellStatusIcon ShellStatusIcon;
typedef struct _ShellStatusIconClass ShellStatusIconClass;

#define TYPE_INDICATOR_STATUS_ICON (indicator_status_icon_get_type ())
#define INDICATOR_STATUS_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INDICATOR_STATUS_ICON, IndicatorStatusIcon))
#define INDICATOR_STATUS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_INDICATOR_STATUS_ICON, IndicatorStatusIconClass))
#define IS_INDICATOR_STATUS_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INDICATOR_STATUS_ICON))
#define IS_INDICATOR_STATUS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_INDICATOR_STATUS_ICON))
#define INDICATOR_STATUS_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_INDICATOR_STATUS_ICON, IndicatorStatusIconClass))

typedef struct _IndicatorStatusIcon IndicatorStatusIcon;
typedef struct _IndicatorStatusIconClass IndicatorStatusIconClass;

#define TYPE_LEGACY_STATUS_ICON (legacy_status_icon_get_type ())
#define LEGACY_STATUS_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LEGACY_STATUS_ICON, LegacyStatusIcon))
#define LEGACY_STATUS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LEGACY_STATUS_ICON, LegacyStatusIconClass))
#define IS_LEGACY_STATUS_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LEGACY_STATUS_ICON))
#define IS_LEGACY_STATUS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LEGACY_STATUS_ICON))
#define LEGACY_STATUS_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LEGACY_STATUS_ICON, LegacyStatusIconClass))

typedef struct _LegacyStatusIcon LegacyStatusIcon;
typedef struct _LegacyStatusIconClass LegacyStatusIconClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _UnityStatusIconPrivate UnityStatusIconPrivate;
typedef struct _IndicatorStatusIconPrivate IndicatorStatusIconPrivate;
typedef struct _ShellStatusIconPrivate ShellStatusIconPrivate;
typedef struct _LegacyStatusIconPrivate LegacyStatusIconPrivate;

struct _StatusIcon {
	GObject parent_instance;
	StatusIconPrivate * priv;
	gboolean is_valid;
	gchar* action;
	gdouble progress;
	gchar* later_label;
	gchar* skip_label;
	GtkMenu* menu;
};

struct _StatusIconClass {
	GObjectClass parent_class;
	void (*update_progress) (StatusIcon* self);
};

typedef enum  {
	STATUS_ICON_CLOSE_ACTION_HIDE,
	STATUS_ICON_CLOSE_ACTION_MINIMIZE
} StatusIconCloseAction;

struct _StatusIconPrivate {
	GtkWindow* _window;
	DejaDupOperation* _op;
	gboolean _automatic;
	StatusIconCloseAction _close_action;
	gboolean _show_automatic_progress;
};

struct _UnityStatusIcon {
	StatusIcon parent_instance;
	UnityStatusIconPrivate * priv;
};

struct _UnityStatusIconClass {
	StatusIconClass parent_class;
};

struct _UnityStatusIconPrivate {
	GObject* entry;
};

struct _IndicatorStatusIcon {
	StatusIcon parent_instance;
	IndicatorStatusIconPrivate * priv;
};

struct _IndicatorStatusIconClass {
	StatusIconClass parent_class;
};

struct _IndicatorStatusIconPrivate {
	GObject* indicator;
};

struct _ShellStatusIcon {
	StatusIcon parent_instance;
	ShellStatusIconPrivate * priv;
};

struct _ShellStatusIconClass {
	StatusIconClass parent_class;
};

struct _ShellStatusIconPrivate {
	gboolean persistence;
	gboolean actions;
};

struct _LegacyStatusIcon {
	StatusIcon parent_instance;
	LegacyStatusIconPrivate * priv;
};

struct _LegacyStatusIconClass {
	StatusIconClass parent_class;
};

struct _LegacyStatusIconPrivate {
	GtkStatusIcon* icon;
};


static gpointer status_icon_parent_class = NULL;
static gpointer unity_status_icon_parent_class = NULL;
static gpointer indicator_status_icon_parent_class = NULL;
static gpointer shell_status_icon_parent_class = NULL;
static gpointer legacy_status_icon_parent_class = NULL;

GType status_icon_get_type (void) G_GNUC_CONST;
GType status_icon_close_action_get_type (void) G_GNUC_CONST;
#define STATUS_ICON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_STATUS_ICON, StatusIconPrivate))
enum  {
	STATUS_ICON_DUMMY_PROPERTY,
	STATUS_ICON_WINDOW,
	STATUS_ICON_OP,
	STATUS_ICON_AUTOMATIC,
	STATUS_ICON_CLOSE_ACTION,
	STATUS_ICON_SHOW_AUTOMATIC_PROGRESS
};
StatusIcon* status_icon_create (GtkWindow* window, DejaDupOperation* op, gboolean automatic);
UnityStatusIcon* unity_status_icon_new (GtkWindow* window, DejaDupOperation* op, gboolean automatic);
UnityStatusIcon* unity_status_icon_construct (GType object_type, GtkWindow* window, DejaDupOperation* op, gboolean automatic);
GType unity_status_icon_get_type (void) G_GNUC_CONST;
ShellStatusIcon* shell_status_icon_new (GtkWindow* window, DejaDupOperation* op, gboolean automatic);
ShellStatusIcon* shell_status_icon_construct (GType object_type, GtkWindow* window, DejaDupOperation* op, gboolean automatic);
GType shell_status_icon_get_type (void) G_GNUC_CONST;
IndicatorStatusIcon* indicator_status_icon_new (GtkWindow* window, DejaDupOperation* op, gboolean automatic);
IndicatorStatusIcon* indicator_status_icon_construct (GType object_type, GtkWindow* window, DejaDupOperation* op, gboolean automatic);
GType indicator_status_icon_get_type (void) G_GNUC_CONST;
LegacyStatusIcon* legacy_status_icon_new (GtkWindow* window, DejaDupOperation* op, gboolean automatic);
LegacyStatusIcon* legacy_status_icon_construct (GType object_type, GtkWindow* window, DejaDupOperation* op, gboolean automatic);
GType legacy_status_icon_get_type (void) G_GNUC_CONST;
static void status_icon_set_action_desc (StatusIcon* self, DejaDupOperation* op, const gchar* action);
void status_icon_update_progress (StatusIcon* self);
static void status_icon_note_progress (StatusIcon* self, DejaDupOperation* op, gdouble progress);
static void status_icon_real_update_progress (StatusIcon* self);
void status_icon_later (StatusIcon* self);
DejaDupOperation* status_icon_get_op (StatusIcon* self);
void status_icon_skip (StatusIcon* self);
GtkMenu* status_icon_ensure_menu (StatusIcon* self, gboolean show_self);
static void _lambda0_ (GtkMenuItem* i, StatusIcon* self);
static void __lambda0__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _lambda1_ (GtkMenuItem* i, StatusIcon* self);
static void __lambda1__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
gboolean status_icon_get_automatic (StatusIcon* self);
static void _lambda2_ (GtkMenuItem* i, StatusIcon* self);
static void __lambda2__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
StatusIcon* status_icon_construct (GType object_type);
GtkWindow* status_icon_get_window (StatusIcon* self);
static void status_icon_set_window (StatusIcon* self, GtkWindow* value);
static void status_icon_set_op (StatusIcon* self, DejaDupOperation* value);
static void status_icon_set_automatic (StatusIcon* self, gboolean value);
StatusIconCloseAction status_icon_get_close_action (StatusIcon* self);
void status_icon_set_close_action (StatusIcon* self, StatusIconCloseAction value);
gboolean status_icon_get_show_automatic_progress (StatusIcon* self);
void status_icon_set_show_automatic_progress (StatusIcon* self, gboolean value);
static GObject * status_icon_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _status_icon_set_action_desc_deja_dup_operation_action_desc_changed (DejaDupOperation* _sender, const gchar* action, gpointer self);
static void _status_icon_note_progress_deja_dup_operation_progress (DejaDupOperation* _sender, gdouble percent, gpointer self);
static void status_icon_finalize (GObject* obj);
static void _vala_status_icon_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_status_icon_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define UNITY_STATUS_ICON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_UNITY_STATUS_ICON, UnityStatusIconPrivate))
enum  {
	UNITY_STATUS_ICON_DUMMY_PROPERTY
};
static void unity_status_icon_real_update_progress (StatusIcon* base);
static GObject * unity_status_icon_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void unity_status_icon_finalize (GObject* obj);
#define INDICATOR_STATUS_ICON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_INDICATOR_STATUS_ICON, IndicatorStatusIconPrivate))
enum  {
	INDICATOR_STATUS_ICON_DUMMY_PROPERTY
};
static GObject * indicator_status_icon_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void indicator_status_icon_finalize (GObject* obj);
#define SHELL_STATUS_ICON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SHELL_STATUS_ICON, ShellStatusIconPrivate))
enum  {
	SHELL_STATUS_ICON_DUMMY_PROPERTY
};
static GObject * shell_status_icon_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _lambda3_ (ShellStatusIcon* self);
static void __lambda3__notify_action_callback (NotifyNotification* notification, const gchar* action, gpointer self);
static void _lambda4_ (ShellStatusIcon* self);
static void __lambda4__notify_action_callback (NotifyNotification* notification, const gchar* action, gpointer self);
static void shell_status_icon_finalize (GObject* obj);
#define LEGACY_STATUS_ICON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LEGACY_STATUS_ICON, LegacyStatusIconPrivate))
enum  {
	LEGACY_STATUS_ICON_DUMMY_PROPERTY
};
static void legacy_status_icon_real_update_progress (StatusIcon* base);
static void legacy_status_icon_show_menu (LegacyStatusIcon* self, GtkStatusIcon* status_icon, guint button, guint activate_time);
static void _gtk_status_icon_position_menu_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self);
static GObject * legacy_status_icon_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _legacy_status_icon_show_menu_gtk_status_icon_popup_menu (GtkStatusIcon* _sender, guint button, guint activate_time, gpointer self);
static void _lambda5_ (GtkStatusIcon* s, LegacyStatusIcon* self);
static void __lambda5__gtk_status_icon_activate (GtkStatusIcon* _sender, gpointer self);
static void legacy_status_icon_finalize (GObject* obj);


GType status_icon_close_action_get_type (void) {
	static volatile gsize status_icon_close_action_type_id__volatile = 0;
	if (g_once_init_enter (&status_icon_close_action_type_id__volatile)) {
		static const GEnumValue values[] = {{STATUS_ICON_CLOSE_ACTION_HIDE, "STATUS_ICON_CLOSE_ACTION_HIDE", "hide"}, {STATUS_ICON_CLOSE_ACTION_MINIMIZE, "STATUS_ICON_CLOSE_ACTION_MINIMIZE", "minimize"}, {0, NULL, NULL}};
		GType status_icon_close_action_type_id;
		status_icon_close_action_type_id = g_enum_register_static ("StatusIconCloseAction", values);
		g_once_init_leave (&status_icon_close_action_type_id__volatile, status_icon_close_action_type_id);
	}
	return status_icon_close_action_type_id__volatile;
}


StatusIcon* status_icon_create (GtkWindow* window, DejaDupOperation* op, gboolean automatic) {
	StatusIcon* result = NULL;
	StatusIcon* instance = NULL;
	UnityStatusIcon* _tmp0_ = NULL;
	g_return_val_if_fail (window != NULL, NULL);
	g_return_val_if_fail (op != NULL, NULL);
	_tmp0_ = unity_status_icon_new (window, op, automatic);
	_g_object_unref0 (instance);
	instance = (StatusIcon*) _tmp0_;
	if (!instance->is_valid) {
		ShellStatusIcon* _tmp1_ = NULL;
		_tmp1_ = shell_status_icon_new (window, op, automatic);
		_g_object_unref0 (instance);
		instance = (StatusIcon*) _tmp1_;
	}
	if (!instance->is_valid) {
		IndicatorStatusIcon* _tmp2_ = NULL;
		_tmp2_ = indicator_status_icon_new (window, op, automatic);
		_g_object_unref0 (instance);
		instance = (StatusIcon*) _tmp2_;
	}
	if (!instance->is_valid) {
		LegacyStatusIcon* _tmp3_ = NULL;
		_tmp3_ = legacy_status_icon_new (window, op, automatic);
		_g_object_unref0 (instance);
		instance = (StatusIcon*) _tmp3_;
	}
	result = instance;
	return result;
}


static void status_icon_set_action_desc (StatusIcon* self, DejaDupOperation* op, const gchar* action) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_strdup (action);
	_g_free0 (self->action);
	self->action = _tmp0_;
	status_icon_update_progress (self);
}


static void status_icon_note_progress (StatusIcon* self, DejaDupOperation* op, gdouble progress) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	self->progress = progress;
	status_icon_update_progress (self);
}


static void status_icon_real_update_progress (StatusIcon* self) {
	g_return_if_fail (self != NULL);
}


void status_icon_update_progress (StatusIcon* self) {
	STATUS_ICON_GET_CLASS (self)->update_progress (self);
}


void status_icon_later (StatusIcon* self) {
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "hide-all");
	deja_dup_operation_stop (self->priv->_op);
}


void status_icon_skip (StatusIcon* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "hide-all");
	deja_dup_update_last_run_timestamp (&_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch7_g_error;
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("StatusIcon.vala:133: %s\n", e->message);
		_g_error_free0 (e);
	}
	__finally7:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	deja_dup_operation_cancel (self->priv->_op);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _lambda0_ (GtkMenuItem* i, StatusIcon* self) {
	g_return_if_fail (i != NULL);
	g_signal_emit_by_name (self, "show-window");
}


static void __lambda0__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda0_ (_sender, self);
}


static void _lambda1_ (GtkMenuItem* i, StatusIcon* self) {
	g_return_if_fail (i != NULL);
	status_icon_later (self);
}


static void __lambda1__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda1_ (_sender, self);
}


static void _lambda2_ (GtkMenuItem* i, StatusIcon* self) {
	g_return_if_fail (i != NULL);
	status_icon_skip (self);
}


static void __lambda2__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda2_ (_sender, self);
}


GtkMenu* status_icon_ensure_menu (StatusIcon* self, gboolean show_self) {
	GtkMenu* result = NULL;
	GtkMenu* _tmp1_ = NULL;
	DejaDupOperationMode _tmp6_;
	GtkMenu* _tmp11_;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->menu != NULL) {
		GtkMenu* _tmp0_;
		_tmp0_ = _g_object_ref0 (self->menu);
		result = _tmp0_;
		return result;
	}
	_tmp1_ = (GtkMenu*) gtk_menu_new ();
	_g_object_unref0 (self->menu);
	self->menu = g_object_ref_sink (_tmp1_);
	if (show_self) {
		GtkImageMenuItem* imageitem = NULL;
		const gchar* _tmp2_ = NULL;
		GtkImageMenuItem* _tmp3_ = NULL;
		GtkImage* _tmp4_ = NULL;
		GtkImage* _tmp5_;
		_tmp2_ = _ ("Déjà Du_p");
		_tmp3_ = (GtkImageMenuItem*) gtk_image_menu_item_new_with_mnemonic (_tmp2_);
		_g_object_unref0 (imageitem);
		imageitem = g_object_ref_sink (_tmp3_);
		_tmp4_ = (GtkImage*) gtk_image_new_from_icon_name ("deja-dup-symbolic", GTK_ICON_SIZE_MENU);
		_tmp5_ = g_object_ref_sink (_tmp4_);
		gtk_image_menu_item_set_image (imageitem, (GtkWidget*) _tmp5_);
		_g_object_unref0 (_tmp5_);
		gtk_image_menu_item_set_always_show_image (imageitem, TRUE);
		g_signal_connect_object ((GtkMenuItem*) imageitem, "activate", (GCallback) __lambda0__gtk_menu_item_activate, self, 0);
		gtk_menu_shell_append ((GtkMenuShell*) self->menu, (GtkWidget*) ((GtkMenuItem*) imageitem));
		_g_object_unref0 (imageitem);
	}
	_tmp6_ = deja_dup_operation_get_mode (self->priv->_op);
	if (_tmp6_ == DEJA_DUP_OPERATION_MODE_BACKUP) {
		GtkMenuItem* item = NULL;
		GtkMenuItem* _tmp9_ = NULL;
		if (show_self) {
			GtkSeparatorMenuItem* _tmp7_ = NULL;
			GtkSeparatorMenuItem* _tmp8_;
			_tmp7_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
			_tmp8_ = g_object_ref_sink (_tmp7_);
			gtk_menu_shell_append ((GtkMenuShell*) self->menu, (GtkWidget*) ((GtkMenuItem*) _tmp8_));
			_g_object_unref0 (_tmp8_);
		}
		_tmp9_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (self->later_label);
		_g_object_unref0 (item);
		item = g_object_ref_sink (_tmp9_);
		g_signal_connect_object (item, "activate", (GCallback) __lambda1__gtk_menu_item_activate, self, 0);
		gtk_menu_shell_append ((GtkMenuShell*) self->menu, (GtkWidget*) item);
		if (self->priv->_automatic) {
			GtkMenuItem* _tmp10_ = NULL;
			_tmp10_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (self->skip_label);
			_g_object_unref0 (item);
			item = g_object_ref_sink (_tmp10_);
			g_signal_connect_object (item, "activate", (GCallback) __lambda2__gtk_menu_item_activate, self, 0);
			gtk_menu_shell_append ((GtkMenuShell*) self->menu, (GtkWidget*) item);
		}
		_g_object_unref0 (item);
	}
	status_icon_update_progress (self);
	gtk_widget_show_all ((GtkWidget*) self->menu);
	_tmp11_ = _g_object_ref0 (self->menu);
	result = _tmp11_;
	return result;
}


StatusIcon* status_icon_construct (GType object_type) {
	StatusIcon * self = NULL;
	self = (StatusIcon*) g_object_new (object_type, NULL);
	return self;
}


GtkWindow* status_icon_get_window (StatusIcon* self) {
	GtkWindow* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_window;
	return result;
}


static void status_icon_set_window (StatusIcon* self, GtkWindow* value) {
	GtkWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_window);
	self->priv->_window = _tmp0_;
	g_object_notify ((GObject *) self, "window");
}


DejaDupOperation* status_icon_get_op (StatusIcon* self) {
	DejaDupOperation* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_op;
	return result;
}


static void status_icon_set_op (StatusIcon* self, DejaDupOperation* value) {
	DejaDupOperation* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_op);
	self->priv->_op = _tmp0_;
	g_object_notify ((GObject *) self, "op");
}


gboolean status_icon_get_automatic (StatusIcon* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_automatic;
	return result;
}


static void status_icon_set_automatic (StatusIcon* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_automatic = value;
	g_object_notify ((GObject *) self, "automatic");
}


StatusIconCloseAction status_icon_get_close_action (StatusIcon* self) {
	StatusIconCloseAction result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_close_action;
	return result;
}


void status_icon_set_close_action (StatusIcon* self, StatusIconCloseAction value) {
	g_return_if_fail (self != NULL);
	self->priv->_close_action = value;
	g_object_notify ((GObject *) self, "close-action");
}


gboolean status_icon_get_show_automatic_progress (StatusIcon* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_automatic_progress;
	return result;
}


void status_icon_set_show_automatic_progress (StatusIcon* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_show_automatic_progress = value;
	g_object_notify ((GObject *) self, "show-automatic-progress");
}


static void _status_icon_set_action_desc_deja_dup_operation_action_desc_changed (DejaDupOperation* _sender, const gchar* action, gpointer self) {
	status_icon_set_action_desc (self, _sender, action);
}


static void _status_icon_note_progress_deja_dup_operation_progress (DejaDupOperation* _sender, gdouble percent, gpointer self) {
	status_icon_note_progress (self, _sender, percent);
}


static GObject * status_icon_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	StatusIcon * self;
	DejaDupDuplicityInfo* _tmp0_ = NULL;
	DejaDupDuplicityInfo* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	parent_class = G_OBJECT_CLASS (status_icon_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = STATUS_ICON (obj);
	_tmp0_ = deja_dup_duplicity_info_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = deja_dup_duplicity_info_get_can_resume (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	if (_tmp3_) {
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp4_ = _ ("_Resume Later");
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (self->later_label);
		self->later_label = _tmp5_;
	} else {
		if (self->priv->_automatic) {
			const gchar* _tmp6_ = NULL;
			gchar* _tmp7_;
			_tmp6_ = _ ("_Delay Backup");
			_tmp7_ = g_strdup (_tmp6_);
			_g_free0 (self->later_label);
			self->later_label = _tmp7_;
		} else {
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			_tmp8_ = _ ("_Cancel Backup");
			_tmp9_ = g_strdup (_tmp8_);
			_g_free0 (self->later_label);
			self->later_label = _tmp9_;
		}
	}
	_tmp10_ = _ ("_Skip Backup");
	_tmp11_ = g_strdup (_tmp10_);
	_g_free0 (self->skip_label);
	self->skip_label = _tmp11_;
	g_signal_connect_object (self->priv->_op, "action-desc-changed", (GCallback) _status_icon_set_action_desc_deja_dup_operation_action_desc_changed, self, 0);
	g_signal_connect_object (self->priv->_op, "progress", (GCallback) _status_icon_note_progress_deja_dup_operation_progress, self, 0);
	return obj;
}


static void status_icon_class_init (StatusIconClass * klass) {
	status_icon_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (StatusIconPrivate));
	STATUS_ICON_CLASS (klass)->update_progress = status_icon_real_update_progress;
	G_OBJECT_CLASS (klass)->get_property = _vala_status_icon_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_status_icon_set_property;
	G_OBJECT_CLASS (klass)->constructor = status_icon_constructor;
	G_OBJECT_CLASS (klass)->finalize = status_icon_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), STATUS_ICON_WINDOW, g_param_spec_object ("window", "window", "window", GTK_TYPE_WINDOW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), STATUS_ICON_OP, g_param_spec_object ("op", "op", "op", DEJA_DUP_TYPE_OPERATION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), STATUS_ICON_AUTOMATIC, g_param_spec_boolean ("automatic", "automatic", "automatic", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), STATUS_ICON_CLOSE_ACTION, g_param_spec_enum ("close-action", "close-action", "close-action", STATUS_ICON_TYPE_CLOSE_ACTION, STATUS_ICON_CLOSE_ACTION_HIDE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), STATUS_ICON_SHOW_AUTOMATIC_PROGRESS, g_param_spec_boolean ("show-automatic-progress", "show-automatic-progress", "show-automatic-progress", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("show_window", TYPE_STATUS_ICON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("hide_all", TYPE_STATUS_ICON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void status_icon_instance_init (StatusIcon * self) {
	self->priv = STATUS_ICON_GET_PRIVATE (self);
	self->priv->_automatic = FALSE;
	self->priv->_close_action = STATUS_ICON_CLOSE_ACTION_HIDE;
	self->priv->_show_automatic_progress = FALSE;
	self->is_valid = TRUE;
}


static void status_icon_finalize (GObject* obj) {
	StatusIcon * self;
	self = STATUS_ICON (obj);
	_g_object_unref0 (self->priv->_window);
	_g_object_unref0 (self->priv->_op);
	_g_free0 (self->action);
	_g_free0 (self->later_label);
	_g_free0 (self->skip_label);
	_g_object_unref0 (self->menu);
	G_OBJECT_CLASS (status_icon_parent_class)->finalize (obj);
}


/**
 * There are four modes for 'shell' integration:
 * 1) GNOME Shell
 * 2) Unity
 * 3) Indicator
 * 4) Legacy
 * 
 * GNOME Shell:
 * No status icon at all.
 * Actions on persistent notifications.
 * Detected by 'persistent' capability of notification server.
 * 
 * Unity:
 * Register as a launcher entry.
 * Always shows progress.
 * No notifications.
 * Detected by presence of Unity (usually on Ubuntu).
 * 
 * Indicator:
 * Register as an application indicator, which falls back to standard GTK+ status icon.
 * No notifications.
 * Detected by presence of application indicator host (usually on Ubuntu).
 * 
 * Legacy:
 * Standard GTK+ status icon.
 * No notifications.
 */
GType status_icon_get_type (void) {
	static volatile gsize status_icon_type_id__volatile = 0;
	if (g_once_init_enter (&status_icon_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (StatusIconClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) status_icon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (StatusIcon), 0, (GInstanceInitFunc) status_icon_instance_init, NULL };
		GType status_icon_type_id;
		status_icon_type_id = g_type_register_static (G_TYPE_OBJECT, "StatusIcon", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&status_icon_type_id__volatile, status_icon_type_id);
	}
	return status_icon_type_id__volatile;
}


static void _vala_status_icon_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	StatusIcon * self;
	self = STATUS_ICON (object);
	switch (property_id) {
		case STATUS_ICON_WINDOW:
		g_value_set_object (value, status_icon_get_window (self));
		break;
		case STATUS_ICON_OP:
		g_value_set_object (value, status_icon_get_op (self));
		break;
		case STATUS_ICON_AUTOMATIC:
		g_value_set_boolean (value, status_icon_get_automatic (self));
		break;
		case STATUS_ICON_CLOSE_ACTION:
		g_value_set_enum (value, status_icon_get_close_action (self));
		break;
		case STATUS_ICON_SHOW_AUTOMATIC_PROGRESS:
		g_value_set_boolean (value, status_icon_get_show_automatic_progress (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_status_icon_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	StatusIcon * self;
	self = STATUS_ICON (object);
	switch (property_id) {
		case STATUS_ICON_WINDOW:
		status_icon_set_window (self, g_value_get_object (value));
		break;
		case STATUS_ICON_OP:
		status_icon_set_op (self, g_value_get_object (value));
		break;
		case STATUS_ICON_AUTOMATIC:
		status_icon_set_automatic (self, g_value_get_boolean (value));
		break;
		case STATUS_ICON_CLOSE_ACTION:
		status_icon_set_close_action (self, g_value_get_enum (value));
		break;
		case STATUS_ICON_SHOW_AUTOMATIC_PROGRESS:
		status_icon_set_show_automatic_progress (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


UnityStatusIcon* unity_status_icon_construct (GType object_type, GtkWindow* window, DejaDupOperation* op, gboolean automatic) {
	UnityStatusIcon * self = NULL;
	g_return_val_if_fail (window != NULL, NULL);
	g_return_val_if_fail (op != NULL, NULL);
	self = (UnityStatusIcon*) g_object_new (object_type, "window", window, "op", op, "automatic", automatic, NULL);
	return self;
}


UnityStatusIcon* unity_status_icon_new (GtkWindow* window, DejaDupOperation* op, gboolean automatic) {
	return unity_status_icon_construct (TYPE_UNITY_STATUS_ICON, window, op, automatic);
}


static void unity_status_icon_real_update_progress (StatusIcon* base) {
	UnityStatusIcon * self;
	self = (UnityStatusIcon*) base;
	hacks_unity_entry_set_progress (self->priv->entry, ((StatusIcon*) self)->progress);
	hacks_unity_entry_show_progress (self->priv->entry, TRUE);
}


static GObject * unity_status_icon_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityStatusIcon * self;
	GObject* _tmp0_ = NULL;
	parent_class = G_OBJECT_CLASS (unity_status_icon_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_STATUS_ICON (obj);
	_tmp0_ = hacks_unity_get_entry ();
	_g_object_unref0 (self->priv->entry);
	self->priv->entry = _tmp0_;
	((StatusIcon*) self)->is_valid = self->priv->entry != NULL;
	status_icon_set_close_action ((StatusIcon*) self, STATUS_ICON_CLOSE_ACTION_MINIMIZE);
	status_icon_set_show_automatic_progress ((StatusIcon*) self, TRUE);
	if (((StatusIcon*) self)->is_valid) {
		GtkMenu* _tmp1_ = NULL;
		GtkMenu* _tmp2_;
		_tmp1_ = status_icon_ensure_menu ((StatusIcon*) self, FALSE);
		_tmp2_ = _tmp1_;
		hacks_unity_entry_set_menu (self->priv->entry, _tmp2_);
		_g_object_unref0 (_tmp2_);
	}
	return obj;
}


static void unity_status_icon_class_init (UnityStatusIconClass * klass) {
	unity_status_icon_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityStatusIconPrivate));
	STATUS_ICON_CLASS (klass)->update_progress = unity_status_icon_real_update_progress;
	G_OBJECT_CLASS (klass)->constructor = unity_status_icon_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_status_icon_finalize;
}


static void unity_status_icon_instance_init (UnityStatusIcon * self) {
	self->priv = UNITY_STATUS_ICON_GET_PRIVATE (self);
}


static void unity_status_icon_finalize (GObject* obj) {
	UnityStatusIcon * self;
	self = UNITY_STATUS_ICON (obj);
	if (self->priv->entry != NULL) {
		hacks_unity_entry_show_progress (self->priv->entry, FALSE);
		hacks_unity_entry_set_menu (self->priv->entry, NULL);
	}
	_g_object_unref0 (self->priv->entry);
	G_OBJECT_CLASS (unity_status_icon_parent_class)->finalize (obj);
}


GType unity_status_icon_get_type (void) {
	static volatile gsize unity_status_icon_type_id__volatile = 0;
	if (g_once_init_enter (&unity_status_icon_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityStatusIconClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_status_icon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityStatusIcon), 0, (GInstanceInitFunc) unity_status_icon_instance_init, NULL };
		GType unity_status_icon_type_id;
		unity_status_icon_type_id = g_type_register_static (TYPE_STATUS_ICON, "UnityStatusIcon", &g_define_type_info, 0);
		g_once_init_leave (&unity_status_icon_type_id__volatile, unity_status_icon_type_id);
	}
	return unity_status_icon_type_id__volatile;
}


IndicatorStatusIcon* indicator_status_icon_construct (GType object_type, GtkWindow* window, DejaDupOperation* op, gboolean automatic) {
	IndicatorStatusIcon * self = NULL;
	g_return_val_if_fail (window != NULL, NULL);
	g_return_val_if_fail (op != NULL, NULL);
	self = (IndicatorStatusIcon*) g_object_new (object_type, "window", window, "op", op, "automatic", automatic, NULL);
	return self;
}


IndicatorStatusIcon* indicator_status_icon_new (GtkWindow* window, DejaDupOperation* op, gboolean automatic) {
	return indicator_status_icon_construct (TYPE_INDICATOR_STATUS_ICON, window, op, automatic);
}


static GObject * indicator_status_icon_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	IndicatorStatusIcon * self;
	GtkMenu* _tmp0_ = NULL;
	GtkMenu* _tmp1_;
	GObject* _tmp2_ = NULL;
	parent_class = G_OBJECT_CLASS (indicator_status_icon_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = INDICATOR_STATUS_ICON (obj);
	_tmp0_ = status_icon_ensure_menu ((StatusIcon*) self, TRUE);
	_tmp1_ = _tmp0_;
	_tmp2_ = hacks_status_icon_make_app_indicator (_tmp1_);
	_g_object_unref0 (self->priv->indicator);
	self->priv->indicator = _tmp2_;
	_g_object_unref0 (_tmp1_);
	((StatusIcon*) self)->is_valid = self->priv->indicator != NULL;
	return obj;
}


static void indicator_status_icon_class_init (IndicatorStatusIconClass * klass) {
	indicator_status_icon_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (IndicatorStatusIconPrivate));
	G_OBJECT_CLASS (klass)->constructor = indicator_status_icon_constructor;
	G_OBJECT_CLASS (klass)->finalize = indicator_status_icon_finalize;
}


static void indicator_status_icon_instance_init (IndicatorStatusIcon * self) {
	self->priv = INDICATOR_STATUS_ICON_GET_PRIVATE (self);
}


static void indicator_status_icon_finalize (GObject* obj) {
	IndicatorStatusIcon * self;
	self = INDICATOR_STATUS_ICON (obj);
	if (self->priv->indicator != NULL) {
		hacks_status_icon_close_app_indicator (self->priv->indicator);
	}
	_g_object_unref0 (self->priv->indicator);
	G_OBJECT_CLASS (indicator_status_icon_parent_class)->finalize (obj);
}


GType indicator_status_icon_get_type (void) {
	static volatile gsize indicator_status_icon_type_id__volatile = 0;
	if (g_once_init_enter (&indicator_status_icon_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IndicatorStatusIconClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) indicator_status_icon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IndicatorStatusIcon), 0, (GInstanceInitFunc) indicator_status_icon_instance_init, NULL };
		GType indicator_status_icon_type_id;
		indicator_status_icon_type_id = g_type_register_static (TYPE_STATUS_ICON, "IndicatorStatusIcon", &g_define_type_info, 0);
		g_once_init_leave (&indicator_status_icon_type_id__volatile, indicator_status_icon_type_id);
	}
	return indicator_status_icon_type_id__volatile;
}


ShellStatusIcon* shell_status_icon_construct (GType object_type, GtkWindow* window, DejaDupOperation* op, gboolean automatic) {
	ShellStatusIcon * self = NULL;
	g_return_val_if_fail (window != NULL, NULL);
	g_return_val_if_fail (op != NULL, NULL);
	self = (ShellStatusIcon*) g_object_new (object_type, "window", window, "op", op, "automatic", automatic, NULL);
	return self;
}


ShellStatusIcon* shell_status_icon_new (GtkWindow* window, DejaDupOperation* op, gboolean automatic) {
	return shell_status_icon_construct (TYPE_SHELL_STATUS_ICON, window, op, automatic);
}


static void _lambda3_ (ShellStatusIcon* self) {
	status_icon_later ((StatusIcon*) self);
}


static void __lambda3__notify_action_callback (NotifyNotification* notification, const gchar* action, gpointer self) {
	_lambda3_ (self);
}


static void _lambda4_ (ShellStatusIcon* self) {
	status_icon_skip ((StatusIcon*) self);
}


static void __lambda4__notify_action_callback (NotifyNotification* notification, const gchar* action, gpointer self) {
	_lambda4_ (self);
}


static GObject * shell_status_icon_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	ShellStatusIcon * self;
	GList* _tmp0_ = NULL;
	GList* caps;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (shell_status_icon_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SHELL_STATUS_ICON (obj);
	_tmp0_ = notify_get_server_caps ();
	caps = _tmp0_;
	{
		GList* cap_collection;
		GList* cap_it;
		cap_collection = caps;
		for (cap_it = cap_collection; cap_it != NULL; cap_it = cap_it->next) {
			gchar* _tmp1_;
			gchar* cap;
			_tmp1_ = g_strdup ((const gchar*) cap_it->data);
			cap = _tmp1_;
			{
				if (g_strcmp0 (cap, "persistence") == 0) {
					self->priv->persistence = TRUE;
				} else {
					if (g_strcmp0 (cap, "actions") == 0) {
						self->priv->actions = TRUE;
					}
				}
				_g_free0 (cap);
			}
		}
	}
	if (self->priv->persistence) {
		_tmp2_ = self->priv->actions;
	} else {
		_tmp2_ = FALSE;
	}
	((StatusIcon*) self)->is_valid = _tmp2_;
	if (((StatusIcon*) self)->is_valid) {
		gboolean _tmp5_;
		_tmp5_ = status_icon_get_automatic ((StatusIcon*) self);
		_tmp4_ = _tmp5_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		DejaDupOperation* _tmp6_ = NULL;
		DejaDupOperationMode _tmp7_;
		_tmp6_ = status_icon_get_op ((StatusIcon*) self);
		_tmp7_ = deja_dup_operation_get_mode (_tmp6_);
		_tmp3_ = _tmp7_ == DEJA_DUP_OPERATION_MODE_BACKUP;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		NotifyNotification* _tmp10_ = NULL;
		NotifyNotification* note;
		DejaDupOperation* _tmp11_ = NULL;
		_tmp8_ = g_get_application_name ();
		notify_init (_tmp8_);
		_tmp9_ = _ ("Starting scheduled backup");
		_tmp10_ = notify_notification_new (_tmp9_, NULL, "deja-dup-backup");
		note = _tmp10_;
		notify_notification_add_action (note, "later", ((StatusIcon*) self)->later_label, __lambda3__notify_action_callback, g_object_ref (self), g_object_unref);
		notify_notification_add_action (note, "skip", ((StatusIcon*) self)->skip_label, __lambda4__notify_action_callback, g_object_ref (self), g_object_unref);
		notify_notification_show (note, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
		goto __finally8;
		__catch8_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			g_warning ("StatusIcon.vala:262: %s\n", e->message);
			_g_error_free0 (e);
		}
		__finally8:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (note);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_tmp11_ = status_icon_get_op ((StatusIcon*) self);
		deja_dup_operation_set_use_progress (_tmp11_, FALSE);
		_g_object_unref0 (note);
	}
	return obj;
}


static void shell_status_icon_class_init (ShellStatusIconClass * klass) {
	shell_status_icon_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ShellStatusIconPrivate));
	G_OBJECT_CLASS (klass)->constructor = shell_status_icon_constructor;
	G_OBJECT_CLASS (klass)->finalize = shell_status_icon_finalize;
}


static void shell_status_icon_instance_init (ShellStatusIcon * self) {
	self->priv = SHELL_STATUS_ICON_GET_PRIVATE (self);
	self->priv->persistence = FALSE;
	self->priv->actions = FALSE;
}


static void shell_status_icon_finalize (GObject* obj) {
	ShellStatusIcon * self;
	self = SHELL_STATUS_ICON (obj);
	G_OBJECT_CLASS (shell_status_icon_parent_class)->finalize (obj);
}


GType shell_status_icon_get_type (void) {
	static volatile gsize shell_status_icon_type_id__volatile = 0;
	if (g_once_init_enter (&shell_status_icon_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ShellStatusIconClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) shell_status_icon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ShellStatusIcon), 0, (GInstanceInitFunc) shell_status_icon_instance_init, NULL };
		GType shell_status_icon_type_id;
		shell_status_icon_type_id = g_type_register_static (TYPE_STATUS_ICON, "ShellStatusIcon", &g_define_type_info, 0);
		g_once_init_leave (&shell_status_icon_type_id__volatile, shell_status_icon_type_id);
	}
	return shell_status_icon_type_id__volatile;
}


LegacyStatusIcon* legacy_status_icon_construct (GType object_type, GtkWindow* window, DejaDupOperation* op, gboolean automatic) {
	LegacyStatusIcon * self = NULL;
	g_return_val_if_fail (window != NULL, NULL);
	g_return_val_if_fail (op != NULL, NULL);
	self = (LegacyStatusIcon*) g_object_new (object_type, "window", window, "op", op, "automatic", automatic, NULL);
	return self;
}


LegacyStatusIcon* legacy_status_icon_new (GtkWindow* window, DejaDupOperation* op, gboolean automatic) {
	return legacy_status_icon_construct (TYPE_LEGACY_STATUS_ICON, window, op, automatic);
}


static void legacy_status_icon_real_update_progress (StatusIcon* base) {
	LegacyStatusIcon * self;
	gchar* _tmp0_;
	gchar* tooltip;
	self = (LegacyStatusIcon*) base;
	_tmp0_ = g_strdup ("");
	tooltip = _tmp0_;
	if (((StatusIcon*) self)->action != NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (((StatusIcon*) self)->action);
		_g_free0 (tooltip);
		tooltip = _tmp1_;
	}
	if (((StatusIcon*) self)->progress > 0) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp2_ = g_strconcat (tooltip, "\n", NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = _ ("%.1f%% complete");
		_tmp5_ = g_strdup_printf (_tmp4_, ((StatusIcon*) self)->progress * 100);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strconcat (_tmp3_, _tmp6_, NULL);
		_g_free0 (tooltip);
		tooltip = _tmp7_;
		_g_free0 (_tmp6_);
		_g_free0 (_tmp3_);
	}
	gtk_status_icon_set_tooltip_text (self->priv->icon, tooltip);
	_g_free0 (tooltip);
}


static void _gtk_status_icon_position_menu_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self) {
	gtk_status_icon_position_menu (menu, x, y, push_in, self);
}


static void legacy_status_icon_show_menu (LegacyStatusIcon* self, GtkStatusIcon* status_icon, guint button, guint activate_time) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (status_icon != NULL);
	gtk_menu_popup (((StatusIcon*) self)->menu, NULL, NULL, _gtk_status_icon_position_menu_gtk_menu_position_func, status_icon, button, (guint32) activate_time);
}


static void _legacy_status_icon_show_menu_gtk_status_icon_popup_menu (GtkStatusIcon* _sender, guint button, guint activate_time, gpointer self) {
	legacy_status_icon_show_menu (self, _sender, button, activate_time);
}


static void _lambda5_ (GtkStatusIcon* s, LegacyStatusIcon* self) {
	guint32 _tmp0_;
	g_return_if_fail (s != NULL);
	_tmp0_ = gtk_get_current_event_time ();
	legacy_status_icon_show_menu (self, s, (guint) 0, (guint) _tmp0_);
}


static void __lambda5__gtk_status_icon_activate (GtkStatusIcon* _sender, gpointer self) {
	_lambda5_ (_sender, self);
}


static GObject * legacy_status_icon_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	LegacyStatusIcon * self;
	GtkStatusIcon* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkMenu* _tmp2_ = NULL;
	GtkMenu* _tmp3_;
	parent_class = G_OBJECT_CLASS (legacy_status_icon_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = LEGACY_STATUS_ICON (obj);
	_tmp0_ = gtk_status_icon_new ();
	_g_object_unref0 (self->priv->icon);
	self->priv->icon = _tmp0_;
	_tmp1_ = g_get_application_name ();
	g_object_set ((GObject*) self->priv->icon, "icon-name", "deja-dup-symbolic", "title", _tmp1_, NULL);
	_tmp2_ = status_icon_ensure_menu ((StatusIcon*) self, TRUE);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp3_);
	g_signal_connect_object (self->priv->icon, "popup-menu", (GCallback) _legacy_status_icon_show_menu_gtk_status_icon_popup_menu, self, 0);
	g_signal_connect_object (self->priv->icon, "activate", (GCallback) __lambda5__gtk_status_icon_activate, self, 0);
	return obj;
}


static void legacy_status_icon_class_init (LegacyStatusIconClass * klass) {
	legacy_status_icon_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (LegacyStatusIconPrivate));
	STATUS_ICON_CLASS (klass)->update_progress = legacy_status_icon_real_update_progress;
	G_OBJECT_CLASS (klass)->constructor = legacy_status_icon_constructor;
	G_OBJECT_CLASS (klass)->finalize = legacy_status_icon_finalize;
}


static void legacy_status_icon_instance_init (LegacyStatusIcon * self) {
	self->priv = LEGACY_STATUS_ICON_GET_PRIVATE (self);
}


static void legacy_status_icon_finalize (GObject* obj) {
	LegacyStatusIcon * self;
	self = LEGACY_STATUS_ICON (obj);
	_g_object_unref0 (self->priv->icon);
	G_OBJECT_CLASS (legacy_status_icon_parent_class)->finalize (obj);
}


GType legacy_status_icon_get_type (void) {
	static volatile gsize legacy_status_icon_type_id__volatile = 0;
	if (g_once_init_enter (&legacy_status_icon_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LegacyStatusIconClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) legacy_status_icon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LegacyStatusIcon), 0, (GInstanceInitFunc) legacy_status_icon_instance_init, NULL };
		GType legacy_status_icon_type_id;
		legacy_status_icon_type_id = g_type_register_static (TYPE_STATUS_ICON, "LegacyStatusIcon", &g_define_type_info, 0);
		g_once_init_leave (&legacy_status_icon_type_id__volatile, legacy_status_icon_type_id);
	}
	return legacy_status_icon_type_id__volatile;
}



