/* -*- Mode: C; indent-tabs-mode: nil; tab-width: 2 -*- */

#include "AssistantRestore.h"
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <OperationRestore.h>
#include <time.h>
#include <Backend.h>
#include <libintl.h>
#include "MainWindow.h"




static char* g_time_format (struct tm *self, const char* format);
struct _AssistantRestorePrivate {
	char* _restore_location;
	GList* _restore_files;
	DejaDupOperationStatus* query_op;
	GtkProgressBar* query_progress_bar;
	guint query_timeout_id;
	GtkComboBox* date_combo;
	GtkListStore* date_store;
	GtkHBox* cust_box;
	GtkFileChooserButton* cust_button;
	GtkTable* confirm_table;
	GtkLabel* confirm_backup;
	gint confirm_location_row;
	GtkLabel* confirm_location_label;
	GtkLabel* confirm_location;
	gint confirm_date_row;
	GtkLabel* confirm_date_label;
	GtkLabel* confirm_date;
	gint confirm_files_row;
	GtkLabel* confirm_files_label;
	GtkVBox* confirm_files;
	GtkWidget* query_progress_page;
	GtkWidget* date_page;
	GtkWidget* restore_dest_page;
	gboolean got_dates;
};

#define ASSISTANT_RESTORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ASSISTANT_RESTORE, AssistantRestorePrivate))
enum  {
	ASSISTANT_RESTORE_DUMMY_PROPERTY,
	ASSISTANT_RESTORE_RESTORE_LOCATION,
	ASSISTANT_RESTORE_RESTORE_FILES
};
static void _g_list_free_g_object_unref (GList* self);
static void assistant_restore_real_add_setup_pages (AssistantOperation* base);
static GtkWidget* assistant_restore_make_query_backend_page (AssistantRestore* self);
static GtkWidget* assistant_restore_make_date_page (AssistantRestore* self);
static void __lambda0 (GtkRadioButton* r, AssistantRestore* self);
static void ___lambda0_gtk_toggle_button_toggled (GtkRadioButton* _sender, gpointer self);
static void __lambda1 (GtkRadioButton* r, AssistantRestore* self);
static void ___lambda1_gtk_toggle_button_toggled (GtkRadioButton* _sender, gpointer self);
static void __lambda2 (GtkFileChooserButton* b, AssistantRestore* self);
static void ___lambda2_gtk_file_chooser_selection_changed (GtkFileChooserButton* _sender, gpointer self);
static GtkWidget* assistant_restore_make_restore_dest_page (AssistantRestore* self);
static GtkWidget* assistant_restore_real_make_confirm_page (AssistantOperation* base);
static void assistant_restore_add_query_backend_page (AssistantRestore* self);
static void assistant_restore_add_date_page (AssistantRestore* self);
static void assistant_restore_add_restore_dest_page (AssistantRestore* self);
static DejaDupOperation* assistant_restore_real_create_op (AssistantOperation* base);
static char* assistant_restore_real_get_progress_file_prefix (AssistantOperation* base);
static GdkPixbuf* assistant_restore_real_get_op_icon (AssistantOperation* base);
static gboolean assistant_restore_query_pulse (AssistantRestore* self);
static void _assistant_restore_handle_collection_dates_deja_dup_operation_status_collection_dates (DejaDupOperationStatus* _sender, GList* dates, gpointer self);
static void _assistant_restore_query_finished_deja_dup_operation_done (DejaDupOperationStatus* _sender, gboolean success, gpointer self);
static void _assistant_operation_show_error_deja_dup_operation_raise_error (DejaDupOperation* _sender, const char* errstr, const char* detail, gpointer self);
static gboolean _assistant_restore_query_pulse_gsource_func (gpointer self);
static void assistant_restore_real_do_prepare (AssistantOperation* base, AssistantOperation* assist, GtkWidget* page);
static void assistant_restore_real_do_close (AssistantOperation* base);
static gint _assistant_restore_do_forward_gtk_assistant_page_func (gint current_page, gpointer self);
static GObject * assistant_restore_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer assistant_restore_parent_class = NULL;
static void assistant_restore_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



static char* g_time_format (struct tm *self, const char* format) {
	gchar* _tmp0;
	gint buffer_size;
	gint buffer_length1;
	gchar* buffer;
	const char* _tmp1;
	char* _tmp2;
	g_return_val_if_fail (format != NULL, NULL);
	_tmp0 = NULL;
	buffer = (_tmp0 = g_new0 (gchar, 64), buffer_length1 = 64, buffer_size = buffer_length1, _tmp0);
	strftime (buffer, buffer_length1, format, &(*self));
	_tmp1 = NULL;
	_tmp2 = NULL;
	return (_tmp2 = (_tmp1 = (const char*) buffer, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), buffer = (g_free (buffer), NULL), _tmp2);
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


AssistantRestore* assistant_restore_construct_with_files (GType object_type, GList* files) {
	AssistantRestore * self;
	g_return_val_if_fail (files != NULL, NULL);
	self = g_object_newv (object_type, 0, NULL);
	assistant_restore_set_restore_files (self, files);
	return self;
}


AssistantRestore* assistant_restore_new_with_files (GList* files) {
	return assistant_restore_construct_with_files (TYPE_ASSISTANT_RESTORE, files);
}


static void assistant_restore_real_add_setup_pages (AssistantOperation* base) {
	AssistantRestore * self;
	self = (AssistantRestore*) base;
	assistant_restore_add_query_backend_page (self);
	assistant_restore_add_date_page (self);
	assistant_restore_add_restore_dest_page (self);
}


static GtkWidget* assistant_restore_make_query_backend_page (AssistantRestore* self) {
	GtkProgressBar* _tmp0;
	GtkVBox* page;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0 = NULL;
	self->priv->query_progress_bar = (_tmp0 = g_object_ref_sink ((GtkProgressBar*) gtk_progress_bar_new ()), (self->priv->query_progress_bar == NULL) ? NULL : (self->priv->query_progress_bar = (g_object_unref (self->priv->query_progress_bar), NULL)), _tmp0);
	page = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 6));
	g_object_set ((GObject*) page, "child", self->priv->query_progress_bar, "border-width", 12, NULL);
	gtk_container_child_set ((GtkContainer*) page, (GtkWidget*) self->priv->query_progress_bar, "expand", FALSE, NULL);
	return (GtkWidget*) page;
}


static GtkWidget* assistant_restore_make_date_page (AssistantRestore* self) {
	GtkListStore* _tmp0;
	GtkComboBox* _tmp1;
	GtkLabel* date_label;
	GtkHBox* hbox;
	GtkVBox* page;
	GtkWidget* _tmp2;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0 = NULL;
	self->priv->date_store = (_tmp0 = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING, NULL), (self->priv->date_store == NULL) ? NULL : (self->priv->date_store = (g_object_unref (self->priv->date_store), NULL)), _tmp0);
	_tmp1 = NULL;
	self->priv->date_combo = (_tmp1 = g_object_ref_sink ((GtkComboBox*) gtk_combo_box_new_text ()), (self->priv->date_combo == NULL) ? NULL : (self->priv->date_combo = (g_object_unref (self->priv->date_combo), NULL)), _tmp1);
	gtk_combo_box_set_model (self->priv->date_combo, (GtkTreeModel*) self->priv->date_store);
	date_label = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("_Date:")));
	g_object_set ((GObject*) date_label, "mnemonic-widget", self->priv->date_combo, "use-underline", TRUE, "xalign", 0.0f, NULL);
	hbox = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6));
	g_object_set ((GObject*) hbox, "child", date_label, "child", self->priv->date_combo, NULL);
	page = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 6));
	g_object_set ((GObject*) page, "child", hbox, "border-width", 12, NULL);
	gtk_container_child_set ((GtkContainer*) hbox, (GtkWidget*) date_label, "expand", FALSE, NULL);
	gtk_container_child_set ((GtkContainer*) hbox, (GtkWidget*) self->priv->date_combo, "expand", FALSE, NULL);
	gtk_container_child_set ((GtkContainer*) page, (GtkWidget*) hbox, "expand", FALSE, NULL);
	_tmp2 = NULL;
	return (_tmp2 = (GtkWidget*) page, (date_label == NULL) ? NULL : (date_label = (g_object_unref (date_label), NULL)), (hbox == NULL) ? NULL : (hbox = (g_object_unref (hbox), NULL)), _tmp2);
}


static void __lambda0 (GtkRadioButton* r, AssistantRestore* self) {
	g_return_if_fail (r != NULL);
	if (gtk_toggle_button_get_active ((GtkToggleButton*) r)) {
		assistant_restore_set_restore_location (self, "/");
	}
}


static void ___lambda0_gtk_toggle_button_toggled (GtkRadioButton* _sender, gpointer self) {
	__lambda0 (_sender, self);
}


static void __lambda1 (GtkRadioButton* r, AssistantRestore* self) {
	g_return_if_fail (r != NULL);
	if (gtk_toggle_button_get_active ((GtkToggleButton*) r)) {
		assistant_restore_set_restore_location (self, gtk_file_chooser_get_filename ((GtkFileChooser*) self->priv->cust_button));
	}
	g_object_set ((GtkWidget*) self->priv->cust_box, "sensitive", gtk_toggle_button_get_active ((GtkToggleButton*) r), NULL);
}


static void ___lambda1_gtk_toggle_button_toggled (GtkRadioButton* _sender, gpointer self) {
	__lambda1 (_sender, self);
}


static void __lambda2 (GtkFileChooserButton* b, AssistantRestore* self) {
	g_return_if_fail (b != NULL);
	assistant_restore_set_restore_location (self, gtk_file_chooser_get_filename ((GtkFileChooser*) b));
}


static void ___lambda2_gtk_file_chooser_selection_changed (GtkFileChooserButton* _sender, gpointer self) {
	__lambda2 (_sender, self);
}


static GtkWidget* assistant_restore_make_restore_dest_page (AssistantRestore* self) {
	GtkRadioButton* orig_radio;
	GtkRadioButton* cust_radio;
	GtkFileChooserButton* _tmp0;
	char* _tmp1;
	GtkLabel* _tmp2;
	GtkLabel* cust_label;
	GtkHBox* _tmp3;
	GtkVBox* page;
	GtkWidget* _tmp4;
	g_return_val_if_fail (self != NULL, NULL);
	orig_radio = g_object_ref_sink ((GtkRadioButton*) gtk_radio_button_new (NULL));
	g_object_set ((GObject*) orig_radio, "label", _ ("Restore files to _original locations"), "use-underline", TRUE, NULL);
	g_signal_connect ((GtkToggleButton*) orig_radio, "toggled", (GCallback) ___lambda0_gtk_toggle_button_toggled, self);
	cust_radio = g_object_ref_sink ((GtkRadioButton*) gtk_radio_button_new (NULL));
	g_object_set ((GObject*) cust_radio, "label", _ ("Restore to _specific folder"), "use-underline", TRUE, "group", orig_radio, NULL);
	g_signal_connect ((GtkToggleButton*) cust_radio, "toggled", (GCallback) ___lambda1_gtk_toggle_button_toggled, self);
	_tmp0 = NULL;
	self->priv->cust_button = (_tmp0 = g_object_ref_sink ((GtkFileChooserButton*) gtk_file_chooser_button_new (_ ("Choose destination for restored files"), GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER)), (self->priv->cust_button == NULL) ? NULL : (self->priv->cust_button = (g_object_unref (self->priv->cust_button), NULL)), _tmp0);
	g_signal_connect ((GtkFileChooser*) self->priv->cust_button, "selection-changed", (GCallback) ___lambda2_gtk_file_chooser_selection_changed, self);
	_tmp1 = NULL;
	_tmp2 = NULL;
	cust_label = (_tmp2 = g_object_ref_sink ((GtkLabel*) gtk_label_new (_tmp1 = g_strconcat ("    ", _ ("Restore _folder:"), NULL))), _tmp1 = (g_free (_tmp1), NULL), _tmp2);
	g_object_set ((GObject*) cust_label, "mnemonic-widget", self->priv->cust_button, "use-underline", TRUE, "xalign", 0.0f, NULL);
	_tmp3 = NULL;
	self->priv->cust_box = (_tmp3 = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6)), (self->priv->cust_box == NULL) ? NULL : (self->priv->cust_box = (g_object_unref (self->priv->cust_box), NULL)), _tmp3);
	g_object_set ((GObject*) self->priv->cust_box, "child", cust_label, "child", self->priv->cust_button, "sensitive", FALSE, NULL);
	page = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 6));
	g_object_set ((GObject*) page, "child", orig_radio, "child", cust_radio, "child", self->priv->cust_box, "border-width", 12, NULL);
	gtk_container_child_set ((GtkContainer*) page, (GtkWidget*) orig_radio, "expand", FALSE, NULL);
	gtk_container_child_set ((GtkContainer*) page, (GtkWidget*) cust_radio, "expand", FALSE, NULL);
	gtk_container_child_set ((GtkContainer*) page, (GtkWidget*) self->priv->cust_box, "expand", FALSE, NULL);
	_tmp4 = NULL;
	return (_tmp4 = (GtkWidget*) page, (orig_radio == NULL) ? NULL : (orig_radio = (g_object_unref (orig_radio), NULL)), (cust_radio == NULL) ? NULL : (cust_radio = (g_object_unref (cust_radio), NULL)), (cust_label == NULL) ? NULL : (cust_label = (g_object_unref (cust_label), NULL)), _tmp4);
}


static GtkWidget* assistant_restore_real_make_confirm_page (AssistantOperation* base) {
	AssistantRestore * self;
	gint rows;
	GtkLabel* backup_label;
	GtkLabel* _tmp0;
	GtkLabel* _tmp1;
	GtkLabel* _tmp2;
	GtkLabel* _tmp3;
	GtkLabel* _tmp4;
	GtkLabel* _tmp5;
	GtkVBox* _tmp6;
	GtkTable* _tmp7;
	GtkTable* _tmp8;
	GtkTable* page;
	GtkWidget* _tmp9;
	self = (AssistantRestore*) base;
	rows = 0;
	backup_label = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Backup location:")));
	g_object_set ((GObject*) backup_label, "xalign", 0.0f, NULL);
	_tmp0 = NULL;
	self->priv->confirm_backup = (_tmp0 = g_object_ref_sink ((GtkLabel*) gtk_label_new ("")), (self->priv->confirm_backup == NULL) ? NULL : (self->priv->confirm_backup = (g_object_unref (self->priv->confirm_backup), NULL)), _tmp0);
	g_object_set ((GObject*) self->priv->confirm_backup, "xalign", 0.0f, NULL);
	rows = rows + 1;
	_tmp1 = NULL;
	self->priv->confirm_date_label = (_tmp1 = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Restore date:"))), (self->priv->confirm_date_label == NULL) ? NULL : (self->priv->confirm_date_label = (g_object_unref (self->priv->confirm_date_label), NULL)), _tmp1);
	g_object_set ((GObject*) self->priv->confirm_date_label, "xalign", 0.0f, NULL);
	_tmp2 = NULL;
	self->priv->confirm_date = (_tmp2 = g_object_ref_sink ((GtkLabel*) gtk_label_new ("")), (self->priv->confirm_date == NULL) ? NULL : (self->priv->confirm_date = (g_object_unref (self->priv->confirm_date), NULL)), _tmp2);
	g_object_set ((GObject*) self->priv->confirm_date, "xalign", 0.0f, NULL);
	rows = rows + 1;
	_tmp3 = NULL;
	self->priv->confirm_location_label = (_tmp3 = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Restore folder:"))), (self->priv->confirm_location_label == NULL) ? NULL : (self->priv->confirm_location_label = (g_object_unref (self->priv->confirm_location_label), NULL)), _tmp3);
	g_object_set ((GObject*) self->priv->confirm_location_label, "xalign", 0.0f, NULL);
	_tmp4 = NULL;
	self->priv->confirm_location = (_tmp4 = g_object_ref_sink ((GtkLabel*) gtk_label_new ("")), (self->priv->confirm_location == NULL) ? NULL : (self->priv->confirm_location = (g_object_unref (self->priv->confirm_location), NULL)), _tmp4);
	g_object_set ((GObject*) self->priv->confirm_location, "xalign", 0.0f, NULL);
	rows = rows + 1;
	_tmp5 = NULL;
	self->priv->confirm_files_label = (_tmp5 = g_object_ref_sink ((GtkLabel*) gtk_label_new ("")), (self->priv->confirm_files_label == NULL) ? NULL : (self->priv->confirm_files_label = (g_object_unref (self->priv->confirm_files_label), NULL)), _tmp5);
	g_object_set ((GObject*) self->priv->confirm_files_label, "xalign", 0.0f, "yalign", 0.0f, NULL);
	_tmp6 = NULL;
	self->priv->confirm_files = (_tmp6 = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (TRUE, 6)), (self->priv->confirm_files == NULL) ? NULL : (self->priv->confirm_files = (g_object_unref (self->priv->confirm_files), NULL)), _tmp6);
	rows = rows + 1;
	_tmp7 = NULL;
	self->priv->confirm_table = (_tmp7 = g_object_ref_sink ((GtkTable*) gtk_table_new ((guint) rows, (guint) 3, FALSE)), (self->priv->confirm_table == NULL) ? NULL : (self->priv->confirm_table = (g_object_unref (self->priv->confirm_table), NULL)), _tmp7);
	_tmp8 = NULL;
	page = (_tmp8 = self->priv->confirm_table, (_tmp8 == NULL) ? NULL : g_object_ref (_tmp8));
	g_object_set ((GObject*) page, "row-spacing", 6, "column-spacing", 6, "border-width", 12, NULL);
	rows = 0;
	gtk_table_attach (page, (GtkWidget*) backup_label, (guint) 0, (guint) 1, (guint) rows, (guint) (rows + 1), GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
	gtk_table_attach (page, (GtkWidget*) self->priv->confirm_backup, (guint) 1, (guint) 2, (guint) rows, (guint) (rows + 1), GTK_FILL, 0, (guint) 0, (guint) 0);
	rows = rows + 1;
	self->priv->confirm_date_row = rows;
	gtk_table_attach (page, (GtkWidget*) self->priv->confirm_date_label, (guint) 0, (guint) 1, (guint) rows, (guint) (rows + 1), GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
	gtk_table_attach (page, (GtkWidget*) self->priv->confirm_date, (guint) 1, (guint) 2, (guint) rows, (guint) (rows + 1), GTK_FILL, 0, (guint) 0, (guint) 0);
	rows = rows + 1;
	self->priv->confirm_location_row = rows;
	gtk_table_attach (page, (GtkWidget*) self->priv->confirm_location_label, (guint) 0, (guint) 1, (guint) rows, (guint) (rows + 1), GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
	gtk_table_attach (page, (GtkWidget*) self->priv->confirm_location, (guint) 1, (guint) 2, (guint) rows, (guint) (rows + 1), GTK_FILL, 0, (guint) 0, (guint) 0);
	rows = rows + 1;
	self->priv->confirm_files_row = rows;
	gtk_table_attach (page, (GtkWidget*) self->priv->confirm_files_label, (guint) 0, (guint) 1, (guint) rows, (guint) (rows + 1), GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
	gtk_table_attach (page, (GtkWidget*) self->priv->confirm_files, (guint) 1, (guint) 2, (guint) rows, (guint) (rows + 1), GTK_FILL, 0, (guint) 0, (guint) 0);
	_tmp9 = NULL;
	return (_tmp9 = (GtkWidget*) page, (backup_label == NULL) ? NULL : (backup_label = (g_object_unref (backup_label), NULL)), _tmp9);
}


static void assistant_restore_add_query_backend_page (AssistantRestore* self) {
	GtkWidget* page;
	GtkWidget* _tmp1;
	GtkWidget* _tmp0;
	g_return_if_fail (self != NULL);
	page = assistant_restore_make_query_backend_page (self);
	gtk_assistant_append_page ((GtkAssistant*) self, page);
	gtk_container_child_set ((GtkContainer*) self, page, "title", _ ("Checking for Backups"), "complete", FALSE, "header-image", assistant_operation_get_icon ((AssistantOperation*) self), NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->priv->query_progress_page = (_tmp1 = (_tmp0 = page, (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0)), (self->priv->query_progress_page == NULL) ? NULL : (self->priv->query_progress_page = (g_object_unref (self->priv->query_progress_page), NULL)), _tmp1);
	(page == NULL) ? NULL : (page = (g_object_unref (page), NULL));
}


static void assistant_restore_add_date_page (AssistantRestore* self) {
	GtkWidget* page;
	GtkWidget* _tmp1;
	GtkWidget* _tmp0;
	g_return_if_fail (self != NULL);
	page = assistant_restore_make_date_page (self);
	gtk_assistant_append_page ((GtkAssistant*) self, page);
	gtk_container_child_set ((GtkContainer*) self, page, "title", _ ("Restore from When?"), "complete", TRUE, "header-image", assistant_operation_get_icon ((AssistantOperation*) self), NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->priv->date_page = (_tmp1 = (_tmp0 = page, (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0)), (self->priv->date_page == NULL) ? NULL : (self->priv->date_page = (g_object_unref (self->priv->date_page), NULL)), _tmp1);
	(page == NULL) ? NULL : (page = (g_object_unref (page), NULL));
}


static void assistant_restore_add_restore_dest_page (AssistantRestore* self) {
	GtkWidget* page;
	GtkWidget* _tmp1;
	GtkWidget* _tmp0;
	g_return_if_fail (self != NULL);
	page = assistant_restore_make_restore_dest_page (self);
	gtk_assistant_append_page ((GtkAssistant*) self, page);
	gtk_container_child_set ((GtkContainer*) self, page, "title", _ ("Restore to Where?"), "complete", TRUE, "header-image", assistant_operation_get_icon ((AssistantOperation*) self), NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->priv->restore_dest_page = (_tmp1 = (_tmp0 = page, (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0)), (self->priv->restore_dest_page == NULL) ? NULL : (self->priv->restore_dest_page = (g_object_unref (self->priv->restore_dest_page), NULL)), _tmp1);
	(page == NULL) ? NULL : (page = (g_object_unref (page), NULL));
}


static DejaDupOperation* assistant_restore_real_create_op (AssistantOperation* base) {
	AssistantRestore * self;
	char* date;
	DejaDupOperation* _tmp0;
	self = (AssistantRestore*) base;
	date = NULL;
	if (self->priv->got_dates) {
		GtkTreeIter iter = {0};
		if (gtk_combo_box_get_active_iter (self->priv->date_combo, &iter)) {
			gtk_tree_model_get ((GtkTreeModel*) self->priv->date_store, &iter, 1, &date, -1);
		}
	}
	_tmp0 = NULL;
	return (_tmp0 = (DejaDupOperation*) deja_dup_operation_restore_new ((GtkWindow*) self, self->priv->_restore_location, date, assistant_restore_get_restore_files (self), 0), date = (g_free (date), NULL), _tmp0);
}


static char* assistant_restore_real_get_progress_file_prefix (AssistantOperation* base) {
	AssistantRestore * self;
	const char* _tmp0;
	self = (AssistantRestore*) base;
	/* Translators:  This is the word 'Restoring' in the phrase
	 "Restoring '%s'".  %s is a filename.*/
	_tmp0 = NULL;
	return (_tmp0 = _ ("Restoring"), (_tmp0 == NULL) ? NULL : g_strdup (_tmp0));
}


static GdkPixbuf* assistant_restore_real_get_op_icon (AssistantOperation* base) {
	AssistantRestore * self;
	GError * inner_error;
	self = (AssistantRestore*) base;
	inner_error = NULL;
	{
		char* filename;
		GdkPixbuf* _tmp0;
		filename = get_restore_icon_filename ();
		_tmp0 = NULL;
		return (_tmp0 = gdk_pixbuf_new_from_file_at_size (filename, 48, 48, &inner_error), filename = (g_free (filename), NULL), _tmp0);
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			GdkPixbuf* _tmp1;
			g_warning ("AssistantRestore.vala:277: %s\n", e->message);
			_tmp1 = NULL;
			return (_tmp1 = NULL, (e == NULL) ? NULL : (e = (g_error_free (e), NULL)), _tmp1);
		}
	}
	__finally4:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return NULL;
	}
}


void assistant_restore_handle_collection_dates (AssistantRestore* self, DejaDupOperationStatus* op, GList* dates) {
	GTimeVal _tmp0 = {0};
	GTimeVal tv;
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	tv = (g_get_current_time (&_tmp0), _tmp0);
	self->priv->got_dates = TRUE;
	gtk_list_store_clear (self->priv->date_store);
	{
		GList* date_collection;
		GList* date_it;
		date_collection = dates;
		for (date_it = date_collection; date_it != NULL; date_it = date_it->next) {
			const char* _tmp2;
			char* date;
			_tmp2 = NULL;
			date = (_tmp2 = (const char*) date_it->data, (_tmp2 == NULL) ? NULL : g_strdup (_tmp2));
			{
				if (g_time_val_from_iso8601 (date, &tv)) {
					struct tm _tmp1 = {0};
					struct tm t;
					char* user_str;
					GtkTreeIter iter = {0};
					t = (localtime_r (&tv.tv_sec, &_tmp1), _tmp1);
					user_str = g_time_format (&t, "%c");
					gtk_list_store_prepend (self->priv->date_store, &iter);
					gtk_list_store_set (self->priv->date_store, &iter, 0, user_str, 1, date, -1);
					gtk_combo_box_set_active_iter (self->priv->date_combo, &iter);
					user_str = (g_free (user_str), NULL);
				}
				date = (g_free (date), NULL);
			}
		}
	}
	/* If we didn't see any dates...  Must not be any backups on the backend*/
	if (gtk_tree_model_iter_n_children ((GtkTreeModel*) self->priv->date_store, NULL) == 0) {
		assistant_operation_show_error ((AssistantOperation*) self, (DejaDupOperation*) self->priv->query_op, _ ("No backups to restore"), NULL);
	}
}


void assistant_restore_query_finished (AssistantRestore* self, DejaDupOperationStatus* op, gboolean success) {
	gboolean _tmp0;
	DejaDupOperationStatus* _tmp1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	_tmp0 = FALSE;
	if (success) {
		_tmp0 = !assistant_operation_get_error_occurred ((AssistantOperation*) self);
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		gint next_page;
		next_page = assistant_restore_do_forward (self, gtk_assistant_get_current_page ((GtkAssistant*) self));
		if (next_page >= 0) {
			gtk_assistant_set_current_page ((GtkAssistant*) self, next_page);
		}
	}
	_tmp1 = NULL;
	self->priv->query_op = (_tmp1 = NULL, (self->priv->query_op == NULL) ? NULL : (self->priv->query_op = (g_object_unref (self->priv->query_op), NULL)), _tmp1);
}


static gboolean assistant_restore_query_pulse (AssistantRestore* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	gtk_progress_bar_pulse (self->priv->query_progress_bar);
	return TRUE;
}


static void _assistant_restore_handle_collection_dates_deja_dup_operation_status_collection_dates (DejaDupOperationStatus* _sender, GList* dates, gpointer self) {
	assistant_restore_handle_collection_dates (self, _sender, dates);
}


static void _assistant_restore_query_finished_deja_dup_operation_done (DejaDupOperationStatus* _sender, gboolean success, gpointer self) {
	assistant_restore_query_finished (self, _sender, success);
}


static void _assistant_operation_show_error_deja_dup_operation_raise_error (DejaDupOperation* _sender, const char* errstr, const char* detail, gpointer self) {
	assistant_operation_show_error (self, _sender, errstr, detail);
}


void assistant_restore_do_query (AssistantRestore* self) {
	GError * inner_error;
	DejaDupOperationStatus* _tmp0;
	g_return_if_fail (self != NULL);
	inner_error = NULL;
	_tmp0 = NULL;
	self->priv->query_op = (_tmp0 = deja_dup_operation_status_new ((GtkWindow*) self, 0), (self->priv->query_op == NULL) ? NULL : (self->priv->query_op = (g_object_unref (self->priv->query_op), NULL)), _tmp0);
	g_signal_connect_object (self->priv->query_op, "collection-dates", (GCallback) _assistant_restore_handle_collection_dates_deja_dup_operation_status_collection_dates, self, 0);
	g_signal_connect_object ((DejaDupOperation*) self->priv->query_op, "done", (GCallback) _assistant_restore_query_finished_deja_dup_operation_done, self, 0);
	g_signal_connect_object ((DEJA_DUP_OPERATION (self->priv->query_op)), "raise-error", (GCallback) _assistant_operation_show_error_deja_dup_operation_raise_error, (AssistantOperation*) self, 0);
	{
		deja_dup_operation_start ((DejaDupOperation*) self->priv->query_op, &inner_error);
		if (inner_error != NULL) {
			goto __catch5_g_error;
			goto __finally5;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_warning ("AssistantRestore.vala:333: %s\n", e->message);
			assistant_operation_show_error ((AssistantOperation*) self, (DejaDupOperation*) self->priv->query_op, e->message, NULL);
			/* not really user-friendly text, but ideally this won't happen*/
			assistant_restore_query_finished (self, self->priv->query_op, FALSE);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally5:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
}


gint assistant_restore_do_forward (AssistantRestore* self, gint n) {
	gint next;
	GtkWidget* _tmp1;
	GtkWidget* next_page;
	gboolean _tmp4;
	gint _tmp7;
	g_return_val_if_fail (self != NULL, 0);
	if (n >= (gtk_assistant_get_n_pages ((GtkAssistant*) self) - 1)) {
		return -1;
	}
	next = n + 1;
	_tmp1 = NULL;
	next_page = (_tmp1 = gtk_assistant_get_nth_page ((GtkAssistant*) self, next), (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1));
	if (next_page == self->priv->date_page) {
		if (!self->priv->got_dates) {
			GtkWidget* _tmp3;
			GtkWidget* _tmp2;
			/* Hmm, we never got a date from querying the backend, but we also
			 didn't hit an error (since we're about to show this page, and not
			 the summary/error page).  Skip the date portion, since the backend
			 must not be capable of giving us dates (duplicity < 0.5.04 couldn't).*/
			_tmp3 = NULL;
			_tmp2 = NULL;
			next_page = (_tmp3 = (_tmp2 = gtk_assistant_get_nth_page ((GtkAssistant*) self, (next = next + 1)), (_tmp2 == NULL) ? NULL : g_object_ref (_tmp2)), (next_page == NULL) ? NULL : (next_page = (g_object_unref (next_page), NULL)), _tmp3);
		}
	}
	_tmp4 = FALSE;
	if (next_page == self->priv->restore_dest_page) {
		_tmp4 = assistant_restore_get_restore_files (self) != NULL;
	} else {
		_tmp4 = FALSE;
	}
	/* If we're doing a known-file-set restore, assume user wants same-location
	 restore.*/
	if (_tmp4) {
		GtkWidget* _tmp6;
		GtkWidget* _tmp5;
		_tmp6 = NULL;
		_tmp5 = NULL;
		next_page = (_tmp6 = (_tmp5 = gtk_assistant_get_nth_page ((GtkAssistant*) self, (next = next + 1)), (_tmp5 == NULL) ? NULL : g_object_ref (_tmp5)), (next_page == NULL) ? NULL : (next_page = (g_object_unref (next_page), NULL)), _tmp6);
	}
	return (_tmp7 = next, (next_page == NULL) ? NULL : (next_page = (g_object_unref (next_page), NULL)), _tmp7);
}


static gboolean _assistant_restore_query_pulse_gsource_func (gpointer self) {
	return assistant_restore_query_pulse (self);
}


static void assistant_restore_real_do_prepare (AssistantOperation* base, AssistantOperation* assist, GtkWidget* page) {
	AssistantRestore * self;
	GError * inner_error;
	self = (AssistantRestore*) base;
	g_return_if_fail (assist != NULL);
	g_return_if_fail (page != NULL);
	inner_error = NULL;
	ASSISTANT_OPERATION_CLASS (assistant_restore_parent_class)->do_prepare (ASSISTANT_OPERATION (self), assist, page);
	if (self->priv->query_timeout_id > 0) {
		g_source_remove (self->priv->query_timeout_id);
		self->priv->query_timeout_id = (guint) 0;
	}
	if (page == assistant_operation_get_confirm_page ((AssistantOperation*) self)) {
		char* backup_loc;
		/* Where the backup is*/
		backup_loc = NULL;
		{
			DejaDupBackend* _tmp0;
			DejaDupBackend* _tmp1;
			char* _tmp2;
			char* _tmp3;
			char* _tmp4;
			_tmp0 = deja_dup_backend_get_default ((GtkWindow*) self, &inner_error);
			if (inner_error != NULL) {
				goto __catch6_g_error;
				goto __finally6;
			}
			_tmp1 = NULL;
			_tmp2 = NULL;
			_tmp3 = (_tmp2 = deja_dup_backend_get_location_pretty (_tmp1 = _tmp0, &inner_error), (_tmp1 == NULL) ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)), _tmp2);
			if (inner_error != NULL) {
				goto __catch6_g_error;
				goto __finally6;
			}
			_tmp4 = NULL;
			backup_loc = (_tmp4 = _tmp3, backup_loc = (g_free (backup_loc), NULL), _tmp4);
		}
		goto __finally6;
		__catch6_g_error:
		{
			GError * e;
			e = inner_error;
			inner_error = NULL;
			{
				g_warning ("AssistantRestore.vala:381: %s\n", e->message);
				(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			}
		}
		__finally6:
		if (inner_error != NULL) {
			backup_loc = (g_free (backup_loc), NULL);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
			return;
		}
		if (backup_loc == NULL) {
			char* _tmp6;
			const char* _tmp5;
			_tmp6 = NULL;
			_tmp5 = NULL;
			backup_loc = (_tmp6 = (_tmp5 = _ ("Unknown"), (_tmp5 == NULL) ? NULL : g_strdup (_tmp5)), backup_loc = (g_free (backup_loc), NULL), _tmp6);
		}
		gtk_label_set_label (self->priv->confirm_backup, backup_loc);
		/* When we restore from*/
		if (self->priv->got_dates) {
			gtk_label_set_label (self->priv->confirm_date, gtk_combo_box_get_active_text (self->priv->date_combo));
			gtk_widget_show ((GtkWidget*) self->priv->confirm_date_label);
			gtk_widget_show ((GtkWidget*) self->priv->confirm_date);
			gtk_table_set_row_spacing (self->priv->confirm_table, (guint) self->priv->confirm_date_row, gtk_table_get_default_row_spacing (self->priv->confirm_table));
		} else {
			gtk_widget_hide ((GtkWidget*) self->priv->confirm_date_label);
			gtk_widget_hide ((GtkWidget*) self->priv->confirm_date);
			gtk_table_set_row_spacing (self->priv->confirm_table, (guint) self->priv->confirm_date_row, (guint) 0);
		}
		/* Where we restore to*/
		if (assistant_restore_get_restore_files (self) == NULL) {
			if (_vala_strcmp0 (self->priv->_restore_location, "/") == 0) {
				gtk_label_set_label (self->priv->confirm_location, _ ("Original location"));
			} else {
				gtk_label_set_label (self->priv->confirm_location, self->priv->_restore_location);
			}
			gtk_widget_show ((GtkWidget*) self->priv->confirm_location_label);
			gtk_widget_show ((GtkWidget*) self->priv->confirm_location);
			gtk_table_set_row_spacing (self->priv->confirm_table, (guint) self->priv->confirm_location_row, gtk_table_get_default_row_spacing (self->priv->confirm_table));
			gtk_widget_hide ((GtkWidget*) self->priv->confirm_files_label);
			gtk_widget_hide ((GtkWidget*) self->priv->confirm_files);
			gtk_table_set_row_spacing (self->priv->confirm_table, (guint) self->priv->confirm_files_row, (guint) 0);
		} else {
			gtk_label_set_label (self->priv->confirm_files_label, ngettext ("File to restore:", "Files to restore:", (gulong) g_list_length (assistant_restore_get_restore_files (self))));
			{
				GList* f_collection;
				GList* f_it;
				f_collection = assistant_restore_get_restore_files (self);
				for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
					GFile* _tmp9;
					GFile* f;
					_tmp9 = NULL;
					f = (_tmp9 = (GFile*) f_it->data, (_tmp9 == NULL) ? NULL : g_object_ref (_tmp9));
					{
						char* parse_name;
						char* _tmp7;
						GtkLabel* _tmp8;
						GtkLabel* file_label;
						parse_name = g_file_get_parse_name (f);
						_tmp7 = NULL;
						_tmp8 = NULL;
						file_label = (_tmp8 = g_object_ref_sink ((GtkLabel*) gtk_label_new (_tmp7 = g_path_get_basename (parse_name))), _tmp7 = (g_free (_tmp7), NULL), _tmp8);
						gtk_widget_set_tooltip_text ((GtkWidget*) file_label, parse_name);
						g_object_set ((GObject*) file_label, "xalign", 0.0f, NULL);
						gtk_container_add ((GtkContainer*) self->priv->confirm_files, (GtkWidget*) file_label);
						(f == NULL) ? NULL : (f = (g_object_unref (f), NULL));
						parse_name = (g_free (parse_name), NULL);
						(file_label == NULL) ? NULL : (file_label = (g_object_unref (file_label), NULL));
					}
				}
			}
			gtk_widget_hide ((GtkWidget*) self->priv->confirm_location_label);
			gtk_widget_hide ((GtkWidget*) self->priv->confirm_location);
			gtk_table_set_row_spacing (self->priv->confirm_table, (guint) self->priv->confirm_location_row, (guint) 0);
			gtk_widget_show ((GtkWidget*) self->priv->confirm_files_label);
			gtk_widget_show_all ((GtkWidget*) self->priv->confirm_files);
			gtk_table_set_row_spacing (self->priv->confirm_table, (guint) self->priv->confirm_files_row, gtk_table_get_default_row_spacing (self->priv->confirm_table));
		}
		backup_loc = (g_free (backup_loc), NULL);
	} else {
		if (page == assistant_operation_get_summary_page ((AssistantOperation*) self)) {
			if (assistant_operation_get_error_occurred ((AssistantOperation*) self)) {
				gtk_container_child_set ((GtkContainer*) assist, page, "title", _ ("Restore Failed"), NULL);
			} else {
				gtk_container_child_set ((GtkContainer*) assist, page, "title", _ ("Restore Finished"), NULL);
				gtk_label_set_label (((AssistantOperation*) self)->summary_label, _ ("Your files were successfully restored."));
			}
		} else {
			if (page == assistant_operation_get_progress_page ((AssistantOperation*) self)) {
				gtk_container_child_set ((GtkContainer*) assist, page, "title", _ ("Restoring..."), NULL);
			} else {
				if (page == self->priv->query_progress_page) {
					gtk_progress_bar_set_fraction (self->priv->query_progress_bar, (double) 0);
					self->priv->query_timeout_id = g_timeout_add ((guint) 250, _assistant_restore_query_pulse_gsource_func, self);
					assistant_restore_do_query (self);
				}
			}
		}
	}
}


static void assistant_restore_real_do_close (AssistantOperation* base) {
	AssistantRestore * self;
	self = (AssistantRestore*) base;
	if (self->priv->query_timeout_id > 0) {
		g_source_remove (self->priv->query_timeout_id);
		self->priv->query_timeout_id = (guint) 0;
	}
	ASSISTANT_OPERATION_CLASS (assistant_restore_parent_class)->do_close (ASSISTANT_OPERATION (self));
}


/*
    Déjà Dup
    © 2008—2009 Michael Terry <mike@mterry.name>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
AssistantRestore* assistant_restore_construct (GType object_type) {
	AssistantRestore * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


AssistantRestore* assistant_restore_new (void) {
	return assistant_restore_construct (TYPE_ASSISTANT_RESTORE);
}


const char* assistant_restore_get_restore_location (AssistantRestore* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_restore_location;
}


void assistant_restore_set_restore_location (AssistantRestore* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_restore_location = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_restore_location = (g_free (self->priv->_restore_location), NULL), _tmp2);
	g_object_notify ((GObject *) self, "restore-location");
}


GList* assistant_restore_get_restore_files (AssistantRestore* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_restore_files;
}


void assistant_restore_set_restore_files (AssistantRestore* self, GList* value) {
	GList* _tmp2;
	g_return_if_fail (self != NULL);
	{
		GList* f_collection;
		GList* f_it;
		f_collection = self->priv->_restore_files;
		for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
			GFile* _tmp1;
			GFile* f;
			_tmp1 = NULL;
			f = (_tmp1 = (GFile*) f_it->data, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1));
			{
				g_object_unref ((GObject*) f);
				(f == NULL) ? NULL : (f = (g_object_unref (f), NULL));
			}
		}
	}
	_tmp2 = NULL;
	self->priv->_restore_files = (_tmp2 = g_list_copy (value), (self->priv->_restore_files == NULL) ? NULL : (self->priv->_restore_files = (_g_list_free_g_object_unref (self->priv->_restore_files), NULL)), _tmp2);
	{
		GList* f_collection;
		GList* f_it;
		f_collection = self->priv->_restore_files;
		for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
			GFile* _tmp3;
			GFile* f;
			_tmp3 = NULL;
			f = (_tmp3 = (GFile*) f_it->data, (_tmp3 == NULL) ? NULL : g_object_ref (_tmp3));
			{
				g_object_ref ((GObject*) f);
				(f == NULL) ? NULL : (f = (g_object_unref (f), NULL));
			}
		}
	}
	g_object_notify ((GObject *) self, "restore-files");
}


static gint _assistant_restore_do_forward_gtk_assistant_page_func (gint current_page, gpointer self) {
	return assistant_restore_do_forward (self, current_page);
}


static GObject * assistant_restore_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	AssistantRestoreClass * klass;
	GObjectClass * parent_class;
	AssistantRestore * self;
	klass = ASSISTANT_RESTORE_CLASS (g_type_class_peek (TYPE_ASSISTANT_RESTORE));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = ASSISTANT_RESTORE (obj);
	{
		gtk_window_set_title ((GtkWindow*) self, _ ("Restore"));
		gtk_assistant_set_forward_page_func ((GtkAssistant*) self, _assistant_restore_do_forward_gtk_assistant_page_func, g_object_ref (self), g_object_unref);
	}
	return obj;
}


static void assistant_restore_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	AssistantRestore * self;
	gpointer boxed;
	self = ASSISTANT_RESTORE (object);
	switch (property_id) {
		case ASSISTANT_RESTORE_RESTORE_LOCATION:
		g_value_set_string (value, assistant_restore_get_restore_location (self));
		break;
		case ASSISTANT_RESTORE_RESTORE_FILES:
		g_value_set_pointer (value, assistant_restore_get_restore_files (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void assistant_restore_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	AssistantRestore * self;
	self = ASSISTANT_RESTORE (object);
	switch (property_id) {
		case ASSISTANT_RESTORE_RESTORE_LOCATION:
		assistant_restore_set_restore_location (self, g_value_get_string (value));
		break;
		case ASSISTANT_RESTORE_RESTORE_FILES:
		assistant_restore_set_restore_files (self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void assistant_restore_class_init (AssistantRestoreClass * klass) {
	assistant_restore_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AssistantRestorePrivate));
	G_OBJECT_CLASS (klass)->get_property = assistant_restore_get_property;
	G_OBJECT_CLASS (klass)->set_property = assistant_restore_set_property;
	G_OBJECT_CLASS (klass)->constructor = assistant_restore_constructor;
	G_OBJECT_CLASS (klass)->finalize = assistant_restore_finalize;
	ASSISTANT_OPERATION_CLASS (klass)->add_setup_pages = assistant_restore_real_add_setup_pages;
	ASSISTANT_OPERATION_CLASS (klass)->make_confirm_page = assistant_restore_real_make_confirm_page;
	ASSISTANT_OPERATION_CLASS (klass)->create_op = assistant_restore_real_create_op;
	ASSISTANT_OPERATION_CLASS (klass)->get_progress_file_prefix = assistant_restore_real_get_progress_file_prefix;
	ASSISTANT_OPERATION_CLASS (klass)->get_op_icon = assistant_restore_real_get_op_icon;
	ASSISTANT_OPERATION_CLASS (klass)->do_prepare = assistant_restore_real_do_prepare;
	ASSISTANT_OPERATION_CLASS (klass)->do_close = assistant_restore_real_do_close;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_RESTORE_RESTORE_LOCATION, g_param_spec_string ("restore-location", "restore-location", "restore-location", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_RESTORE_RESTORE_FILES, g_param_spec_pointer ("restore-files", "restore-files", "restore-files", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void assistant_restore_instance_init (AssistantRestore * self) {
	self->priv = ASSISTANT_RESTORE_GET_PRIVATE (self);
	self->priv->_restore_location = g_strdup ("/");
}


static void assistant_restore_finalize (GObject* obj) {
	AssistantRestore * self;
	self = ASSISTANT_RESTORE (obj);
	self->priv->_restore_location = (g_free (self->priv->_restore_location), NULL);
	(self->priv->_restore_files == NULL) ? NULL : (self->priv->_restore_files = (_g_list_free_g_object_unref (self->priv->_restore_files), NULL));
	(self->priv->query_op == NULL) ? NULL : (self->priv->query_op = (g_object_unref (self->priv->query_op), NULL));
	(self->priv->query_progress_bar == NULL) ? NULL : (self->priv->query_progress_bar = (g_object_unref (self->priv->query_progress_bar), NULL));
	(self->priv->date_combo == NULL) ? NULL : (self->priv->date_combo = (g_object_unref (self->priv->date_combo), NULL));
	(self->priv->date_store == NULL) ? NULL : (self->priv->date_store = (g_object_unref (self->priv->date_store), NULL));
	(self->priv->cust_box == NULL) ? NULL : (self->priv->cust_box = (g_object_unref (self->priv->cust_box), NULL));
	(self->priv->cust_button == NULL) ? NULL : (self->priv->cust_button = (g_object_unref (self->priv->cust_button), NULL));
	(self->priv->confirm_table == NULL) ? NULL : (self->priv->confirm_table = (g_object_unref (self->priv->confirm_table), NULL));
	(self->priv->confirm_backup == NULL) ? NULL : (self->priv->confirm_backup = (g_object_unref (self->priv->confirm_backup), NULL));
	(self->priv->confirm_location_label == NULL) ? NULL : (self->priv->confirm_location_label = (g_object_unref (self->priv->confirm_location_label), NULL));
	(self->priv->confirm_location == NULL) ? NULL : (self->priv->confirm_location = (g_object_unref (self->priv->confirm_location), NULL));
	(self->priv->confirm_date_label == NULL) ? NULL : (self->priv->confirm_date_label = (g_object_unref (self->priv->confirm_date_label), NULL));
	(self->priv->confirm_date == NULL) ? NULL : (self->priv->confirm_date = (g_object_unref (self->priv->confirm_date), NULL));
	(self->priv->confirm_files_label == NULL) ? NULL : (self->priv->confirm_files_label = (g_object_unref (self->priv->confirm_files_label), NULL));
	(self->priv->confirm_files == NULL) ? NULL : (self->priv->confirm_files = (g_object_unref (self->priv->confirm_files), NULL));
	(self->priv->query_progress_page == NULL) ? NULL : (self->priv->query_progress_page = (g_object_unref (self->priv->query_progress_page), NULL));
	(self->priv->date_page == NULL) ? NULL : (self->priv->date_page = (g_object_unref (self->priv->date_page), NULL));
	(self->priv->restore_dest_page == NULL) ? NULL : (self->priv->restore_dest_page = (g_object_unref (self->priv->restore_dest_page), NULL));
	G_OBJECT_CLASS (assistant_restore_parent_class)->finalize (obj);
}


GType assistant_restore_get_type (void) {
	static GType assistant_restore_type_id = 0;
	if (assistant_restore_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (AssistantRestoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) assistant_restore_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AssistantRestore), 0, (GInstanceInitFunc) assistant_restore_instance_init, NULL };
		assistant_restore_type_id = g_type_register_static (TYPE_ASSISTANT_OPERATION, "AssistantRestore", &g_define_type_info, 0);
	}
	return assistant_restore_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




