/* -*- Mode: C; indent-tabs-mode: nil; tab-width: 2 -*- */

#include <DuplicityInstance.h>
#include <unistd.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <signal.h>




static char* string_substring (const char* self, glong offset, glong len);
struct _DejaDupDuplicityInstancePrivate {
	gboolean _verbose;
	guint stanza_id;
	guint watch_id;
	GPid child_pid;
	gint* pipes;
	gint pipes_length1;
	gint pipes_size;
	GIOChannel* reader;
};

#define DEJA_DUP_DUPLICITY_INSTANCE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DEJA_DUP_TYPE_DUPLICITY_INSTANCE, DejaDupDuplicityInstancePrivate))
enum  {
	DEJA_DUP_DUPLICITY_INSTANCE_DUMMY_PROPERTY,
	DEJA_DUP_DUPLICITY_INSTANCE_VERBOSE
};
static void _g_list_free_g_free (GList* self);
static gboolean _deja_dup_duplicity_instance_read_stanza_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
static void _deja_dup_duplicity_instance_spawn_finished_gchild_watch_func (GPid pid, gint status, gpointer self);
static void deja_dup_duplicity_instance_real_start (DejaDupDuplicityInstance* self, GList* argv_in, GList* envp_in, GError** error);
static void deja_dup_duplicity_instance_kill_child (DejaDupDuplicityInstance* self);
static gboolean deja_dup_duplicity_instance_read_stanza (DejaDupDuplicityInstance* self, GIOChannel* channel, GIOCondition cond);
static gint deja_dup_duplicity_instance_num_suffix (const char* word, gchar ch, glong start);
static char* deja_dup_duplicity_instance_validated_string (const char* s);
static char* deja_dup_duplicity_instance_compress_string (const char* s_in);
static void deja_dup_duplicity_instance_split_line (const char* line, char*** split, int* split_length1);
static void deja_dup_duplicity_instance_process_stanza (DejaDupDuplicityInstance* self, GList* stanza);
static GList* deja_dup_duplicity_instance_grab_stanza_data (DejaDupDuplicityInstance* self, GList* stanza);
static char* deja_dup_duplicity_instance_grab_stanza_text (DejaDupDuplicityInstance* self, GList* stanza);
static void deja_dup_duplicity_instance_spawn_finished (DejaDupDuplicityInstance* self, GPid pid, gint status);
static void deja_dup_duplicity_instance_set_verbose (DejaDupDuplicityInstance* self, gboolean value);
static GObject * deja_dup_duplicity_instance_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer deja_dup_duplicity_instance_parent_class = NULL;
static void deja_dup_duplicity_instance_finalize (GObject* obj);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);


static void g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__BOXED_INT_POINTER_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

static char* string_substring (const char* self, glong offset, glong len) {
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = g_utf8_strlen (self, -1);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	return g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
}


static void _g_list_free_g_free (GList* self) {
	g_list_foreach (self, (GFunc) g_free, NULL);
	g_list_free (self);
}


static gboolean _deja_dup_duplicity_instance_read_stanza_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	return deja_dup_duplicity_instance_read_stanza (self, source, condition);
}


static void _deja_dup_duplicity_instance_spawn_finished_gchild_watch_func (GPid pid, gint status, gpointer self) {
	deja_dup_duplicity_instance_spawn_finished (self, pid, status);
}


static void deja_dup_duplicity_instance_real_start (DejaDupDuplicityInstance* self, GList* argv_in, GList* envp_in, GError** error) {
	GError * inner_error;
	const char* _tmp0;
	char* verbose_str;
	gboolean _tmp1;
	char** _tmp3;
	gint myenv_size;
	gint myenv_length1;
	char** _tmp2;
	char** myenv;
	gint myenv_len;
	guint env_len;
	char** _tmp4;
	gint real_envp_size;
	gint real_envp_length1;
	char** real_envp;
	gint i;
	char* _tmp10;
	GList* argv;
	char* _tmp13;
	gboolean _tmp14;
	char* cmd;
	char** _tmp16;
	gint real_argv_size;
	gint real_argv_length1;
	gint _tmp15;
	char** real_argv;
	GIOChannel* _tmp24;
	g_return_if_fail (self != NULL);
	g_return_if_fail (argv_in != NULL);
	inner_error = NULL;
	_tmp0 = NULL;
	verbose_str = (_tmp0 = g_getenv ("DEJA_DUP_DEBUG"), (_tmp0 == NULL) ? NULL : g_strdup (_tmp0));
	_tmp1 = FALSE;
	if (verbose_str != NULL) {
		_tmp1 = atoi (verbose_str) > 0;
	} else {
		_tmp1 = FALSE;
	}
	if (_tmp1) {
		deja_dup_duplicity_instance_set_verbose (self, TRUE);
	}
	/* Open pipes to communicate with subprocess*/
	if (pipe (self->priv->pipes) != 0) {
		g_signal_emit_by_name (self, "done", FALSE, FALSE);
		verbose_str = (g_free (verbose_str), NULL);
		return;
	}
	/* Copy current environment, add custom variables*/
	_tmp3 = NULL;
	_tmp2 = NULL;
	myenv = (_tmp3 = _tmp2 = g_listenv (), myenv_length1 = _vala_array_length (_tmp2), myenv_size = myenv_length1, _tmp3);
	myenv_len = 0;
	while (myenv[myenv_len] != NULL) {
		myenv_len = myenv_len + 1;
	}
	env_len = myenv_len + g_list_length (envp_in);
	_tmp4 = NULL;
	real_envp = (_tmp4 = g_new0 (char*, (env_len + 1) + 1), real_envp_length1 = env_len + 1, real_envp_size = real_envp_length1, _tmp4);
	i = 0;
	for (; i < myenv_len; (i = i + 1)) {
		char* _tmp5;
		_tmp5 = NULL;
		real_envp[i] = (_tmp5 = g_strdup_printf ("%s=%s", myenv[i], g_getenv (myenv[i])), real_envp[i] = (g_free (real_envp[i]), NULL), _tmp5);
	}
	{
		GList* env_collection;
		GList* env_it;
		env_collection = envp_in;
		for (env_it = env_collection; env_it != NULL; env_it = env_it->next) {
			const char* _tmp9;
			char* env;
			_tmp9 = NULL;
			env = (_tmp9 = (const char*) env_it->data, (_tmp9 == NULL) ? NULL : g_strdup (_tmp9));
			{
				gint _tmp8;
				char* _tmp7;
				const char* _tmp6;
				_tmp7 = NULL;
				_tmp6 = NULL;
				_tmp8 = i++;
				real_envp[_tmp8] = (_tmp7 = (_tmp6 = env, (_tmp6 == NULL) ? NULL : g_strdup (_tmp6)), real_envp[_tmp8] = (g_free (real_envp[_tmp8]), NULL), _tmp7);
				env = (g_free (env), NULL);
			}
		}
	}
	_tmp10 = NULL;
	real_envp[i] = (_tmp10 = NULL, real_envp[i] = (g_free (real_envp[i]), NULL), _tmp10);
	argv = NULL;
	{
		GList* arg_collection;
		GList* arg_it;
		arg_collection = argv_in;
		for (arg_it = arg_collection; arg_it != NULL; arg_it = arg_it->next) {
			const char* _tmp12;
			char* arg;
			_tmp12 = NULL;
			arg = (_tmp12 = (const char*) arg_it->data, (_tmp12 == NULL) ? NULL : g_strdup (_tmp12));
			{
				const char* _tmp11;
				_tmp11 = NULL;
				argv = g_list_append (argv, (_tmp11 = arg, (_tmp11 == NULL) ? NULL : g_strdup (_tmp11)));
				arg = (g_free (arg), NULL);
			}
		}
	}
	argv = g_list_append (argv, g_strdup ("--verbosity=9"));
	/* Our default volsize is 5M (duplicity's default is now 25M).
	 Advantages of a smaller value:
	 * takes less temp space
	 * retries of a volume take less time
	 * quicker restore of a particular file (less excess baggage to download)
	 * we get feedback more frequently (duplicity only gives us a progress
	   report at the end of a volume)
	 Downsides:
	 * network throughput might be lower
	 * some protocols have large per-file overhead (like sftp)
	 * the network doesn't have time to ramp up to max tcp transfer speed per
	   file.
	 * too many files on the backend can lead to not being able to do
	   anything with duplicity, as ssh (or ftp or others?) can't list all
	   the files without timing out
	
	 All told, it would be nice if we could do lower volsize.  If duplicity
	 ever solves the 'too many files' problem, we should go down to volsize
	 1 or 2.  For now, we'll keep with the default.*/
	argv = g_list_append (argv, g_strdup ("--volsize=5"));
	/* Add always-there arguments*/
	argv = g_list_append (argv, g_strdup_printf ("--log-fd=%d", self->priv->pipes[1]));
	argv = g_list_prepend (argv, g_strdup ("duplicity"));
	/* Check for ionice to be a good disk citizen*/
	_tmp13 = NULL;
	if ((_tmp14 = (_tmp13 = g_find_program_in_path ("ionice")) != NULL, _tmp13 = (g_free (_tmp13), NULL), _tmp14)) {
		argv = g_list_prepend (argv, g_strdup ("-c3"));
		/* idle class*/
		argv = g_list_prepend (argv, g_strdup ("ionice"));
	}
	cmd = NULL;
	_tmp16 = NULL;
	real_argv = (_tmp16 = g_new0 (char*, (_tmp15 = g_list_length (argv)) + 1), real_argv_length1 = _tmp15, real_argv_size = real_argv_length1, _tmp16);
	i = 0;
	{
		GList* a_collection;
		GList* a_it;
		a_collection = argv;
		for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
			const char* _tmp23;
			char* a;
			_tmp23 = NULL;
			a = (_tmp23 = (const char*) a_it->data, (_tmp23 == NULL) ? NULL : g_strdup (_tmp23));
			{
				gint _tmp19;
				char* _tmp18;
				const char* _tmp17;
				_tmp18 = NULL;
				_tmp17 = NULL;
				_tmp19 = i++;
				real_argv[_tmp19] = (_tmp18 = (_tmp17 = a, (_tmp17 == NULL) ? NULL : g_strdup (_tmp17)), real_argv[_tmp19] = (g_free (real_argv[_tmp19]), NULL), _tmp18);
				if (cmd == NULL) {
					char* _tmp21;
					const char* _tmp20;
					_tmp21 = NULL;
					_tmp20 = NULL;
					cmd = (_tmp21 = (_tmp20 = a, (_tmp20 == NULL) ? NULL : g_strdup (_tmp20)), cmd = (g_free (cmd), NULL), _tmp21);
				} else {
					if (a != NULL) {
						char* _tmp22;
						_tmp22 = NULL;
						cmd = (_tmp22 = g_strdup_printf ("%s %s", cmd, a), cmd = (g_free (cmd), NULL), _tmp22);
					}
				}
				a = (g_free (a), NULL);
			}
		}
	}
	g_spawn_async_with_pipes (NULL, real_argv, real_envp, (((G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD) | G_SPAWN_LEAVE_DESCRIPTORS_OPEN) | G_SPAWN_STDOUT_TO_DEV_NULL) | G_SPAWN_STDERR_TO_DEV_NULL, NULL, NULL, &self->priv->child_pid, NULL, NULL, NULL, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		verbose_str = (g_free (verbose_str), NULL);
		myenv = (_vala_array_free (myenv, myenv_length1, (GDestroyNotify) g_free), NULL);
		real_envp = (_vala_array_free (real_envp, real_envp_length1, (GDestroyNotify) g_free), NULL);
		(argv == NULL) ? NULL : (argv = (_g_list_free_g_free (argv), NULL));
		cmd = (g_free (cmd), NULL);
		real_argv = (_vala_array_free (real_argv, real_argv_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	g_debug ("DuplicityInstance.vala:115: Running the following duplicity (%i) command: %s\n", (gint) self->priv->child_pid, cmd);
	_tmp24 = NULL;
	self->priv->reader = (_tmp24 = g_io_channel_unix_new (self->priv->pipes[0]), (self->priv->reader == NULL) ? NULL : (self->priv->reader = (g_io_channel_unref (self->priv->reader), NULL)), _tmp24);
	{
		/* Don't use an encoding, filenames may have any old bytes in them*/
		g_io_channel_set_encoding (self->priv->reader, NULL, &inner_error);
		if (inner_error != NULL) {
			if (inner_error->domain == G_IO_CHANNEL_ERROR) {
				goto __catch6_g_io_channel_error;
			}
			goto __finally6;
		}
	}
	goto __finally6;
	__catch6_g_io_channel_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally6:
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		verbose_str = (g_free (verbose_str), NULL);
		myenv = (_vala_array_free (myenv, myenv_length1, (GDestroyNotify) g_free), NULL);
		real_envp = (_vala_array_free (real_envp, real_envp_length1, (GDestroyNotify) g_free), NULL);
		(argv == NULL) ? NULL : (argv = (_g_list_free_g_free (argv), NULL));
		cmd = (g_free (cmd), NULL);
		real_argv = (_vala_array_free (real_argv, real_argv_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	/* ignore*/
	self->priv->stanza_id = g_io_add_watch (self->priv->reader, G_IO_IN, _deja_dup_duplicity_instance_read_stanza_gio_func, self);
	close (self->priv->pipes[1]);
	self->priv->watch_id = g_child_watch_add (self->priv->child_pid, _deja_dup_duplicity_instance_spawn_finished_gchild_watch_func, self);
	verbose_str = (g_free (verbose_str), NULL);
	myenv = (_vala_array_free (myenv, myenv_length1, (GDestroyNotify) g_free), NULL);
	real_envp = (_vala_array_free (real_envp, real_envp_length1, (GDestroyNotify) g_free), NULL);
	(argv == NULL) ? NULL : (argv = (_g_list_free_g_free (argv), NULL));
	cmd = (g_free (cmd), NULL);
	real_argv = (_vala_array_free (real_argv, real_argv_length1, (GDestroyNotify) g_free), NULL);
}


void deja_dup_duplicity_instance_start (DejaDupDuplicityInstance* self, GList* argv_in, GList* envp_in, GError** error) {
	DEJA_DUP_DUPLICITY_INSTANCE_GET_CLASS (self)->start (self, argv_in, envp_in, error);
}


gboolean deja_dup_duplicity_instance_is_started (DejaDupDuplicityInstance* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return ((gint) self->priv->child_pid) > 0;
}


void deja_dup_duplicity_instance_cancel (DejaDupDuplicityInstance* self) {
	g_return_if_fail (self != NULL);
	if (deja_dup_duplicity_instance_is_started (self)) {
		deja_dup_duplicity_instance_kill_child (self);
	} else {
		g_signal_emit_by_name (self, "done", FALSE, TRUE);
	}
}


static void deja_dup_duplicity_instance_kill_child (DejaDupDuplicityInstance* self) {
	g_return_if_fail (self != NULL);
	kill ((gint) self->priv->child_pid, 9);
}


static gboolean deja_dup_duplicity_instance_read_stanza (DejaDupDuplicityInstance* self, GIOChannel* channel, GIOCondition cond) {
	GError * inner_error;
	char* line;
	gboolean _tmp6;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (channel != NULL, FALSE);
	inner_error = NULL;
	line = NULL;
	{
		GIOStatus status;
		GList* stanza;
		status = 0;
		stanza = NULL;
		while (TRUE) {
			char* _tmp2;
			GIOStatus _tmp1;
			char* _tmp0;
			GIOStatus _tmp3;
			gboolean _tmp4;
			_tmp2 = NULL;
			_tmp0 = NULL;
			_tmp3 = (_tmp1 = g_io_channel_read_line (channel, &_tmp0, NULL, NULL, &inner_error), line = (_tmp2 = _tmp0, line = (g_free (line), NULL), _tmp2), _tmp1);
			if (inner_error != NULL) {
				(stanza == NULL) ? NULL : (stanza = (_g_list_free_g_free (stanza), NULL));
				goto __catch7_g_error;
				goto __finally7;
			}
			status = _tmp3;
			_tmp4 = FALSE;
			if (status == G_IO_STATUS_NORMAL) {
				_tmp4 = _vala_strcmp0 (line, "\n") != 0;
			} else {
				_tmp4 = FALSE;
			}
			if (_tmp4) {
				const char* _tmp5;
				if (self->priv->_verbose) {
					g_print ("DUPLICITY: %s", line);
				}
				/* line has line ending*/
				_tmp5 = NULL;
				stanza = g_list_append (stanza, (_tmp5 = line, (_tmp5 == NULL) ? NULL : g_strdup (_tmp5)));
			} else {
				break;
			}
		}
		if (self->priv->_verbose) {
			g_print ("\n");
		}
		/* breather*/
		deja_dup_duplicity_instance_process_stanza (self, stanza);
		(stanza == NULL) ? NULL : (stanza = (_g_list_free_g_free (stanza), NULL));
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_warning ("DuplicityInstance.vala:194: %s\n", e->message);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally7:
	if (inner_error != NULL) {
		line = (g_free (line), NULL);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return FALSE;
	}
	return (_tmp6 = TRUE, line = (g_free (line), NULL), _tmp6);
}


/* If start is < 0, starts at word.size() - 1.*/
static gint deja_dup_duplicity_instance_num_suffix (const char* word, gchar ch, glong start) {
	gint rv;
	g_return_val_if_fail (word != NULL, 0);
	rv = 0;
	if (start < 0) {
		start = strlen (word) - 1;
	}
	{
		glong i;
		i = start;
		for (; i >= 0; (i = i - 1), (rv = rv + 1)) {
			if (g_utf8_get_char (g_utf8_offset_to_pointer (word, i)) != ch) {
				break;
			}
		}
	}
	return rv;
}


static char* deja_dup_duplicity_instance_validated_string (const char* s) {
	char* rv;
	const char* p;
	gchar* _tmp0;
	gint charstr_size;
	gint charstr_length1;
	gchar* charstr;
	char* _tmp4;
	g_return_val_if_fail (s != NULL, NULL);
	rv = g_strdup ("");
	p = s;
	_tmp0 = NULL;
	charstr = (_tmp0 = g_new0 (gchar, 6), charstr_length1 = 6, charstr_size = charstr_length1, _tmp0);
	while (g_utf8_get_char (g_utf8_offset_to_pointer (p, 0)) != 0) {
		gunichar ch;
		gboolean _tmp1;
		ch = g_utf8_get_char_validated (p, -1);
		_tmp1 = FALSE;
		if (ch == ((guint) (-1))) {
			_tmp1 = TRUE;
		} else {
			_tmp1 = ch == ((guint) (-2));
		}
		if (_tmp1) {
			char* _tmp2;
			_tmp2 = NULL;
			rv = (_tmp2 = g_strconcat (rv, ("\xef\xbf\xbd"), NULL), rv = (g_free (rv), NULL), _tmp2);
			/* the 'unknown character' character in utf-8*/
			p = g_utf8_offset_to_pointer (p, (glong) 1);
		} else {
			char* _tmp3;
			g_unichar_to_utf8 (ch, (const char*) charstr);
			_tmp3 = NULL;
			rv = (_tmp3 = g_strconcat (rv, ((const char*) charstr), NULL), rv = (g_free (rv), NULL), _tmp3);
			p = g_utf8_next_char (p);
		}
	}
	_tmp4 = NULL;
	return (_tmp4 = rv, charstr = (g_free (charstr), NULL), _tmp4);
}


static char* deja_dup_duplicity_instance_compress_string (const char* s_in) {
	gchar* _tmp1;
	gint rv_size;
	gint rv_length1;
	gint _tmp0;
	gchar* rv;
	gchar* _tmp2;
	gint s_size;
	gint s_length1;
	gchar* s;
	gint i;
	gint j;
	const char* _tmp9;
	char* _tmp10;
	g_return_val_if_fail (s_in != NULL, NULL);
	_tmp1 = NULL;
	rv = (_tmp1 = g_new0 (gchar, _tmp0 = strlen (s_in)), rv_length1 = _tmp0, rv_size = rv_length1, _tmp1);
	_tmp2 = NULL;
	s = (_tmp2 = (gchar*) s_in, s_length1 = -1, s_size = s_length1, _tmp2);
	i = 0;
	j = 0;
	while (s[i] != 0) {
		gboolean _tmp3;
		_tmp3 = FALSE;
		if (s[i] == '\\') {
			_tmp3 = s[i + 1] != 0;
		} else {
			_tmp3 = FALSE;
		}
		if (_tmp3) {
			gboolean bare_escape;
			bare_escape = FALSE;
			switch (s[i + 1]) {
				case 'b':
				{
					rv[j++] = '\b';
					i = i + (2);
					break;
				}
				case 'f':
				{
					rv[j++] = '\014';
					i = i + (2);
					break;
				}
				case 't':
				{
					rv[j++] = '\t';
					i = i + (2);
					break;
				}
				case 'n':
				{
					rv[j++] = '\n';
					i = i + (2);
					break;
				}
				case 'r':
				{
					rv[j++] = '\r';
					i = i + (2);
					break;
				}
				case 'v':
				{
					rv[j++] = '\013';
					i = i + (2);
					break;
				}
				case 'a':
				{
					rv[j++] = '\007';
					i = i + (2);
					break;
				}
				case 'x':
				{
					gboolean _tmp4;
					_tmp4 = FALSE;
					if (s[i + 2] != 0) {
						_tmp4 = s[i + 3] != 0;
					} else {
						_tmp4 = FALSE;
					}
					if (_tmp4) {
						gchar* _tmp5;
						gint tmpstr_size;
						gint tmpstr_length1;
						gchar* tmpstr;
						gulong val;
						_tmp5 = NULL;
						tmpstr = (_tmp5 = g_new0 (gchar, 3), tmpstr_length1 = 3, tmpstr_size = tmpstr_length1, _tmp5);
						tmpstr[0] = s[i + 2];
						tmpstr[1] = s[i + 3];
						val = strtoul (((const char*) tmpstr), NULL, 16);
						rv[j++] = (gchar) val;
						i = i + (4);
						tmpstr = (g_free (tmpstr), NULL);
					} else {
						bare_escape = TRUE;
					}
					break;
				}
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				{
					gboolean _tmp6;
					gboolean _tmp7;
					_tmp6 = FALSE;
					_tmp7 = FALSE;
					if (s[i + 2] != 0) {
						_tmp7 = s[i + 3] != 0;
					} else {
						_tmp7 = FALSE;
					}
					if (_tmp7) {
						_tmp6 = s[i + 4] != 0;
					} else {
						_tmp6 = FALSE;
					}
					if (_tmp6) {
						gchar* _tmp8;
						gint tmpstr_size;
						gint tmpstr_length1;
						gchar* tmpstr;
						gulong val;
						_tmp8 = NULL;
						tmpstr = (_tmp8 = g_new0 (gchar, 4), tmpstr_length1 = 4, tmpstr_size = tmpstr_length1, _tmp8);
						tmpstr[0] = s[i + 2];
						tmpstr[1] = s[i + 3];
						tmpstr[2] = s[i + 4];
						val = strtoul (((const char*) tmpstr), NULL, 8);
						rv[j++] = (gchar) val;
						i = i + (5);
						tmpstr = (g_free (tmpstr), NULL);
					} else {
						bare_escape = TRUE;
					}
					break;
				}
				default:
				{
					bare_escape = TRUE;
					break;
				}
			}
			if (bare_escape) {
				rv[j++] = s[i + 1];
				i = i + (2);
			}
		} else {
			rv[j++] = s[i++];
		}
	}
	_tmp9 = NULL;
	_tmp10 = NULL;
	return (_tmp10 = (_tmp9 = (const char*) rv, (_tmp9 == NULL) ? NULL : g_strdup (_tmp9)), rv = (g_free (rv), NULL), _tmp10);
}


static void deja_dup_duplicity_instance_split_line (const char* line, char*** split, int* split_length1) {
	char** _tmp1;
	gint firstsplit_size;
	gint firstsplit_length1;
	char** _tmp0;
	char** firstsplit;
	GList* splitlist;
	gint i;
	gboolean in_group;
	char* group_word;
	char** _tmp14;
	gint _tmp13;
	g_return_if_fail (line != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	firstsplit = (_tmp1 = _tmp0 = g_strsplit (line, " ", 0), firstsplit_length1 = _vala_array_length (_tmp0), firstsplit_size = firstsplit_length1, _tmp1);
	splitlist = NULL;
	i = 0;
	in_group = FALSE;
	group_word = g_strdup ("");
	for (i = 0; firstsplit[i] != NULL; (i = i + 1)) {
		const char* _tmp2;
		char* word;
		gboolean _tmp3;
		_tmp2 = NULL;
		word = (_tmp2 = firstsplit[i], (_tmp2 == NULL) ? NULL : g_strdup (_tmp2));
		if (firstsplit[i + 1] == NULL) {
			g_strchomp (word);
		}
		_tmp3 = FALSE;
		if (!in_group) {
			_tmp3 = g_str_has_prefix (word, "\'");
		} else {
			_tmp3 = FALSE;
		}
		/* Merge word groupings like 'hello \'goodbye' as one word.
		 Assumes that duplicity isn't a dick and gives us well formed groupings
		 so we only check for apostrophe at beginning and end of words.  We
		 won't crash if duplicity is a dick, but we won't correctly group words.*/
		if (_tmp3) {
			in_group = TRUE;
		}
		if (in_group) {
			gboolean _tmp4;
			char* _tmp6;
			_tmp4 = FALSE;
			if (g_str_has_suffix (word, "\'")) {
				_tmp4 = (deja_dup_duplicity_instance_num_suffix (word, '\\', strlen (word) - 2) % 2) == 0;
			} else {
				_tmp4 = FALSE;
			}
			if (_tmp4) {
				in_group = FALSE;
			} else {
				if ((deja_dup_duplicity_instance_num_suffix (word, '\\', -1) % 2) == 1) {
					char* _tmp5;
					_tmp5 = NULL;
					word = (_tmp5 = string_substring (word, (glong) 0, g_utf8_strlen (word, -1) - 2), word = (g_free (word), NULL), _tmp5);
				}
			}
			/* get rid of any other escaping backslashes and translate octals*/
			_tmp6 = NULL;
			word = (_tmp6 = deja_dup_duplicity_instance_compress_string (word), word = (g_free (word), NULL), _tmp6);
			/* Now join to rest of group.*/
			if (_vala_strcmp0 (group_word, "") == 0) {
				char* _tmp8;
				const char* _tmp7;
				_tmp8 = NULL;
				_tmp7 = NULL;
				group_word = (_tmp8 = (_tmp7 = word, (_tmp7 == NULL) ? NULL : g_strdup (_tmp7)), group_word = (g_free (group_word), NULL), _tmp8);
			} else {
				char* _tmp10;
				char* _tmp9;
				_tmp10 = NULL;
				_tmp9 = NULL;
				group_word = (_tmp10 = g_strconcat (group_word, _tmp9 = (g_strconcat (" ", word, NULL)), NULL), group_word = (g_free (group_word), NULL), _tmp10);
				_tmp9 = (g_free (_tmp9), NULL);
			}
			if (!in_group) {
				char* _tmp11;
				/* add to list, but drop single quotes*/
				splitlist = g_list_append (splitlist, string_substring (group_word, (glong) 1, g_utf8_strlen (group_word, -1) - 2));
				_tmp11 = NULL;
				group_word = (_tmp11 = g_strdup (""), group_word = (g_free (group_word), NULL), _tmp11);
			}
		} else {
			const char* _tmp12;
			_tmp12 = NULL;
			splitlist = g_list_append (splitlist, (_tmp12 = word, (_tmp12 == NULL) ? NULL : g_strdup (_tmp12)));
		}
		word = (g_free (word), NULL);
	}
	/* Now make it nice array for ease of random access*/
	_tmp14 = NULL;
	(*split) = (_tmp14 = g_new0 (char*, (_tmp13 = g_list_length (splitlist)) + 1), (*split) = (_vala_array_free ((*split), *split_length1, (GDestroyNotify) g_free), NULL), *split_length1 = _tmp13, _tmp14);
	i = 0;
	{
		GList* s_collection;
		GList* s_it;
		s_collection = splitlist;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			const char* _tmp18;
			char* s;
			_tmp18 = NULL;
			s = (_tmp18 = (const char*) s_it->data, (_tmp18 == NULL) ? NULL : g_strdup (_tmp18));
			{
				gint _tmp17;
				char* _tmp16;
				const char* _tmp15;
				_tmp16 = NULL;
				_tmp15 = NULL;
				_tmp17 = i++;
				(*split)[_tmp17] = (_tmp16 = (_tmp15 = s, (_tmp15 == NULL) ? NULL : g_strdup (_tmp15)), (*split)[_tmp17] = (g_free ((*split)[_tmp17]), NULL), _tmp16);
				s = (g_free (s), NULL);
			}
		}
	}
	firstsplit = (_vala_array_free (firstsplit, firstsplit_length1, (GDestroyNotify) g_free), NULL);
	(splitlist == NULL) ? NULL : (splitlist = (_g_list_free_g_free (splitlist), NULL));
	group_word = (g_free (group_word), NULL);
}


static void deja_dup_duplicity_instance_process_stanza (DejaDupDuplicityInstance* self, GList* stanza) {
	gint control_line_size;
	gint control_line_length1;
	char** control_line;
	GList* data;
	char* text;
	g_return_if_fail (self != NULL);
	g_return_if_fail (stanza != NULL);
	control_line = (control_line_length1 = 0, NULL);
	deja_dup_duplicity_instance_split_line ((const char*) stanza->data, &control_line, &control_line_length1);
	data = deja_dup_duplicity_instance_grab_stanza_data (self, stanza);
	text = deja_dup_duplicity_instance_grab_stanza_text (self, stanza);
	g_signal_emit_by_name (self, "message", control_line, control_line_length1, data, text);
	control_line = (_vala_array_free (control_line, control_line_length1, (GDestroyNotify) g_free), NULL);
	(data == NULL) ? NULL : (data = (_g_list_free_g_free (data), NULL));
	text = (g_free (text), NULL);
}


static GList* deja_dup_duplicity_instance_grab_stanza_data (DejaDupDuplicityInstance* self, GList* stanza) {
	GList* list;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (stanza != NULL, NULL);
	list = NULL;
	stanza = stanza->next;
	/* skip first control line*/
	{
		GList* line_collection;
		GList* line_it;
		line_collection = stanza;
		for (line_it = line_collection; line_it != NULL; line_it = line_it->next) {
			const char* _tmp0;
			char* line;
			_tmp0 = NULL;
			line = (_tmp0 = (const char*) line_it->data, (_tmp0 == NULL) ? NULL : g_strdup (_tmp0));
			{
				if (!g_str_has_prefix (line, ". ")) {
					list = g_list_append (list, deja_dup_duplicity_instance_validated_string (g_strchomp (line)));
				}
				line = (g_free (line), NULL);
			}
		}
	}
	/* drop endline*/
	return list;
}


static char* deja_dup_duplicity_instance_grab_stanza_text (DejaDupDuplicityInstance* self, GList* stanza) {
	char* text;
	const char* _tmp5;
	char* _tmp6;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (stanza != NULL, NULL);
	text = g_strdup ("");
	{
		GList* line_collection;
		GList* line_it;
		line_collection = stanza;
		for (line_it = line_collection; line_it != NULL; line_it = line_it->next) {
			const char* _tmp4;
			char* line;
			_tmp4 = NULL;
			line = (_tmp4 = (const char*) line_it->data, (_tmp4 == NULL) ? NULL : g_strdup (_tmp4));
			{
				if (g_str_has_prefix (line, ". ")) {
					char** _tmp1;
					gint split_size;
					gint split_length1;
					char** _tmp0;
					char** split;
					char* _tmp3;
					char* _tmp2;
					_tmp1 = NULL;
					_tmp0 = NULL;
					split = (_tmp1 = _tmp0 = g_strsplit (line, ". ", 2), split_length1 = _vala_array_length (_tmp0), split_size = split_length1, _tmp1);
					_tmp3 = NULL;
					_tmp2 = NULL;
					text = (_tmp3 = g_strdup_printf ("%s%s", text, _tmp2 = deja_dup_duplicity_instance_validated_string (split[1])), text = (g_free (text), NULL), _tmp3);
					_tmp2 = (g_free (_tmp2), NULL);
					split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
				}
				line = (g_free (line), NULL);
			}
		}
	}
	_tmp5 = NULL;
	_tmp6 = NULL;
	return (_tmp6 = (_tmp5 = g_strchomp (text), (_tmp5 == NULL) ? NULL : g_strdup (_tmp5)), text = (g_free (text), NULL), _tmp6);
}


static void deja_dup_duplicity_instance_spawn_finished (DejaDupDuplicityInstance* self, GPid pid, gint status) {
	GError * inner_error;
	gboolean _tmp0;
	gboolean success;
	gboolean cancelled;
	g_return_if_fail (self != NULL);
	inner_error = NULL;
	/* Reference ourselves, because when processing stanza we have not
	 yet gotten to below, whoever owns us might unref us in the middle of
	 this function, and we don't want to die immediately.  Wait until the
	 end.*/
	g_object_ref ((GObject*) self);
	if (self->priv->stanza_id != 0) {
		g_source_remove (self->priv->stanza_id);
	}
	self->priv->stanza_id = (guint) 0;
	self->priv->watch_id = (guint) 0;
	_tmp0 = FALSE;
	if (WIFEXITED (status)) {
		_tmp0 = WEXITSTATUS (status) == 0;
	} else {
		_tmp0 = FALSE;
	}
	success = _tmp0;
	cancelled = !WIFEXITED (status);
	if (self->priv->reader != NULL) {
		GIOChannel* _tmp1;
		while (TRUE) {
			GIOCondition cond;
			cond = g_io_channel_get_buffer_condition (self->priv->reader);
			if (cond == G_IO_IN) {
				deja_dup_duplicity_instance_read_stanza (self, self->priv->reader, cond);
			} else {
				break;
			}
		}
		if (WIFEXITED (status)) {
			gint exitval;
			exitval = WEXITSTATUS (status);
			g_debug ("DuplicityInstance.vala:426: duplicity (%i) exited with value %i\n", (gint) pid, exitval);
		} else {
			g_debug ("DuplicityInstance.vala:429: duplicity (%i) process killed\n", (gint) pid);
		}
		{
			g_io_channel_shutdown (self->priv->reader, FALSE, &inner_error);
			if (inner_error != NULL) {
				goto __catch8_g_error;
				goto __finally8;
			}
		}
		goto __finally8;
		__catch8_g_error:
		{
			GError * e;
			e = inner_error;
			inner_error = NULL;
			{
				g_warning ("DuplicityInstance.vala:435: %s\n", e->message);
				(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			}
		}
		__finally8:
		if (inner_error != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
			return;
		}
		_tmp1 = NULL;
		self->priv->reader = (_tmp1 = NULL, (self->priv->reader == NULL) ? NULL : (self->priv->reader = (g_io_channel_unref (self->priv->reader), NULL)), _tmp1);
	}
	g_spawn_close_pid (pid);
	self->priv->child_pid = (GPid) 0;
	g_signal_emit_by_name (self, "done", success, cancelled);
	g_object_unref ((GObject*) self);
}


DejaDupDuplicityInstance* deja_dup_duplicity_instance_construct (GType object_type) {
	DejaDupDuplicityInstance * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


DejaDupDuplicityInstance* deja_dup_duplicity_instance_new (void) {
	return deja_dup_duplicity_instance_construct (DEJA_DUP_TYPE_DUPLICITY_INSTANCE);
}


gboolean deja_dup_duplicity_instance_get_verbose (DejaDupDuplicityInstance* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return self->priv->_verbose;
}


static void deja_dup_duplicity_instance_set_verbose (DejaDupDuplicityInstance* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_verbose = value;
	g_object_notify ((GObject *) self, "verbose");
}


static GObject * deja_dup_duplicity_instance_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	DejaDupDuplicityInstanceClass * klass;
	GObjectClass * parent_class;
	DejaDupDuplicityInstance * self;
	klass = DEJA_DUP_DUPLICITY_INSTANCE_CLASS (g_type_class_peek (DEJA_DUP_TYPE_DUPLICITY_INSTANCE));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DEJA_DUP_DUPLICITY_INSTANCE (obj);
	{
		GIOChannel* _tmp0;
		gint* _tmp1;
		_tmp0 = NULL;
		self->priv->reader = (_tmp0 = NULL, (self->priv->reader == NULL) ? NULL : (self->priv->reader = (g_io_channel_unref (self->priv->reader), NULL)), _tmp0);
		_tmp1 = NULL;
		self->priv->pipes = (_tmp1 = g_new0 (gint, 2), self->priv->pipes = (g_free (self->priv->pipes), NULL), self->priv->pipes_length1 = 2, self->priv->pipes_size = self->priv->pipes_length1, _tmp1);
		self->priv->pipes[0] = self->priv->pipes[1] = -1;
	}
	return obj;
}


static void deja_dup_duplicity_instance_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DejaDupDuplicityInstance * self;
	gpointer boxed;
	self = DEJA_DUP_DUPLICITY_INSTANCE (object);
	switch (property_id) {
		case DEJA_DUP_DUPLICITY_INSTANCE_VERBOSE:
		g_value_set_boolean (value, deja_dup_duplicity_instance_get_verbose (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void deja_dup_duplicity_instance_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DejaDupDuplicityInstance * self;
	self = DEJA_DUP_DUPLICITY_INSTANCE (object);
	switch (property_id) {
		case DEJA_DUP_DUPLICITY_INSTANCE_VERBOSE:
		deja_dup_duplicity_instance_set_verbose (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void deja_dup_duplicity_instance_class_init (DejaDupDuplicityInstanceClass * klass) {
	deja_dup_duplicity_instance_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DejaDupDuplicityInstancePrivate));
	G_OBJECT_CLASS (klass)->get_property = deja_dup_duplicity_instance_get_property;
	G_OBJECT_CLASS (klass)->set_property = deja_dup_duplicity_instance_set_property;
	G_OBJECT_CLASS (klass)->constructor = deja_dup_duplicity_instance_constructor;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_duplicity_instance_finalize;
	DEJA_DUP_DUPLICITY_INSTANCE_CLASS (klass)->start = deja_dup_duplicity_instance_real_start;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_DUPLICITY_INSTANCE_VERBOSE, g_param_spec_boolean ("verbose", "verbose", "verbose", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("done", DEJA_DUP_TYPE_DUPLICITY_INSTANCE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN);
	g_signal_new ("message", DEJA_DUP_TYPE_DUPLICITY_INSTANCE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED_INT_POINTER_STRING, G_TYPE_NONE, 4, G_TYPE_STRV, G_TYPE_INT, G_TYPE_POINTER, G_TYPE_STRING);
}


static void deja_dup_duplicity_instance_instance_init (DejaDupDuplicityInstance * self) {
	self->priv = DEJA_DUP_DUPLICITY_INSTANCE_GET_PRIVATE (self);
	self->priv->_verbose = FALSE;
}


static void deja_dup_duplicity_instance_finalize (GObject* obj) {
	DejaDupDuplicityInstance * self;
	self = DEJA_DUP_DUPLICITY_INSTANCE (obj);
	{
		if (self->priv->stanza_id != 0) {
			g_source_remove (self->priv->stanza_id);
		}
		if (self->priv->watch_id != 0) {
			g_source_remove (self->priv->watch_id);
		}
		if (deja_dup_duplicity_instance_is_started (self)) {
			g_debug ("DuplicityInstance.vala:162: duplicity (%i) process killed\n", (gint) self->priv->child_pid);
			deja_dup_duplicity_instance_kill_child (self);
		}
	}
	self->priv->pipes = (g_free (self->priv->pipes), NULL);
	(self->priv->reader == NULL) ? NULL : (self->priv->reader = (g_io_channel_unref (self->priv->reader), NULL));
	G_OBJECT_CLASS (deja_dup_duplicity_instance_parent_class)->finalize (obj);
}


GType deja_dup_duplicity_instance_get_type (void) {
	static GType deja_dup_duplicity_instance_type_id = 0;
	if (deja_dup_duplicity_instance_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupDuplicityInstanceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_duplicity_instance_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupDuplicityInstance), 0, (GInstanceInitFunc) deja_dup_duplicity_instance_instance_init, NULL };
		deja_dup_duplicity_instance_type_id = g_type_register_static (G_TYPE_OBJECT, "DejaDupDuplicityInstance", &g_define_type_info, 0);
	}
	return deja_dup_duplicity_instance_type_id;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}



static void g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOOLEAN_BOOLEAN) (gpointer data1, gboolean arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__BOOLEAN_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOOLEAN_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boolean (param_values + 1), g_value_get_boolean (param_values + 2), data2);
}


static void g_cclosure_user_marshal_VOID__BOXED_INT_POINTER_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOXED_INT_POINTER_STRING) (gpointer data1, gpointer arg_1, gint arg_2, gpointer arg_3, const char* arg_4, gpointer data2);
	register GMarshalFunc_VOID__BOXED_INT_POINTER_STRING callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOXED_INT_POINTER_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boxed (param_values + 1), g_value_get_int (param_values + 2), g_value_get_pointer (param_values + 3), g_value_get_string (param_values + 4), data2);
}



