/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */

#ifndef __OPERATION_H__
#define __OPERATION_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <Backend.h>

G_BEGIN_DECLS

typedef struct _DejaDupDuplicity DejaDupDuplicity;
typedef struct _DejaDupDuplicityClass DejaDupDuplicityClass;
typedef struct _DejaDupOperation DejaDupOperation;
typedef struct _DejaDupOperationClass DejaDupOperationClass;

#define DEJA_DUP_TYPE_OPERATION (deja_dup_operation_get_type ())
#define DEJA_DUP_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_OPERATION, DejaDupOperation))
#define DEJA_DUP_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_OPERATION, DejaDupOperationClass))
#define DEJA_DUP_IS_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_OPERATION))
#define DEJA_DUP_IS_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_OPERATION))
#define DEJA_DUP_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_OPERATION, DejaDupOperationClass))

typedef struct _DejaDupOperationPrivate DejaDupOperationPrivate;

#define DEJA_DUP_OPERATION_TYPE_MODE (deja_dup_operation_mode_get_type ())

struct _DejaDupOperation {
	GObject parent_instance;
	DejaDupOperationPrivate * priv;
	DejaDupDuplicity* dup;
	DejaDupBackend* backend;
	char* passphrase;
};

struct _DejaDupOperationClass {
	GObjectClass parent_class;
	void (*start) (DejaDupOperation* self, GError** error);
	void (*connect_to_dup) (DejaDupOperation* self);
	void (*operation_finished) (DejaDupOperation* self, DejaDupDuplicity* dup, gboolean success, gboolean cancelled);
	GList* (*make_argv) (DejaDupOperation* self, GError** error);
};

typedef enum  {
	DEJA_DUP_OPERATION_MODE_INVALID,
	DEJA_DUP_OPERATION_MODE_BACKUP,
	DEJA_DUP_OPERATION_MODE_RESTORE,
	DEJA_DUP_OPERATION_MODE_STATUS
} DejaDupOperationMode;


GType deja_dup_operation_mode_get_type (void);
char* deja_dup_operation_mode_to_string (DejaDupOperationMode mode);
void deja_dup_operation_start (DejaDupOperation* self, GError** error);
void deja_dup_operation_cancel (DejaDupOperation* self);
void deja_dup_operation_connect_to_dup (DejaDupOperation* self);
void deja_dup_operation_operation_finished (DejaDupOperation* self, DejaDupDuplicity* dup, gboolean success, gboolean cancelled);
GList* deja_dup_operation_make_argv (DejaDupOperation* self, GError** error);
void deja_dup_operation_ask_passphrase (DejaDupOperation* self, GError** error);
void deja_dup_operation_ask_backend_password (DejaDupOperation* self, GError** error);
GtkWindow* deja_dup_operation_get_toplevel (DejaDupOperation* self);
guint deja_dup_operation_get_uppermost_xid (DejaDupOperation* self);
DejaDupOperationMode deja_dup_operation_get_mode (DejaDupOperation* self);
GType deja_dup_operation_get_type (void);


G_END_DECLS

#endif
