/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */

#include "ConfigBackend.h"
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include "ConfigWidget.h"




enum  {
	CONFIG_BACKEND_DUMMY_PROPERTY
};
static GObject * config_backend_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer config_backend_parent_class = NULL;



ConfigBackend* config_backend_construct (GType object_type, const char* key) {
	GParameter * __params;
	GParameter * __params_it;
	ConfigBackend * self;
	g_return_val_if_fail (key != NULL, NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "key";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, key);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


ConfigBackend* config_backend_new (const char* key) {
	return config_backend_construct (TYPE_CONFIG_BACKEND, key);
}


static GObject * config_backend_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	ConfigBackendClass * klass;
	GObjectClass * parent_class;
	ConfigBackend * self;
	klass = CONFIG_BACKEND_CLASS (g_type_class_peek (TYPE_CONFIG_BACKEND));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = CONFIG_BACKEND (obj);
	{
		GtkListStore* store;
		GtkTreeIter iter = {0};
		gint i;
		store = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING, NULL);
		i = 0;
		gtk_list_store_insert_with_values (store, &iter, i++, 0, _ ("Amazon S3"), 1, "s3", -1);
		gtk_list_store_insert_with_values (store, &iter, i++, 0, _ ("Local Folder"), 1, "file", -1);
		gtk_list_store_insert_with_values (store, &iter, i++, 0, _ ("SSH"), 1, "ssh", -1);
		gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) store, 0, GTK_SORT_ASCENDING);
		config_choice_init ((ConfigChoice*) self, (GtkTreeModel*) store, 1);
		(store == NULL) ? NULL : (store = (g_object_unref (store), NULL));
	}
	return obj;
}


static void config_backend_class_init (ConfigBackendClass * klass) {
	config_backend_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = config_backend_constructor;
}


static void config_backend_instance_init (ConfigBackend * self) {
}


GType config_backend_get_type (void) {
	static GType config_backend_type_id = 0;
	if (config_backend_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ConfigBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) config_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConfigBackend), 0, (GInstanceInitFunc) config_backend_instance_init, NULL };
		config_backend_type_id = g_type_register_static (TYPE_CONFIG_CHOICE, "ConfigBackend", &g_define_type_info, 0);
	}
	return config_backend_type_id;
}




