/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */

#include "ConfigBool.h"
#include <gtk/gtk.h>
#include <gconf/gconf-client.h>




struct _ConfigBoolPrivate {
	char* _label;
	GtkCheckButton* button;
};

#define CONFIG_BOOL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CONFIG_BOOL, ConfigBoolPrivate))
enum  {
	CONFIG_BOOL_DUMMY_PROPERTY,
	CONFIG_BOOL_LABEL
};
static gboolean config_bool_real_get_active (Togglable* base);
static void config_bool_real_set_from_config (ConfigWidget* base);
static void config_bool_handle_toggled (ConfigBool* self);
static void config_bool_set_label (ConfigBool* self, const char* value);
static void _config_bool_handle_toggled_gtk_toggle_button_toggled (GtkCheckButton* _sender, gpointer self);
static GObject * config_bool_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer config_bool_parent_class = NULL;
static TogglableIface* config_bool_togglable_parent_iface = NULL;
static void config_bool_finalize (GObject* obj);



ConfigBool* config_bool_construct (GType object_type, const char* key, const char* label) {
	GParameter * __params;
	GParameter * __params_it;
	ConfigBool * self;
	g_return_val_if_fail (key != NULL, NULL);
	g_return_val_if_fail (label != NULL, NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	__params_it->name = "key";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, key);
	__params_it++;
	__params_it->name = "label";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, label);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


ConfigBool* config_bool_new (const char* key, const char* label) {
	return config_bool_construct (TYPE_CONFIG_BOOL, key, label);
}


static gboolean config_bool_real_get_active (Togglable* base) {
	ConfigBool * self;
	self = (ConfigBool*) base;
	return gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->button);
}


static void config_bool_real_set_from_config (ConfigWidget* base) {
	ConfigBool * self;
	GError * inner_error;
	self = (ConfigBool*) base;
	inner_error = NULL;
	{
		gboolean val;
		val = gconf_client_get_bool (((ConfigWidget*) self)->client, config_widget_get_key ((ConfigWidget*) self), &inner_error);
		if (inner_error != NULL) {
			goto __catch0_g_error;
			goto __finally0;
		}
		gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->button, val);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_warning ("ConfigBool.vala:50: %s\n", e->message);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally0:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
}


static void config_bool_handle_toggled (ConfigBool* self) {
	GError * inner_error;
	g_return_if_fail (self != NULL);
	inner_error = NULL;
	{
		gconf_client_set_bool (((ConfigWidget*) self)->client, config_widget_get_key ((ConfigWidget*) self), gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->button), &inner_error);
		if (inner_error != NULL) {
			goto __catch1_g_error;
			goto __finally1;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_warning ("ConfigBool.vala:60: %s\n", e->message);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally1:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
	g_signal_emit_by_name ((Togglable*) self, "toggled");
}


const char* config_bool_get_label (ConfigBool* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_label;
}


static void config_bool_set_label (ConfigBool* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_label = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_label = (g_free (self->priv->_label), NULL), _tmp2);
	g_object_notify ((GObject *) self, "label");
}


static void _config_bool_handle_toggled_gtk_toggle_button_toggled (GtkCheckButton* _sender, gpointer self) {
	config_bool_handle_toggled (self);
}


static GObject * config_bool_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	ConfigBoolClass * klass;
	GObjectClass * parent_class;
	ConfigBool * self;
	klass = CONFIG_BOOL_CLASS (g_type_class_peek (TYPE_CONFIG_BOOL));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = CONFIG_BOOL (obj);
	{
		GtkCheckButton* _tmp0;
		_tmp0 = NULL;
		self->priv->button = (_tmp0 = g_object_ref_sink ((GtkCheckButton*) gtk_check_button_new_with_mnemonic (self->priv->_label)), (self->priv->button == NULL) ? NULL : (self->priv->button = (g_object_unref (self->priv->button), NULL)), _tmp0);
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->priv->button);
		config_widget_set_from_config ((ConfigWidget*) self);
		g_signal_connect_object ((GtkToggleButton*) self->priv->button, "toggled", (GCallback) _config_bool_handle_toggled_gtk_toggle_button_toggled, self, 0);
	}
	return obj;
}


static void config_bool_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ConfigBool * self;
	gpointer boxed;
	self = CONFIG_BOOL (object);
	switch (property_id) {
		case CONFIG_BOOL_LABEL:
		g_value_set_string (value, config_bool_get_label (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void config_bool_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ConfigBool * self;
	self = CONFIG_BOOL (object);
	switch (property_id) {
		case CONFIG_BOOL_LABEL:
		config_bool_set_label (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void config_bool_class_init (ConfigBoolClass * klass) {
	config_bool_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ConfigBoolPrivate));
	G_OBJECT_CLASS (klass)->get_property = config_bool_get_property;
	G_OBJECT_CLASS (klass)->set_property = config_bool_set_property;
	G_OBJECT_CLASS (klass)->constructor = config_bool_constructor;
	G_OBJECT_CLASS (klass)->finalize = config_bool_finalize;
	CONFIG_WIDGET_CLASS (klass)->set_from_config = config_bool_real_set_from_config;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONFIG_BOOL_LABEL, g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void config_bool_togglable_interface_init (TogglableIface * iface) {
	config_bool_togglable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_active = config_bool_real_get_active;
}


static void config_bool_instance_init (ConfigBool * self) {
	self->priv = CONFIG_BOOL_GET_PRIVATE (self);
}


static void config_bool_finalize (GObject* obj) {
	ConfigBool * self;
	self = CONFIG_BOOL (obj);
	self->priv->_label = (g_free (self->priv->_label), NULL);
	(self->priv->button == NULL) ? NULL : (self->priv->button = (g_object_unref (self->priv->button), NULL));
	G_OBJECT_CLASS (config_bool_parent_class)->finalize (obj);
}


GType config_bool_get_type (void) {
	static GType config_bool_type_id = 0;
	if (config_bool_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ConfigBoolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) config_bool_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConfigBool), 0, (GInstanceInitFunc) config_bool_instance_init, NULL };
		static const GInterfaceInfo togglable_info = { (GInterfaceInitFunc) config_bool_togglable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		config_bool_type_id = g_type_register_static (TYPE_CONFIG_WIDGET, "ConfigBool", &g_define_type_info, 0);
		g_type_add_interface_static (config_bool_type_id, TYPE_TOGGLABLE, &togglable_info);
	}
	return config_bool_type_id;
}




