/* -*- Mode: C; indent-tabs-mode: nil; tab-width: 2 -*- */

#include "preferences.h"
#include <glib/gi18n-lib.h>
#include <config.h>
#include <unique/unique.h>
#include <gtk/gtk.h>
#include "PreferencesDialog.h"




enum  {
	DEJA_DUP_PREFERENCES_DUMMY_PROPERTY
};
static gboolean deja_dup_preferences_show_version = FALSE;
static PreferencesDialog* deja_dup_preferences_pref_window = NULL;
static gboolean deja_dup_preferences_handle_console_options (gint* status);
static UniqueResponse deja_dup_preferences_message_received (UniqueApp* app, gint command, UniqueMessageData* message_data, guint time_);
static UniqueResponse _deja_dup_preferences_message_received_unique_app_message_received (UniqueApp* _sender, gint command, UniqueMessageData* message_data, guint time_, gpointer self);
static gpointer deja_dup_preferences_parent_class = NULL;
static void deja_dup_preferences_finalize (GObject* obj);

static const GOptionEntry DEJA_DUP_PREFERENCES_options[] = {{"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &deja_dup_preferences_show_version, N_ ("Show version"), NULL}, {NULL}};


static gboolean deja_dup_preferences_handle_console_options (gint* status) {
	(*status) = 0;
	if (deja_dup_preferences_show_version) {
		g_print ("%s %s\n", _ ("Déjà Dup Preferences"), VERSION);
		return FALSE;
	}
	return TRUE;
}


static UniqueResponse deja_dup_preferences_message_received (UniqueApp* app, gint command, UniqueMessageData* message_data, guint time_) {
	UniqueResponse res;
	g_return_val_if_fail (app != NULL, 0);
	g_return_val_if_fail (message_data != NULL, 0);
	res = UNIQUE_RESPONSE_OK;
	switch (command) {
		case UNIQUE_ACTIVATE:
		{
			gtk_window_present_with_time ((GtkWindow*) deja_dup_preferences_pref_window, (guint32) time_);
			break;
		}
	}
	return res;
}


static UniqueResponse _deja_dup_preferences_message_received_unique_app_message_received (UniqueApp* _sender, gint command, UniqueMessageData* message_data, guint time_, gpointer self) {
	return deja_dup_preferences_message_received (_sender, command, message_data, time_);
}


gint deja_dup_preferences_main (char** args, int args_length1) {
	GError * inner_error;
	GOptionContext* context;
	gint status;
	UniqueApp* app;
	gboolean _tmp3;
	gint _tmp5;
	inner_error = NULL;
	textdomain (GETTEXT_PACKAGE);
	bindtextdomain (GETTEXT_PACKAGE, LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	g_set_application_name (_ ("Déjà Dup Preferences"));
	context = g_option_context_new ("");
	g_option_context_add_main_entries (context, DEJA_DUP_PREFERENCES_options, GETTEXT_PACKAGE);
	g_option_context_add_group (context, gtk_get_option_group (FALSE));
	{
		g_option_context_parse (context, &args_length1, &args, &inner_error);
		if (inner_error != NULL) {
			goto __catch19_g_error;
			goto __finally19;
		}
	}
	goto __finally19;
	__catch19_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			char* _tmp0;
			gint _tmp1;
			_tmp0 = NULL;
			g_printerr ("%s\n\n%s", e->message, _tmp0 = g_option_context_get_help (context, TRUE, NULL));
			_tmp0 = (g_free (_tmp0), NULL);
			return (_tmp1 = 1, (e == NULL) ? NULL : (e = (g_error_free (e), NULL)), (context == NULL) ? NULL : (context = (g_option_context_free (context), NULL)), _tmp1);
		}
	}
	__finally19:
	if (inner_error != NULL) {
		(context == NULL) ? NULL : (context = (g_option_context_free (context), NULL));
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return 0;
	}
	status = 0;
	if (!deja_dup_preferences_handle_console_options (&status)) {
		gint _tmp2;
		return (_tmp2 = status, (context == NULL) ? NULL : (context = (g_option_context_free (context), NULL)), _tmp2);
	}
	gtk_init (&args_length1, &args);
	/* to open display ('cause we passed false above)
	 We don't have a solid domain for Déjà Dup...*/
	app = unique_app_new ("net.launchpad.deja-dup.preferences", NULL);
	if ((g_object_get (app, "is-running", &_tmp3, NULL), _tmp3)) {
		unique_app_send_message (app, (gint) UNIQUE_ACTIVATE, NULL);
	} else {
		PreferencesDialog* _tmp4;
		/* We're first instance.  Yay!    */
		gtk_icon_theme_append_search_path (gtk_icon_theme_get_default (), THEME_DIR);
		gtk_window_set_default_icon_name (PACKAGE);
		_tmp4 = NULL;
		deja_dup_preferences_pref_window = (_tmp4 = g_object_ref_sink (preferences_dialog_new (NULL)), (deja_dup_preferences_pref_window == NULL) ? NULL : (deja_dup_preferences_pref_window = (g_object_unref (deja_dup_preferences_pref_window), NULL)), _tmp4);
		g_signal_connect (app, "message-received", (GCallback) _deja_dup_preferences_message_received_unique_app_message_received, NULL);
		unique_app_watch_window (app, (GtkWindow*) deja_dup_preferences_pref_window);
		gtk_widget_show_all ((GtkWidget*) deja_dup_preferences_pref_window);
		gtk_main ();
	}
	return (_tmp5 = 0, (context == NULL) ? NULL : (context = (g_option_context_free (context), NULL)), (app == NULL) ? NULL : (app = (g_object_unref (app), NULL)), _tmp5);
}


int main (int argc, char ** argv) {
	g_type_init ();
	return deja_dup_preferences_main (argv, argc);
}


/*
    Déjà Dup Preferences
    © 2008—2009 Michael Terry <mike@mterry.name>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
DejaDupPreferences* deja_dup_preferences_construct (GType object_type) {
	DejaDupPreferences * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


DejaDupPreferences* deja_dup_preferences_new (void) {
	return deja_dup_preferences_construct (TYPE_DEJA_DUP_PREFERENCES);
}


static void deja_dup_preferences_class_init (DejaDupPreferencesClass * klass) {
	deja_dup_preferences_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = deja_dup_preferences_finalize;
}


static void deja_dup_preferences_instance_init (DejaDupPreferences * self) {
}


static void deja_dup_preferences_finalize (GObject* obj) {
	DejaDupPreferences * self;
	self = DEJA_DUP_PREFERENCES (obj);
	G_OBJECT_CLASS (deja_dup_preferences_parent_class)->finalize (obj);
}


GType deja_dup_preferences_get_type (void) {
	static GType deja_dup_preferences_type_id = 0;
	if (deja_dup_preferences_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupPreferencesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_preferences_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupPreferences), 0, (GInstanceInitFunc) deja_dup_preferences_instance_init, NULL };
		deja_dup_preferences_type_id = g_type_register_static (G_TYPE_OBJECT, "DejaDupPreferences", &g_define_type_info, 0);
	}
	return deja_dup_preferences_type_id;
}




