//////////////////////////////////////////////////////////////////////////////
// deKoratorconfig.cc
// -------------------
// DeKorator window decoration for KDE
// -------------------
// Autor: moty rahamim
// Email: moty.rahamim@gmail.com
// Based on Example-0.8 by David Johnson <david@usermode.org>
// some ideas and code have been taken from plastik and KCMicons
//////////////////////////////////////////////////////////////////////////////

#ifndef EXAMPLECONFIG_H
#define EXAMPLECONFIG_H

#include <qobject.h>


class KConfig;
class ConfigDialog;
class IconThemesConfig;

class DeKoratorConfig : public QObject
{
    Q_OBJECT
public:
    DeKoratorConfig( KConfig* config, QWidget* parent );
    ~DeKoratorConfig();

signals:
    void changed();

public slots:
    void load( KConfig* );
    void save( KConfig* );
    void defaults();


protected slots:
    void themeSelected( QListViewItem *item );
    void selectionChanged( int );
    void installNewTheme();
    void removeSelectedTheme();
    void setTheme();
private:
    KConfig *config_;
    IconThemesConfig *themes_;
    ConfigDialog *dialog_;
};

#endif // EXAMPLECONFIG_H
