//////////////////////////////////////////////////////////////////////////////
// deKoratorconfig.cc
// -------------------
// DeKorator window decoration for KDE
// -------------------
// Autor: moty rahamim
// Email: moty.rahamim@gmail.com
// Based on Example-0.8 by David Johnson <david@usermode.org>
// some ideas and code have been taken from plastik and KCMicons
//////////////////////////////////////////////////////////////////////////////

#ifndef ICONTHEMES_H
#define ICONTHEMES_H

#include <kcmodule.h>
#include <qmap.h>
#include <klistview.h>

class QPushButton;
class DeviceManager;
class QCheckBox;
class QStringList;



class IconThemesConfig : public QObject
{
    Q_OBJECT

public:
    IconThemesConfig( QWidget *parent, KListView *themesView, QPushButton *removethemeBtn );
    virtual ~IconThemesConfig();

    void loadThemes();
    bool installThemes( const QStringList &themes, const QString &archiveName );
    QStringList findThemeDirs( const QString &archiveName );
    void themeSelected( QListViewItem *item, QLabel *preview );
    void installNewTheme();
    void removeSelectedTheme();
    void setTheme( KURLRequester *framesPath, KURLRequester *buttonsPath, KURLRequester *masksPath );

private:
    QListViewItem *iconThemeItem( const QString &name );
    KListView *themesView_;
    QWidget *parent_;
    QPushButton *removeThemeBtn_;
    QListViewItem *m_defaultTheme;
    QMap <QString, QString>m_themeNames;
};

#endif // ICONTHEMES_H

